<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE Tracing Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using tracing with a Helidon SE application.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 30 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>

</div>


<h2 id="_introduction">Introduction</h2>
<div class="section">
<p>Distributed tracing is a critical feature of microservice-based applications, since it traces workflow both
within a service and across multiple services.  This provides insight to sequence and timing data for specific blocks of work,
which helps you identify performance and operational issues. Helidon includes support for distributed tracing through its own API, backed by either
through the <a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a>, or by
<a target="_blank" href="https://opentracing.io">OpenTracing API</a>.</p>


<h3 id="_tracing_concepts">Tracing Concepts</h3>
<div class="section">
<p>This section explains a few concepts that you need to understand before you get started with tracing.
In the context of this document, a service is synonymous with an application.
A <em>span</em> is the basic unit of work done within a single service, on a single host.
Every span has a name, starting timestamp, and duration.  For example, the work done by a REST endpoint is a span.
A span is associated to a single service, but its descendants can belong to different services and hosts.
A <em>trace</em> contains a collection of spans from one or more services, running on one or more hosts. For example,
if you trace a service endpoint that calls another service, then the trace would contain spans from both services.
Within a trace, spans are organized as a directed acyclic graph (DAG) and
can belong to multiple services, running on multiple hosts.
Spans are automatically created by Helidon as needed during execution of the REST request.</p>

</div>

</div>


<h2 id="_getting_started_with_tracing">Getting Started with Tracing</h2>
<div class="section">
<p>The examples in this guide demonstrate how to integrate tracing with Helidon, how to view traces, how to trace
across multiple services, and how to integrate tracing with Kubernetes. All examples use Jaeger and traces
will be viewed using the Jaeger UI.</p>


<h3 id="_create_a_sample_helidon_se_project">Create a Sample Helidon SE Project</h3>
<div class="section">
<p>Use the Helidon SE Maven archetype to create a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.4 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<markup
lang="bash"
title="The project will be built and run from the <code>helidon-quickstart-se</code> directory:"
>cd helidon-quickstart-se</markup>

</div>


<h3 id="_set_up_jaeger">Set up Jaeger</h3>
<div class="section">
<p>First, you need to run the Jaeger tracer.  Helidon will communicate with this tracer at runtime.</p>

<markup
lang="bash"
title="Run Jaeger within a docker container, then check the Jaeger server working:"
>docker run -d --name jaeger \                  <span class="conum" data-value="1" />
  -e COLLECTOR_OTLP_ENABLED=true \
  -p 6831:6831/udp \
  -p 6832:6832/udp \
  -p 5778:5778 \
  -p 16686:16686 \
  -p 4317:4317 \
  -p 4318:4318 \
  -p 14250:14250 \
  -p 14268:14268 \
  -p 14269:14269 \
  -p 9411:9411 \
  jaegertracing/all-in-one:1.50</markup>

<ul class="colist">
<li data-value="1">Run the Jaeger docker image.</li>
</ul>

</div>


<h3 id="_enable_tracing_in_the_helidon_application">Enable Tracing in the Helidon Application</h3>
<div class="section">
<p>Update the <code>pom.xml</code> file and add the following Jaeger dependency to the <code>&lt;dependencies&gt;</code>
section (<strong>not</strong> <code>&lt;dependencyManagement&gt;</code>). This will enable Helidon to use Jaeger at the
default host and port, <code>localhost:14250</code>.</p>

<markup
lang="xml"
title="Add the following dependencies to <code>pom.xml</code>:"
> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;   <span class="conum" data-value="1" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
     &lt;scope&gt;runtime&lt;/scope&gt;
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;  <span class="conum" data-value="3" />
     &lt;scope&gt;runtime&lt;/scope&gt;
 &lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon Tracing dependencies.</li>
<li data-value="2">Observability features for tracing.</li>
<li data-value="3">Jaeger tracing provider.</li>
</ul>

<p>All spans sent by Helidon to Jaeger need to be associated with a service, assigned by the <code>tracing.service</code> setting in the example below.</p>

<markup
lang="bash"
title="Add the following lines to <code>src/main/resources/application.yaml</code>:"
>tracing:
  service: helidon-se-1
  protocol: http
  port: 14250
  path: /api/traces
  tags:
    env: development
  enabled: true
  sampler-type: "const"
  sampler-param: 1
  log-spans: true
  propagation: b3</markup>

</div>


<h3 id="_view_automatic_tracing_of_rest_endpoints">View Automatic Tracing of REST Endpoints</h3>
<div class="section">
<p>Tracing is part of Helidon&#8217;s observability support. By default, Helidon discovers any observability feature on the classpath and activates it automatically. In particular for tracing, Helidon adds a trace each time a client accesses a service endpoint.
You can see these traces using the Jaeger UI once you build, run, and access your application without changing your application&#8217;s Java code.</p>


<h4 id="_build_and_access_quickstart">Build and Access QuickStart</h4>
<div class="section">
<markup
lang="bash"
title="Build and run the application"
>mvn clean package
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Access the application"
>curl http://localhost:8080/greet</markup>

</div>

</div>


<h3 id="_viewing_traces_using_the_jaeger_ui">Viewing Traces Using the Jaeger UI</h3>
<div class="section">
<p>Jaeger provides a web-based UI at <a target="_blank" href="http://localhost:16686" class="bare">http://localhost:16686</a> where you can see a visual
representation of the traces and spans within them.</p>

<ol style="margin-left: 15px;">
<li>
From the <code>Service</code> drop list select <code>helidon-se-1</code>. This name corresponds to the <code>tracing.service</code> setting you assigned in the <code>application.yaml</code> config file.

</li>
<li>
Click on the UI Find Traces button. Notice that you can change the look-back time to restrict the trace list.
You will see a trace for each <code>curl</code> command you ran to access the application.

</li>
</ol>

<div class="fit"><div>
<div class="block-title"><span>List of traces</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_trace_list.png" alt="Trace List" />
</v-card-text>
</v-card>
</div></div>

<p>Click on a trace to see the trace detail page (shown below) which shows the spans within the trace. You can clearly
see the root span (<code>HTTP Request</code>) and the single child span (<code>content-write</code>) along with the time over which each span was active.</p>

<div class="fit"><div>
<div class="block-title"><span>Trace detail page</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_first_trace.png" alt="Trace Detail" />
</v-card-text>
</v-card>
</div></div>

<p>You can examine span details by clicking on the span row.  Refer to the image below which shows the span details including timing information.
You can see times for each space relative to the root span.</p>

<div class="fit"><div>
<div class="block-title"><span>Span detail page</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_span_detail.png" alt="Span Details" />
</v-card-text>
</v-card>
</div></div>

</div>


<h3 id="_adding_a_custom_span">Adding a Custom Span</h3>
<div class="section">
<p>Your application can use the Helidon tracing API to create custom spans.
The following code replaces the generated <code>getDefaultMessageHandler</code> method to add a custom span around the code which prepares the default greeting response. The new custom span&#8217;s parent span is set to the one which Helidon automatically creates for the REST endpoint.</p>

<markup
lang="java"
title="Update the <code>GreetService</code> class, replacing the <code>getDefaultMessageHandler</code> method:"
>private void getDefaultMessageHandler(ServerRequest request,
                                      ServerResponse response) {
    var spanBuilder = Tracer.global().spanBuilder("secondchildSpan"); <span class="conum" data-value="1" />
    request.context().get(SpanContext.class).ifPresent(sc -&gt; sc.asParent(spanBuilder)); <span class="conum" data-value="2" />
    var span = spanBuilder.start(); <span class="conum" data-value="3" />

    try (Scope scope = span.activate()) { <span class="conum" data-value="4" />
        sendResponse(response, "World");
        span.end(); <span class="conum" data-value="5" />
    } catch (Throwable t) {
        span.end(t);    <span class="conum" data-value="6" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Create a new <code>Span</code> using the global tracer.</li>
<li data-value="2">Set the parent of the new span to the span from the <code>Request</code> if available.</li>
<li data-value="3">Start the span.</li>
<li data-value="4">Make the new span the current span, returning a <code>Scope</code> which is autoclosed.</li>
<li data-value="5">End the span normally after the response is sent.</li>
<li data-value="6">End the span with an exception if one was thrown.</li>
</ul>

<markup
lang="bash"
title="Build the application and run it:"
>mvn package
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Run the <code>curl</code> command in a new terminal window and check the response:"
>curl http://localhost:8080/greet
...
{
  "message": "Hello World!"
}</markup>

<p>Return to the main Jaeger UI screen and click Find Traces again. The new display contains an additional trace, displayed first, for the most recent <code>curl</code> you ran.</p>

<div class="fit"><div>
<div class="block-title"><span>Expanded trace list</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_second_trace_list.png" alt="Expanded trace list" />
</v-card-text>
</v-card>
</div></div>

<p>Notice that the top trace has three spans, not two as with the earlier trace. Click on the trace to see the trace details.</p>

<div class="fit"><div>
<div class="block-title"><span>Trace details with custom span</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_expanded_trace.png" alt="Trace details with custom span" />
</v-card-text>
</v-card>
</div></div>

<p>Note the row for <code>mychildSpan</code>--the custom span created by the added code.</p>

</div>


<h3 id="_using_tracing_across_services">Using Tracing Across Services</h3>
<div class="section">
<p>Helidon automatically traces across services if the services use the same tracer, for example, the same instance of Jaeger.
This means a single trace can include spans from multiple services and hosts.  Helidon uses a <code>SpanContext</code> to
propagate tracing information across process boundaries.  When you make client API calls, Helidon will
internally call OpenTelemetry APIs or OpenTracing APIs to propagate the <code>SpanContext</code>. There is nothing you need to do in your application to make this work.</p>

<p>To demonstrate distributed tracing, create a second project where the server listens to on port 8081.
Create a new directory to hold this new project, then do the following steps, similar to
what you did at the start of this guide:</p>

</div>


<h3 id="_create_the_second_service">Create the Second Service</h3>
<div class="section">
<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.4 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se-2 \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<markup
lang="bash"
title="The project is in the <code>helidon-quickstart-se-2</code> directory:"
>cd helidon-quickstart-se-2</markup>

<markup
lang="xml"
title="Add the following dependencies to <code>pom.xml</code>:"
> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;   <span class="conum" data-value="1" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
     &lt;scope&gt;runtime&lt;/scope&gt;
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;  <span class="conum" data-value="3" />
     &lt;scope&gt;runtime&lt;/scope&gt;
 &lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon Tracing API.</li>
<li data-value="2">Observability features for tracing.</li>
<li data-value="3">Jaeger tracing provider.</li>
</ul>

<markup
lang="bash"
title="Replace <code>src/main/resources/application.yaml</code> with the following:"
>app:
  greeting: "Hello From SE-2"

tracing:
  service: helidon-se-2
  protocol: http
  port: 14250
  path: /api/traces
  tags:
    env: development
  enabled: true
  sampler-type: "const"
  sampler-param: 1
  log-spans: true
  propagation: b3

server:
  port: 8081
  host: 0.0.0.0</markup>

<div class="admonition note">
<p class="admonition-inline">The settings above are for development and experimental purposes only. For production environment, please see the
<router-link to="/se/tracing">Tracing documentation</router-link>.</p>
</div>

<markup
lang="java"
title="Update the <code>GreetService</code> class. Replace the <code>getDefaultMessageHandler</code> method:"
>private void getDefaultMessageHandler(ServerRequest request,
                                      ServerResponse response) {

    var spanBuilder = Tracer.global().spanBuilder("getDefaultMessageHandler");
    request.context().get(SpanContext.class).ifPresent(spanBuilder::parent);
    Span span = spanBuilder.start();

    try (Scope scope = span.activate()) {
        sendResponse(response, "World");
        span.end();
    } catch (Throwable t) {
        span.end(t);
    }
}</markup>

<p>Build the application, skipping unit tests; the unit tests check for the default greeting response which is now different in the updated config. Then run the application.</p>

<markup
lang="bash"
title="Build and run:"
>mvn package -DskipTests=true
java -jar target/helidon-quickstart-se-2.jar</markup>

<markup
lang="bash"
title="Run the curl command in a new terminal window and check the response (<strong>notice the port is 8081</strong>) :"
>curl http://localhost:8081/greet
...
{
  "message": "Hello From SE-2 World!"
}</markup>

</div>


<h3 id="_modify_the_first_service">Modify the First Service</h3>
<div class="section">
<p>Once you have validated that the second service is running correctly, you need to modify the original application to
call it.</p>

<markup
lang="xml"
title="Add the following dependencies to <code>pom.xml</code>:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-api&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-tracing&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-http1&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Make the following changes to the <code>GreetService</code> class.</p>

<ol style="margin-left: 15px;">
<li>
Add a <code>WebClient</code> field.
<markup
lang="java"
title="Add a private instance field (before the constructors)"
>private WebClient webClient;</markup>

</li>
<li>
Add code to initialize the <code>WebClient</code> field.
<markup
lang="java"
title="Add the following code to the <code>GreetService(Config)</code> constructor"
>webClient = WebClient.builder()
        .baseUri("http://localhost:8081")
        .addService(WebClientTracing.create())
        .build();</markup>

</li>
<li>
Add a routing rule for the new endpoint <code>/outbound</code>.
<markup
lang="java"
title="Add the following line in the <code>routing</code> method as the first <code>.get</code> invocation in the method"
>.get("/outbound", this::outboundMessageHandler)</markup>

</li>
<li>
Add a method to handle requests to <code>/outbound</code>.
<markup
lang="java"
title="Add the following method"
>private void outboundMessageHandler(ServerRequest request,
                                     ServerResponse response) {
    var spanBuilder = Tracer.global().spanBuilder("outboundMessageHandler");
    request.context().get(SpanContext.class).ifPresent(spanBuilder::parent);
    var span = spanBuilder.start();

    try (Scope scope = span.activate()) {
        ClientResponseTyped&lt;JsonObject&gt; remoteResult = webClient.get()
                .path("/greet")
                .accept(MediaTypes.APPLICATION_JSON)
                .request(JsonObject.class);

        response.status(remoteResult.status()).send(remoteResult.entity());
        span.end();
    } catch (Exception e) {
        response.status(Status.INTERNAL_SERVER_ERROR_500).send();
        span.end(e);
    }
}</markup>

</li>
</ol>

<p>Stop the application if it is still running, rebuild and run it, then invoke the endpoint and check the response.</p>

<markup
lang="bash"
title="Build, run, and access the application"
>mvn clean package
java -jar target/helidon-quickstart-se.jar
curl -i http://localhost:8080/greet/outbound <span class="conum" data-value="1" />
...
{
  "message": "Hello From SE-2 World!" <span class="conum" data-value="2" />
}</markup>

<ul class="colist">
<li data-value="1">The request goes to the service on <code>8080</code>, which then invokes the service at <code>8081</code> to get the greeting.</li>
<li data-value="2">Notice the greeting came from the second service.</li>
</ul>

<p>Refresh the Jaeger UI trace listing page and notice that there is a trace across two services. Click on that trace to see its details.</p>

<div class="fit"><div>
<div class="block-title"><span>Tracing across multiple services detail view</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/tracing_se_second_expanded_trace.png" alt="Traces" />
</v-card-text>
</v-card>
</div></div>

<p>Note several things about the display:</p>

<ol style="margin-left: 15px;">
<li>
The top-level span <code>helidon-se-1 HTTP Request</code> includes all the work across <em>both</em> services.

</li>
<li>
<code>helidon-se-1 outboundMessageHandler</code> is the custom span you added to the first service <code>/outbound</code> endpoint code.

</li>
<li>
<code>helidon-se-1 GET-http://localhost:8080/greet</code> captures the work the <code>WebClient</code> is doing in sending a request to the second service. Helidon adds these spans automatically to each outbound <code>WebClient</code> request.

</li>
<li>
<code>helidon-se-2 HTTP Request</code> represents the arrival of the request sent by the first service&#8217;s <code>WebClient</code> at the second service&#8217;s <code>/greet</code> endpoint.

</li>
<li>
<code>helidon-se-2 getDefaultMessageHandler</code> is the custom span you added to the second service <code>/greet</code> endpoint code.

</li>
</ol>

<p>You can now stop your second service, it is no longer used in this guide.</p>

</div>

</div>


<h2 id="_integration_with_kubernetes">Integration with Kubernetes</h2>
<div class="section">
<p>The following example demonstrates how to use Jaeger from a Helidon application running in Kubernetes.</p>

<markup
lang="bash"
title="Replace the tracing configuration in <code>resources/application.yaml</code> with the following:"
><span class="conum" data-value="1" />
tracing:
  service: helidon-se-1
  host: jaeger</markup>

<ul class="colist">
<li data-value="1">Helidon service <code>helidon-se-1</code> will connect to the Jaeger server at host name <code>jaeger</code>.</li>
</ul>

<markup
lang="bash"
title="Stop the application and build the docker image for your application:"
>docker build -t helidon-tracing-se .</markup>


<h3 id="_deploy_jaeger_into_kubernetes">Deploy Jaeger into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>jaeger.yaml</code>, with the following contents:"
>apiVersion: v1
kind: Service
metadata:
  name: jaeger
spec:
  ports:
    - port: 16686
      protocol: TCP
  selector:
    app: jaeger
---
kind: Pod
apiVersion: v1
metadata:
  name: jaeger
  labels:
    app: jaeger
spec:
  containers:
    - name: jaeger
      image: jaegertracing/all-in-one
      imagePullPolicy: IfNotPresent
      ports:
        - containerPort: 16686</markup>

<markup
lang="bash"
title="Create the Jaeger pod and ClusterIP service:"
>kubectl apply -f ./jaeger.yaml</markup>

<markup
lang="bash"
title="Create a Jaeger external server to view the UI and expose it on port 9142:"
>kubectl expose pod  jaeger --name=jaeger-external --port=16687 --target-port=16686 --type=LoadBalancer</markup>

<p>Navigate to <a target="_blank" href="http://localhost:16687/jaeger" class="bare">http://localhost:16687/jaeger</a> to validate that you can access Jaeger running in Kubernetes. It may
take a few seconds before it is ready.</p>

</div>


<h3 id="_deploy_your_helidon_application_into_kubernetes">Deploy Your Helidon Application into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>tracing.yaml</code>, with the following contents:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-tracing <span class="conum" data-value="1" />
  labels:
    app: helidon-tracing
spec:
  type: NodePort
  selector:
    app: helidon-tracing
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-tracing
spec:
  replicas: 1 <span class="conum" data-value="2" />
  selector:
    matchLabels:
      app: helidon-tracing
  template:
    metadata:
      labels:
        app: helidon-tracing
        version: v1
    spec:
      containers:
        - name: helidon-tracing
          image: helidon-tracing-se
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./tracing.yaml</markup>

</div>


<h3 id="_access_your_application_and_the_jaeger_trace">Access Your Application and the Jaeger Trace</h3>
<div class="section">
<markup
lang="bash"
title="Get the application service information:"
>kubectl get service/helidon-tracing</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-tracing   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the tracing endpoint using port <code>31143</code>, your port will likely be different:"
>curl http://localhost:31143/greet
...
{
  "message": "Hello World!"
}</markup>

<p>Access the Jaeger UI at <a target="_blank" href="http://localhost:9412/jaeger" class="bare">http://localhost:9412/jaeger</a> and click on the refresh icon to see the trace that was just created.</p>

</div>


<h3 id="_cleanup">Cleanup</h3>
<div class="section">
<p>You can now delete the Kubernetes resources just created during this example.</p>

<markup
lang="bash"
title="Delete the Kubernetes resources:"
>kubectl delete -f ./jaeger.yaml
kubectl delete -f ./tracing.yaml
kubectl delete service jaeger-external
docker rm -f jaeger</markup>

</div>

</div>


<h2 id="_summary">Summary</h2>
<div class="section">
<p>This guide has demonstrated how to use the Helidon SE tracing feature with Jaeger. You have learned to do the following:</p>

<ul class="ulist">
<li>
<p>Enable tracing within a service</p>

</li>
<li>
<p>Use tracing with JAX-RS</p>

</li>
<li>
<p>Use the Jaeger REST API and UI</p>

</li>
<li>
<p>Use tracing across multiple services</p>

</li>
<li>
<p>Integrate tracing with Kubernetes</p>

</li>
</ul>

<p>Refer to the following references for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/microprofile-opentracing-spec-3.0.html">MicroProfile OpenTracing specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/apidocs">MicroProfile OpenTracing Javadoc</a></p>
<ul class="ulist">
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a></p>

</li>
</ul>

</li>
<li>
<p><a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadoc</a></p>

</li>
</ul>

</div>

</doc-view>
