<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The Helidon SE DB Client provides a unified API for working with databases.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable DB Client
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.dbclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-dbclient&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>To use with a JDBC client also add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.dbclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-dbclient-jdbc&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Or to use with MongoDB client add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.dbclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-dbclient-mongodb&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The DB Client simplifies how you work with databases by abstracting the type of the database.
The API can be used both for relational and non-relational databases.</p>

</div>


<h2 id="_api">API</h2>
<div class="section">
<ul class="ulist">
<li>
<p>Database configuration abstraction</p>
<p>Using Helidon configuration allows database implementation specific configuration options
without the need to use database implementation specific APIs. This allows for seamless switching between databases
based on configuration.</p>

</li>
<li>
<p>Statement configuration abstraction</p>
<p>Using Helidon configuration allows use of database specific statements. This allows usage of
different databases on different environments without changing code.</p>

</li>
<li>
<p>Unified API for data access and query</p>
<p>Thanks to the statement configuration abstraction, we can invoke a statement against a relational
or non-relations databases (such as MySQL and MongoDB) without modifying source code</p>

</li>
<li>
<p>Observability<br>
</p>
<p>The API offers support for health checks, metrics and tracing.</p>

</li>
</ul>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Before you begin you must add the DB Client dependencies and configure the client.</p>


<h3 id="_add_the_db_client_dependencies_to_the_maven_pom_xml_file">Add the DB Client dependencies to the Maven <code>pom.xml</code> file.</h3>
<div class="section">
<p>For the DB Client using JDBC implementation and H2 database, you must include the following dependencies in your project:</p>

<markup
lang="xml"

>&lt;dependencies&gt;
     &lt;dependency&gt;
         &lt;groupId&gt;io.helidon.dbclient&lt;/groupId&gt; <span class="conum" data-value="1" />
         &lt;artifactId&gt;helidon-dbclient&lt;/artifactId&gt;
     &lt;/dependency&gt;
     &lt;dependency&gt;
         &lt;groupId&gt;io.helidon.dbclient&lt;/groupId&gt; <span class="conum" data-value="2" />
         &lt;artifactId&gt;helidon-dbclient-jdbc&lt;/artifactId&gt;
     &lt;/dependency&gt;
     &lt;dependency&gt;
         &lt;groupId&gt;com.h2database&lt;/groupId&gt; <span class="conum" data-value="3" />
         &lt;artifactId&gt;h2&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<ul class="colist">
<li data-value="1">Add the Helidon DB Client</li>
<li data-value="2">Specify JDBC or MongoDB</li>
<li data-value="3">Add the database JDBC driver (only for JDBC)</li>
</ul>

</div>


<h3 id="_use_helidon_config_to_configure_the_client">Use Helidon Config to configure the client.</h3>
<div class="section">
<p>The DB Client must be configured before you begin. In the example below we&#8217;ll use Helidon Config to set up JDBC-based client:</p>

<markup
lang="yaml"

>db:
  source: "jdbc" <span class="conum" data-value="1" />
  connection:
    url: "jdbc:mysql://127.0.0.1:3306/pokemon?useSSL=false" <span class="conum" data-value="2" />
    username: "user"
    password: "password"
  statements: <span class="conum" data-value="3" />
    ping: "DO 0" <span class="conum" data-value="4" />
    select-all-pokemons: "SELECT id, name FROM Pokemons"</markup>

<ul class="colist">
<li data-value="1">Source: <code>jdbc</code> or <code>mongoDb</code></li>
<li data-value="2">Connection: database connection parameters</li>
<li data-value="3">Statements: named statements to be used in application</li>
<li data-value="4">A ping statement used by health check</li>
</ul>

</div>

</div>


<h2 id="_using_db_client_api_methods">Using DB Client API Methods</h2>
<div class="section">
<p>The Helidon DB Client API contains many methods to run various statements with parameters and to retrieve statement execution
results. The following sections describe the options you can use to build and execute your statements.</p>


<h3 id="_executor_selection">Executor Selection</h3>
<div class="section">
<p><code>DBClient</code> class has two methods to select whether statements will be executed in transaction or not:</p>

<ul class="ulist">
<li>
<p><code>execute()</code></p>

</li>
<li>
<p><code>transaction()</code></p>

</li>
</ul>

<p>Both methods provide an executor: either <code>DbExecute</code> or <code>DbTransaction</code>.</p>

</div>


<h3 id="_statement_building_and_execution">Statement Building and Execution</h3>
<div class="section">
<p>DbExecute class offers many methods for various statements builders:</p>

<ul class="ulist">
<li>
<p>DML statements: <code>createDmlStatement</code>, <code>createNamedDmlStatement</code></p>

</li>
<li>
<p>insert statements: <code>createInsert</code>, <code>createNamedInsert</code></p>

</li>
<li>
<p>update statements: <code>createUpdate</code>, <code>createNamedUpdate</code></p>

</li>
<li>
<p>delete statements: <code>createDelete</code>, <code>createNamedDelete</code></p>

</li>
<li>
<p>query statements: <code>createQuery</code>, <code>createNamedQuery</code></p>

</li>
<li>
<p>get statements: <code>createGet</code>, <code>createNamedGet</code></p>

</li>
</ul>

<p>Methods with "Named" in their name (<code>create<strong>Named</strong>DmlStatement</code>) expect statement name from statements section of Config,
or a named statement configured when the <code>DbClient</code> was created using a <code>Builder</code>.</p>

<p>All statement builders offer methods to set statement parameters. Those parameters can be ordered parameters or named parameters.
Ordered and named parameters can’t be mixed in a single statement.</p>

<p>Note that <code>get</code> statements are query statements that allow zero to one results.</p>

</div>


<h3 id="_ordered_parameters">Ordered Parameters</h3>
<div class="section">
<p>Ordered parameters are written down as <code>?</code> in the statement text:</p>

<markup
lang="sql"

>SELECT name FROM Pokemons WHERE id = ?</markup>

<p>The ordered parameters are equivalent to JDBC <code>PreparedStatement</code> parameters.</p>

<p>Methods to set ordered parameters are:</p>

<ul class="ulist">
<li>
<p><code>params(List&lt;?&gt; parameters)</code> with all parameters as List</p>

</li>
<li>
<p><code>params(Object… parameters)</code> with all parameters as array</p>

</li>
<li>
<p><code>indexedParam(Object parameters)</code> POJO used with registered mapper</p>

</li>
<li>
<p><code>addParam(Object parameter)</code> with single parameter, can be called repeatedly</p>

</li>
</ul>

</div>


<h3 id="_named_parameters">Named Parameters</h3>
<div class="section">
<p>Named parameters are written down as <code>:&lt;name&gt;</code> in the JDBC statements</p>

<markup
lang="sql"

>SELECT name FROM Pokemons WHERE id = :id</markup>

<p>or as <code>$&lt;name&gt;</code> in the MongoDB statement:</p>

<markup
lang="json"

>{
    "collection": "pokemons",
    "operation": "update",
    "value": {
      "$set": {
        "name": "$name"
      }
    },
    "query": { "id": "$id" }
}</markup>

<p>Methods to set named parameters are:</p>

<ul class="ulist">
<li>
<p><code>params(Map&lt;String, ?&gt; parameters)</code> with all parameters as Map</p>

</li>
<li>
<p><code>namedParam(Object parameters)</code> POJO used with registered mapper</p>

</li>
<li>
<p><code>addParam(String name, Object parameter)</code> with single parameter, can be called repeatedly</p>

</li>
</ul>

</div>


<h3 id="_statement_execution">Statement Execution</h3>
<div class="section">
<p>Statements are executed by calling execute() method after statement parameters are set.
This method returns either a <code>Single</code> or <code>Multi</code> depending on statement type. The type returned also depends on statement
type.</p>

<p>JDBC query with ordered parameters and query that does not run in the transaction:</p>

<markup
lang="java"

>dbClient.execute()
    .createQuery("SELECT name FROM Pokemons WHERE id = ?")
    .params(1)
    .execute();</markup>

<p>JDBC query with named parameters and the query runs in transaction:</p>

<markup
lang="java"

>dbClient.transaction()
    .createQuery("SELECT name FROM Pokemons WHERE id = :id")
    .addParam("id", 1)
    .execute();</markup>

<p>Both examples will return <code>Multi&lt;DbRow&gt;</code> with rows returned by the query.</p>

<p>This example shows a MongoDB update statement with named parameters and the query does not run in transaction:</p>

<markup
lang="java"

>dbClient.execute()
    .createUpdate("{\"collection\": \"pokemons\","
        + "\"value\":{$set:{\"name\":$name}},"
        + "\"query\":{id:$id}}")
    .addParam("id", 1)
    .addParam("name", "Pikachu")
    .execute();</markup>

<p>This update statement will return a <code>long</code> with the number of modified records in the database.</p>


<h4 id="_dml_statement_result">DML Statement Result</h4>
<div class="section">
<p>Execution of DML statements will always return a <code>long</code> with the number of modified records in the database.</p>

<p>In following example, the number of modified records is printed to standard output:</p>

<markup
lang="java"

>long count = dbClient.execute()
    .insert("INSERT INTO Pokemons (id, name) VALUES(?, ?)",
        1, "Pikachu"));
System.out.printf("Inserted %d records\n", count)</markup>

</div>


<h4 id="_query_statement_result">Query Statement Result</h4>
<div class="section">
<p>Execution of a query statement will always return <code>Stream&lt;DbRow&gt;&gt;</code>.</p>

<ul class="ulist">
<li>
<p>The stream is populated lazily, result rows can be processed individually</p>

</li>
<li>
<p>Use <code>.map(…)</code> to map returned result</p>

</li>
<li>
<p>Use <code>.toList()</code> on the stream to collect all rows</p>

</li>
</ul>

</div>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Now that you understand how to build and execute statements, try it for yourself.
<a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.4/examples/dbclient">DB Client Examples</a>.</p>

</div>

</doc-view>
