<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_config_example" @click.native="this.scrollFix('#_config_example')">Config Example</router-link></p>

</li>
<li>
<p><router-link to="#_nack_strategy" @click.native="this.scrollFix('#_nack_strategy')">NACK Strategy</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Connecting streams to Kafka with Reactive Messaging is easy to do.
There is a standard Kafka client behind the scenes, all the <a target="_blank" href="https://kafka.apache.org/28/documentation.html#producerconfigs">producer</a> and <a target="_blank" href="https://kafka.apache.org/28/documentation.html#consumerconfigs">consumer</a> configs can
be propagated through messaging config.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Reactive Kafka Connector
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.kafka&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-kafka&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_config_example">Config Example</h2>
<div class="section">
<markup
lang="yaml"
title="Example of connector config:"
>mp.messaging:

  incoming.from-kafka:
    connector: helidon-kafka
    topic: messaging-test-topic-1
    auto.offset.reset: latest <span class="conum" data-value="1" />
    enable.auto.commit: true
    group.id: example-group-id

  outgoing.to-kafka:
    connector: helidon-kafka
    topic: messaging-test-topic-1

  connector:
    helidon-kafka:
      bootstrap.servers: localhost:9092 <span class="conum" data-value="2" />
      key.serializer: org.apache.kafka.common.serialization.StringSerializer
      value.serializer: org.apache.kafka.common.serialization.StringSerializer
      key.deserializer: org.apache.kafka.common.serialization.StringDeserializer
      value.deserializer: org.apache.kafka.common.serialization.StringDeserializer</markup>

<ul class="colist">
<li data-value="1">Kafka client consumer&#8217;s property auto.offset.reset configuration for <code>from-kafka</code> channel only</li>
<li data-value="2">Kafka client&#8217;s property <a target="_blank" href="https://kafka.apache.org/28/documentation.html#consumerconfigs_bootstrap.servers">bootstrap.servers</a> configuration for all channels using the connector</li>
</ul>

<markup
lang="java"
title="Example of consuming from Kafka:"
>@Incoming("from-kafka")
public void consumeKafka(String msg) {
    System.out.println("Kafka says: " + msg);
}</markup>

<markup
lang="java"
title="Example of producing to Kafka:"
>@Outgoing("to-kafka")
public PublisherBuilder&lt;String&gt; produceToKafka() {
    return ReactiveStreams.of("test1", "test2");
}</markup>

</div>


<h2 id="_nack_strategy">NACK Strategy</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Strategy</td>
<td class="">Description</td>
</tr>
<tr>
<td class="">Kill channel</td>
<td class="">Nacked message sends error signal and causes channel failure so Messaging Health check can report it as DOWN</td>
</tr>
<tr>
<td class="">DLQ</td>
<td class="">Nacked messages are sent to specified dead-letter-queue</td>
</tr>
<tr>
<td class="">Log only</td>
<td class="">Nacked message is logged and channel continues normally</td>
</tr>
</tbody>
</table>
</div>


<h3 id="_kill_channel">Kill channel</h3>
<div class="section">
<p>Default NACK strategy for Kafka connector. When</p>

</div>


<h3 id="_dead_letter_queue">Dead Letter Queue</h3>
<div class="section">
<p>Sends nacked messages to error topic, <a target="_blank" href="https://en.wikipedia.org/wiki/Dead_letter_queue">DLQ</a> is well known pattern for dealing with unprocessed messages.</p>

<p>Helidon can derive connection settings for DLQ topic automatically if the error
topic is present on the same Kafka cluster.
Serializers are derived from deserializers used for consumption
<code>org.apache.kafka.common.serialization.StringDeserializer</code> &gt;
<code>org.apache.kafka.common.serialization.StringSerializer</code>.
Note that the name of the error topic is needed only in this case.</p>

<markup
lang="yaml"
title="Example of derived DLQ config:"
>mp.messaging:
  incoming:
    my-channel:
      nack-dlq: dql_topic_name</markup>

<p>If a custom connection is needed, then use the 'nack-dlq' key for all of the producer configuration.</p>

<markup
lang="yaml"
title="Example of custom DLQ config:"
>mp.messaging:
  incoming:
    my-channel:
      nack-dlq:
        topic: dql_topic_name
        bootstrap.servers: localhost:9092
        key.serializer: org.apache.kafka.common.serialization.StringSerializer
        value.serializer: org.apache.kafka.common.serialization.StringSerializer</markup>

</div>


<h3 id="_log_only">Log only</h3>
<div class="section">
<p>Only logs nacked messages and throws them away, offset is committed and channel
continues normally consuming subsequent messages.</p>

<markup
lang="yaml"
title="Example of log only enabled nack strategy"
>mp.messaging:
  incoming:
    my-channel:
      nack-log-only: true</markup>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Don&#8217;t forget to check out the examples with pre-configured Kafka docker image, for easy testing:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.4/examples/messaging" class="bare">https://github.com/oracle/helidon/tree/4.0.4/examples/messaging</a></p>

</li>
</ul>

</div>

</doc-view>
