<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">Coordinator</router-link></p>

</li>
<li>
<p><router-link to="#_helidon_lra_coordinator" @click.native="this.scrollFix('#_helidon_lra_coordinator')">Helidon LRA Coordinator</router-link></p>

</li>
<li>
<p><router-link to="#_narayana" @click.native="this.scrollFix('#_narayana')">Narayana</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Distributed transactions for microservices are known as SAGA design patterns and are defined by the <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-2.0/microprofile-lra-spec-2.0.html">MicroProfile Long Running Actions specification</a>.
Unlike well known XA protocol, LRA is asynchronous and therefore much more scalable. Every LRA JAX-RS resource (<router-link to="#_participant" @click.native="this.scrollFix('#_participant')">participant</router-link>) defines endpoints to be invoked when transaction needs to be <em>completed</em> or <em>compensated</em>.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Long Running Actions
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
  &lt;groupId&gt;io.helidon.microprofile.lra&lt;/groupId&gt;
  &lt;artifactId&gt;helidon-microprofile-lra&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;!-- Support for Narayana coordinator --&gt;
&lt;dependency&gt;
  &lt;groupId&gt;io.helidon.lra&lt;/groupId&gt;
  &lt;artifactId&gt;helidon-lra-coordinator-narayana-client&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>The LRA transactions need to be coordinated over REST API by the LRA coordinator. <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">Coordinator</router-link>
keeps track of all transactions and calls the <code>@Compensate</code> or <code>@Complete</code> endpoints for all participants involved in the particular
transaction. LRA transaction is first started, then joined by <router-link to="#_participant" @click.native="this.scrollFix('#_participant')">participant</router-link>.
The participant reports the successful finish of the transaction by calling it complete. The coordinator then calls the JAX-RS
<em>complete</em> endpoint that was registered during the join of each
<router-link to="#_participant" @click.native="this.scrollFix('#_participant')">participant</router-link>. As the completed or compensated participants don&#8217;t have to be on same instance,
the whole architecture is highly scalable.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/lra/lra-complete-lb.svg" alt="Complete" />
</v-card-text>
</v-card>


<p>If an error occurs during the LRA transaction, the participant reports a cancellation of LRA to the coordinator. <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">Coordinator</router-link> calls compensate on all the joined participants.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/lra/lra-compensate-lb-error.svg" alt="Cancel" />
</v-card-text>
</v-card>


<p>When a participant joins the LRA with timeout defined <code>@LRA(value = LRA.Type.REQUIRES_NEW, timeLimit = 5, timeUnit = ChronoUnit.MINUTES)</code>, the coordinator compensates if the timeout occurred before the close is reported by the participants.</p>



<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/lra/lra-compensate-lb-timeout.svg" alt="Timeout" />
</v-card-text>
</v-card>


</div>


<h2 id="_api">API</h2>
<div class="section">

<h3 id="_participant">Participant</h3>
<div class="section">
<p>The Participant, or Compensator, is an LRA resource with at least one of the JAX-RS(or non-JAX-RS) methods annotated with
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/Compensate.html">@Compensate</a> or <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/AfterLRA.html">@AfterLRA</a>.</p>

</div>


<h3 id="lra-method">@LRA</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html"><sub>javadoc</sub></a></p>

<p>Marks JAX-RS method which should run in LRA context and needs to be accompanied by at least minimal set of mandatory
participant methods(<router-link to="#compensate-participant-method" @click.native="this.scrollFix('#compensate-participant-method')">Compensate</router-link> or <router-link to="#after-participant-method" @click.native="this.scrollFix('#after-participant-method')">AfterLRA</router-link>).</p>

<p>LRA options:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#value--">value</a></p>
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#REQUIRED">REQUIRED</a> join incoming LRA or create and join new</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#REQUIRES_NEW">REQUIRES_NEW</a> create and join new LRA</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#MANDATORY">MANDATORY</a> join incoming LRA or fail</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#SUPPORTS">SUPPORTS</a> join incoming LRA or continue outside LRA context</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#NOT_SUPPORTED">NOT_SUPPORTED</a> always continue outside LRA context</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#NEVER">NEVER</a> Fail with 412 if executed in LRA context</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.Type.html#NESTED">NESTED</a> create and join new LRA nested in the incoming LRA context</p>

</li>
</ul>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#timeLimit--">timeLimit</a> max time limit before LRA gets cancelled automatically by <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#timeUnit--">timeUnit</a> time unit if the timeLimit value</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#end--">end</a> when false LRA is not closed after successful method execution</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#cancelOn--">cancelOn</a> which HTTP response codes of the method causes LRA to cancel</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#cancelOnFamily--">cancelOnFamily</a> which family of HTTP response codes causes LRA to cancel</p>

</li>
</ul>

<p>Method parameters:</p>

<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
</ul>

<markup
lang="java"

>@PUT
@LRA(LRA.Type.REQUIRES_NEW, timeLimit = 500, timeUnit = ChronoUnit.MILLIS)
@Path("start-example")
public Response startLra(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId, String data)</markup>

</div>


<h3 id="compensate-participant-method">@Compensate</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/Compensate.html"><sub>javadoc</sub></a></p>

<div class="admonition caution">
<p class="admonition-inline">Expected to be called by LRA <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> only!</p>
</div>

<p>Compensate method is called by a <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> when LRA is cancelled,
usually by error during execution of method body of <router-link to="#lra-method" @click.native="this.scrollFix('#lra-method')">@LRA annotated method</router-link>.
If the method responds with 500 or 202, coordinator will eventually try the call again.
If participant has <router-link to="#status-participant-method" @click.native="this.scrollFix('#status-participant-method')">@Status annotated method</router-link>, <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link>
retrieves the status to find out if retry should be done.</p>


<h4 id="_jax_rs_variant_with_supported_lra_context_values">JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_PARENT_CONTEXT_HEADER">LRA_HTTP_PARENT_CONTEXT_HEADER</a> - parent LRA ID in case of nested LRA</p>

</li>
</ul>

<markup
lang="java"

>@PUT
@Path("/compensate")
@Compensate
public Response compensateWork(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId,
                               @HeaderParam(LRA_HTTP_PARENT_CONTEXT_HEADER) URI parent){
    return LRAResponse.compensated();
}</markup>

</div>


<h4 id="_non_jax_rs_variant_with_supported_lra_context_values">Non JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>URI with LRA ID</p>

</li>
</ul>

<markup
lang="java"

>@Compensate
public void compensate(URI lraId)</markup>

</div>

</div>


<h3 id="complete-participant-method">@Complete</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/Complete.html"><sub>javadoc</sub></a></p>

<div class="admonition caution">
<p class="admonition-inline">Expected to be called by LRA <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> only!</p>
</div>

<p>Complete method is called by <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> when LRA is successfully closed.
If the method responds with 500 or 202, coordinator will eventually try the call again.
If participant has <router-link to="#status-participant-method" @click.native="this.scrollFix('#status-participant-method')">@Status annotated method</router-link>, <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> retrieves the status to find out if retry should be done.</p>


<h4 id="_jax_rs_variant_with_supported_lra_context_values_2">JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_PARENT_CONTEXT_HEADER">LRA_HTTP_PARENT_CONTEXT_HEADER</a> - parent LRA ID in case of nested LRA</p>

</li>
</ul>

<markup
lang="java"

>@PUT
@Path("/complete")
@Complete
public Response complete(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId,
                         @HeaderParam(LRA_HTTP_PARENT_CONTEXT_HEADER) URI parentLraId)</markup>

</div>


<h4 id="_non_jax_rs_variant_with_supported_lra_context_values_2">Non JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>URI with LRA ID</p>

</li>
</ul>

<markup
lang="java"

>@Complete
public void complete(URI lraId)</markup>

</div>

</div>


<h3 id="_forget">@Forget</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/Forget.html"><sub>javadoc</sub></a></p>

<div class="admonition caution">
<p class="admonition-inline">Expected to be called by LRA <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> only!</p>
</div>

<p><router-link to="#complete-participant-method" @click.native="this.scrollFix('#complete-participant-method')">Complete</router-link> and <router-link to="#complete-participant-method" @click.native="this.scrollFix('#complete-participant-method')">compensate</router-link>
methods can fail(500) or report that compensation/completion is in progress(202).
In such case participant needs to be prepared to report its status over <router-link to="#status-participant-method" @click.native="this.scrollFix('#status-participant-method')">@Status annotated method</router-link>
to <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link>.
When <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> decides all the participants have finished, method annotated with @Forget is called.</p>


<h4 id="_jax_rs_variant_with_supported_lra_context_values_3">JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_PARENT_CONTEXT_HEADER">LRA_HTTP_PARENT_CONTEXT_HEADER</a> - parent LRA ID in case of nested LRA</p>

</li>
</ul>

<markup
lang="java"

>@DELETE
@Path("/forget")
@Forget
public Response forget(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId,
                       @HeaderParam(LRA_HTTP_PARENT_CONTEXT_HEADER) URI parent)</markup>

</div>


<h4 id="_non_jax_rs_variant_with_supported_lra_context_values_3">Non JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>URI with LRA ID</p>

</li>
</ul>

<markup
lang="java"

>@Forget
public void forget(URI lraId)
}</markup>

</div>

</div>


<h3 id="_leave">@Leave</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/Leave.html"><sub>javadoc</sub></a></p>

<p>Method annotated with @Leave called with LRA context(with header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a>) informs <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> that current participant is leaving the LRA.
Method body is executed after leave signal is sent.
As a result, participant methods complete and compensate won&#8217;t be called when the particular LRA ends.</p>

<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
</ul>

<markup
lang="java"

>@PUT
@Path("/leave")
@Leave
public Response leaveLRA(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraIdtoLeave)</markup>

</div>


<h3 id="status-participant-method">@Status</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/Status.html"><sub>javadoc</sub></a></p>

<div class="admonition caution">
<p class="admonition-inline">Expected to be called by LRA <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> only!</p>
</div>

<p>If the coordinator&#8217;s call to the participant&#8217;s method fails, then it will retry the call.
If the participant is not idempotent, then it may need to report its state to coordinator by declaring method
annotated with @Status for reporting if previous call did change participant status.
<router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">Coordinator</router-link> can call it and decide if compensate or complete retry is needed.</p>


<h4 id="_jax_rs_variant_with_supported_lra_context_values_4">JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_CONTEXT_HEADER">LRA_HTTP_CONTEXT_HEADER</a> - ID of the LRA transaction</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ParticipantStatus.html">ParticipantStatus</a> - Status of the participant reported to <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link></p>

</li>
</ul>

<markup
lang="java"

>@GET
@Path("/status")
@Status
public Response reportStatus(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId) {
    return Response.status(ParticipantStatus.FailedToCompensate).build();
}</markup>

</div>


<h4 id="_non_jax_rs_variant_with_supported_lra_context_values_4">Non JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>URI with LRA ID</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ParticipantStatus.html">ParticipantStatus</a> - Status of the participant reported to <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link></p>

</li>
</ul>

<markup
lang="java"

>@Status
public Response reportStatus(URI lraId){
    return Response.ok(ParticipantStatus.FailedToCompensate).build();
}</markup>

</div>

</div>


<h3 id="after-participant-method">@AfterLRA</h3>
<div class="section">
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/AfterLRA.html"><sub>javadoc</sub></a></p>

<div class="admonition caution">
<p class="admonition-inline">Expected to be called by LRA <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link> only!</p>
</div>

<p>Method annotated with <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/AfterLRA.html">@AfterLRA</a> in the same class as the one with @LRA annotation gets invoked after particular LRA finishes.</p>


<h4 id="_jax_rs_variant_with_supported_lra_context_values_5">JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_ENDED_CONTEXT_HEADER">LRA_HTTP_ENDED_CONTEXT_HEADER</a> - ID of the finished LRA transaction</p>

</li>
<li>
<p>Header <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/ws/rs/LRA.html#LRA_HTTP_PARENT_CONTEXT_HEADER">LRA_HTTP_PARENT_CONTEXT_HEADER</a> - parent LRA ID in case of nested LRA</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html">LRAStatus</a> - Final status of the LRA (<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#Cancelled">Cancelled</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#Closed">Closed</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#FailedToCancel">FailedToCancel</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#FailedToClose">FailedToClose</a>)</p>

</li>
</ul>

<markup
lang="java"

>@PUT
@Path("/finished")
@AfterLRA
public Response whenLRAFinishes(@HeaderParam(LRA_HTTP_ENDED_CONTEXT_HEADER) URI lraId,
                                @HeaderParam(LRA_HTTP_PARENT_CONTEXT_HEADER) URI parentLraId,
                                LRAStatus status)</markup>

</div>


<h4 id="_non_jax_rs_variant_with_supported_lra_context_values_5">Non JAX-RS variant with supported LRA context values:</h4>
<div class="section">
<ul class="ulist">
<li>
<p>URI with finished LRA ID</p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html">LRAStatus</a> - Final status of the LRA (<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#Cancelled">Cancelled</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#Closed">Closed</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#FailedToCancel">FailedToCancel</a>, <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/annotation/LRAStatus.html#FailedToClose">FailedToClose</a>)</p>

</li>
</ul>

<markup
lang="java"

>public void whenLRAFinishes(URI lraId, LRAStatus status)</markup>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<markup
lang="text"
title="Type"
>io.helidon.microprofile.lra</markup>

<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>Key</th>
<th>Type</th>
<th>Default value</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>mp.lra.coordinator.url</code></td>
<td class="">string</td>
<td class=""><code>http://localhost:8070/lra-coordinator</code></td>
<td class=""><doc-view>
<p>Url of coordinator.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.lra.coordinator.propagation.active</code></td>
<td class="">boolean</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Propagate LRA headers <code>LRA_HTTP_CONTEXT_HEADER</code> and <code>LRA_HTTP_PARENT_CONTEXT_HEADER</code> through non-LRA endpoints.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.lara.participant.url</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Url of the LRA enabled service overrides standard base uri, so coordinator can call load-balancer instead of the service.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.lra.coordinator.timeout</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Timeout for synchronous communication with coordinator.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>mp.lra.coordinator.timeout-unit</code></td>
<td class="">string</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Timeout unit for synchronous communication with coordinator.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="yaml"
title="Example of LRA configuration"
>mp.lra:
  coordinator.url: http://localhost:8070/lra-coordinator <span class="conum" data-value="1" />
  propagation.active: true <span class="conum" data-value="2" />
  participant.url: http://coordinator.visible.host:80/awesomeapp <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Url of coordinator</li>
<li data-value="2">Propagate LRA headers LRA_HTTP_CONTEXT_HEADER and LRA_HTTP_PARENT_CONTEXT_HEADER through non-LRA endpoints</li>
<li data-value="3">Url of the LRA enabled service overrides standard base uri,
so coordinator can call load-balancer instead of the service</li>
</ul>

<p>For more information continue to <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-2.0/microprofile-lra-spec-2.0.html">MicroProfile Long Running Actions specification</a>.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>The following example shows how a simple LRA participant starts and joins a transaction after calling the '/start-example' resource.
When startExample method finishes successfully, close is reported to <router-link to="#_coordinator" @click.native="this.scrollFix('#_coordinator')">coordinator</router-link>
and <code>/complete-example</code> endpoint is called by coordinator to confirm successful closure of the LRA.</p>

<p>If an exception occurs during startExample method execution, coordinator receives cancel call and <code>/compensate-example</code>
is called by coordinator to compensate for cancelled LRA transaction.</p>

<markup
lang="java"
title="Example of simple LRA participant"
>@PUT
@LRA(LRA.Type.REQUIRES_NEW) <span class="conum" data-value="1" />
@Path("start-example")
public Response startExample(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId, <span class="conum" data-value="2" />
                             String data) {
    if (data.contains("BOOM")) {
        throw new RuntimeException("BOOM 💥"); <span class="conum" data-value="3" />
    }

    LOGGER.info("Data " + data + " processed 🏭");
    return Response.ok().build(); <span class="conum" data-value="4" />
}

@PUT
@Complete <span class="conum" data-value="5" />
@Path("complete-example")
public Response completeExample(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId) {
    LOGGER.log(Level.INFO, "LRA ID: {0} completed 🎉", lraId);
    return LRAResponse.completed();
}

@PUT
@Compensate <span class="conum" data-value="6" />
@Path("compensate-example")
public Response compensateExample(@HeaderParam(LRA_HTTP_CONTEXT_HEADER) URI lraId) {
    LOGGER.log(Level.SEVERE, "LRA ID: {0} compensated 🦺", lraId);
    return LRAResponse.compensated();
}</markup>

<ul class="colist">
<li data-value="1">This JAX-RS PUT method will start new LRA transactions and join it before method body gets executed</li>
<li data-value="2">LRA ID assigned by coordinator to this LRA transaction</li>
<li data-value="3">When method execution finishes exceptionally, cancel signal for this particular LRA is sent to coordinator</li>
<li data-value="4">When method execution finishes successfully, complete signal for this particular LRA is sent to coordinator</li>
<li data-value="5">Method which will be called by coordinator when LRA is completed</li>
<li data-value="6">Method which will be called by coordinator when LRA is canceled</li>
</ul>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_coordinator">Coordinator</h3>
<div class="section">
<p>Coordinator is a service that tracks all LRA transactions and calls the compensate REST endpoints of
the participants when the LRA transaction gets cancelled or completes (in case it gets closed).
In addition, participant also keeps track of timeouts, retries participant calls, and assigns LRA ids.</p>

<ul class="ulist">
<li>
<p>Helidon LRA coordinator</p>

</li>
<li>
<p><a target="_blank" href="https://narayana.io/lra">Narayana coordinator</a>.</p>

</li>
</ul>

</div>


<h3 id="_helidon_lra_coordinator">Helidon LRA Coordinator</h3>
<div class="section">
<div class="admonition caution">
<p class="admonition-inline">Experimental tool, usage in production is not advised.</p>
</div>

<markup
lang="bash"
title="Build and run Helidon LRA coordinator"
>docker build -t helidon/lra-coordinator https://github.com/oracle/helidon.git#:lra/coordinator/server
docker run --name lra-coordinator --network="host" helidon/lra-coordinator</markup>

<p>Helidon LRA coordinator is compatible with Narayana clients, you need to add an additional dependency for Narayana client:</p>

<markup
lang="xml"
title="Dependency needed for using Helidon LRA with Narayana compatible coordinator"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.lra&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-lra-coordinator-narayana-client&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_narayana">Narayana</h3>
<div class="section">
<p><a target="_blank" href="https://narayana.io">Narayana</a> is a transaction manager supporting LRA.
To use Narayana LRA coordinator with Helidon LRA client you need to add an additional dependency for Narayana client:</p>

<markup
lang="xml"
title="Dependency needed for using Helidon LRA with Narayana coordinator"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.lra&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-lra-coordinator-narayana-client&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>The simplest way to run Narayana LRA coordinator locally:</p>

<markup
lang="bash"
title="Downloading and running Narayana LRA coordinator"
>wget https://search.maven.org/remotecontent?filepath=org/jboss/narayana/rts/lra-coordinator-quarkus/5.11.1.Final/lra-coordinator-quarkus-5.11.1.Final-runner.jar \
-O narayana-coordinator.jar \
&amp;&amp; java -Dquarkus.http.port=8070 -jar narayana-coordinator.jar</markup>

<p>Narayana LRA coordinator is running by default under <code>lra-coordinator</code> context,
with port <code>8070</code> defined in the snippet above you need to configure your Helidon LRA app as follows:
<code>mp.lra.coordinator.url=http://localhost:8070/lra-coordinator</code></p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-lra">MicroProfile LRA GitHub Repository</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-2.0/microprofile-lra-spec-2.0.html">MicroProfile Long Running Actions specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-1.0-RC3/apidocs/org/eclipse/microprofile/lra/">Microprofile LRA JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://helidon.io/docs/v4/apidocs/io.helidon.lra.coordinator.client/module-summary.html">Helidon LRA Client JavaDoc</a></p>

</li>
</ul>

</div>

</doc-view>
