<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon supports Bean Validation via its integration with JAX-RS/Jersey. The
<a target="_blank" href="https://jakarta.ee/specifications/bean-validation/3.0/jakarta-bean-validation-spec-3.0.html">Jakarta Bean Validation specification</a> defines an API to validate Java beans.
Bean Validation is supported in REST resource classes as well as in regular application beans.</p>

<p>If bean validation is required outside JAX-RS/Jersey use cases, it is also available in Helidon.
It follows the standard <a target="_blank" href="https://jakarta.ee/specifications/bean-validation/3.0/jakarta-bean-validation-spec-3.0.html">Jakarta Bean Validation specification</a> which defines an API to validate Java beans.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Bean Validation
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
  &lt;groupId&gt;org.glassfish.jersey.ext&lt;/groupId&gt;
  &lt;artifactId&gt;jersey-bean-validation&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For general validation, please add to your <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
  &lt;groupId&gt;io.helidon.microprofile.bean-validation&lt;/groupId&gt;
  &lt;artifactId&gt;helidon-microprofile-bean-validation&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The specification defines a small set of built-in constraints. Their usage is encouraged both in regular constraint declarations and as composing constraints. Using this set of constraints will enhance portability of your constraints across constraint-consuming frameworks relying on the metadata API (such as client side validation frameworks or database schema generation frameworks).</p>

<p>Built-in annotations are annotated with an empty <code>@Constraint</code> annotation to avoid any dependency between the specification API and a specific implementation. Each Jakarta Bean Validation provider must recognize built-in constraint annotations as valid constraint definitions and provide compliant constraint implementations for each. The built-in constraint validation implementation is having a lower priority than an XML mapping definition. In other words ConstraintValidator implementations for built-in constraints can be overridden by using the XML mapping (see Overriding constraint definitions in XML).</p>

<p>All built-in constraints are in the <code>jakarta.validation.constraints</code> package. Here is the list of constraints and their declaration.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 28.571%;">
<col style="width: 71.429%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>@Null</code></td>
<td class="">The annotated element must be <code>null</code>. Accepts any type.</td>
</tr>
<tr>
<td class=""><code>@NotNull</code></td>
<td class="">The annotated element must not be <code>null</code>. Accepts any type.</td>
</tr>
<tr>
<td class=""><code>@AssertTrue</code></td>
<td class="">The annotated element must be true. Supported types are <code>boolean</code> and <code>Boolean</code>. <code>Null</code> elements are considered valid.</td>
</tr>
<tr>
<td class=""><code>@AssertFalse</code></td>
<td class="">The annotated element must be false. Supported types are <code>boolean</code> and <code>Boolean</code>. <code>Null</code> elements are considered valid.</td>
</tr>
<tr>
<td class=""><code>@Min</code></td>
<td class=""><doc-view>
<p>The annotated element must be a number whose value must be higher or equal to the specified minimum.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrappers</p>

</li>
</ul>

<p>Note that <code>double</code> and <code>float</code> are not supported due to rounding errors (some providers might provide some approximative support).</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Max</code></td>
<td class=""><doc-view>
<p>The annotated element must be a number whose value must be higher or equal to the specified minimum.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrappers</p>

</li>
</ul>

<p>Note that <code>double</code> and <code>float</code> are not supported due to rounding errors (some providers might provide some approximative support).</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@DecimalMin</code></td>
<td class=""><doc-view>
<p>The annotated element must be a number whose value must be lower or equal to the specified maximum.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrappers</p>

</li>
</ul>

<p>Note that <code>double</code> and <code>float</code> are not supported due to rounding errors (some providers might provide some approximative support).</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@DecimalMax</code></td>
<td class=""><doc-view>
<p>The annotated element must be a number whose value must be lower or equal to the specified maximum.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrappers</p>

</li>
</ul>

<p>Note that <code>double</code> and <code>float</code> are not supported due to rounding errors (some providers might provide some approximative support).</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Negative</code></td>
<td class=""><doc-view>
<p>The annotated element must be a strictly negative number (i.e. 0 is considered as an invalid value).</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrappers</p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@NegativeOrZero</code></td>
<td class=""><doc-view>
<p>The annotated element must be a negative number or 0.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, <code>float</code>, or <code>double</code> and their respective wrappers</p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Positive</code></td>
<td class=""><doc-view>
<p>The annotated element must be a strictly positive number (i.e. 0 is considered as an invalid value).</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, <code>float</code>, or <code>double</code> and their respective wrappers</p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@PositiveOrZero</code></td>
<td class=""><doc-view>
<p>The annotated element must be a positive number or 0.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, <code>float</code>, or <code>double</code> and their respective wrappers</p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Size</code></td>
<td class=""><doc-view>
<p>The annotated element size must be between the specified boundaries (included).
Supported types are:
 * <code>CharSequence</code> - length of character sequence is evaluated
 * <code>Collection</code> - collection size is evaluated
 * <code>Map</code> - map size is evaluated
 * <code>Array</code> (array length is evaluated)</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Digits</code></td>
<td class=""><doc-view>
<p>The annotated element must be a number within accepted range.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>BigDecimal</code></p>

</li>
<li>
<p><code>BigInteger</code></p>

</li>
<li>
<p><code>CharSequence</code></p>

</li>
<li>
<p><code>byte</code>, <code>short</code>, <code>int</code>, <code>long</code>, and their respective wrapper types</p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Past</code></td>
<td class=""><doc-view>
<p>The annotated element must be an instant, date or time in the past or in the present.
<code>Now</code> is defined by the <code>ClockProvider</code> attached to the <code>Validator</code> or <code>ValidatorFactory</code>. The default <code>clockProvider</code> defines the current time
according to the virtual machine, applying the current default time zone if needed.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>java.util.Date</code></p>

</li>
<li>
<p><code>java.util.Calendar</code></p>

</li>
<li>
<p><code>java.time.Instant</code></p>

</li>
<li>
<p><code>java.time.LocalDate</code></p>

</li>
<li>
<p><code>java.time.LocalDateTime</code></p>

</li>
<li>
<p><code>java.time.LocalTime</code></p>

</li>
<li>
<p><code>java.time.MonthDay</code></p>

</li>
<li>
<p><code>java.time.OffsetDateTime</code></p>

</li>
<li>
<p><code>java.time.OffsetTime</code></p>

</li>
<li>
<p><code>java.time.Year</code></p>

</li>
<li>
<p><code>java.time.YearMonth</code></p>

</li>
<li>
<p><code>java.time.ZonedDateTime</code></p>

</li>
<li>
<p><code>java.time.chrono.HijrahDate</code></p>

</li>
<li>
<p><code>java.time.chrono.JapaneseDate</code></p>

</li>
<li>
<p><code>java.time.chrono.MinguoDate</code></p>

</li>
<li>
<p><code>java.time.chrono.ThaiBuddhistDate</code></p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@PastOrPresent</code></td>
<td class=""><doc-view>
<p>The annotated element must be an instant, date or time in the past or in the present.
<code>Now</code> is defined by the <code>ClockProvider</code> attached to the <code>Validator</code> or <code>ValidatorFactory</code>. The default <code>clockProvider</code> defines the current time
according to the virtual machine, applying the current default time zone if needed.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>java.util.Date</code></p>

</li>
<li>
<p><code>java.util.Calendar</code></p>

</li>
<li>
<p><code>java.time.Instant</code></p>

</li>
<li>
<p><code>java.time.LocalDate</code></p>

</li>
<li>
<p><code>java.time.LocalDateTime</code></p>

</li>
<li>
<p><code>java.time.LocalTime</code></p>

</li>
<li>
<p><code>java.time.MonthDay</code></p>

</li>
<li>
<p><code>java.time.OffsetDateTime</code></p>

</li>
<li>
<p><code>java.time.OffsetTime</code></p>

</li>
<li>
<p><code>java.time.Year</code></p>

</li>
<li>
<p><code>java.time.YearMonth</code></p>

</li>
<li>
<p><code>java.time.ZonedDateTime</code></p>

</li>
<li>
<p><code>java.time.chrono.HijrahDate</code></p>

</li>
<li>
<p><code>java.time.chrono.JapaneseDate</code></p>

</li>
<li>
<p><code>java.time.chrono.MinguoDate</code></p>

</li>
<li>
<p><code>java.time.chrono.ThaiBuddhistDate</code></p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@PastOrPresent</code></td>
<td class=""><doc-view>
<p>The annotated element must be an instant, date or time in the future.
<code>Now</code> is defined by the <code>ClockProvider</code> attached to the <code>Validator</code> or <code>ValidatorFactory</code>. The default <code>clockProvider</code> defines the current time
according to the virtual machine, applying the current default time zone if needed.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>java.util.Date</code></p>

</li>
<li>
<p><code>java.util.Calendar</code></p>

</li>
<li>
<p><code>java.time.Instant</code></p>

</li>
<li>
<p><code>java.time.LocalDate</code></p>

</li>
<li>
<p><code>java.time.LocalDateTime</code></p>

</li>
<li>
<p><code>java.time.LocalTime</code></p>

</li>
<li>
<p><code>java.time.MonthDay</code></p>

</li>
<li>
<p><code>java.time.OffsetDateTime</code></p>

</li>
<li>
<p><code>java.time.OffsetTime</code></p>

</li>
<li>
<p><code>java.time.Year</code></p>

</li>
<li>
<p><code>java.time.YearMonth</code></p>

</li>
<li>
<p><code>java.time.ZonedDateTime</code></p>

</li>
<li>
<p><code>java.time.chrono.HijrahDate</code></p>

</li>
<li>
<p><code>java.time.chrono.JapaneseDate</code></p>

</li>
<li>
<p><code>java.time.chrono.MinguoDate</code></p>

</li>
<li>
<p><code>java.time.chrono.ThaiBuddhistDate</code></p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@FutureOrPresent</code></td>
<td class=""><doc-view>
<p>The annotated element must be an instant, date or time in the present or in the future.
<code>Now</code> is defined by the <code>ClockProvider</code> attached to the <code>Validator</code> or <code>ValidatorFactory</code>. The default <code>clockProvider</code> defines the current time
according to the virtual machine, applying the current default time zone if needed.</p>

<p>Supported types are:</p>

<ul class="ulist">
<li>
<p><code>java.util.Date</code></p>

</li>
<li>
<p><code>java.util.Calendar</code></p>

</li>
<li>
<p><code>java.time.Instant</code></p>

</li>
<li>
<p><code>java.time.LocalDate</code></p>

</li>
<li>
<p><code>java.time.LocalDateTime</code></p>

</li>
<li>
<p><code>java.time.LocalTime</code></p>

</li>
<li>
<p><code>java.time.MonthDay</code></p>

</li>
<li>
<p><code>java.time.OffsetDateTime</code></p>

</li>
<li>
<p><code>java.time.OffsetTime</code></p>

</li>
<li>
<p><code>java.time.Year</code></p>

</li>
<li>
<p><code>java.time.YearMonth</code></p>

</li>
<li>
<p><code>java.time.ZonedDateTime</code></p>

</li>
<li>
<p><code>java.time.chrono.HijrahDate</code></p>

</li>
<li>
<p><code>java.time.chrono.JapaneseDate</code></p>

</li>
<li>
<p><code>java.time.chrono.MinguoDate</code></p>

</li>
<li>
<p><code>java.time.chrono.ThaiBuddhistDate</code></p>

</li>
</ul>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@FutureOrPresent</code></td>
<td class=""><doc-view>
<p>The annotated <code>CharSequence</code> must match the specified regular expression.
The regular expression follows the Java regular expression conventions see <code>java.util.regex.Pattern</code>.
Accepts <code>CharSequence</code>.</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@NotEmpty</code></td>
<td class=""><doc-view>
<p>The annotated element must not be <code>null</code> nor empty.
Supported types are:
* <code>CharSequence</code> - length of character sequence is evaluated
* <code>Collection</code> - collection size is evaluated
* <code>Map</code> - map size is evaluated
* <code>Array</code> (array length is evaluated)</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@NotBlank</code></td>
<td class=""><doc-view>
<p>The annotated element must not be <code>null</code> and must contain at least one
non-whitespace character. Accepts <code>CharSequence</code>.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>@Email</code></td>
<td class=""><doc-view>
<p>The string has to be a well-formed email address. Exact semantics of what makes up a valid
email address are left to Jakarta Bean Validation providers. Accepts <code>CharSequence</code>.</p>

<p><code>Null</code> elements are considered valid.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Bean Validation can be configured using <code>META-INF/validation.xml</code>.</p>

<p>For more information about configuring the validator factory in validation.xml, see <a target="_blank" href="https://docs.jboss.org/hibernate/stable/validator/reference/en-US/html_single/?v=7.0#chapter-xml-configuration">Hibernate Validator Documentation</a>.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<ol style="margin-left: 15px;">
<li>
The following example shows a simple resource method annotated with <code>@POST</code> whose
parameter must be <em>not null</em> and <em>valid</em>. Validating a parameter in this case implies
making sure that any constraint annotations in the <code>Greeting</code> class are satisfied.
The resource method shall never be called if the validation fails, with a 400
(Bad Request) status code returned instead.
<markup
lang="java"

>@Path("helloworld")
public class HelloWorld {

    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    public void post(@NotNull @Valid Greeting greeting) {
        // ...
    }
}</markup>

</li>
<li>
The following example shows a simple application with one field declared as <em>not null</em> using <code>@NotNull</code> annotation:
<markup
lang="java"

>public class GreetingHolder {
    @NotNull
    private String greeting;
    //...
}</markup>

<p>If the bean contains a method parameter annotated with @Valid, and GreetingHolder with <em>null_greeting is passed, then a _ValidationException</em> will be thrown:</p>

<markup
lang="java"

>@ApplicationScoped
public class GreetingProvider {
    private GreetingHolder greetingHolder;
    //..
    void setGreeting(@Valid GreetingHolder greetingHolder) {
        this.greetingHolder = greetingHolder;
    }
}</markup>

<div class="admonition note">
<p class="admonition-inline"><code>beans.xml</code> is required to identify beans and for bean validation to work properly.</p>
</div>

</li>
</ol>

<p>Examples are available in <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.4/examples/microprofile/bean-validation">our official GitHub repository</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Helidon uses <a target="_blank" href="https://hibernate.org/validator/">Hibernate Bean Validator</a> for general bean validation.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/bean-validation/3.0/jakarta-bean-validation-spec-3.0.html">Bean Validation Specification</a></p>

</li>
</ul>

</div>

</doc-view>
