<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Http1Config (webserver.http1) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.http1/io/helidon/webserver/http1/Http1Config.html">io.helidon.webserver.http1.Http1Config</a></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ProtocolConfig</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>continue-immediately</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>When true WebServer answers to expect continue with 100 continue immediately,
 not waiting for user to actually request the data.</p>

<pre>@return if `true` answer with 100 continue immediately after expect continue</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-headers-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>Maximal size of received headers in bytes.</p>

<pre>@return maximal header size</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-prologue-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>2048</code></td>
<td class=""><doc-view>
<p>Maximal size of received HTTP prologue (GET /path HTTP/1.1).</p>

<pre>@return maximal size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>recv-log</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Logging of received packets. Uses trace and debug levels on logger of
 Http1LoggingConnectionListener with suffix of <code>.recv`</code>.</p>

<pre>@return `true` if logging should be enabled for received packets, `false` if no logging should be done</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>requested-uri-discovery</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_RequestedUriDiscoveryContext">RequestedUriDiscoveryContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Requested URI discovery settings.</p>

<pre>@return settings for computing the requested URI</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>send-log</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Logging of sent packets. Uses trace and debug levels on logger of
 Http1LoggingConnectionListener with suffix of <code>.send`</code>.</p>

<pre>@return `true` if logging should be enabled for sent packets, `false` if no logging should be done</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-path</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to false, any path is accepted (even containing illegal characters).</p>

<pre>@return whether to validate path</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-request-headers</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to validate headers.
 If set to false, any value is accepted, otherwise validates headers + known headers
 are validated by format
 (content length is always validated as it is part of protocol processing (other headers may be validated if
 features use them)).</p>

<pre>Defaults to `true`.</pre>
<pre>@return whether to validate headers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-response-headers</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to validate headers.
 If set to false, any value is accepted, otherwise validates headers + known headers
 are validated by format
 (content length is always validated as it is part of protocol processing (other headers may be validated if
 features use them)).</p>

<pre>Defaults to `false` as user has control on the header creation.</pre>
<pre>@return whether to validate headers</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
