<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_enabling_health_support_and_built_in_health_checks_in_your_application" @click.native="this.scrollFix('#_enabling_health_support_and_built_in_health_checks_in_your_application')">Enabling Health Support</router-link></p>

</li>
<li>
<p><router-link to="#_writing_custom_health_checks" @click.native="this.scrollFix('#_writing_custom_health_checks')">Writing Custom Health Checks</router-link></p>

</li>
<li>
<p><router-link to="#_kubernetes_probes" @click.native="this.scrollFix('#_kubernetes_probes')">Kubernetes Probes</router-link></p>

</li>
<li>
<p><router-link to="#_troubleshooting_probes" @click.native="this.scrollFix('#_troubleshooting_probes')">Troubleshooting Probes</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_json_response_example" @click.native="this.scrollFix('#_json_response_example')">JSON Response Example</router-link></p>

</li>
<li>
<p><router-link to="#_kubernetes_example" @click.native="this.scrollFix('#_kubernetes_example')">Kubernetes Example</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>It’s a good practice to monitor your microservice’s health to ensure that it is
available and performs correctly.
Applications implement health checks to expose health status that is collected
at regular intervals by external tooling, such as orchestrators like
Kubernetes. The orchestrator may then take action, such as restarting your
application if the health check fails.</p>

<p>A typical health check combines the statuses of all the dependencies that
affect availability and the ability to perform correctly:</p>

<ul class="ulist">
<li>
<p>Network Latency</p>

</li>
<li>
<p>Storage</p>

</li>
<li>
<p>Database</p>

</li>
<li>
<p>Other Services (used by your application)</p>

</li>
</ul>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Health Checks
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Optional dependency to use built-in health checks:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">

<h3 id="_enabling_health_support_and_built_in_health_checks_in_your_application">Enabling Health Support (and Built-in Health Checks) in Your Application</h3>
<div class="section">
<p>The health subsystem is part of Helidon&#8217;s observability support. As a result, your application includes health support by default provided your project meets several conditions:</p>

<ul class="ulist">
<li>
<p>Your project depends on the <code>helidon-webserver-observe-health</code> component as described above.</p>

</li>
<li>
<p>(Optional) Your project depends on the <code>helidon-health-checks</code> component (if you want Helidon&#8217;s built-in health checks).</p>

</li>
<li>
<p>Your code allows the webserver&#8217;s automatic feature discovery (enabled by default).</p>

</li>
<li>
<p>Your code allows the observe feature&#8217;s automatic observer discovery (also enabled by default).</p>

</li>
</ul>

<p>If you disable either type of automatic discovery you can add the observe feature to the webserver explicitly and you can add the health observer to the observe feature explicitly, customizing the behavior of each programmatically if you wish.
You can also use configuration to tailor some of the behavior of the health component (such as changing the URI path from <code>/observe/health</code> to something else).</p>

</div>


<h3 id="_writing_custom_health_checks">Writing Custom Health Checks</h3>
<div class="section">
<p>In many cases, the ability of your application to do its job depends on conditions known only to your application: for example, whether certain external resources such as databases are available.
You can create custom health checks which reflect those conditions and add them to Helidon&#8217;s overall health assessment of your application.</p>

<p>A health check is a Java functional interface that returns a new
<code>HealthCheckResponse</code> instance each time Helidon queries the health check.
Each health check also has a fixed name and a fixed health check type (start-up, liveness, or readiness).</p>

<p>Your code registers a custom health check by invoking a method on Helidon-provided types in one of the following ways:</p>

<ul class="ulist">
<li>
<p>Pass the name and type of the health check and a <code>Supplier</code> of a <code>HealthCheckResponse</code> such as a method reference or a lambda expression.</p>

</li>
<li>
<p>Pass an instance of a class which implements the <code>HealthCheck</code> interface.</p>

</li>
</ul>

<p>Within an application different techniques might make sense for different custom health checks, depending on the complexity of the logic for computing the status for each check.
The various styles are functionally equivalent; for a given custom health check choose the style which enhances the readability and clarity of your code.
The examples below, in no particular order, implement the same custom health check functionality in different ways to illustrate.</p>


<h4 id="_option_1_using_a_healthcheckresponse_supplier_method">Option 1: Using a <code>HealthCheckResponse</code> supplier method</h4>
<div class="section">
<p>If you gather the logic for computing the health check response into a method, then you can use a method reference to register the health check.</p>

<markup
lang="java"
title="Declaring a health check response supplier method"
>static HealthCheckResponse slowStartLivenessResponse() {
    long now = System.currentTimeMillis();
    return HealthCheckResponse.builder()
            .detail("time", now)
            .status(now - serverStartTime &gt;= 8000)
            .build();
}</markup>

<markup
lang="java"
title="Registering a health check using a method reference"
>ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))                  <span class="conum" data-value="1" />
        .addObserver(HealthObserver.builder()                           <span class="conum" data-value="2" />
                             .useSystemServices(true)                   <span class="conum" data-value="3" />
                             .addCheck(Main::slowStartLivenessResponse, <span class="conum" data-value="4" />
                                       HealthCheckType.LIVENESS,        <span class="conum" data-value="5" />
                                       "live-after-8-seconds")          <span class="conum" data-value="6" />
                             .build())
        .build();</markup>

<ul class="colist">
<li data-value="1">Apply configuration to auto-discovered observers (e.g., health, metrics).</li>
<li data-value="2">Augment the web server by adding the <code>ObserveFeature</code> containing the <code>HealthObserver</code>. This replaces the auto-discovered health observer.</li>
<li data-value="3">Include the Helidon-supplied health checks.</li>
<li data-value="4">Add the custom health check, passing a reference to the method which returns the health check responses.</li>
<li data-value="5">Set the type of the custom health check.</li>
<li data-value="6">Set the name of the custom health check.</li>
</ul>

</div>


<h4 id="_option_2_using_an_in_line_lambda_expression">Option 2: Using an in-line lambda expression</h4>
<div class="section">
<p>If the logic for computing the health check response is fairly simple, express it as an in-line lambda when you register the health check.</p>

<markup
lang="java"
title="Registering a health check using an in-line lambda expression"
>ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))
        .addObserver(HealthObserver.builder()                                              <span class="conum" data-value="1" />
                             .useSystemServices(true) // Include Helidon-provided health checks.
                             .addCheck(() -&gt; HealthCheckResponse.builder()                 <span class="conum" data-value="2" />
                                               .status(System.currentTimeMillis() - serverStartTime &gt;= 8000) <span class="conum" data-value="3" />
                                               .detail("time", System.currentTimeMillis()) <span class="conum" data-value="4" />
                                               .build(),                                   <span class="conum" data-value="5" />
                                       HealthCheckType.READINESS,                          <span class="conum" data-value="6" />
                                       "live-after-8-seconds")                             <span class="conum" data-value="7" />
                            .build())
        .build();</markup>

<ul class="colist">
<li data-value="1">Augment the web server by adding the <code>ObserveFeature</code> containing the <code>HealthObserver</code>.</li>
<li data-value="2">Add the custom health check passing a lambda expression supplying the health check response.</li>
<li data-value="3">In the lambda, set the health check response status.</li>
<li data-value="4">Still in the lambda, set a detail associated with the health check response.</li>
<li data-value="5">Still in the lambda, build the health check response.</li>
<li data-value="6">Set the type of the custom health check.</li>
<li data-value="7">Set the name of the custom health check.</li>
</ul>

<p>Note that the logic in the lambda expression runs every time Helidon probes the added health check, so the values passed to <code>status</code> and <code>detail</code> are recomputed every time.</p>

</div>


<h4 id="_option_3_using_a_healthcheck_instance">Option 3: Using a <code>HealthCheck</code> Instance</h4>
<div class="section">
<p>If a custom health check requires a lot of information to compute its health check response, it might be clearest to implement it as a class that implements the <code>HealthCheck</code> interface.
Your code instantiates the class with all the information, including references to other data, it might need to compute the response each time Helidon probes it.</p>

<p>This example <em>is not</em> complicated in that way but it&#8217;s useful to illustrate this technique of writing a custom health check.</p>

<markup
lang="java"
title="Declaring a concrete <code>HealthCheck</code> implementation"
>/**
 * A custom readiness health check that reports UP 8 seconds after server start-up.
 */
class SlowStartHealthCheck implements HealthCheck {     <span class="conum" data-value="1" />

    @Override
    public HealthCheckType type() {
        return HealthCheckType.READINESS;               <span class="conum" data-value="2" />
    }

    @Override
    public HealthCheckResponse call() {
        long now = System.currentTimeMillis();
        return HealthCheckResponse.builder()
                .detail("time", now)                    <span class="conum" data-value="3" />
                .status(now - serverStartTime &gt;= 8000)  <span class="conum" data-value="4" />
                .build();
    }
}</markup>

<ul class="colist">
<li data-value="1">Implement the <code>io.helidon.health.HealthCheck</code> interface. The default health check name is the simple class name of the implementing class. Your code can override the <code>name()</code> method to return a different name. (Not shown in this example)</li>
<li data-value="2">The default health check type is <code>LIVENESS</code> so this implementation overrides <code>type()</code> to declare a <code>READINESS</code> check.</li>
<li data-value="3">Sets a detail value <code>time</code> associated with the response to the current time.</li>
<li data-value="4">Reports <code>DOWN</code> until at least eight seconds have passed since the server start-up, then reports <code>UP</code> thereafter.</li>
</ul>

<markup
lang="java"
title="Registering a <code>HealthCheck</code> instance"
>ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))
        .addObserver(HealthObserver.builder()                     <span class="conum" data-value="1" />
                            .addCheck(new SlowStartHealthCheck()) <span class="conum" data-value="2" />
                            .build())
        .build();</markup>

<ul class="colist">
<li data-value="1">Augment the web server by adding the <code>ObserveFeature</code> containing the <code>HealthObserver</code>.</li>
<li data-value="2">Instantiate the custom health check class and add the instance to the <code>HealthObserver</code>.</li>
</ul>

</div>


<h4 id="_adding_observability_including_the_custom_health_checks_to_helidon">Adding Observability (including the Custom Health Checks) to Helidon</h4>
<div class="section">
<p>The code examples above prepare the <code>observe</code> feature instance using the built-in and custom health checks.
To activate the health subsystem and other auto-discovered observability subsystems, add that <code>observe</code> instance as a feature to the webserver and start the server.</p>

<markup
lang="java"
title="Register the observe feature with the server and start it"
>WebServer server = WebServer.builder()
        .featuresDiscoverServices(false)
        .addFeature(observe) <span class="conum" data-value="1" />
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Add the previously-prepared health observer to the server as a feature</li>
</ul>

</div>


<h4 id="_triggering_and_interpreting_health_check_output">Triggering and Interpreting Health Check Output</h4>
<div class="section">
<p>Health support in Helidon is part of Helidon&#8217;s observability feature.
<code>HealthObserver</code> is a Helidon-provided observability implementation that contains a collection of
registered <code>HealthCheck</code> instances and, when queried, invokes the registered
health checks and returns a response with a status code representing the overall
status of the application.</p>

<div class="block-title"><span>Health status codes</span></div>
<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 16.667%;">
<col style="width: 83.333%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>200</code></td>
<td class="">The application is healthy (with health check details in the response).</td>
</tr>
<tr>
<td class=""><code>204</code></td>
<td class="">The application is healthy (with <em>no</em> health check details in the response).</td>
</tr>
<tr>
<td class=""><code>503</code></td>
<td class="">The application is not healthy.</td>
</tr>
<tr>
<td class=""><code>500</code></td>
<td class="">An error occurred while reporting the health.</td>
</tr>
</tbody>
</table>
</div>

<p>You control, either using configuration or adding code to your application, whether the HTTP responses to <code>GET</code> requests contain detailed information about each health check.
With details enabled, HTTP <code>GET</code> responses include JSON content showing the detailed results of all the health checks which the server executed after receiving the request.
With details disabled, HTTP <code>GET</code> responses have no payload.
HTTP <code>HEAD</code> requests always return only the status with no payload.</p>

<p>If you add the Helidon health dependency to your <code>pom.xml</code> file, Helidon automatically registers the <code>HelidonObserver</code> service and responds to the default <code>/observe/health</code> endpoint.
Further, if you add the built-in health checks dependency, Helidon automatically finds them and adds those checks to the <code>HealthObserver</code>.</p>

<p>Below are parts of health responses which include the custom health check added in the earlier example code.
This first response shows the health output within the first eight seconds after start-up. Recall that the custom health check will report <code>DOWN</code> during that time, so the overall health is <code>DOWN</code> and the HTTP response status is <code>503 Service Unavailable</code>.</p>

<markup
lang="json"
title="Response within 8 seconds: HTTP status 503 (not healthy)"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "live-after-8-seconds",
      "status": "DOWN",
      "data": {
        "time": 1701984253071
      }
    },
...
}</markup>

<p>The next response shows the health output once the server has been running for at least eight seconds. The custom health check now reports <code>UP</code> so the overall health status is also <code>UP</code> now and the HTTP status is <code>200</code>.</p>

<markup
lang="json"
title="Response after 8 seconds: HTTP status 200"
>{
  "status": "UP",
  "checks": [
    {
      "name": "live-after-8-seconds",
      "status": "UP",
      "data": {
        "time": 1701984258292
      }
    },</markup>

<div class="admonition tip">
<p class="admonition-inline">Balance collecting a lot of information with the need to avoid overloading
the application and overwhelming users.</p>
</div>

<p>The following table provides a summary of the Health Check API classes.</p>

<div class="block-title"><span>Health check API classes</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 40%;">
<col style="width: 60%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>io.helidon.health.HealthCheck</code></td>
<td class="">Java functional interface representing the logic of a single health check</td>
</tr>
<tr>
<td class=""><code>io.helidon.health.HealthCheckResponse</code></td>
<td class="">Result of a health check invocation that contains a status</td>
</tr>
<tr>
<td class=""><code>io.helidon.webserver.observe.health.HealthObserver</code></td>
<td class="">WebServer service that exposes <code>/observe/health</code> and invokes the registered health
checks</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h3 id="built-in-health-checks-table">Built-In Health Checks</h3>
<div class="section">
<p>You can use Helidon-provided health checks to report various
common health check statuses:</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 4.348%;">
<col style="width: 4.348%;">
<col style="width: 13.043%;">
<col style="width: 65.217%;">
<col style="width: 13.044%;">
</colgroup>
<thead>
<tr>
<th>Built-in health check</th>
<th>Health check name</th>
<th>JavaDoc</th>
<th>Config properties (within <code>server.features.observe.observers.health</code>)</th>
<th>Default config value</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">deadlock detection</td>
<td class=""><code>deadlock</code></td>
<td class=""><a target="_blank" href="/apidocs/io.helidon.health.checks/io/helidon/health/checks/DeadlockHealthCheck.html"><code>DeadlockHealthCheck</code></a></td>
<td class="">n/a</td>
<td class="">n/a</td>
</tr>
<tr>
<td class="">available disk space</td>
<td class=""><code>diskSpace</code></td>
<td class=""><a target="_blank" href="/apidocs/io.helidon.health.checks/io/helidon/health/checks/DiskSpaceHealthCheck.html"><code>DiskSpaceHealthCheck</code></a></td>
<td class=""><code>helidon.health.diskSpace.thresholdPercent</code><br>

+
<code>helidon.health.diskSpace.path</code></td>
<td class=""><code>99.999</code><br>

+
<code>/</code></td>
</tr>
<tr>
<td class="">available heap memory</td>
<td class=""><code>heapMemory</code></td>
<td class=""><a target="_blank" href="/apidocs/io.helidon.health.checks/io/helidon/health/checks/HeapMemoryHealthCheck.html"><code>HeapMemoryHealthCheck</code></a></td>
<td class=""><code>helidon.health.heapMemory.thresholdPercent</code></td>
<td class=""><code>98</code></td>
</tr>
</tbody>
</table>
</div>

<p>Simply adding the built-in health check dependency is sufficient to register all the built-in health checks automatically.
If you want to use only some of the built-in checks in your application, you can disable automatic discovery of the built-in health checks and register only the ones you want.</p>

<p>The following code adds only selected built-in health checks to your application:</p>

<markup
lang="java"
title="Adding selected built-in health checks"
>WebServer server = WebServer.builder()
        .config(config.get("server"))
        .addFeature(ObserveFeature.create(HealthObserver.builder()
                                                  .useSystemServices(false) <span class="conum" data-value="1" />
                                                  .addCheck(HealthChecks.deadlockCheck()) <span class="conum" data-value="2" />
                                                  .addCheck(hc) <span class="conum" data-value="3" />
                                                  .details(true)
                                                  .build()))
        .routing(Main::routing)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Disables automatic registration of the built-in health checks.</li>
<li data-value="2">Adds the specific built-in check(s) you want.</li>
<li data-value="3">Adds a custom check (in a previously-prepared variable <code>hc</code>).</li>
</ul>

<p>You can control the thresholds for built-in health checks in either of two ways:</p>

<ul class="ulist">
<li>
<p>Create the health checks individually
using their builders instead of using the <code>HealthChecks</code> convenience class.
Follow the JavaDoc links in the <router-link to="#built-in-health-checks-table" @click.native="this.scrollFix('#built-in-health-checks-table')">table</router-link> above.</p>

</li>
<li>
<p>Using configuration as explained in <router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link>.</p>

</li>
</ul>

</div>


<h3 id="_kubernetes_probes">Kubernetes Probes</h3>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_liveness_probe" @click.native="this.scrollFix('#_liveness_probe')">Liveness Probe</router-link></p>

</li>
<li>
<p><router-link to="#_readiness_probe" @click.native="this.scrollFix('#_readiness_probe')">Readiness Probe</router-link></p>

</li>
<li>
<p><router-link to="#_startup_probe" @click.native="this.scrollFix('#_startup_probe')">Startup Probe</router-link></p>

</li>
</ul>

<p>Probes is the term used by Kubernetes to describe health checks for containers
(<a target="_blank" href="https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-probes">Kubernetes documentation</a>).</p>

<p>There are three types of probes:</p>

<ul class="ulist">
<li>
<p><em>liveness</em>: Indicates whether the container is running</p>

</li>
<li>
<p><em>readiness</em>: Indicates whether the container is ready to service requests</p>

</li>
<li>
<p><em>startup</em>: Indicates whether the application in the container has started</p>

</li>
</ul>

<p>You can implement probes using the following mechanisms:</p>

<ol style="margin-left: 15px;">
<li>
Running a command inside a container

</li>
<li>
Sending an <code>HTTP</code> request to a container

</li>
<li>
Opening a <code>TCP</code> socket to a container

</li>
</ol>

<p>A microservice exposed to HTTP traffic will typically implement both the
liveness probe and the readiness probe using HTTP requests.
If the microservice takes a significant time to initialize itself, you can also define a startup probe, in which case
Kubernetes does not check liveness or readiness probes until the startup probe returns success.</p>

<p>You can configure several parameters for probes. The following are the most
relevant parameters:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 28.571%;">
<col style="width: 71.429%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class=""><code>initialDelaySeconds</code></td>
<td class="">Number of seconds after the container has started before liveness or readiness
probes are initiated.</td>
</tr>
<tr>
<td class=""><code>periodSeconds</code></td>
<td class="">Probe interval. Default to 10 seconds. Minimum value is 1.</td>
</tr>
<tr>
<td class=""><code>timeoutSeconds</code></td>
<td class="">Number of seconds after which the probe times out. Defaults to 1 second.
Minimum value is 1</td>
</tr>
<tr>
<td class=""><code>failureThreshold</code></td>
<td class="">Number of consecutive failures after which the probe should stop. Default: 3.
Minimum: 1.</td>
</tr>
</tbody>
</table>
</div>


<h4 id="_liveness_probe">Liveness Probe</h4>
<div class="section">
<p>The liveness probe is used to verify the container has become unresponsive.
For example, it can be used to detect deadlocks or analyze heap usage. When
Kubernetes gives up on a liveness probe, the corresponding pod is restarted.</p>

<div class="admonition note">
<p class="admonition-inline">The liveness probe can result in repeated restarts in certain cases.
For example, if the probe is implemented to check all the dependencies
strictly, then it can fail repeatedly for temporary issues. Repeated restarts
can also occur if <code>timeoutSeconds</code> or <code>periodSeconds</code> is too low.</p>
</div>

<p>We recommend the following:</p>

<ul class="ulist">
<li>
<p>Avoid checking dependencies in a liveness probe.</p>

</li>
<li>
<p>Set <code>timeoutSeconds</code> to avoid excessive probe failures.</p>

</li>
<li>
<p>Acknowledge startup times with <code>initialDelaySeconds</code>.</p>

</li>
</ul>

</div>


<h4 id="_readiness_probe">Readiness Probe</h4>
<div class="section">
<p>The readiness probe is used to avoid routing requests to the pod until it is
ready to accept traffic. When Kubernetes gives up on a readiness probe, the
pod is not restarted, traffic is not routed to the pod anymore.</p>

<div class="admonition note">
<p class="admonition-inline">In certain cases, the readiness probe can cause all the pods to be removed
from service routing. For example, if the probe is implemented to check all the
dependencies strictly, then it can fail repeatedly for temporary issues. This
issue can also occur if <code>timeoutSeconds</code> or <code>periodSeconds</code> is too low.</p>
</div>

<p>We recommend the following:</p>

<ul class="ulist">
<li>
<p>Be conservative when checking shared dependencies.</p>

</li>
<li>
<p>Be aggressive when checking local dependencies.</p>

</li>
<li>
<p>Set <code>failureThreshold</code> according to <code>periodSeconds</code> in order to accommodate
temporary errors.</p>

</li>
</ul>

</div>


<h4 id="_startup_probe">Startup Probe</h4>
<div class="section">
<p>The startup probe prevents Kubernetes from prematurely checking the other probes if the application takes a long time to start.
Otherwise, Kubernetes might misinterpret a failed liveness or readiness probe and shut down the container when, in fact, the application is still coming up.</p>

</div>

</div>


<h3 id="_troubleshooting_probes">Troubleshooting Probes</h3>
<div class="section">
<p>Failed probes are recorded as events associated with their corresponding pods.
The event message contains only the status code.</p>

<markup
lang="bash"
title="Get the events of a single pod:"
>POD_NAME=$(kubectl get pod -l app=acme -o jsonpath='{.items[0].metadata.name}') <span class="conum" data-value="1" />
kubectl get event --field-selector involvedObject.name=${POD_NAME} <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Get the effective pod name by filtering pods with the label <code>app=acme</code>.</li>
<li data-value="2">Filter the events for the pod.</li>
</ul>

<div class="admonition tip">
<p class="admonition-inline">Create log messages in your health check implementation when setting a
<code>DOWN</code> status. This will allow you to correlate the cause of a failed probe.</p>
</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Built-in health checks can be configured using the config property keys
described in this
<router-link to="#built-in-health-checks-table" @click.native="this.scrollFix('#built-in-health-checks-table')">table</router-link>. Further, you can suppress one or more of the built-in
health checks by setting the configuration item
<code>helidon.health.exclude</code> to a comma-separated list of the health check names
(from this <router-link to="#built-in-health-checks-table" @click.native="this.scrollFix('#built-in-health-checks-table')">table</router-link>) you want to exclude.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">

<h3 id="_json_response_example">JSON Response Example</h3>
<div class="section">
<p>Accessing the Helidon-provided <code>/observe/health</code> endpoint reports the health of your application
as shown below:</p>

<markup
lang="json"
title="JSON response."
>{
    "status": "UP",
    "checks": [
        {
            "name": "deadlock",
            "status": "UP"
        },
        {
            "name": "diskSpace",
            "status": "UP",
            "data": {
                "free": "211.00 GB",
                "freeBytes": 226563444736,
                "percentFree": "45.31%",
                "total": "465.72 GB",
                "totalBytes": 500068036608
            }
        },
        {
            "name": "heapMemory",
            "status": "UP",
            "data": {
                "free": "215.15 MB",
                "freeBytes": 225600496,
                "max": "3.56 GB",
                "maxBytes": 3817865216,
                "percentFree": "99.17%",
                "total": "245.50 MB",
                "totalBytes": 257425408
            }
        }
    ]
}</markup>

</div>


<h3 id="_kubernetes_example">Kubernetes Example</h3>
<div class="section">
<p>This example shows the usage of the Helidon health API in an application that
implements health endpoints for the liveness and readiness probes. Note that
the application code dissociates the health endpoints from the default routes,
so that the health endpoints are not exposed by the service. An example YAML
specification is also provided for the Kubernetes service and deployment.</p>

<markup
lang="java"
title="Application code:"
>ObserveFeature observeFeature = ObserveFeature.builder()
    .addObserver(HealthObserver.builder()
                         .useSystemServices(false)
                         .endpoint("/health/live") <span class="conum" data-value="1" />
                         .addChecks(HealthChecks.healthChecks()) <span class="conum" data-value="2" />
                         .build())
    .addObserver(HealthObserver.builder()
                         .useSystemServices(false)
                         .endpoint("/health/ready") <span class="conum" data-value="3" />
                         .addCheck(() -&gt; HealthCheckResponse.builder() <span class="conum" data-value="4" />
                                      .status(true)
                                      .build(),
                              HealthCheckType.READINESS,
                              "database")
                         .build())
    .build();
WebServer server = WebServer.builder()
    .putSocket("@default", socket -&gt; socket
        .port(8080) <span class="conum" data-value="5" />
        .routing(r -&gt; r.any((req, res) -&gt; res.send("It works!")))) <span class="conum" data-value="6" />
    .putSocket("observe", socket -&gt; socket
        .port(8081) <span class="conum" data-value="7" />
        .routing(r -&gt; r.addFeature(observeFeature))) <span class="conum" data-value="8" />
    .build()
    .start();</markup>

<ul class="colist">
<li data-value="1">The health service for the <code>liveness</code> probe is exposed at <code>/observe/health/live</code>.</li>
<li data-value="2">Using the built-in health checks for the <code>liveness</code> probe.</li>
<li data-value="3">The health service for the <code>readiness</code> probe is exposed at <code>/observe/health/ready</code>.</li>
<li data-value="4">Using a custom health check for a pseudo database that is always <code>UP</code>.</li>
<li data-value="5">The default socket uses port 8080 for the default routes.</li>
<li data-value="6">The default route: returns It works! for any request.</li>
<li data-value="7">The <code>observe</code> socket uses port 8081 for the "/observe" routes.</li>
<li data-value="8">Route the <code>observe</code> feature exclusively on the <code>observe</code> socket.</li>
</ul>

<markup
lang="yaml"
title="Kubernetes descriptor:"
>kind: Service
apiVersion: v1
metadata:
  name: acme <span class="conum" data-value="1" />
  labels:
    app: acme
spec:
  type: NodePort
  selector:
    app: acme
  ports:
  - port: 8080
    targetPort: 8080
    name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: acme <span class="conum" data-value="2" />
spec:
  replicas: 1
  selector:
    matchLabels:
      app: acme
  template:
    metadata:
      name: acme
      labels:
        name: acme
    spec:
      containers:
      - name: acme
        image: acme
        imagePullPolicy: IfNotPresent
        ports:
        - containerPort: 8080
        livenessProbe:
          httpGet:
            path: /observe/health/live <span class="conum" data-value="3" />
            port: 8081
          initialDelaySeconds: 3 <span class="conum" data-value="4" />
          periodSeconds: 10
          timeoutSeconds: 3
          failureThreshold: 3
        readinessProbe:
          httpGet:
            path: /observe/health/ready <span class="conum" data-value="5" />
            port: 8081
          initialDelaySeconds: 10 <span class="conum" data-value="6" />
          periodSeconds: 30
          timeoutSeconds: 10
---</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
<li data-value="3">The HTTP endpoint for the liveness probe.</li>
<li data-value="4">The liveness probe configuration.</li>
<li data-value="5">The HTTP endpoint for the readiness probe.</li>
<li data-value="6">The readiness probe configuration.</li>
</ul>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.health.checks/module-summary.html">Health Checks SE API JavaDocs</a>.</p>

</li>
</ul>

</div>

</doc-view>
