<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon provides a very flexible and comprehensive configuration system, offering you many application configuration choices. The Config component provides a Java API to load and process
configuration data from various sources into a <code>Config</code> object which the application can then use.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Config
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.config&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-config&lt;/artifactId&gt;
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>A brief overview of the config system helps clarify its different parts and how they work together. Most applications will typically deal with more than one of these parts.</p>



<v-card>
<v-card-text class="overflow-y-hidden" style="text-align:center">
<img src="/images/config/overview.png" alt="Configuration Overview" />
</v-card-text>
</v-card>


<p>These are the main parts of the configuration system:</p>

<ul class="ulist">
<li>
<p><code>Config</code> system - allows you to read configuration data in an application</p>

</li>
<li>
<p>A config source - a location containing configuration data (File, Map, Properties etc.)</p>

</li>
<li>
<p>A config parser - a component capable of transforming bytes into configuration data (such as JSON content, YAML etc.)</p>

</li>
</ul>


<h3 id="config_sources">Config Sources</h3>
<div class="section">
<p>Configuration can be loaded from different types of locations and expressed in different formats. The config system includes support for several types of config sources, for example:</p>

<ol style="margin-left: 15px;">
<li>
Environment variables - the property is a name/value pair.

</li>
<li>
Java system properties - the property is a name/value pair.

</li>
<li>
Resources in the classpath - the contents of the resource is parsed according to its inferred format.

</li>
<li>
File - the contents of the file is parsed according to its inferred format.

</li>
<li>
Directory - each non-directory file in the directory becomes a config entry: the file name is the key.
and the contents of that file are used as the corresponding config String value.

</li>
<li>
A URL resource - contents is parsed according to its inferred format.

</li>
<li>
A variety of in-memory data structures (<code>String</code>, <code>Map</code>, <code>Properties</code>)

</li>
</ol>

<p>See the JavaDoc for the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/ConfigSources.html"><code>ConfigSources</code></a>
class for a complete list of the built-in config source types and how to use them.</p>

<p>See the <router-link :to="{path: '/se/config/advanced-configuration', hash: '#_advanced_config_sources'}">advanced topics'</router-link> page for further information on some more involved aspects of config sources.</p>

</div>


<h3 id="parsers">Config Parsers</h3>
<div class="section">
<p>When it reads configuration text from sources, the config system uses config parsers
to translate that text into the in-memory data structures representing that
configuration.</p>

<p>The config system includes several built-in parsers, such as for the Java properties, YAML, JSON, and HOCON formats. See <router-link to="#built-in-formats" @click.native="this.scrollFix('#built-in-formats')">this section</router-link> for
how to change your <code>pom.xml</code> to make parsers for those formats available to your
application. Then your application can invoke the
<a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/Config.Builder.html#addParser-io.helidon.config.spi.ConfigParser-">config builder&#8217;s <code>addParser</code></a> method
so that builder will use the parsers you choose.</p>

<p>You can extend the system with custom parsers of your own. Implement the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/spi/ConfigParser.html"><code>ConfigParser</code></a> interface, then construct a <code>Config.Builder</code> using the <code>addParser</code> method, passing an instance of your customer parser. Invoke one of the <code>sources</code> methods to include a source that uses the custom format and then build the <code>Config</code> object.</p>

<p>See the <router-link :to="{path: '/se/config/advanced-configuration', hash: '#_advanced_config_parsers'}">advanced topics'</router-link> page for further information on some more involved aspects of config parsers.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Helidon has an internal configuration, so you are not required to provide any configuration data for your application, though in practice you most likely would.</p>

<p>In your application code, when you create a default <code>Config</code> object, Helidon uses the default configuration .</p>

<markup
lang="Java"

>Config config = Config.create(); <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The <code>Config</code> object is created with default settings.</li>
</ul>


<h3 id="_global_configuration">Global Configuration</h3>
<div class="section">
<p>Global configuration is a singleton instance of <code>Config</code> that is implicitly used by some components of Helidon, plus it provides a convenient mechanism for your application to retrieve configuration from anywhere in your code.
By default global configuration is initialized to the default <code>Config</code> object (as returned by <code>Config.create()</code>). But it is recommended that you initialize it explicitly. This is especially important if you define custom config sources.</p>

<markup


>Config config = Config.create(); <span class="conum" data-value="1" />
Config.global(config); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Create configuration. This shows creating the default config, but it could be created from custom config sources.</li>
<li data-value="2">Assign it to the application&#8217;s global configuration</li>
</ul>

<p>You can use global configuration to conveniently retrieve the application&#8217;s configuration:</p>

<markup


>Config config = Config.global();</markup>

</div>


<h3 id="_custom_config_sources">Custom Config Sources</h3>
<div class="section">
<p>Although the default configuration is very simple to use, your application can take full control of all configuration sources and precedence. You can do so by creating and invoking methods on a <code>Config.Builder</code> object to construct a <code>Config</code> instance.</p>

<p>When your application prepares a <code>Config.Builder</code> it sets what <code>ConfigSource</code>s and
<code>ConfigParser</code>s the builder should use in constructing the resulting <code>Config</code> object. The JavaDoc explains how to use the
<a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/Config.Builder.html"><code>Config.Builder</code></a>.</p>

<p>See the <router-link :to="{path: '/se/guides/config', hash: '#_custom_configuration_sources'}">Custom Configuration Sources</router-link> and <router-link :to="{path: '/se/config/advanced-configuration', hash: '#_advanced_config_sources'}">advanced config sources</router-link> sections for detailed examples and further information.</p>

</div>


<h3 id="_accessing_config_values">Accessing Config Values</h3>
<div class="section">
<p>You have used Helidon to customize configuration behavior from your code using the <code>Config</code> and <code>Config.Builder</code> classes. As discussed previously, <code>Config</code> system reads configuration from a config source, which uses a config parser to translate the source into an in-memory tree which represents the configuration’s structure and values.</p>

<p>This approach allows us to take any source data, be it a flat properties file or an object structure such as JSON, and transform it into a single tree that allows for overriding of values using heterogeneous config sources.</p>

<p>We are using the <code>.</code> as a separator of tree structure.</p>

<p>Example of two config sources that can be used by <code>Config</code> with the same data tree in different formats:</p>

<p>A Properties source:</p>

<markup
lang="properties"

>web.page-size=25</markup>

<p>A YAML source:</p>

<markup
lang="yaml"

>web:
  page-size: 25</markup>

<p>The configuration has the same internal representation in <code>Config</code>. Once created, the <code>Config</code> object provides many methods the application can use to
retrieve config data as various Java types. See the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/Config.html"><code>Config</code></a>
JavaDoc for complete details.</p>

<markup
lang="java"

>int pageSize = config.get("web.page-size")
        .asInt()
        .orElse(20);</markup>

<p>Or using the tree node approach:</p>

<markup
lang="java"

>int pageSize = config
                .get("web")
                .get("page-size")
                .asInt()
                .orElse(20);</markup>

<p>For this first example we can see the basic features of <code>Config</code>:</p>

<ul class="ulist">
<li>
<p>Configuration is a tree of <code>Config</code> nodes</p>

</li>
<li>
<p>You can use <code>.</code> as a tree separator when requesting node values</p>

</li>
<li>
<p>Each config value can be retrieved as a typed object, with shortcut methods for the most commonly used types, such as <code>int</code>, <code>String</code>, <code>long</code> and other</p>

</li>
<li>
<p>You can immediately provide a default value for the cases the configuration option is not defined in any source</p>

</li>
</ul>

</div>


<h3 id="_overriding_values">Overriding Values</h3>
<div class="section">
<p>The <code>Config</code> system treats config sources as a hierarchy, where the first source that
has a specific configuration key "wins" and its value is used, other sources are not even queried for it.</p>

<p>In order to properly configure your application using configuration sources, you need to understand the precedence rules that Helidon uses to merge your configuration data. If any of the Helidon required properties are not specified in one of these source, then Helidon will use a default value.</p>

<p>For example the default configuration when you use <code>Config.create()</code> uses the following config sources in precedence order:</p>

<ol style="margin-left: 15px;">
<li>
System properties config source

</li>
<li>
Environment variables config source

</li>
<li>
A classpath config source called <code>application.?</code> where the <code>?</code> depends on supported media types currently on the classpath.By default, it is <code>properties</code>, but if you have YAML support on classpath, it would be <code>application.yaml</code> (a <code>ConfigParser</code> may add additional supported suffixes for default file)

</li>
</ol>

<p>Let&#8217;s consider the following keys:</p>

<ol style="margin-left: 15px;">
<li>
System property <code>answer=42</code>

</li>
<li>
Environment variable <code>ANSWER=38</code>

</li>
<li>
A key in a configuration file <code>answer=36</code>

</li>
</ol>

<p>When you request <code>config.get(`answer</code>).asInt().orElse(25)<code>, you would get `42</code></p>

<p>This allows you to configure environment specific configuration values through
system properties, environment variables, or through files available on each environment (be it a physical machine, a Kubernetes pod, or a docker image) without changing your source code.</p>

</div>


<h3 id="_config_filters">Config Filters</h3>
<div class="section">
<p>Config system applies configured <em>config filters</em> on each value when it is requested
for the first time.</p>

<p>There is a built-in filter called <code>ValueResolvingFilter</code> (enabled by default, can be disabled through API)
 that resolves references to other keys in values in configuration.</p>

<p>Example:
Let&#8217;s consider the following example properties file</p>

<markup
lang="properties"

>host=localhost
first-service.host=${host}/firstservice
second-service.host=${host}/secondservice</markup>

<p>The filter resolves the <code>${host}</code> reference to the <code>localhost</code> value.</p>

<p>This makes it easier to override values in testing and production, as you can just
override the <code>host</code> key and leave the URIs same.</p>

<p>See <router-link :to="{path: '/se/config/advanced-configuration', hash: '#filters-and-overrides'}">Filter, Overrides, and Token Substitution</router-link> section for further information on some more involved aspects.</p>

</div>


<h3 id="_typed_config_values">Typed config values</h3>
<div class="section">
<p>The <code>Config</code> object lets your application retrieve config data as a typed ConfigValue.</p>

<p>You can retrieve a <code>ConfigValue&lt;T&gt;</code> using the following <code>as</code> methods in <code>Config</code>:
* <code>asString()</code> - to get a string config value
* <code>asBoolean()</code> and other accessors for primitive types
* <code>as(Class)</code> - to get a value for a type that has a mapper configured
* <code>as(Generic)</code> - to get a value for a type supporting generics (such as <code>Set&lt;String&gt;</code>)
* <code>asMap()</code> - to get a map of key to value pairs
* <code>asList(Class)</code> - to get a list of typed values
* <code>as(Function&lt;Config,T&gt;)</code> - to get a typed value providing a mapper function</p>

<p>ConfigValue&lt;T&gt; can be used to obtain:
* an <code>Optional&lt;T&gt;</code> value <em>from a single node</em>,
* the <code>T</code> value <em>from a single node</em> interpreted as a basic Java type (primitive or simple object) already known to the config system (such as a <code>boolean</code> or a <code>Double</code>), or
* a complex Java type <em>from a subtree</em> of the config tree.</p>

<p>+
The config system automatically knows how to return <code>List</code> and <code>Map</code> complex types, and you can provide <em>config mappers</em> to convert a config subtree to whatever
Java types your application needs.</p>

<p>See <router-link to="/se/config/property-mapping">Property Mapping</router-link> page for details on how to use the built-in mappings and your own custom ones to convert to simple and complex types.</p>

</div>


<h3 id="retry">Dealing with Loading Errors: Retry Policies</h3>
<div class="section">
<p>Config sources, especially those that depend on fallible mechanisms such as the network or a shared file system, might fail to load during momentary outages. The config system allows you to build resiliency into your application&#8217;s use of configuration that relies on such technologies.</p>

<p>When your application builds a <code>ConfigSource</code> it can specify a <em>retry policy</em>. When the config system needs to load data from that source it delegates the load operation to that retry policy. That policy is responsible not only for loading the data but also for detecting errors during loading and implementing the algorithm for deciding when and how many times to retry a failed load before reporting a failure back to your application.</p>

<p>The config system includes two predefined retry policies:</p>

<div class="block-title"><span>Predefined Retry Policies</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Policy</th>
<th>Summary</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">"just call" (default)</td>
<td class="">asks the config source to load the data with no retry</td>
</tr>
<tr>
<td class="">"repeat"</td>
<td class="">performs a settable number of time-based retries, reporting failure only after all available retries have failed</td>
</tr>
</tbody>
</table>
</div>

<p>See the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/RetryPolicies.html"><code>RetryPolicies</code></a> JavaDoc for complete details on these built-in retry policies.</p>

<p>You can devise your own policy. Implement the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/spi/RetryPolicy.html"><code>RetryPolicy</code></a> interface. Then pass an instance of your policy implementation to the config source builder&#8217;s <code>retryPolicy</code> method.</p>

</div>


<h3 id="_change_support">Change Support</h3>
<div class="section">
<p>Each <code>Config</code> object which the config system returns to your application is
immutable; even if the information in one of the underlying config sources changes, an in-memory data structure built from the earlier content remains unchanged.</p>

<p>Nevertheless, we know that configuration sometimes changes, and we may want to react to such changes. So the config system allows your application to learn when such underlying changes in the data occur and respond accordingly.</p>

<p>In <code>Config</code> system, you can do this through change support provided by these components:</p>

<ol style="margin-left: 15px;">
<li>
<code>Config.onChange()</code> API - you can use to add your listener, to be notified of configuration changes

</li>
<li>
<code>PollingStrategy</code> - a component providing regular events to check if a source has changed. This
requires support in config sources themselves (see <code>PollableSource</code>)

</li>
<li>
<code>ChangeWatcher</code> - a component watching the underlying source for changes. This requires support
in config sources themselves (see <code>WatchableSource</code>)

</li>
<li>
<code>EventConfigSource</code> - an event source that is capable of notifying about changes itself

</li>
</ol>

<p>If you want to receive <code>onChange</code> events, you must configure your Config with at least one source that is capable of providing changes (having a <code>PollingStrategy</code> or <code>ChangeWatcher</code> configured, or implementing <code>EventConfigSource</code>)</p>

<p>The <router-link to="/se/config/mutability-support">mutability</router-link> documentation explains this in detail, and the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/PollingStrategies.html"><code>PollingStrategies</code></a> JavaDoc describes the built-in implementations.</p>

<p>You can, of course, write your own by implementing the <a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/spi/PollingStrategy.html"><code>PollingStrategy</code></a> interface. On a config source builder invoke <code>pollingStrategy</code> with an instance of your custom strategy and then invoke <code>build</code> to create the <code>ConfigSource</code>.</p>

</div>


<h3 id="built-in-formats">Built-in Support for Config Formats</h3>
<div class="section">
<p>If you add additional Helidon config maven artifacts to your dependencies, then the
config system can read formats other than Java properties format and the default
configuration will search for other <code>application</code> file types
in the following order. Note that the default configuration <em>stops</em> once it finds
one of the files below; it <em>does not</em> merge all such files it can find.</p>

<div class="block-title"><span>Default Config Files (most to the least important)</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Source</th>
<th>Helidon maven artifact ID (group ID: <code>io.helidon.config</code>)</th>
<th>Notes</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>application.yaml</code></td>
<td class=""><code>helidon-config-yaml</code></td>
<td class="">YAML format <a target="_blank" href="http://yaml.org" class="bare">http://yaml.org</a></td>
</tr>
<tr>
<td class=""><code>application.conf</code></td>
<td class=""><code>helidon-config-hocon</code></td>
<td class="">HOCON format <a target="_blank" href="https://github.com/lightbend/config#using-hocon-the-json-superset" class="bare">https://github.com/lightbend/config#using-hocon-the-json-superset</a></td>
</tr>
<tr>
<td class=""><code>application.json</code></td>
<td class=""><code>helidon-config-hocon</code></td>
<td class="">JSON format <a target="_blank" href="https://json.org/" class="bare">https://json.org/</a></td>
</tr>
<tr>
<td class=""><code>application.properties</code></td>
<td class=""><code>helidon-config</code></td>
<td class="">Java properties format</td>
</tr>
</tbody>
</table>
</div>

<p>You can also extend the config system
to handle other types of sources by implementing the
<a target="_blank" href="/apidocs/io.helidon.config/io/helidon/config/spi/ConfigSource.html"><code>ConfigSource</code></a> interface. See
the <router-link to="/se/config/extensions">extensions'</router-link> documentation for complete information.</p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<v-layout row wrap class="mb-5">
<v-flex xs12>
<v-container fluid grid-list-md class="pa-0">
<v-layout row wrap class="pillars">
<v-flex xs12 sm4 lg3>
<v-card>
<router-link to="/se/guides/config"><div class="card__link-hover"/>
</router-link>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">SE Config Guide</span>
</v-card-title>
<v-card-text class="caption">
<p></p>
<p>Step-by-step guide about using Config in your Helidon SE application.</p>
</v-card-text>
</v-card>
</v-flex>
</v-layout>
</v-container>
</v-flex>
</v-layout>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>The links in the following tables lead you to more information about various
other config topics.</p>

<div class="block-title"><span>Controlling How Config is Loaded</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Topic</th>
<th>Documentation</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">Where config comes from</td>
<td class=""><router-link to="#config_sources" @click.native="this.scrollFix('#config_sources')">Config sources</router-link>,<router-link to="/se/config/config-profiles">Config Profiles</router-link></td>
</tr>
<tr>
<td class="">What format config data is expressed in</td>
<td class=""><router-link to="#parsers" @click.native="this.scrollFix('#parsers')">Config parsers</router-link>,
<router-link to="/se/config/supported-formats">supported formats</router-link></td>
</tr>
<tr>
<td class="">How to filter, override, and dereference values</td>
<td class=""><router-link :to="{path: '/se/config/advanced-configuration', hash: '#filters-and-overrides'}">Filters and overrides</router-link></td>
</tr>
<tr>
<td class="">What happens when config data changes</td>
<td class=""><router-link to="/se/config/mutability-support">Mutability Support</router-link></td>
</tr>
<tr>
<td class="">How to deal with loading errors</td>
<td class=""><router-link to="#retry" @click.native="this.scrollFix('#retry')">Config retry policies</router-link></td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Accessing Configuration Data</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Topic</th>
<th>Documentation</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">How config data is translated into Java types</td>
<td class=""><router-link to="/se/config/property-mapping">Config mappers</router-link></td>
</tr>
<tr>
<td class="">How to navigate config trees</td>
<td class=""><router-link to="/se/config/hierarchical-features">Navigation</router-link></td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Extending and Fine-tuning the Config System</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Topic</th>
<th>Documentation</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">Writing extensions</td>
<td class=""><router-link to="/se/config/extensions">Extensions</router-link></td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
