<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_helidon_test_with_mock_connector" @click.native="this.scrollFix('#_helidon_test_with_mock_connector')">Helidon Test</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Mock connector is a simple application scoped bean that can be used for emitting to a channel
or asserting received data in a test environment. All data received are kept in memory only.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Mock Connector
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.mock&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-mock&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<div class="admonition warning">
<p class="admonition-inline">Mock connector should be used in the test environment only!</p>
</div>

<p>For injecting Mock Connector use <code>@TestConnector</code> qualifier:</p>

<markup
lang="java"

>@Inject
@TestConnector
MockConnector mockConnector;</markup>


<h3 id="_emitting_data">Emitting Data</h3>
<div class="section">
<markup
lang="java"
title="Emitting String values <code>a</code>, <code>b</code>, <code>c</code>"
>mockConnector
     .incoming("my-incoming-channel", String.class) <span class="conum" data-value="1" />
     .emit("a", "b", "c");</markup>

<ul class="colist">
<li data-value="1">Get incoming channel of given name and payload type</li>
</ul>

</div>


<h3 id="_asserting_data">Asserting Data</h3>
<div class="section">
<markup
lang="java"
title="Awaiting and asserting payloads with custom mapper"
>mockConnector
    .outgoing("my-outgoing-channel", String.class)           <span class="conum" data-value="1" />
    .awaitData(TIMEOUT, Message::getPayload, "a", "b", "c"); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Get outgoing channel of given name and payload type</li>
<li data-value="2">Request number of expected items and block the thread until items arrive then assert the payloads</li>
</ul>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Key</td>
<td class="">Default value</td>
<td class="">Description</td>
</tr>
<tr>
<td class="">mock-data</td>

<td class="">Initial data emitted to the channel immediately after subscription</td>
</tr>
<tr>
<td class="">mock-data-type</td>
<td class="">java.lang.String</td>
<td class="">Type of the emitted initial data to be emitted</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_helidon_test_with_mock_connector">Helidon Test with Mock Connector</h2>
<div class="section">
<p>Mock connector works great with built-in Helidon test support for
<a target="_blank" href="//home/runner/work/helidon/helidon/docs/src/main/asciidoc/mp/reactivemessaging/../../testing/testing.adoc">JUnit 5</a> or <a target="_blank" href="//home/runner/work/helidon/helidon/docs/src/main/asciidoc/mp/reactivemessaging/../../testing/testing-ng.adoc">TestNG</a>.</p>

<p>As Helidon test support makes a bean out of your test, you can inject MockConnector directly into it.</p>

<markup
lang="java"

>@HelidonTest
@DisableDiscovery <span class="conum" data-value="1" />
@AddBean(MockConnector.class) <span class="conum" data-value="2" />
@AddExtension(MessagingCdiExtension.class) <span class="conum" data-value="3" />
@AddConfig(key = "mp.messaging.incoming.test-channel-in.connector", value = MockConnector.CONNECTOR_NAME)  <span class="conum" data-value="4" />
@AddConfig(key = "mp.messaging.incoming.test-channel-in.mock-data-type", value = "java.lang.Integer")      <span class="conum" data-value="5" />
@AddConfig(key = "mp.messaging.incoming.test-channel-in.mock-data", value = "6,7,8")                       <span class="conum" data-value="6" />
@AddConfig(key = "mp.messaging.outgoing.test-channel-out.connector", value = MockConnector.CONNECTOR_NAME) <span class="conum" data-value="7" />
public class MessagingTest {

    private static final Duration TIMEOUT = Duration.ofSeconds(15);

    @Inject
    @TestConnector
    private MockConnector mockConnector; <span class="conum" data-value="8" />

    @Incoming("test-channel-in")
    @Outgoing("test-channel-out")
    int multiply(int payload) {  <span class="conum" data-value="9" />
        return payload * 10;
    }

    @Test
    void testMultiplyChannel() {
        mockConnector.outgoing("test-channel-out", Integer.TYPE) <span class="conum" data-value="10" />
                .awaitPayloads(TIMEOUT, 60, 70, 80);
    }
}</markup>

<ul class="colist">
<li data-value="1">If you want to add all the beans manually</li>
<li data-value="2">Manually add MockConnector bean, so it is accessible by messaging for constructing the channels</li>
<li data-value="3">Messaging support in Helidon MP is provided by this CDI extension</li>
<li data-value="4">Instruct messaging to use <code>mock-connector</code> as an upstream for channel <code>test-channel-in</code></li>
<li data-value="5">Generate mock data of <code>java.lang.Integer</code>, String is default</li>
<li data-value="6">Generate mock data</li>
<li data-value="7">Instruct messaging to use <code>mock-connector</code> as a downstream for channel <code>test-channel-out</code></li>
<li data-value="8">Inject mock connector so we can access publishers and subscribers registered within the mock connector</li>
<li data-value="9">Messaging processing method connecting together channels <code>test-channel-in</code> and <code>test-channel-out</code></li>
<li data-value="10">Actual JUnit 5 test method which is going to block the thread until 3 items are intercepted on <code>test-channel-out</code>
channel&#8217;s downstream and assert those with expected values.</li>
</ul>

</div>

</doc-view>
