<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#Overview" @click.native="this.scrollFix('#Overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#DS" @click.native="this.scrollFix('#DS')">Named Data Source Integration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-Setup" @click.native="this.scrollFix('#DS-Setup')">Project Setup</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-CP-Project-Setup" @click.native="this.scrollFix('#DS-CP-Project-Setup')">Setting Up a Connection Pool</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-HikariCP-Project-Setup" @click.native="this.scrollFix('#DS-HikariCP-Project-Setup')">Setting Up the HikariCP Connection Pool</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-HikariCP-Maven-Coordinates" @click.native="this.scrollFix('#DS-HikariCP-Maven-Coordinates')">Maven Coordinates (HikariCP)</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#DS-UCP-Project-Setup" @click.native="this.scrollFix('#DS-UCP-Project-Setup')">Setting Up the Oracle Universal Connection Pool</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-UCP-Maven-Coordinates" @click.native="this.scrollFix('#DS-UCP-Maven-Coordinates')">Maven Coordinates (Oracle Universal Connection Pool)</router-link></p>

</li>
</ul>

</li>
</ul>

</li>
<li>
<p><router-link to="#DS-Driver-Project-Setup" @click.native="this.scrollFix('#DS-Driver-Project-Setup')">Setting Up a Database Driver</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-H2-Driver-Project-Setup" @click.native="this.scrollFix('#DS-H2-Driver-Project-Setup')">Setting Up H2</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-H2-Driver-Maven-Coordinates" @click.native="this.scrollFix('#DS-H2-Driver-Maven-Coordinates')">Maven Coordinates (H2)</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#DS-Oracle-Driver-Project-Setup" @click.native="this.scrollFix('#DS-Oracle-Driver-Project-Setup')">Setting Up Oracle JDBC</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-Oracle-Driver-Maven-Coordinates" @click.native="this.scrollFix('#DS-Oracle-Driver-Maven-Coordinates')">Maven Coordinates (Oracle JDBC)</router-link></p>

</li>
</ul>

</li>
</ul>

</li>
</ul>

</li>
<li>
<p><router-link to="#DS-Configuration" @click.native="this.scrollFix('#DS-Configuration')">Configuration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#DS-Configuration-Examples" @click.native="this.scrollFix('#DS-Configuration-Examples')">Examples</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#DS-Usage" @click.native="this.scrollFix('#DS-Usage')">Usage</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Jakarta Transactions (JTA) Integration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#JTA-Maven-Coordinates" @click.native="this.scrollFix('#JTA-Maven-Coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#JTA-Configuration" @click.native="this.scrollFix('#JTA-Configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#JTA-Usage" @click.native="this.scrollFix('#JTA-Usage')">Usage</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#JPA" @click.native="this.scrollFix('#JPA')">Jakarta Persistence (JPA) Integration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#JPA-Setup" @click.native="this.scrollFix('#JPA-Setup')">Project Setup</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#JPA-Maven-Coordinates" @click.native="this.scrollFix('#JPA-Maven-Coordinates')">Common Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#JPA-MetaModel" @click.native="this.scrollFix('#JPA-MetaModel')">Setting Up Static Metamodel Generation</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Hibernate-Maven-Coordinates" @click.native="this.scrollFix('#JPA-Hibernate-Maven-Coordinates')">Maven Coordinates (Hibernate ORM)</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Hibernate-Weaving" @click.native="this.scrollFix('#JPA-Hibernate-Weaving')">Setting Up Static Weaving (Hibernate ORM)</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Eclipselink-Maven-Coordinates" @click.native="this.scrollFix('#JPA-Eclipselink-Maven-Coordinates')">Maven Coordinates (Eclipselink)</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Eclipselink-Weaving" @click.native="this.scrollFix('#JPA-Eclipselink-Weaving')">Setting Up Static Weaving (Eclipselink)</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#JPA-Configuration" @click.native="this.scrollFix('#JPA-Configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Usage" @click.native="this.scrollFix('#JPA-Usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Examples" @click.native="this.scrollFix('#JPA-Examples')">Examples</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#References" @click.native="this.scrollFix('#References')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="Overview">Overview</h2>
<div class="section">
<p>Helidon MP comes with deep integration for three
specification-defined, broadly persistence-related technologies that
can be used together or separately:</p>

<ul class="ulist">
<li>
<p><router-link to="#DS" @click.native="this.scrollFix('#DS')">Named data sources</router-link></p>

</li>
<li>
<p><router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Jakarta Transactions (JTA)</router-link></p>

</li>
<li>
<p><router-link to="#JPA" @click.native="this.scrollFix('#JPA')">Jakarta Persistence (JPA)</router-link></p>

</li>
</ul>

<p>Each integration&#8217;s setup, configuration, and usage are described
below.</p>

</div>


<h2 id="DS">Named Data Source Integration</h2>
<div class="section">

<h3 id="_overview">Overview</h3>
<div class="section">
<p>Helidon MP&#8217;s named data source integration allows you to safely inject
managed
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/javax/sql/DataSource.html"><code>javax.sql.DataSource</code></a>
instances that are annotated with
<a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/named"><code>jakarta.inject.Named</code>
annotations</a> into your Helidon MP application.
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/java/sql/Connection.html"><code>java.sql.Connection</code>
objects</a>
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/javax/sql/DataSource.html#getConnection()">acquired</a>
from these data sources will be pooled by your choice of one of two
possible connection pool implementations.</p>

<p>The connections managed by the connection pool will be supplied by
your relational database vendor&#8217;s JDBC driver.</p>

<p>How you set up Helidon MP&#8217;s named data source integration differs
depending on which of these two connection pools, which JDBC driver,
and which relational database product you use.</p>

<p>Representative setups are described below.  This list of setups is not
exhaustive.</p>

</div>


<h3 id="DS-Setup">Project Setup</h3>
<div class="section">

<h4 id="DS-CP-Project-Setup">Setting Up a Connection Pool</h4>
<div class="section">

<h5 id="_overview_2">Overview</h5>
<div class="section">
<p>Helidon MP&#8217;s named data source integration requires a connection pool
implementation.</p>

<p>Helidon MP comes with support for two connection
pools:</p>

<ol style="margin-left: 15px;">
<li>
<a target="_blank" href="https://github.com/brettwooldridge/HikariCP">HikariCP</a>

</li>
<li>
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjucp/index.html">Oracle Universal
Connection Pool</a>

</li>
</ol>

<p>You can choose to use either, but not both.</p>

<p>Details concerning each connection pool&#8217;s setup are described below.</p>

</div>


<h5 id="DS-HikariCP-Project-Setup">Setting Up the HikariCP Connection Pool</h5>
<div class="section">

<h6 id="DS-HikariCP-Maven-Coordinates">Maven Coordinates (HikariCP)</h6>
<div class="section">
<p>To include the <a target="_blank" href="https://github.com/brettwooldridge/HikariCP">HikariCP
connection pool</a> in your Helidon MP application:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> element is present as a child
element of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-datasource-hikaricp&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>runtime</code>, indicating that the HikariCP integration
will be available on the runtime classpath.</li>
</ul>

</li>
</ul>

</div>

</div>


<h5 id="DS-UCP-Project-Setup">Setting up the Oracle Universal Connection Pool</h5>
<div class="section">

<h6 id="DS-UCP-Maven-Coordinates">Maven Coordinates (Oracle Universal Connection Pool)</h6>
<div class="section">
<p>To include the <a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjucp/index.html">Oracle
Universal Connection Pool</a> in your Helidon MP application:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> element is present as a child
element of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
  &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
  &lt;artifactId&gt;helidon-integrations-cdi-datasource-ucp&lt;/artifactId&gt;
  &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>runtime</code>, indicating that the Oracle
Universal Connection Pool integration will be available on the
runtime classpath.</li>
</ul>

</li>
</ul>

</div>

</div>

</div>


<h4 id="DS-Driver-Project-Setup">Setting Up a Database Driver</h4>
<div class="section">

<h5 id="_overview_3">Overview</h5>
<div class="section">
<p>Regardless of which connection pool you use, at the lowest level, JDBC
database driver classes are what is ultimately responsible for making
any connections to a relational database.  JDBC database driver
classes are database-product-specific.</p>

<p>Once you have decided upon a relational database product to use, and
JDBC driver classes to use to connect to it,
<router-link to="/about/managing-dependencies">ensure your dependencies are
managed</router-link>, and then ensure that a <code>runtime</code>-scoped <code>&lt;dependency&gt;</code>
element describing your JDBC driver classes is present as a child
element of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element.</p>

<p>See the
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/java/sql/package-summary.html">JDBC 4.3
Specification</a> for more information about JDBC.</p>

<p>Representative setups are described below.  This list of setups is not
exhaustive.</p>

</div>


<h5 id="DS-H2-Driver-Project-Setup">Setting Up H2</h5>
<div class="section">

<h6 id="DS-H2-Driver-Maven-Coordinates">Maven Coordinates (H2)</h6>
<div class="section">
<p>To include the <a target="_blank" href="https://www.h2database.com/html/main.html">H2 JDBC
driver</a> classes in your Helidon MP application so your application can
<a target="_blank" href="https://www.h2database.com/html/features.html#database_url">connect to
an H2 database</a> (whether in-memory or persistent):</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> element is present as a child
element of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;com.h2database&lt;/groupId&gt;
    &lt;artifactId&gt;h2&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>runtime</code>, indicating that the H2
JDBC driver classes will be available on the runtime classpath.</li>
</ul>

</li>
</ul>

</div>

</div>


<h5 id="DS-Oracle-Driver-Project-Setup">Setting Up Oracle JDBC</h5>
<div class="section">

<h6 id="DS-Oracle-Driver-Maven-Coordinates">Maven Coordinates (Oracle JDBC)</h6>
<div class="section">
<p>To include the <a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jajdb/index.html">Oracle
JDBC driver classes</a> in your Helidon MP application so your
application can
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjdbc/data-sources-and-URLs.html#GUID-EF07727C-50AB-4DCE-8EDC-57F0927FF61A">connect
to an Oracle database</a>:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p>Read and understand
<a target="_blank" href="https://www.oracle.com/database/technologies/maven-central-guide.html">Developer&#8217;s
Guide For Oracle JDBC 21c on Maven Central</a></p>

</li>
<li>
<p>For a basic setup, ensure the following <code>&lt;dependency&gt;</code> element is
present as a child element of your project&#8217;s <code>pom.xml</code> file&#8217;s
<code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;com.oracle.database.jdbc&lt;/groupId&gt; <span class="conum" data-value="1" />
    &lt;artifactId&gt;ojdbc11&lt;/artifactId&gt; <span class="conum" data-value="2" />
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="3" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">See
<a target="_blank" href="https://www.oracle.com/database/technologies/maven-central-guide.html">[Developer&#8217;s
Guide For Oracle JDBC 21c on Maven Central</a> for more details.</li>
<li data-value="2">The <code>ojdbc11</code> artifact
<a target="_blank" href="https://www.oracle.com/database/technologies/maven-central-guide.html#:~:text=ojdbc11.jar,JDK14%20and%20JDK15">implements
relevant parts of the JDBC 4.3 specification</a>, which forms part of
Java 21, which is the Java version targeted by Helidon 4.</li>
<li data-value="3">The <code>scope</code> is <code>runtime</code>, indicating that the Oracle
JDBC driver classes will be available on the runtime classpath.</li>
</ul>

</li>
</ul>

</div>

</div>

</div>

</div>


<h3 id="DS-Configuration">Configuration</h3>
<div class="section">

<h4 id="_overview_4">Overview</h4>
<div class="section">
<p>Each connection pool supported by Helidon&#8217;s named data source
integration support is, itself, a <code>DataSource</code> that wraps a
<em>vendor-supplied</em> <code>DataSource</code> present in the JDBC driver classes you
added to your project.  You must configure both the pool and the
vendor-supplied <code>DataSource</code>.</p>

<p>To configure Helidon MP&#8217;s named data source integration:</p>

<ol style="margin-left: 15px;">
<li>
Decide where each property of the configuration will reside, as
permitted by <router-link to="/mp/config/introduction">Helidon MP&#8217;s
MicroProfile Config implementation</router-link>

</li>
<li>
Create configuration suitable for the combination of your selected
connection pool and your selected vendor-supplied <code>DataSource</code>
implementation in those locations

</li>
</ol>

<p>Helidon MP&#8217;s named data source integration relies on
<router-link to="/mp/config/introduction">Helidon MP&#8217;s usage of MicroProfile
Config</router-link>, so you have many choices for each configuration property when
deciding on your configuration&#8217;s location in (1) above.</p>

<p>The configuration property values themselves are necessarily specific
to the connection pool you selected, and to the vendor-supplied
<code>DataSource</code> responsible for actually connecting to your relational
database.  In general, at a minimum, in your configuration you
typically supply:</p>

<ul class="ulist">
<li>
<p>Information so the connection pool knows which vendor-supplied
<code>DataSource</code> implementation to manage</p>

</li>
<li>
<p>A JDBC URL specific to the vendor-supplied <code>DataSource</code> describing
where the database is located, so the managed vendor-supplied
<code>DataSource</code> knows how to connect to it</p>

</li>
<li>
<p>Information required for the vendor-supplied <code>DataSource</code> to
authenticate to the database and otherwise tailor itself to it</p>

</li>
</ul>

<p>Some examples for representative configurations follow.  This list of
configurations is not exhaustive.</p>

</div>


<h4 id="DS-Configuration-Prefixes">Configuration Prefixes</h4>
<div class="section">
<p>All MicroProfile Config-compatible property names for Helidon MP&#8217;s
named data source integration follow a common pattern:</p>

<v-card flat color="grey lighten-3"  class="card__example">
<v-card-text><strong><em>objecttype</em></strong>.<strong><em>datasourcename</em></strong>.<strong><em>propertyname</em></strong></v-card-text>
</v-card>


<ul class="ulist">
<li>
<p>The name of a given configuration property always begins with the
<strong><em>objecttype</em></strong> portion: a fully-qualified Java class name of the
object being configured.  Configuration for Helidon MP&#8217;s named
data source integration concerns the behavior of
<code>javax.sql.DataSource</code> objects, so Helidon MP&#8217;s named data source
integration configuration property names begin with
<code>javax.sql.DataSource</code>.</p>
<ul class="ulist">
<li>
<p>A period (<code>.</code>) separates the <em>objecttype</em> portion from the rest of
the property name.</p>

</li>
</ul>

</li>
<li>
<p>The <strong><em>datasourcename</em></strong> portion, the name of the data source being
configured, comes next.  It cannot contain a period (<code>.</code>).</p>
<ul class="ulist">
<li>
<p>A period (<code>.</code>) separates the <em>datasourcename</em> portion from the rest
of the property name.</p>

</li>
</ul>

</li>
<li>
<p>The <strong><em>propertyname</em></strong> portion, identifying the connection-pool- or
vendor-supplied-<code>DataSource</code>-specific configuration property name,
comes last.  It may contain periods (<code>.</code>).</p>

</li>
</ul>

<p>As an example, configuration to set an imaginary <code>foo.bar</code> property on
the <code>test</code> data source&#8217;s associated connection pool or vendor-specific
<code>DataSource</code> to <code>baz</code> looks like this in Java <code>.properties</code> format:</p>

<markup
lang="properties"

>javax.sql.DataSource.test.foo.bar=baz <span class="conum" data-value="1" /> <span class="conum" data-value="2" /> <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">The <strong><em>objecttype</em></strong> portion of the configuration property name is
<code>javax.sql.DataSource</code>.</li>
<li data-value="2">The <strong><em>datasourcename</em></strong> portion of the configuration property name
is <code>test</code>.</li>
<li data-value="3">The <strong><em>propertyname</em></strong> portion of the configuration property name is
<code>foo.bar</code>.</li>
</ul>

</div>


<h4 id="DS-Configuration-Examples">Examples</h4>
<div class="section">
<p>Here are some examples illustrating general named data source
configuration patterns in various
<router-link to="/mp/config/advanced-configuration">common MicroProfile
Config-compatible locations</router-link>.</p>


<h5 id="_example_meta_infmicroprofile_config_properties_classpath_resource">Example: <code>META-INF/microprofile-config.properties</code> Classpath Resource</h5>
<div class="section">
<p>Here is an example of some named data source configuration as might be
found in a
<code>src/main/resources/META-INF/microprofile-config.properties</code>
configuration source:</p>

<markup
lang="properties"

>javax.sql.DataSource.yourDataSourceName.somePropertyOfYourConnectionPoolAndDataSource = itsValue
javax.sql.DataSource.yourDataSourceName.someOtherPropertyOfYourConnectionPoolAndDataSource = anotherValue</markup>

</div>


<h5 id="_example_system_properties_set_on_the_command_line">Example: System Properties Set on the Command Line</h5>
<div class="section">
<p>Here is an example of some named data source configuration using
system properties on the command line instead:</p>

<markup
lang="bash"

>java \
  -Djavax.sql.DataSource.yourDataSourceName.somePropertyOfYourConnectionPoolAndDataSource=itsValue \
  -Djavax.sql.DataSource.yourDataSourceName.someOtherPropertyOfYourConnectionPoolAndDataSource=anotherValue \
  # ...</markup>

</div>


<h5 id="_example_environment_variables_set_on_the_command_line">Example: Environment Variables Set on the Command Line</h5>
<div class="section">
<p>Here is an example of some named data source configuration using
environment variables as typed directly into a command line shell,
relying on
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.3/apidocs/org/eclipse/microprofile/config/spi/ConfigSource.html#default_config_sources">MicroProfile
Config&#8217;s mapping rules</a>, since many shells will not understand
environment variable names with periods (.)  in them:</p>

<markup
lang="bash"

>JAVAX_SQL_DATASOURCE_YOURDATASOURCENAME_SOMEPROPERTYOFYOURCONNECTIONPOOLANDDATASOURCE=itsValue \
JAVAX_SQL_DATASOURCE_YOURDATASOURCENAME_SOMEOTHERPROPERTYOFYOURCONNECTIONPOOLANDDATASOURCE=anotherValue \
java # ...</markup>

</div>


<h5 id="_example_environment_variables_set_by_the_env_command">Example: Environment Variables Set By the <code>env</code> Command</h5>
<div class="section">
<p>Here is an example of some named data source configuration using
environment variables as supplied via the
<a target="_blank" href="https://www.gnu.org/software/coreutils/manual/html_node/env-invocation.html"><code>env</code>
shell command</a>, thus removing the need for
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.3/apidocs/org/eclipse/microprofile/config/spi/ConfigSource.html#default_config_sources">MicroProfile
Config&#8217;s mapping rules</a>:</p>

<markup
lang="bash"

>env 'javax.sql.DataSource.yourDataSourceName.somePropertyOfYourConnectionPoolAndDataSource=itsValue' \
  'javax.sql.DataSource.yourDataSourceName.someOtherPropertyOfYourConnectionPoolAndDataSource=anotherValue' \
  java # ...</markup>

</div>


<h5 id="_example_application_yaml_classpath_resource">Example: <code>application.yaml</code> Classpath Resource</h5>
<div class="section">
<p>Here is an example of some named data source configuration as might be
found in a <code>src/main/resources/application.yaml</code> classpath resource:</p>

<markup
lang="yaml"

>javax:
  sql:
    DataSource:
      yourDataSourceName:
        somePropertyOfYourConnectionPoolAndDataSource: itsValue
        someOtherPropertyOfYourConnectionPoolAndDataSource: anotherValue</markup>

</div>


<h5 id="DS-Configuration-UCP-Oracle-Example">Example: Configuring the Oracle Universal Connection Pool and Oracle JDBC</h5>
<div class="section">
<p>This example presumes you have:</p>

<ul class="ulist">
<li>
<p><router-link to="#DS-UCP-Project-Setup" @click.native="this.scrollFix('#DS-UCP-Project-Setup')">set up the Oracle Universal Connection Pool</router-link></p>

</li>
<li>
<p><router-link to="#DS-Oracle-Driver-Project-Setup" @click.native="this.scrollFix('#DS-Oracle-Driver-Project-Setup')">set up Oracle JDBC</router-link></p>

</li>
</ul>

<p>This example, in Java properties file format, configures an Oracle
Universal Connection Pool-managed data source named <code>main</code> to
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjdbc/data-sources-and-URLs.html#GUID-C4F2CA86-0F68-400C-95DA-30171C9FB8F0">connect
to an Oracle Database</a> on <code>localhost</code> port <code>1521</code>, using the
<code>oracle.jdbc.poolOracleDataSource</code> vendor-supplied <code>DataSource</code>, with
a service name of <code>XE</code>, a <code>user</code> of <code>scott</code>, and a <code>password</code> of
<code>tiger</code>:</p>

<markup
lang="properties"

>javax.sql.DataSource.main.connectionFactoryClassName = oracle.jdbc.pool.OracleDataSource <span class="conum" data-value="1" />
javax.sql.DataSource.main.url = jdbc:oracle:thin://@localhost:1521/XE <span class="conum" data-value="2" />
javax.sql.DataSource.main.user = scott
javax.sql.DataSource.main.password = tiger</markup>

<ul class="colist">
<li data-value="1">Why <code>connectionFactoryClassName</code>? See
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjuar/oracle/ucp/jdbc/PoolDataSourceImpl.html#setConnectionFactoryClassName_java_lang_String_)"><code>PoolDataSourceImpl#setConnectionFactoryClassName(String)</code></a>.</li>
<li data-value="2">See
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjdbc/data-sources-and-URLs.html#GUID-EF07727C-50AB-4DCE-8EDC-57F0927FF61A">Thin-style
Service Name Syntax</a>.</li>
</ul>

<p>In general, the properties that can be set on the Oracle Universal
Connection Pool can be inferred from the "setter" methods found in
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjuar/oracle/ucp/jdbc/PoolDataSourceImpl.html">the
javadoc for the <code>PoolDataSourceImpl</code> class</a>.</p>

<p>In general, the properties that can be set on the
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jajdb/oracle/jdbc/pool/OracleDataSource.html"><code>oracle.jdbc.pool.OracleDataSource</code></a>
<code>DataSource</code> implementation can be inferred from the "setter" methods
found in
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jajdb/oracle/jdbc/pool/OracleDataSource.html">its
javadoc</a>.</p>

<div class="admonition note">
<p class="admonition-inline"><a target="_blank" href="https://github.com/brettwooldridge/HikariCP/blob/HikariCP-5.0.1/src/main/java/com/zaxxer/hikari/util/PropertyElf.java#L46-L53">Unlike
HikariCP</a>, the Oracle Universal Connection Pool does not distinguish
cleanly between configuration properties that affect <em>its</em> behavior
and those that affect the behavior of the vendor-supplied <code>DataSource</code>
implementation whose connections it pools.  For example, in the
example above it is not possible to tell that
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjuar/oracle/ucp/jdbc/PoolDataSourceImpl.html#setConnectionFactoryClassName_java_lang_String_"><code>connectionFactoryClassName</code>
is a property of the Oracle Universal Connection Pool</a>, and
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jajdb/oracle/jdbc/datasource/impl/OracleDataSource.html#setUser_java_lang_String_"><code>user</code>
is a property of the <code>oracle.jdbc.pool.OracleDataSource</code> <code>DataSource</code>
implementation</a>.  In some cases, the Oracle Universal Connection Pool
will
<a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjuar/oracle/ucp/jdbc/PoolDataSource.html#setUser_java_lang_String_">set
the given property on <em>both</em> the connection pool itself <em>and</em> on the
vendor-supplied <code>DataSource</code> it manages</a>.</p>
</div>

</div>


<h5 id="DS-Configuration-HikariCP-H2-Example">Example: Configuring the HikariCP Connection Pool and H2</h5>
<div class="section">
<p>This example presumes you have:</p>

<ul class="ulist">
<li>
<p><router-link to="#DS-HikariCP-Project-Setup" @click.native="this.scrollFix('#DS-HikariCP-Project-Setup')">set up the HikariCP connection pool</router-link></p>

</li>
<li>
<p><router-link to="#DS-H2-Driver-Project-Setup" @click.native="this.scrollFix('#DS-H2-Driver-Project-Setup')">set up H2</router-link></p>

</li>
</ul>

<p>This example, in Java properties file format, configures a
HikariCP-managed data source named <code>test</code> to connect to an in-memory
H2 database named <code>unit-testing</code> with a <code>user</code> of <code>sa</code> and an empty
password:</p>

<markup
lang="properties"

>javax.sql.DataSource.test.dataSourceClassName = org.h2.jdbcx.JdbcDataSource <span class="conum" data-value="1" />
javax.sql.DataSource.test.dataSource.url = jdbc:h2:mem:unit-testing;DB_CLOSE_DELAY=-1 <span class="conum" data-value="2" /> <span class="conum" data-value="3" />
javax.sql.DataSource.test.dataSource.user = sa
javax.sql.DataSource.test.dataSource.password =</markup>

<ul class="colist">
<li data-value="1">Why <code>dataSourceClassName</code>? See
<a target="_blank" href="https://github.com/brettwooldridge/HikariCP#essentials">HikariCP&#8217;s
configuration documentation</a> for information about how HikariCP
separates configuration of the connection pool itself from
configuration of the vendor-supplied <code>DataSource</code>.</li>
<li data-value="2">Why <code>dataSource.</code>? See
<a target="_blank" href="https://github.com/brettwooldridge/HikariCP/blob/HikariCP-5.0.1/src/main/java/com/zaxxer/hikari/util.PropertyElf.java#L47-49"><code>PropertyElf.java</code>,
lines 47–49</a>.</li>
<li data-value="3">See <a target="_blank" href="https://www.h2database.com/html/features.html#database_url">the
H2 database&#8217;s documentation about its URL format</a>.</li>
</ul>

<p>HikariCP&#8217;s configuration properties are described
<a target="_blank" href="https://github.com/brettwooldridge/HikariCP#gear-configuration-knobs-baby">on
its Github repository</a>.  Properties that should be forwarded on to the
vendor-supplied <code>DataSource</code>
<a target="_blank" href="https://github.com/brettwooldridge/HikariCP/blob/HikariCP-5.0.1/src/main/java/com/zaxxer/hikari/util/PropertyElf.java#L46-L53">are
prefixed with <code>dataSource.</code></a> as seen in the example above.</p>

<p>In general, the properties that can be set on the
<a target="_blank" href="https://www.h2database.com/javadoc/org/h2/jdbcx/JdbcDataSource.html"><code>org.h2.jdbcx.JdbcDataSource</code></a>
vendor-supplied <code>DataSource</code> can be inferred from the "setter" methods
found in
<a target="_blank" href="https://www.h2database.com/javadoc/org/h2/jdbcx/JdbcDataSource.html">its
javadoc</a>.</p>

</div>

</div>


<h4 id="DS-Usage">Usage</h4>
<div class="section">
<p>You use Helidon MP&#8217;s named data source integration in the same way,
regardless of your choices of vendor-supplied <code>DataSource</code> and
connection pool.</p>

<p>To use Helidon MP&#8217;s named data source integration in your application,
once it has been <router-link to="#DS-Setup" @click.native="this.scrollFix('#DS-Setup')">set up</router-link> and
<router-link to="#DS-Configuration" @click.native="this.scrollFix('#DS-Configuration')">configured</router-link>, create an ordinary
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/javax/sql/DataSource.html"><code>DataSource</code></a>-typed
injection point in a
<a target="_blank" href="https://github.com/oracle/helidon/wiki/FAQ#how-do-i-make-a-class-a-cdi-bean">Java
class representing a CDI bean</a> somewhere in your application,
<a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/named">annotated with
the name</a> of the data source you wish to use.</p>

<p>Here is how to define such a field-backed injection point:</p>

<markup
lang="java"

>import javax.sql.DataSource;

import jakarta.inject.Inject;
import jakarta.inject.Named;

// ...

@Inject <span class="conum" data-value="1" />
@Named("test") <span class="conum" data-value="2" />
private DataSource ds; <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1"><a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/inject"><code>@Inject</code></a>
marks the field as an injection point.  Its behavior is defined by
the <a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/jakarta-injection-spec-2.0.html">Jakarta Dependency Injection
specification</a>.</li>
<li data-value="2"><a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/named"><code>@Named("test")</code></a>
says to use the data source named <code>test</code> (as declared by the
<router-link to="#DS-Configuration-Prefixes" @click.native="this.scrollFix('#DS-Configuration-Prefixes')"><em>datasourcename</em> portion</router-link> of a named
data source configuration property).</li>
<li data-value="3">The field injection point has a type of
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/javax/sql/DataSource.html"><code>javax.sql.DataSource</code></a>,
and the field itselfmay be named anything you like.</li>
</ul>

<p>Here is how to define such a constructor parameter injection point:</p>

<markup
lang="java"

>import javax.sql.DataSource;

import jakarta.inject.Inject;
import jakarta.inject.Named;

// ...

private final DataSource ds; <span class="conum" data-value="1" />

@Inject <span class="conum" data-value="2" />
public SomeObject(@Named("test") DataSource ds) { <span class="conum" data-value="3" />
    this.ds = ds; <span class="conum" data-value="4" />
}</markup>

<ul class="colist">
<li data-value="1">This is the field whose value will be set in the constructor.</li>
<li data-value="2"><a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/inject"><code>@Inject</code></a>
marks the constructor as one containing parameter injection
points.  Its behavior is defined by the
<a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/jakarta-injection-spec-2.0.html">Jakarta Dependency Injection
specification</a>.</li>
<li data-value="3"><a target="_blank" href="https://jakarta.ee/specifications/dependency-injection/2.0/apidocs/jakarta/inject/named"><code>@Named("test")</code></a>
says to use the data source named <code>test</code> (as declared by the
<router-link to="#DS-Configuration-Prefixes" @click.native="this.scrollFix('#DS-Configuration-Prefixes')"><em>datasourcename</em> portion</router-link> of a named
data source configuration property).  The parameter injection
point has a type of
<a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/javax/sql/DataSource.html"><code>javax.sql.DataSource</code></a>,
and the parameter itself may be named anything you like.</li>
<li data-value="4">The injected argument will never be <code>null</code>.</li>
</ul>

</div>

</div>

</div>


<h2 id="JTA">Jakarta Transactions (JTA) Integration</h2>
<div class="section">

<h3 id="_overview_5">Overview</h3>
<div class="section">
<p>Helidon MP&#8217;s Jakarta Transactions integration integrates the
<a target="_blank" href="https://www.narayana.io/">Naryana transaction engine</a>, an
implementation of the <a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/">Jakarta
Transactions Specification</a>, into Helidon MP.  It lets you use
<a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/jakarta/transaction/transactional"><code>@jakarta.transaction.Transactional</code></a>
to declare JTA transactions in your Java code.</p>

</div>


<h3 id="JTA-Maven-Coordinates">Maven Coordinates (JTA)</h3>
<div class="section">
<p>To include Helidon&#8217;s JTA integration in your application:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> elements are present as child
elements of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;jakarta.transaction&lt;/groupId&gt;
    &lt;artifactId&gt;jakarta.transaction-api&lt;/artifactId&gt;
    &lt;scope&gt;provided&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-jta-weld&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="2" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>provided</code>, which ensures that the
<a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/jakarta/transaction/transactional">JTA
classes required for compilation</a> are available at compile time.</li>
<li data-value="2">The implementation of these API classes (provided by
<a target="_blank" href="https://narayana.io/">Narayana</a>) will be available at runtime.</li>
</ul>

</li>
</ul>

</div>


<h3 id="JTA-Configuration">Configuration</h3>
<div class="section">

<h4 id="_overview_6">Overview</h4>
<div class="section">
<p>Helidon MP&#8217;s Jakarta Transactions integration does not require
configuration, but configuration is possible.  Because configuration
is of the <a target="_blank" href="https://narayana.io/">underlying Narayana transaction
engine</a>, any restrictions are those of the engine, not of Helidon
itself.</p>

<p>Narayana, unlike Helidon MP, does not use MicroProfile Config, so its
configuration options are less flexible.</p>

<p>Some common examples of Narayana configuration follow.</p>

</div>


<h4 id="_configuring_the_object_store_directory">Configuring the Object Store Directory</h4>
<div class="section">
<p>Narayana features an object store directory which it uses to store
information about transaction outcomes.  To set its location, you may
set the
<a target="_blank" href="https://www.narayana.io/docs/api/com/arjuna/ats/arjuna/common/ObjectStoreEnvironmentBean.html#setObjectStoreType-java.lang.String-"><code>ObjectStoreEnvironmentBean.objectStoreDir</code></a>
system property to the full path of a writeable directory:</p>

<markup
lang="bash"

>java -DObjectStoreEnvironmentBean.objectStoreDir=/var/tmp # ...</markup>

<p>See <a target="_blank" href="https://www.narayana.io/docs/project/index.html#d0e4013">Specifying
the object store location</a> for more information.</p>

</div>


<h4 id="_configuring_the_default_transaction_manager_timeout">Configuring the Default Transaction Manager Timeout</h4>
<div class="section">
<p>To configure Narayana&#8217;s
<a target="_blank" href="https://www.narayana.io/docs/api/com/arjuna/ats/arjuna/common/CoordinatorEnvironmentBean.html#setDefaultTimeout-int-">default
transaction manager timeout</a>, set the
<code>com.arjuna.ats.arjuna.coordinator.defaultTimeout</code> system property to
an integral value in seconds:</p>

<markup
lang="bash"

>java -Dcom.arjuna.ats.arjuna.coordinator.defaultTimeout=60 # ...</markup>

<p>For more on configuring Narayana, see
<a target="_blank" href="https://www.narayana.io/docs/project/index.html#chap-JBossJTA_Installation_Guide-Test_Chapter">Setting
Properties</a> in the Naryana documentation.</p>

</div>

</div>


<h3 id="JTA-Usage">Usage</h3>
<div class="section">
<p>To use Helidon MP&#8217;s Jakarta Transactions integration, annotate a
method with the
<a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/jakarta/transaction/transactional"><code>jakarta.transaction.Transactional</code></a>
annotation:</p>

<markup
lang="java"

>import jakarta.transaction.Transactional;

// ...

@Transactional <span class="conum" data-value="1" />
public String getGreeting(Integer id) {
  // Use a JTA-aware facility to do something transactional here. <span class="conum" data-value="2" />
}</markup>

<ul class="colist">
<li data-value="1">The
<a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/jakarta/transaction/transactional"><code>@Transactional</code>
annotation</a> indicates that this method should be invoked in the
scope of a JTA transaction.  <strong>The object on which the method is
invoked must be one that Helidon MP&#8217;s CDI container has created</strong>,
i.e. it must be managed.
(<a target="_blank" href="https://jakarta.ee/specifications/cdi/4.0/jakarta-cdi-spec-4.0.html#implementation">CDI beans are
managed</a>, as are
<a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1/jakarta-restful-ws-spec-3.1.html#resource-classes">Jakarta RESTful Web
Services resource classes</a>.)</li>
<li data-value="2">For
<a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/jakarta/transaction/transactional"><code>@Transactional</code></a>
to have any effect, whatever is used inside the method must be
JTA-aware (such as a <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/">Jakarta
Persistence</a> object like a managed
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/entitymanager"><code>EntityManager</code></a>).</li>
</ul>

</div>

</div>


<h2 id="JPA">Jakarta Persistence (JPA)</h2>
<div class="section">

<h3 id="_overview_7">Overview</h3>
<div class="section">
<p>Helidon MP&#8217;s <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/">Jakarta Persistence</a>
integration allows you to interact with Jakarta Persistence (JPA)
objects as if your code were running in an application server,
handling automatic creation and management of objects such as
<code>EntityManager</code> and <code>EntityManagerFactory</code> instances.</p>

<p>More pragmatically, it allows you to inject managed
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/entitymanager"><code>EntityManager</code></a>
instances using the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/persistencecontext"><code>@PersistenceContext</code></a>
annotation.</p>

<p>Jakarta Persistence is a Jakarta EE specification that describes,
among other things, how its implementations:</p>

<ol style="margin-left: 15px;">
<li>
Map Java objects to relational database tables

</li>
<li>
Manage such persistent Java objects

</li>
<li>
Interact with <router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Jakarta Transactions</router-link>

</li>
<li>
Interact with <router-link to="#DS" @click.native="this.scrollFix('#DS')">named data sources</router-link>

</li>
</ol>

<p>Jakarta Persistence may be used in an entirely application-managed
manner, which requires no integration at all.  This
application-managed mode places the burden of error handling, thread
safety, transaction management, and other concerns on the user.
<strong>This documentation does <em>not</em> cover application-managed mode JPA.</strong></p>

<p>Jakarta Persistence may also (preferably) be used in a fully
container-managed manner, which requires that a container, like
Helidon MP, handle error management, thread safety and transaction
management on behalf of the user.  <strong>This documentation covers this
container-managed mode of JPA exclusively.</strong></p>

<p>Helidon MP&#8217;s Jakarta Persistence integration comes with support for
two JPA implementations, known as <em>JPA providers</em>:</p>

<ol style="margin-left: 15px;">
<li>
<a target="_blank" href="https://hibernate.org/orm/documentation/6.1">Hibernate ORM</a>

</li>
<li>
<a target="_blank" href="https://www.eclipse.org/eclipselink/documentation/">Eclipselink</a>

</li>
</ol>

<p>In any given project, you use one or the other, but not both.</p>

<p>How you set up Helidon MP&#8217;s Jakarta Persistence integration differs
depending on which of these JPA providers you choose to use.</p>

<p>Jakarta Persistence requires <router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Jakarta Transactions</router-link> and makes
use of <router-link to="#DS" @click.native="this.scrollFix('#DS')">named data sources</router-link>, so as you set up your project you
will need to understand:</p>

<ul class="ulist">
<li>
<p><router-link to="#DS" @click.native="this.scrollFix('#DS')">Helidon MP&#8217;s named data source integration</router-link></p>

</li>
<li>
<p><router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Helidon MP&#8217;s Jakarta Transactions integration</router-link></p>

</li>
</ul>

</div>


<h3 id="JPA-Setup">Project Setup</h3>
<div class="section">

<h4 id="_setting_up_a_jpa_provider">Setting Up a JPA Provider</h4>
<div class="section">

<h5 id="_overview_8">Overview</h5>
<div class="section">
<p>While the Jakarta Persistence specification standardizes many aspects
around programming and usage, it deliberately leaves many required
setup and configuration aspects up to the JPA provider.  You will need
to set up your project differently depending on which JPA provider you
choose.</p>

<p>To set up Helidon MP&#8217;s Jakarta Persistence integration in your
application to work with your chosen JPA provider, you must:</p>

<ol style="margin-left: 15px;">
<li>
<router-link to="#DS" @click.native="this.scrollFix('#DS')">Set up and configure named data sources as appropriate</router-link>

</li>
<li>
<router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Set up and configure Helidon MP&#8217;s Jakarta Transactions
support</router-link>

</li>
<li>
Include the proper Jakarta Persistence-related dependencies

</li>
<li>
Set up your project to generate and compile the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a6933">static metamodel</a>

</li>
<li>
Set up your project for <em>static weaving</em>

</li>
</ol>

<p>Details and examples for each supported JPA provider are below.</p>

</div>


<h5 id="JPA-Maven-Coordinates">Maven Coordinates (Common)</h5>
<div class="section">
<p>To include the Jakarta Persistence APIs that you will need and to
include the core of Helidon&#8217;s Jakarta Persistence integration:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies
are managed</router-link></p>

</li>
<li>
<p><router-link to="#DS" @click.native="this.scrollFix('#DS')">Ensure you have set up and configured named data sources as
appropriate</router-link></p>

</li>
<li>
<p><router-link to="#JTA" @click.native="this.scrollFix('#JTA')">Ensure you have set up and configured Helidon MP&#8217;s Jakarta
Transactions support</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> elements are present as child
elements of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code> element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;jakarta.persistence&lt;/groupId&gt;
    &lt;artifactId&gt;jakarta.persistence-api&lt;/artifactId&gt;
    &lt;scope&gt;provided&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-jpa&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="2" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>provided</code>, which ensures that the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/package-summary.html">JPA
classes required for compilation</a> are available at compile time.</li>
<li data-value="2">The <code>scope</code> is <code>runtime</code>, which ensures that Helidon&#8217;s core,
provider-independent Jakarta Persistence integration is available at
runtime.</li>
</ul>

</li>
</ul>

<p>These <code>&lt;dependency&gt;</code> elements do not set up a JPA provider.  See
details below for the JPA provider you have chosen to use.</p>

</div>


<h5 id="JPA-MetaModel">Setting Up Static Metamodel Generation</h5>
<div class="section">
<p>To generate and compile the Jakarta Persistence static metamodel for
your application, regardless of whether you are using Hibernate ORM or
Eclipselink, <router-link to="/about/managing-dependencies">ensure your
dependencies are managed</router-link>, and then make sure the <code>&lt;plugin&gt;</code> element
in the following code snippet is present as a child element of the
<code>&lt;pluginManagement&gt;&lt;plugins&gt;</code> element sequence as shown below:</p>

<markup
lang="xml"

>&lt;pluginManagement&gt;
    &lt;plugins&gt;

        &lt;!-- ... --&gt;

        &lt;plugin&gt;
            &lt;artifactId&gt;maven-compiler-plugin&lt;/artifactId&gt;
            &lt;executions&gt;
                &lt;execution&gt;
                    &lt;id&gt;default-compile&lt;/id&gt;
                    &lt;configuration&gt;
                        &lt;annotationProcessorPaths&gt;
                            &lt;annotationProcessorPath&gt;
                                &lt;groupId&gt;org.hibernate.orm&lt;/groupId&gt;
                                &lt;artifactId&gt;hibernate-jpamodelgen&lt;/artifactId&gt; <span class="conum" data-value="1" />
                                &lt;version&gt;${version.lib.hibernate}&lt;/version&gt; <span class="conum" data-value="2" />
                            &lt;/annotationProcessorPath&gt;
                        &lt;/annotationProcessorPaths&gt;
                    &lt;/configuration&gt;
                &lt;/execution&gt;
            &lt;/executions&gt;
        &lt;/plugin&gt;

        &lt;!-- ... --&gt;

    &lt;/plugins&gt;
&lt;/pluginManagement&gt;</markup>

<ul class="colist">
<li data-value="1">This adds the <code>hibernate-jpamodelgen</code> jar, which contains a
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/javadocs/org/hibernate/jpamodelgen/JPAMetaModelEntityProcessor.html">Java
annotation processor that generates the static metamodel source
code</a>, to the Java compiler&#8217;s annotation processor path so that it
is active at compile time.</li>
<li data-value="2">Because your <router-link to="/about/managing-dependencies">dependencies
are managed</router-link>, this will resolve to the currently supported version
of Hibernate ORM.</li>
</ul>

<p>For more on the Hibernate ORM <code>hibernate-jpamodelgen</code> annotation
processor, see
<a target="_blank" href="https://hibernate.org/orm/tooling/#hibernate-metamodel-generator">Hibernate
Metamodel Generator</a> in Hibernate ORM&#8217;s documentation.</p>

<div class="admonition note">
<p class="admonition-inline">Many parts of Hibernate ORM&#8217;s documentation of this feature are
outdated.</p>
</div>

</div>


<h5 id="JPA-Hibernate-Maven-Coordinates">Maven Coordinates (Hibernate ORM)</h5>
<div class="section">
<p>To include Helidon&#8217;s Jakarta Persistence-related integration for
Hibernate ORM:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Maven-Coordinates" @click.native="this.scrollFix('#JPA-Maven-Coordinates')">Ensure the basics of your JPA project are
set up properly</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> elements are present as child
elements of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code>
element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-hibernate&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>runtime</code>, which ensures that Helidon MP&#8217;s
Hibernate ORM integration is available at runtime.</li>
</ul>

</li>
</ul>

</div>


<h5 id="JPA-Hibernate-Weaving">Setting Up Static Weaving (Hibernate ORM)</h5>
<div class="section">
<p>Hibernate ORM can alter your classes' bytecode at build time to keep
track of changes made to objects participating in Jakarta Persistence
workflows.</p>

<p>To set up this required static weaving for Hibernate ORM, ensure that
the following <code>&lt;plugin&gt;</code> element is present as a child element of your
project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;plugins&gt;</code> element:</p>

<markup
lang="xml"

>&lt;plugin&gt;
    &lt;groupId&gt;org.hibernate.orm.tooling&lt;/groupId&gt;
    &lt;artifactId&gt;hibernate-enhance-maven-plugin&lt;/artifactId&gt;
    &lt;!--
        Ideally, your plugin versions are managed via a
        &lt;pluginManagement&gt; element, which is why the &lt;version&gt; element
        is commented out below.  If, nevertheless, you opt for the
        explicit version, check
        https://search.maven.org/artifact/org.hibernate.orm/hibernate-enhance-maven-plugin
        for up-to-date versions, and make sure the version is the same
        as that of Hibernate ORM itself.
    --&gt;
    &lt;!-- &lt;version&gt;6.3.1.Final&lt;/version&gt; --&gt;
    &lt;executions&gt;
        &lt;execution&gt;
            &lt;id&gt;Statically enhance JPA entities for Hibernate&lt;/id&gt;
            &lt;phase&gt;compile&lt;/phase&gt;
            &lt;goals&gt;
                &lt;goal&gt;enhance&lt;/goal&gt;
            &lt;/goals&gt;
            &lt;configuration&gt;
                &lt;failOnError&gt;true&lt;/failOnError&gt;
                &lt;enableDirtyTracking&gt;true&lt;/enableDirtyTracking&gt;
                &lt;enableLazyInitialization&gt;true&lt;/enableLazyInitialization&gt;
            &lt;/configuration&gt;
        &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<p>For more on the <code>hibernate-enhance-maven-plugin</code> in particular, see
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#tooling-maven">its
documentation</a>.</p>

<p>For more on Hibernate ORM&#8217;s bytecode enhancement (weaving) in general,
see
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#BytecodeEnhancement">Bytecode
Enhancement</a> in Hibernate ORM&#8217;s documentation.</p>

<p>For more on bytecode enhancement properties, see
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#configurations-bytecode-enhancement">Bytecode
Enhancement Properties</a> in Hibernate ORM&#8217;s documentation.</p>

</div>


<h5 id="JPA-Eclipselink-Maven-Coordinates">Maven Coordinates (Eclipselink)</h5>
<div class="section">
<p>To include Helidon&#8217;s Jakarta Persistence-related integration for
Eclipselink:</p>

<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Ensure your dependencies are
managed</router-link></p>

</li>
<li>
<p><router-link to="#JPA-Maven-Coordinates" @click.native="this.scrollFix('#JPA-Maven-Coordinates')">Ensure the basics of your JPA project are
set up properly</router-link></p>

</li>
<li>
<p>Ensure the following <code>&lt;dependency&gt;</code> elements are present as child
elements of your project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;dependencies&gt;</code>
element:</p>
<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.integrations.cdi&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-integrations-cdi-eclipselink&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt; <span class="conum" data-value="1" />
&lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">The <code>scope</code> is <code>runtime</code>, which ensures that Helidon MP&#8217;s
Eclipselink integration is available at runtime.</li>
</ul>

</li>
</ul>

</div>


<h5 id="JPA-Eclipselink-Weaving">Setting Up Static Weaving (Eclipselink)</h5>
<div class="section">
<p>Eclipselink can alter your classes' bytecode at build time to keep
track of changes made to objects participating in Jakarta Persistence
workflows.</p>

<p>To set up this required static weaving for Eclipselink, ensure that
the following <code>&lt;plugin&gt;</code> element is present as a child element of your
project&#8217;s <code>pom.xml</code> file&#8217;s <code>&lt;plugins&gt;</code> element:</p>

<markup
lang="xml"

>&lt;plugin&gt;
    &lt;groupId&gt;org.codehaus.mojo&lt;/groupId&gt;
    &lt;artifactId&gt;exec-maven-plugin&lt;/artifactId&gt;
    &lt;version&gt;3.1.0&lt;/version&gt; <span class="conum" data-value="1" />
    &lt;executions&gt;
        &lt;execution&gt;
            &lt;id&gt;weave&lt;/id&gt;
            &lt;phase&gt;process-classes&lt;/phase&gt;
            &lt;goals&gt;
                &lt;goal&gt;java&lt;/goal&gt;
            &lt;/goals&gt;
            &lt;configuration combine.self="override"&gt;
                &lt;classpathScope&gt;compile&lt;/classpathScope&gt;
                &lt;mainClass&gt;org.eclipse.persistence.tools.weaving.jpa.StaticWeave&lt;/mainClass&gt;
                &lt;arguments&gt;
                    &lt;argument&gt;-loglevel&lt;/argument&gt;
                    &lt;argument&gt;INFO&lt;/argument&gt;
                    &lt;argument&gt;-persistenceinfo&lt;/argument&gt;
                    &lt;argument&gt;${project.build.outputDirectory}&lt;/argument&gt;
                    &lt;argument&gt;${project.build.outputDirectory}&lt;/argument&gt;
                    &lt;argument&gt;${project.build.outputDirectory}&lt;/argument&gt;
                &lt;/arguments&gt;
            &lt;/configuration&gt;
        &lt;/execution&gt;
    &lt;/executions&gt;
&lt;/plugin&gt;</markup>

<ul class="colist">
<li data-value="1">Always check
<a target="_blank" href="https://search.maven.org/artifact/org.codehaus.mojo/exec-maven-plugin">Maven
Central</a> for up-to-date versions.</li>
</ul>

<p>For more on the Eclipselink static weaving command-line utility, see
<a target="_blank" href="https://wiki.eclipse.org/EclipseLink/UserGuide/JPA/Advanced_JPA_Development/Performance/Weaving/Static_Weaving#Use_the_Command_Line">Static
Weaving</a> in the Eclipselink documentation.</p>

</div>

</div>

</div>


<h3 id="JPA-Configuration">Configuration</h3>
<div class="section">
<p>To configure Helidon MP&#8217;s Jakarta Persistence integration, you author
a
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#persistence-xml-file"><code>META-INF/persistence.xml</code>
file</a>.  It contains a mix of standardized elements and JPA
provider-specific properties.</p>

<p>If you are writing a component or a library, then you place this in
your Maven project&#8217;s <code>src/test/resources</code> directory (because a library
or component is not itself an application, and by definition can be
included in many applications, so it is inappropriate to put
application-level configuration in your component).  If you are
working on a project that contains the <code>main</code> method (or similar) that
starts your application, then and only then do you place a
<code>META-INF/persistence.xml</code> in your persistence-oriented Maven
project&#8217;s <code>src/main/resources</code> directory.</p>

<p>For details about the structure and syntax of the
<code>META-INF/persistence.xml</code> file, see
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#persistence-xml-file">persistence.xml
file</a> in the Jakarta Persistence specification.</p>


<h4 id="_use_only_one_meta_infpersistence_xml_per_application">Use Only One <code>META-INF/persistence.xml</code> Per Application</h4>
<div class="section">
<p>Like any configuration, a <code>META-INF/persistence.xml</code> file is normally
an <em>application-level</em> concern, not a <em>component-level</em> concern. In
other words, your Java application, made up of various components, or
libraries, some of which you may have written, and many of which you
have not, should normally have exactly one <code>META-INF/persistence.xml</code>
on its classpath, describing the persistence-related aspects of the
application in its particular environment. There are very few use
cases where multiple <code>META-INF/persistence.xml</code> classpath resources
are called for.</p>

<p>A common mistake is to write a component or library&mdash;by
definition intended for use in possibly more than one
application&mdash;and include a
<code>src/main/resources/META-INF/persistence.xml</code> in its Maven project.
If two components or libraries containing <code>META-INF/persistence.xml</code>
classpath resources like this are deployed as part of an application,
it can make for a confusing state of affairs at application runtime,
and may lead to exceptions indicating more <em>persistence units</em> are
present than are expected.</p>

<p>Most library projects that work with JPA artifacts should probably
have a <code>src/test/resources/META-INF/persistence.xml</code> in their Maven
projects instead. This allows you to test your JPA-centric work
against a test configuration, rather than a "main" or production one,
which is almost certainly what you want in nearly all cases.</p>

</div>


<h4 id="_persistence_units">Persistence Units</h4>
<div class="section">
<p>Fundamentally, a <code>META-INF/persistence.xml</code> file contains a collection
of <em>persistence units</em>.  A persistence unit represents a collection of
entities in a relational database loosely coupled to a <router-link to="#DS" @click.native="this.scrollFix('#DS')">named
data source</router-link> that knows how to connect to it.</p>

<p>Your <code>META-INF/persistence.xml</code> file must begin
(and end) with the following XML:</p>

<markup
lang="xml"
title="<code>META-INF/persistence.xml</code>"
>&lt;persistence xmlns="https://jakarta.ee/xml/ns/persistence"
             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
             xsi:schemaLocation="https://jakarta.ee/xml/ns/persistence
                                 https://jakarta.ee/xml/ns/persistence/persistence_3_1.xsd"
             version="3.1"&gt; <span class="conum" data-value="1" />

    <span class="conum" data-value="2" />

&lt;/persistence&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon MP&#8217;s Jakarta Persistence integration supports
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/">Jakarta Persistence version
3.1</a>.</li>
<li data-value="2">`&lt;persistence-unit&gt; elements are listed here.</li>
</ul>

</div>


<h4 id="_persistence_unit">Persistence Unit</h4>
<div class="section">
<p>You list your application&#8217;s persistence units as
<code>&lt;persistence-unit&gt;</code> child elements of the enclosing <code>&lt;persistence&gt;</code>
element.  Each <code>&lt;persistence-unit&gt;</code> element identifies a named
persistence unit that will correspond to an <code>EntityManager</code> in your
code, and represents a collection of entities in a relational database.</p>


<h5 id="_example_persistence_unit_skeleton">Example: Persistence Unit Skeleton</h5>
<div class="section">
<p>Here is a partial example of a persistence unit named <code>test</code> with a
helpful description:</p>

<markup
lang="xml"
title="<code>META-INF/persistence.xml</code>"
>&lt;!-- ... --&gt;

&lt;persistence-unit name="test" transaction-type="JTA"&gt; <span class="conum" data-value="1" />
    &lt;description&gt;A testing database&lt;/description&gt;

    <span class="conum" data-value="2" />

&lt;/persistence-unit&gt;

&lt;!-- ... --&gt;</markup>

<ul class="colist">
<li data-value="1">Because Helidon MP&#8217;s JPA integration is for container-managed JPA,
the <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a12296"><code>transaction-type</code>
attribute</a> must in practice always be set to <code>JTA</code>.</li>
<li data-value="2">The order of subsequent child elements is significant and governed
by the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#persistence-xml-schema">XML
schema</a>.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">In most microservices, there will be only one persistence unit.</p>
</div>

<div class="admonition tip">
<p class="admonition-inline">A <code>&lt;persistence-unit&gt;</code> is represented in Jakarta Persistence as
an instance of the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/spi/persistenceunitinfo"><code>PersistenceUnitInfo</code></a>
class.</p>
</div>

</div>


<h5 id="JPA-JTA-Data-Source">JTA Data Source</h5>
<div class="section">
<p>A persistence unit is always associated with exactly one <router-link to="#DS" @click.native="this.scrollFix('#DS')">named
data source</router-link>.</p>

<p>Because Helidon MP&#8217;s Jakarta Persistence integration provides support
for container-managed JPA, and because container-managed JPA requires
Jakarta Transactions (JTA), the kind of named data source a
persistence unit is associated with is always a <router-link to="#JTA" @click.native="this.scrollFix('#JTA')">JTA</router-link> data
source.  The <code>&lt;jta-data-source&gt;</code> element, a child of the
<code>&lt;persistence-unit&gt;</code> element, is how you link a persistence unit to a
<router-link to="#DS" @click.native="this.scrollFix('#DS')">named data source</router-link> you previously <router-link to="#DS-Configuration" @click.native="this.scrollFix('#DS-Configuration')">configured</router-link>.</p>


<h6 id="_example_persistence_unit_with_jta_data_source">Example: Persistence Unit with JTA Data Source</h6>
<div class="section">
<p>Here is a partial example of a persistence unit named <code>test</code>, with a
helpful description, linked with a JTA data source named <code>main</code>:</p>

<markup
lang="xml"
title="<code>META-INF/persistence.xml</code>"
>&lt;!-- ... ---&gt;

&lt;persistence-unit name="test" transaction-type="JTA"&gt;
    &lt;description&gt;A testing database&lt;/description&gt;
    &lt;jta-data-source&gt;main&lt;/jta-data-source&gt; <span class="conum" data-value="1" />

    <span class="conum" data-value="2" />

&lt;/persistence-unit&gt;

&lt;!-- ... --&gt;</markup>

<ul class="colist">
<li data-value="1">This links this persistence unit to a <router-link to="#DS" @click.native="this.scrollFix('#DS')">data source</router-link> named
<code>main</code>, whose <router-link to="#DS-Configuration" @click.native="this.scrollFix('#DS-Configuration')">connectivity information</router-link> can
be found in a MicroProfile-Config-compatible location, as detailed
in the <router-link to="#DS-Configuration" @click.native="this.scrollFix('#DS-Configuration')">data source configuration</router-link> section
above.</li>
<li data-value="2">Other persistence unit characteristics go here.</li>
</ul>

</div>

</div>


<h5 id="_classes">Classes</h5>
<div class="section">
<p>A persistence unit lists the classes that should be managed and that
will take part in Jakarta Persistence workflows.  You must list:</p>

<ol style="margin-left: 15px;">
<li>
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a18">Entity classes</a>

</li>
<li>
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a487">Embeddable classes</a>

</li>
<li>
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#mapped-superclasses">Mapped
superclasses</a>

</li>
<li>
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a2999">Converter classes</a>

</li>
</ol>

<p>You use a
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#list-of-managed-classes">sequence
of <code>&lt;class&gt;</code> elements</a> to do this.  Each <code>&lt;class&gt;</code> element contains
the fully-qualified class name of one of the types of managed classes
listed above.</p>

<div class="admonition note">
<p class="admonition-inline">There are <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a12305">other
mechanisms that can be used in a <code>META-INF/persistence.xml</code> file to
describe managed classes</a>, but they may or may not be honored by a
given JPA provider.</p>
</div>


<h6 id="_example_persistence_unit_with_class_elements">Example: Persistence Unit with Class Elements</h6>
<div class="section">
<p>Here is a partial example of a persistence unit named <code>test</code>, with a
helpful description, linked with a JTA data source named <code>main</code>,
containing two entity classes:</p>

<markup
lang="xml"
title="<code>META-INF/persistence.xml</code>"
>&lt;!-- ... ---&gt;

&lt;persistence-unit name="test" transaction-type="JTA"&gt;
    &lt;description&gt;A testing database&lt;/description&gt;
    &lt;jta-data-source&gt;main&lt;/jta-data-source&gt;
    &lt;class&gt;com.example.ExampleEntity0&lt;/class&gt; <span class="conum" data-value="1" />
    &lt;class&gt;com.example.ExampleEntity1&lt;/class&gt;

    <span class="conum" data-value="2" />

&lt;/persistence-unit&gt;

&lt;!-- ... --&gt;</markup>

<ul class="colist">
<li data-value="1">Each entity class is listed with a separate <code>&lt;class&gt;</code> element, and
there is no containing <code>&lt;classes&gt;</code> element or similar.</li>
<li data-value="2">Other persistence unit characteristics go here.</li>
</ul>

</div>

</div>


<h5 id="_properties">Properties</h5>
<div class="section">
<p>Persistence units can have simple properties attached to them to
further configure the backing JPA provider.  You use the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a12384"><code>&lt;properties&gt;</code>
element</a> to specify them.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon MP&#8217;s Jakarta Persistence integration is for
container-managed JPA, so the vendor-independent properties
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#a12384">described
in the specification</a> directly concerned with database connectivity
information, such as <code>jakarta.persistence.jdbc.url</code>, <strong>do not apply</strong>
and will be ignored if present.  See <router-link to="#JPA-JTA-Data-Source" @click.native="this.scrollFix('#JPA-JTA-Data-Source')">the JTA
Data Source</router-link> section above for how a persistence unit is linked to a
<router-link to="#DS" @click.native="this.scrollFix('#DS')">named data source</router-link>.</p>
</div>


<h6 id="_example_persistence_unit_with_properties">Example: Persistence Unit with Properties</h6>
<div class="section">
<p>Here is a partial exmaple of a persistence unit named <code>test</code>, with a
helpful description, linked with a JTA data source named <code>sample</code>,
containing two entity classes, configuring a Hibernate ORM-specific
property:</p>

<markup
lang="xml"
title="<code>META-INF/persistence.xml</code>"
>&lt;!-- ... ---&gt;

&lt;persistence-unit name="test" transaction-type="JTA"&gt;
    &lt;description&gt;A testing database&lt;/description&gt;
    &lt;jta-data-source&gt;sample&lt;/jta-data-source&gt; <span class="conum" data-value="1" />
    &lt;class&gt;com.example.ExampleEntity0&lt;/class&gt;
    &lt;class&gt;com.example.ExampleEntity1&lt;/class&gt;
    &lt;properties&gt;
        &lt;property name="hibernate.show_sql" value="true"/&gt; <span class="conum" data-value="2" />
        &lt;property name="eclipselink.weaving" value="false"/&gt; <span class="conum" data-value="3" />
    &lt;/properties&gt;
&lt;/persistence-unit&gt;

&lt;!-- ... --&gt;</markup>

<ul class="colist">
<li data-value="1">The name identifies a name present in the
<router-link to="#DS-Configuration-Prefixes" @click.native="this.scrollFix('#DS-Configuration-Prefixes')"><em>datasourcename</em> portion of a named
datasource configuration</router-link>.  There is no need for any kind of
reserved prefix (like <code>java:comp/env</code>).</li>
<li data-value="2">This is a Hibernate ORM-specific property and will be properly
ignored if the JPA provider you have <router-link to="#JPA-Setup" @click.native="this.scrollFix('#JPA-Setup')">set up</router-link> is
Eclipselink.  See
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#configurations-logging">Statement
logging and statistics</a> in the Hibernate ORM documentation for
more details about the <code>hibernate.show_sql</code> property.</li>
<li data-value="3">This is an Eclipselink-specific property (and (a) is required and
(b) must be set to <code>false</code> if you are using Eclipselink), and will
be properly ignored if the JPA provider you have <router-link to="#JPA-Setup" @click.native="this.scrollFix('#JPA-Setup')">set
up</router-link> is Hibernate ORM.  See
<a target="_blank" href="https://www.eclipse.org/eclipselink/documentation/4.0.2/jpa/extensions/persistenceproperties_ref.htm#weaving">weaving</a>
in the Eclipselink documentation for more details about the
<code>eclipselink.weaving</code> property.</li>
</ul>

<div class="admonition tip">
<p class="admonition-inline">For an exhaustive list of Hibernate ORM-specific properties, see
<a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html#configurations">Configurations</a>
in the Hibernate ORM documentation.</p>
</div>

<div class="admonition tip">
<p class="admonition-inline">For an exhaustive list of Eclipselink-specific properties, see
<a target="_blank" href="https://www.eclipse.org/eclipselink/documentation/4.0.2/jpa/extensions/persistenceproperties_ref.htm#sthref733">Persistence
Property Extensions Reference</a> in the Eclipselink documentation.</p>
</div>

</div>

</div>

</div>

</div>


<h3 id="JPA-Usage">Usage</h3>
<div class="section">
<p>To use Helidon MP&#8217;s Jakarta Persistence integration, once you have
<router-link to="#JPA-Setup" @click.native="this.scrollFix('#JPA-Setup')">set up</router-link> and <router-link to="#JPA-Configuration" @click.native="this.scrollFix('#JPA-Configuration')">configured</router-link> your
project, you use the Jakarta Persistence APIs in almost the same
manner as if your project were deployed to a Jakarta EE application
server.</p>

<p>Specifically, you:</p>

<ol style="margin-left: 15px;">
<li>
Annotate your managed classes (entities, mapped superclasses, etc.)
appropriately (using
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/entity"><code>@Entity</code></a>
and similar annotations)

</li>
<li>
Inject
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/entitymanager"><code>EntityManager</code></a>
instances appropriately with the
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/persistencecontext"><code>@PersistenceContext</code>
annotation</a>

</li>
<li>
Use an injected
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/jakarta.persistence/jakarta/persistence/entitymanager"><code>EntityManager</code></a>
to work with your managed objects

</li>
</ol>

<p>In addition, you <router-link to="#JTA-Usage" @click.native="this.scrollFix('#JTA-Usage')">use Helidon MP&#8217;s JTA integration</router-link> to
declare transactional boundaries where appropriate.</p>

<p>A full tutorial of Jakarta Persistence is <em>well</em> beyond the scope of
this documentation.  Consult
<a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html#entities">the
specification</a> for details on how to map your entity classes to
relational database tables, and how to perform other related tasks.</p>

</div>


<h3 id="JPA-Examples">Examples</h3>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.3/examples/integrations/cdi/pokemons">JPA
Pokemons Example</a></p>

</li>
</ul>

</div>

</div>


<h2 id="References">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="/about/managing-dependencies">Managing Dependencies in Helidon MP</router-link></p>

</li>
<li>
<p><router-link to="/mp/config/introduction">MicroProfile Config in Helidon MP</router-link></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en/java/javase/21/docs/api/java.sql/java/sql/package-summary.html">JDBC
4.3 Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/brettwooldridge/HikariCP/blob/HikariCP-5.0.1#readme">HikariCP 5.0.1
documentation</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.oracle.com/database/technologies/maven-central-guide.html">Developers
Guide For Oracle JDBC 21c on Maven Central</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjucp/index.html">Oracle® Universal
Connection Pool Developer&#8217;s Guide, Release 21c</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjuar/index.html#">Oracle® Universal
Connection Pool Java API Reference, Release 21c</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jjdbc/index.html">Oracle® Database JDBC
Developer&#8217;s Guide and Reference, Release 21c</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en/database/oracle/oracle-database/21/jajdb/index.html">Oracle® Database JDBC
Java API Reference, Release 21c</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.h2database.com/html/main.html">H2 Database Engine documentation</a></p>

</li>
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/jakarta-transactions-spec-2.0.html">Jakarta Transactions
2.0 Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/apidocs/">Jakarta Transactions
2.0 API Reference</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.narayana.io/docs/project/index.html">Narayana Project Documentation</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.narayana.io/docs/api/index.html">Narayana API Reference</a></p>

</li>
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/jakarta-persistence-spec-3.1.html">Jakarta Persistence
{persistence-lib-jakarta-persistence-api} Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1/apidocs/">Jakarta Persistence
{persistence-lib-jakarta-persistence-api} API Reference</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.jboss.org/hibernate/orm/6.1/userguide/html_single/Hibernate_User_Guide.html">Hibernate
ORM User Guide</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.eclipse.org/eclipselink/documentation/">Eclipselink documentation</a></p>

</li>
</ul>

</div>

</doc-view>
