<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The <a target="_blank" href="https://www.w3.org/TR/cors">cross-origin resource sharing (CORS) protocol</a> helps developers control if and how REST resources served by their applications can be shared across origins.
Helidon MP includes an implementation of CORS that you can use to add CORS behavior
to the services you develop. You can define your application&#8217;s CORS behavior programmatically using the Helidon CORS API alone or
together with configuration.</p>

<p>Helidon also provides three built-in services that add their
own endpoints to your application&#8212;&#8203;health, metrics, and OpenAPI&#8212;&#8203;that have integrated CORS support.
By adding very little code to your application, you control how all the resources in
your application&#8212;&#8203;the ones you write and the ones provided by the Helidon built-in services&#8212;&#8203;can be shared across origins.</p>


<h3 id="_before_you_begin">Before You Begin</h3>
<div class="section">
<p>Before you revise your application to add CORS support, you need to decide what type of cross-origin sharing you want
to allow for each resource your application exposes.
For example, suppose for a given resource you want to allow unrestricted sharing for GET, HEAD, and POST requests
(what CORS refers to as "simple" requests), but permit other types of requests only from the two
origins <code>foo.com</code> and <code>there.com</code>.
Your application would implement two types of CORS sharing: more relaxed for the
simple requests and stricter for others.</p>

<p>Once you know the type of sharing you want to allow for each of your resources&#8212;&#8203;including any from built-in
services&#8212;&#8203;you can change your application accordingly.</p>

</div>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable CORS
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-cors&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Once you have planned how each of your resources should support CORS, you specify the CORS behavior in one of two ways:</p>

<ul class="ulist">
<li>
<p>add <code>@CrossOrigin</code> annotations to the Java code for the resources, or</p>

</li>
<li>
<p>add configuration.</p>

</li>
</ul>

<p>You can do both. CORS configuration for a resource overrides any CORS settings declared using <code>@CrossOrigin</code> in the Java class for the resource.</p>

</div>


<h2 id="_api">API</h2>
<div class="section">

<h3 id="_the_crossorigin_annotation">The <code>@CrossOrigin</code> Annotation</h3>
<div class="section">
<p>Adding CORS behavior to your Helidon MP application involves just a few simple steps.</p>

<p>For each resource class in your application:</p>

<ol style="margin-left: 15px;">
<li>
Identify the resources and subresources&#8212;&#8203;in other words, the paths&#8212;&#8203;declared in the resource class which you want to support CORS.

</li>
<li>
For each of those resources and subresources which should support CORS:
<ol style="margin-left: 15px;">
<li>
Find or create a Java method annotated with <code>@OPTIONS</code> and with the correct <code>@Path</code>.

</li>
<li>
To that <code>@OPTIONS</code> Java method add a Helidon <a target="_blank" href="/apidocs/io.helidon.microprofile.cors/io/helidon/microprofile/cors/CrossOrigin.html}"><code>@CrossOrigin</code></a> annotation that describes the cross-origin sharing you want for that resource.

</li>
</ol>

</li>
</ol>

<div class="admonition note">
<p class="admonition-textlabel">Using @CrossOrigin Correctly</p>
<p ><p>Use the <code>@CrossOrigin</code> annotation <em>only</em> on methods which also have the <code>@OPTIONS</code> annotation. Remember that the <code>@CrossOrigin</code> settings apply to a given path and therefore to all Java resource methods which share that path.</p>

<p>Helidon MP aborts the server start-up if you use the <code>@CrossOrigin</code> annotation on a resource method other than an <code>@OPTIONS</code> method.</p>

<p>For an informal look at the reasons for applying the <code>@CrossOrigin</code> annotation to the <code>@OPTIONS</code> method, instead of another
method, see <router-link to="/mp/cors/why-options">Why <code>@OPTIONS</code>?</router-link>.</p>
</p>
</div>

<p>The <router-link to="#config-table" @click.native="this.scrollFix('#config-table')">configuration table</router-link> below describes the attributes of the <code>@CrossOrigin</code> annotation.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can define CORS behavior&#8212;&#8203;and you or your users can override behavior declared in your code&#8212;&#8203;using configuration.</p>

<p>For each resource you want to configure, add a section to <code>META-INF/microprofile-config.properties</code> file:</p>

<markup
lang="properties"
title="General form of CORS configuration"
>cors.enabled= <span class="conum" data-value="1" />
#
<span class="conum" data-value="2" />
cors.paths.<em>i</em>.path-pattern= <span class="conum" data-value="3" />
cors.paths.<em>i</em>.allow-headers=
cors.paths.<em>i</em>.max-age-seconds=
cors.paths.<em>i</em>.allow-credentials=
cors.paths.<em>i</em>.allow-origins=
cors.paths.<em>i</em>.expose-headers=
cors.paths.<em>i</em>.allow-methods=
cors.paths.<em>i</em>.enabled= <span class="conum" data-value="4" /></markup>

<ul class="colist">
<li data-value="1">You can disable CORS processing for all resources by setting <code>cors.enabled</code> to <code>false</code>. Defaults to <code>true</code>.</li>
<li data-value="2">Add a block for each resource you want to configure.
The index <code><em>i</em></code> is an integer (0, 1, 2, etc.).</li>
<li data-value="3">Specify the settings as needed to define the CORS behavior you want for that resource.</li>
<li data-value="4">The <code>enabled</code> setting lets you control whether the system uses that set of CORS configuration. Defaults to <code>true</code>.</li>
</ul>

<p>The system uses the index <code><em>i</em></code>, not the position in the config file, to identify the settings for a particular resource.</p>

<p>Path patterns can be any expression accepted by the <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/PathMatcher.html"><code>PathMatcher</code></a> class.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon scans the cross-origin entries in index order (0, 1, 2, etc.) until it finds an entry that
matches an incoming request&#8217;s path and HTTP method, so be sure to assign index values to the entries so Helidon will check them in the order you want. In particular, use lower index values for entries with more specific path patterns.</p>
</div>

<p>The table below describes the attributes on the <code>@CrossOrigin</code> annotation and the configuration keys
that map to the headers defined in the CORS protocol.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
<col style="width: 16.667%;">
</colgroup>
<thead>
<tr>
<th>annotation attribute</th>
<th>config key</th>
<th>type</th>
<th>default</th>
<th>description</th>
<th>CORS header name</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>allowCredentials</code></td>
<td class=""><code>allow-credentials</code></td>
<td class="">boolean</td>
<td class=""><code>false</code></td>
<td class="">Sets the allow credentials flag.</td>
<td class=""><code>Access-Control-Allow-Credentials</code></td>
</tr>
<tr>
<td class=""><code>allowHeaders</code></td>
<td class=""><code>allow-headers</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed headers.</td>
<td class=""><code>Access-Control-Allow-Headers</code></td>
</tr>
<tr>
<td class=""><code>allowMethods</code></td>
<td class=""><code>allow-methods</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed methods.</td>
<td class=""><code>Access-Control-Allow-Methods</code></td>
</tr>
<tr>
<td class=""><code>allowOrigins</code></td>
<td class=""><code>allow-origins</code></td>
<td class="">string[]</td>
<td class=""><code>*</code></td>
<td class="">Sets the allowed origins.</td>
<td class=""><code>Access-Control-Allow-Origins</code></td>
</tr>
<tr>
<td class=""><code>exposeHeaders</code></td>
<td class=""><code>expose-headers</code></td>
<td class="">string[]</td>
<td class="">&#160;</td>
<td class="">Sets the expose headers.</td>
<td class=""><code>Access-Control-Expose-Headers</code></td>
</tr>
<tr>
<td class=""><code>maxAgeSeconds</code></td>
<td class=""><code>max-age-seconds</code></td>
<td class="">long</td>
<td class=""><code>3600</code></td>
<td class="">Sets the maximum age.</td>
<td class=""><code>Access-Control-Max-Age</code></td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><code>enabled</code></td>
<td class="">boolean</td>
<td class=""><code>true</code></td>
<td class="">Sets whether this config should be enabled or not.</td>
<td class="">n/a</td>
</tr>
</tbody>
</table>
</div>

<p>If the cross-origin configuration is disabled (<code>enabled</code> = false), then the Helidon CORS implementation ignores the cross-origin configuration entry.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>The <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.3/examples/quickstarts/helidon-quickstart-mp">Helidon MP Quickstart application</a> allows users to:</p>

<ul class="ulist">
<li>
<p>obtain greetings by sending <code>GET</code> requests to the <code>/greet</code> resource, and</p>

</li>
<li>
<p>change the greeting message by sending a <code>PUT</code> request to the <code>/greet/greeting</code> resource.</p>

</li>
</ul>

<p>The <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.3/examples/microprofile/cors">Helidon MP CORS Example</a> shows the basic quickstart example enhanced for CORS.</p>

<p>The discussion below describes the changes in the application which:</p>

<ul class="ulist">
<li>
<p>permit unrestricted sharing of the resource <code>/greet</code>, and</p>

</li>
<li>
<p>restrict sharing of the resource <code>/greet/greeting</code> so that only the origins <code>http://foo.com</code> and <code>http://there.com</code> can change the greeting.</p>

</li>
</ul>


<h3 id="_adding_annotations">Adding Annotations</h3>
<div class="section">
<markup
lang="java"
title="Using annotations to declare CORS behavior"
>@Path("/greet")
public class GreetResource { <span class="conum" data-value="1" />

    @GET
    public JsonObject getDefaultMessage() {...} <span class="conum" data-value="2" />

    @Path("/greeting")
    @PUT
    public Response updateGreeting(JsonObject jsonObject) {...} <span class="conum" data-value="3" />

    @OPTIONS
    @CrossOrigin()
    public void optionsForRetrievingUnnamedGreeting() {} <span class="conum" data-value="4" />

    @OPTIONS
    @Path("/greeting")
    @CrossOrigin({"http://foo.com", "http://there.com"},
                 allowMethods = {HttpMethod.PUT})
    public void optionsForUpdatingGreeting() {} <span class="conum" data-value="5" />
}</markup>

<ul class="colist">
<li data-value="1">Existing <code>GreetResource</code> resource class with path <code>/greet</code>.</li>
<li data-value="2">Existing <code>@GET</code> method for resource <code>/greet</code>.</li>
<li data-value="3">Existing <code>@PUT</code> method for resource <code>/greet/greeting</code>.</li>
<li data-value="4">New <code>@OPTIONS</code> method for <code>/greet</code>. (Just like the <code>@GET</code> method <code>getDefaultMessage</code>, this <code>@OPTIONS</code> method does not have a <code>@Path</code> annotation; both "inherit" the class-level <code>@Path</code> setting <code>/greet</code>.) The <code>@CrossOrigin</code> annotation declares default cross-origin sharing which permits sharing via all HTTP methods to all origins.</li>
<li data-value="5">New <code>@OPTIONS</code> method for <code>/greet/greeting</code>. The <code>@CrossOrigin</code> annotation specifies sharing only via the <code>PUT</code> HTTP method and only to the two listed origins.</li>
</ul>

</div>


<h3 id="_adding_configuration">Adding Configuration</h3>
<div class="section">
<p>You could use the following configuration in place of using annotations to set up the same CORS behavior.</p>

<markup
lang="properties"
title="Using configuration to set up the same CORS behavior"
>cors.paths.0.path-pattern=/greet <span class="conum" data-value="1" />

cors.paths.1.path-pattern=/greet/greeting <span class="conum" data-value="2" />
cors.paths.1.allow-origins=http://foo.com,http://there.com
cors.paths.1.allow-methods=PUT</markup>

<ul class="colist">
<li data-value="1">Enables default CORS settings for the <code>/greet</code> resource.</li>
<li data-value="2">Sets up sharing for the <code>/greet/greeting</code> resource only via <code>PUT</code> requests and only from the specified origins.</li>
</ul>

<p>Or, alternatively, the following configuration example augments the settings from the <code>@CrossOrigin</code> annotations in the code.</p>

<markup
lang="properties"
title="Using configuration to augment or override declared CORS behavior"
>cors.paths.0.path-pattern=/greet <span class="conum" data-value="1" />
cors.paths.0.allow-methods=GET
cors.paths.0.allow-origins=http://here.com,http://foo.com,http://there.com

cors.paths.1.path-patterh=/greet/greeting <span class="conum" data-value="2" />
cors.paths.1.allow-methods=PUT
cors.paths.1.allow-origins=http://foo.com</markup>

<ul class="colist">
<li data-value="1">Changes the declared settings to restrict cross-origin use of <code>/greet</code> to only <code>GET</code> and only from <code>foo.com</code> and <code>there.com</code>.</li>
<li data-value="2">Changes the settings for <code>/greet/greeting</code> from what they were declared; with this configuration, only the origin <code>foo.com</code> is permitted. (The declared setting also allowed <code>there.com</code>).</li>
</ul>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">

<h3 id="_cors_and_the_requested_uri_feature">CORS and the Requested URI Feature</h3>
<div class="section">
<p>The decisions the Helidon CORS feature makes depend on accurate information about each incoming request,
particularly the host to which the request is sent.
Conveyed as headers in the request, this information can be changed or overwritten by intermediate nodes&#8212;&#8203;such as load
balancers&#8212;&#8203;between the origin of the request and your service.</p>

<p>Well-behaved intermediate nodes preserve this important data in other headers, such as <code>Forwarded</code>.
You can configure how the Helidon server handles these headers as described in the documentation for <router-link :to="{path: '/mp/server', hash: '#_using_requested_uri_discovery'}">requested URI discovery</router-link>.</p>

<p>The CORS support in Helidon uses the requested URI feature to discover the correct information about each request,
according to your configuration, so it can make accurate decisions about whether to permit cross-origin accesses.</p>

</div>


<h3 id="_using_cors_support_in_built_in_helidon_services">Using CORS Support in Built-in Helidon Services</h3>
<div class="section">
<p>Several built-in Helidon services&#8212;&#8203;<router-link to="/mp/health">health</router-link>, <router-link to="/mp/metrics/metrics">metrics</router-link>, and
<router-link to="/mp/openapi/openapi">OpenAPI</router-link>--have integrated CORS support.
You can include these services in your application and control how those resources can be  shared across origins.</p>

<p>For example, several websites related to OpenAPI run a web application in your browser.
You provide the URL for your application to the browser application.
The browser application uses the URL to retrieve the OpenAPI document
that describes the application&#8217;s endpoints directly from your application.
The browser application then displays a user interface that you use to "drive" your application. That is,
you provide input, have the web application
send requests to your application endpoints, and then view the responses.
This scenario is exactly the situation CORS addresses: an application in the browser from one origin&#8201;&#8212;&#8201;the user
 interface downloaded from the website&#8201;&#8212;&#8201;requests a resource from another origin&#8201;&#8212;&#8201;the <code>/openapi</code> endpoint which
 Helidon&#8217;s OpenAPI built-in service automatically adds to your application.</p>

<p>Integrating CORS support into these built-in services allows such third-party web sites and their browser applications&#8201;&#8212;&#8201;or
more generally, apps from any other origin&#8201;&#8212;&#8201;to work with your Helidon application.</p>

<p>Because all three of these built-in Helidon services serve primarily <code>GET</code> endpoints, by default the
integrated CORS support in all three services permits
any origin to share their resources using <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> HTTP requests. You can customize the CORS set-up
for these built-in services independently from each other using
 configuration.
You can use this override feature to control the CORS behavior of the built-in services even if you do not add CORS behavior
to your own endpoints.</p>


<h4 id="_built_in_services_with_cors">Built-in Services with CORS</h4>
<div class="section">
<p>To use built-in services with CORS support and customize the
CORS behavior:</p>

<ol style="margin-left: 15px;">
<li>
Add the built-in service or services to your application.

</li>
<li>

<div><p>Add a dependency on the <code>io.helidon.webserver:helidon-webserver-cors</code> CORS artifact to your Maven <code>pom.xml</code> file.</p>

<div class="admonition note">
<p class="admonition-inline">If you want the built-in services to support CORS, then you need to add the CORS dependency even if your own endpoints do not use CORS.</p>
</div>
</div>

</li>
<li>
Use
configuration to set up the CORS behavior by path as needed.

</li>
</ol>

<p>The documentation for the individual built-in services describes how to add each
service to your application, including
adding a Maven dependency for the built-in feature.</p>

</div>


<h4 id="_configuring_cors_for_built_in_services">Configuring CORS for Built-in Services</h4>
<div class="section">
<p>Use configuration to control whether and how each of the built-in services works with CORS.</p>

<p>In the <code>cors</code> configuration section add a block for each built-in service using its path as described in the
CORS configuration section.</p>

<p>The following example restricts sharing of</p>

<ul class="ulist">
<li>
<p>the <code>/health</code> resource, provided by the health built-in service, to only the origin <code>http://there.com</code>, and</p>

</li>
<li>
<p>the <code>/metrics</code> resource, provided by the metrics built-in service, to only the origin <code>http://foo.com</code>.</p>

</li>
</ul>

<markup
lang="properties"
title="Configuration which restricts sharing of the health and metrics resources"
>cors.paths.0.path-pattern=/health
cors.paths.0.allow-origins=http://there.com
cors.paths.1.path-pattern=/metrics
cors.paths.1.allow-origins=http://foo.com</markup>

</div>


<h4 id="_accessing_the_shared_resources">Accessing the Shared Resources</h4>
<div class="section">
<p>If you have edited the Helidon MP QuickStart application as described in the previous topics and saved your changes,
you can build and run the application. Once you do so you can execute <code>curl</code> commands to demonstrate the behavior changes
in the metric and health services with the addition of the CORS functionality. Note the addition of the
<code>Origin</code> header value in the <code>curl</code> commands, and the <code>Access-Control-Allow-Origin</code> in the successful responses.</p>


<h5 id="_build_and_run_the_application">Build and Run the Application</h5>
<div class="section">
<p>Build and run the QuickStart application as usual.</p>

<markup
lang="bash"

>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<div class="listing">
<pre> ...
 2020.05.12 05:44:08 INFO io.helidon.microprofile.server.ServerCdiExtension Thread[main,5,main]: Server started on http://localhost:8080 (and all other host addresses) in 5280 milliseconds (since JVM startup).
 ...</pre>
</div>

</div>


<h5 id="_retrieve_metrics">Retrieve Metrics</h5>
<div class="section">
<p>The metrics service rejects attempts to access metrics on behalf of a disallowed origin.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://other.com" http://localhost:8080/metrics</markup>

<markup
lang="listing"

>HTTP/1.1 403 Forbidden
Date: Mon, 11 May 2020 11:08:09 -0500
transfer-encoding: chunked
connection: keep-alive</markup>

<p>But accesses from <code>foo.com</code> succeed.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://foo.com" http://localhost:8080/metrics</markup>

<markup
lang="listing"

>HTTP/1.1 200 OK
Access-Control-Allow-Origin: http://foo.com
Content-Type: text/plain
Date: Mon, 11 May 2020 11:08:16 -0500
Vary: Origin
connection: keep-alive
content-length: 6065

# TYPE base_classloader_loadedClasses_count gauge
# HELP base_classloader_loadedClasses_count Displays the number of classes that are currently loaded in the Java virtual machine.
base_classloader_loadedClasses_count 3568</markup>

</div>


<h5 id="_retrieve_health">Retrieve Health</h5>
<div class="section">
<p>The health service rejects requests from origins not specifically approved.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://foo.com" http://localhost:8080/health</markup>

<markup
lang="listing"

>HTTP/1.1 403 Forbidden
Date: Mon, 11 May 2020 12:06:55 -0500
transfer-encoding: chunked
connection: keep-alive</markup>

<p>And responds successfully only to cross-origin requests from <code>http://there.com</code>.</p>

<markup
lang="bash"

>curl -i -H "Origin: http://there.com" http://localhost:8080/health</markup>

<markup
lang="listing"

>HTTP/1.1 200 OK
Access-Control-Allow-Origin: http://there.com
Content-Type: application/json
Date: Mon, 11 May 2020 12:07:32 -0500
Vary: Origin
connection: keep-alive
content-length: 461

{"outcome":"UP",...}</markup>

</div>

</div>

</div>

</div>

</doc-view>
