<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Security (security) Configuration</dt>
<dd slot="desc"><p>Configuration of security providers, integration and other security options</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.security/io/helidon/security/Security.html">io.helidon.security.Security</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>security</code></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Required configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>providers</code></td>
<td class=""><doc-view>
<p>io.helidon.security.spi.SecurityProvider[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_security_providers_idcs_mapper_IdcsRoleMapperProvider">idcs-role-mapper (IdcsRoleMapperProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_httpauth_HttpBasicAuthProvider">http-basic-auth (HttpBasicAuthProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_idcs_mapper_IdcsMtRoleMapperProvider">idcs-role-mapper (IdcsMtRoleMapperProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_google_login_GoogleTokenProvider">google-login (GoogleTokenProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_oidc_OidcProvider">oidc (OidcProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_httpauth_HttpDigestAuthProvider">http-digest-auth (HttpDigestAuthProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_jwt_JwtProvider">jwt (JwtProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_header_HeaderAtnProvider">header-atn (HeaderAtnProvider)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_security_providers_abac_AbacProvider">abac (AbacProvider)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Add a provider, works as #addProvider(io.helidon.security.spi.SecurityProvider, String), where the name is set
 to <code>Class#getSimpleName()</code>.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>default-authentication-provider</code></td>
<td class=""><doc-view>
<p>string (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>ID of the default authentication provider</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>default-authorization-provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>ID of the default authorization provider</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Security can be disabled using configuration, or explicitly.
 By default, security instance is enabled.
 Disabled security instance will not perform any checks and allow
 all requests.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>environment.server-time</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_security_SecurityTime">SecurityTime</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Server time to use when evaluating security policies that depend on time.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>provider-policy.class-name</code></td>
<td class=""><doc-view>
<p>Class</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Provider selection policy class name, only used when type is set to CLASS</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>provider-policy.type</code></td>
<td class=""><doc-view>
<p>ProviderSelectionPolicyType (FIRST, COMPOSITE, CLASS)</p>

</doc-view>
</td>
<td class=""><code>FIRST</code></td>
<td class=""><doc-view>
<p>Type of the policy.</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secrets</code></td>
<td class=""><doc-view>
<p>Map&lt;string, string&gt; (documented for specific cases)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configured secrets</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secrets.*.config</code></td>
<td class=""><doc-view>
<p>io.helidon.security.SecretsProviderConfig (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration specific to the secret provider</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secrets.*.name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the secret, used for lookup</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secrets.*.provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name of the secret provider</p>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tracing.enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether or not tracing should be enabled. If set to false, security tracer will be a no-op tracer.</p>

</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
