<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_example" @click.native="this.scrollFix('#_example')">Example</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon integrates with <a target="_blank" href="https://projects.eclipse.org/projects/ee4j.tyrus">Tyrus</a> to provide support for the
<a target="_blank" href="https://jakarta.ee/specifications/websocket/2.1.0/websocket-spec-2.1.0.html">Jakarta WebSocket API</a>.
The WebSocket API enables Java applications to participate in WebSocket interactions
as both servers and clients. The server API supports two flavors: annotated and
programmatic endpoints.</p>

<p>Annotated endpoints, as suggested by their name, use Java annotations to provide
the necessary meta-data to define WebSocket handlers; programmatic endpoints
implement API interfaces and are annotation free. Annotated endpoints tend to be
more flexible since they allow different method signatures depending on the
application needs, whereas programmatic endpoints must implement an interface
and are, therefore, bounded to its definition.</p>

<p>Helidon SE support is based on the <code>WebSocketRouting</code> class which enables Helidon application to
configure routing for both annotated and programmatic WebSocket endpoints.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable {feature-name}
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-websocket&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_example">Example</h2>
<div class="section">
<p>This section describes the implementation of a simple application
that uses a REST resource to push messages into a shared queue and a
programmatic WebSocket endpoint to download messages from the queue,
one at a time, over a connection.
The example will show how REST and WebSocket connections can
be seamlessly combined into a Helidon application.</p>

<p>The complete Helidon SE example is available <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/webserver/websocket">here</a>. Let us start by
looking at <code>MessageQueueService</code>:</p>

<markup
lang="java"

>public class MessageQueueService implements HttpService {

    private final MessageQueue messageQueue = MessageQueue.instance();

    @Override
    public void routing(HttpRules routingRules) {
        routingRules.post("/board", this::handlePost);
    }

    private void handlePost(ServerRequest request, ServerResponse response) {
        messageQueue.push(request.content().as(String.class));
        response.status(204).send();
    }
}</markup>

<p>This class exposes a REST resource where messages can be posted. Upon
receiving a message, it simply pushes it into a shared queue and
returns 204 (No Content).</p>

<p>Messages pushed into the queue can be obtained by opening a WebSocket
connection served by <code>MessageBoardEndpoint</code>:</p>

<markup
lang="java"

>public class MessageBoardEndpoint implements WsListener {
    private final MessageQueue messageQueue = MessageQueue.instance();

    @Override
    public void onMessage(WsSession session, String text, boolean last) {
        // Send all messages in the queue
        if (text.equals("send")) {
            while (!messageQueue.isEmpty()) {
                session.send(messageQueue.pop(), last);
            }
        }
    }
}</markup>

<p>This is an example of a programmatic endpoint that extends <code>WsListener</code>. The method
<code>onMessage</code> will be invoked for every message. In this example, when the special <code>send</code> message
is received, it empties the shared queue sending messages one at a time over
the WebSocket connection.</p>

<p>In Helidon SE, REST and WebSocket classes need to be manually registered into
the web server. This is accomplished via a <code>Routing</code> builder:</p>

<markup
lang="java"

>StaticContentService staticContent = StaticContentService.builder("/WEB")
                                                 .welcomeFileName("index.html")
                                                 .build();
MessageQueueService messageQueueService = new MessageQueueService();
server.routing(routing -&gt; routing
               .register("/web", staticContent)
               .register("/rest", messageQueueService))
       .addRouting(WsRouting.builder()
                            .endpoint("/websocket/board", new MessageBoardEndpoint())
                            .build());</markup>

<p>This code snippet registers <code>MessageBoardEndpoint</code> at <code>"/websocket/board"</code> and associates.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webserver.websocket/module-summary.html">Helidon WebSocket JavaDoc</a></p>

</li>
</ul>

</div>

</doc-view>
