<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_channel" @click.native="this.scrollFix('#_channel')">Channel</router-link></p>

</li>
<li>
<p><router-link to="#_processor" @click.native="this.scrollFix('#_processor')">Processor</router-link></p>

</li>
<li>
<p><router-link to="#_message" @click.native="this.scrollFix('#_message')">Message</router-link></p>

</li>
<li>
<p><router-link to="#_connectors" @click.native="this.scrollFix('#_connectors')">Connectors</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_kafka_connector" @click.native="this.scrollFix('#_kafka_connector')">Kafka Connector</router-link></p>

</li>
<li>
<p><router-link to="#_jms_connector" @click.native="this.scrollFix('#_jms_connector')">JMS Connector</router-link></p>

</li>
<li>
<p><router-link to="#_aq_connector" @click.native="this.scrollFix('#_aq_connector')">AQ Connector</router-link></p>

</li>
</ul>

</li>
</ul>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Asynchronous messaging is a commonly used form of communication in the world of microservices.
While it is possible to start building your reactive streams directly by combining operators and
connecting them to reactive APIs, with Helidon SE Reactive Messaging, you can now use prepared
tools for repetitive use case scenarios .</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Reactive Messaging
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Connecting your streams to external services usually requires a lot of boiler-plate
code for configuration handling, backpressure propagation, acknowledgement and more.</p>

<p>In Helidon there is a system of connectors, emitters and means to orchestrate these tasks
called <strong>Reactive Messaging</strong>. It&#8217;s basically an API for connecting and configuring
connectors and emitters with your reactive streams through <router-link to="#_channel" @click.native="this.scrollFix('#_channel')">Channels</router-link>.</p>

<p>Reactive Messaging relates to
<router-link to="/mp/reactivemessaging/introduction">MicroProfile Reactive Messaging</router-link> as the making of connectors and configuring them can be a repetitive task that ultimately leads to
the same results. Helidon SE Reactive Messaging supports the very same configuration format
for connectors as its MicroProfile counterpart does. Also, MP Connectors are reusable in
Helidon SE Messaging with some limitations such as there is no CDI in Helidon SE.
All <router-link to="#_messaging_connector" @click.native="this.scrollFix('#_messaging_connector')">Messaging connectors</router-link> in Helidon are made to be universally usable by Helidon MP and SE.</p>


<h3 id="_channel">Channel</h3>
<div class="section">
<p>A channel is a named pair of <code>Publisher</code> and <code>Subscriber</code>. Channels can be connected together by
<router-link to="#_processor" @click.native="this.scrollFix('#_processor')">processors</router-link>. Registering a <code>Publisher</code> or <code>Subscriber</code> for a channel can be done
by Messaging API, or configured implicitly using registered <router-link to="#_connectors" @click.native="this.scrollFix('#_connectors')">connectors</router-link>
to generate the <code>Publisher</code> or <code>Subscriber</code>.</p>

<markup
lang="java"
title="Example of simple channel:"
>Channel&lt;String&gt; channel1 = Channel.create("channel1");

Messaging.builder()
        .publisher(channel1, Multi.just("message 1", "message 2")
                                  .map(Message::of))
        .listener(channel1, s -&gt; System.out.println("Intecepted message " + s))
        .build()
        .start();</markup>

</div>


<h3 id="_processor">Processor</h3>
<div class="section">
<p>Processor is a typical reactive processor acting as a <code>Subscriber</code> to upstream and as a <code>Publisher</code>
to downstream. In terms of reactive messaging, it is able to connect two <router-link to="#_channel" @click.native="this.scrollFix('#_channel')">channels</router-link> to one
reactive stream.</p>

<markup
lang="java"
title="Example of processor usage:"
>Channel&lt;String&gt; firstChannel = Channel.create("first-channel");
Channel&lt;String&gt; secondChannel = Channel.create("second-channel");

Messaging.builder()
        .publisher(secondChannel, ReactiveStreams.of("test1", "test2", "test3")
                .map(Message::of))
        .processor(secondChannel, firstChannel, ReactiveStreams.&lt;Message&lt;String&gt;&gt;builder()
                .map(Message::getPayload)
                .map(String::toUpperCase)
                .map(Message::of)
        )
        .subscriber(firstChannel, ReactiveStreams.&lt;Message&lt;String&gt;&gt;builder()
                .peek(Message::ack)
                .map(Message::getPayload)
                .forEach(s -&gt; System.out.println("Consuming message " + s)))
        .build()
        .start();

&gt;Consuming message TEST1
&gt;Consuming message TEST2
&gt;Consuming message TEST3</markup>

</div>


<h3 id="_message">Message</h3>
<div class="section">
<p>Reactive Messaging in Helidon SE uses the same concept of
message wrapping as MicroProfile messaging.
The only notable difference is that SE Messaging does almost no implicit or automatic
acknowledgement due to <em>no magic</em> philosophy of Helidon SE.</p>

<p>The only exception to this are the variants of the methods <code>Messaging.Builder#listener</code> and
<code>Messaging.Builder#processor</code> configured with consumer or function parameters which will  conveniently unwrap the payload
for you. Once the payload is automatically unwrapped, it is not possible to do a manual acknowledgement, therefore
an implicit acknowledgement is executed before the callback.</p>

</div>


<h3 id="_connectors">Connectors</h3>
<div class="section">
<p>Connectors are used to connect <router-link to="#_channel" @click.native="this.scrollFix('#_channel')">channels</router-link> to external sources.
To make the <router-link to="#_messaging_connector" @click.native="this.scrollFix('#_messaging_connector')">creation and usage of connectors</router-link>
as easy and versatile as possible, Helidon SE Messaging uses the same API for connectors
that <router-link to="/mp/reactivemessaging/introduction">MicroProfile Reactive Messaging</router-link> does.
This allows connectors to be used in both flavors of Helidon with one limitation which is
that the connector has to be able to work without CDI.</p>

<p>Examples of versatile connectors in Helidon include the following:</p>

<ul class="ulist">
<li>
<p><router-link to="#_kafka_connector" @click.native="this.scrollFix('#_kafka_connector')">Kafka connector</router-link></p>

</li>
<li>
<p><router-link to="#_jms_connector" @click.native="this.scrollFix('#_jms_connector')">JMS connector</router-link></p>

</li>
<li>
<p><router-link to="#_aq_connector" @click.native="this.scrollFix('#_aq_connector')">AQ Connector</router-link></p>

</li>
</ul>


<h4 id="_messaging_connector">Messaging Connector</h4>
<div class="section">
<p>A connector for Reactive Messaging is a factory that produces Publishers and Subscribers for
Channels in Reactive Messaging. Messaging connector is just an implementation of
<code>IncomingConnectorFactory</code>, <code>OutgoingConnectorFactory</code> or both.</p>

<markup
lang="java"
title="Example connector <code>example-connector</code>:"
>@Connector("example-connector")
public class ExampleConnector implements IncomingConnectorFactory, OutgoingConnectorFactory {

   @Override
   public PublisherBuilder&lt;? extends Message&lt;?&gt;&gt; getPublisherBuilder(Config config) {
       return ReactiveStreams.of("foo", "bar")
               .map(Message::of);
   }

   @Override
   public SubscriberBuilder&lt;? extends Message&lt;?&gt;, Void&gt; getSubscriberBuilder(Config config) {
       return ReactiveStreams.&lt;Message&lt;?&gt;&gt;builder()
               .map(Message::getPayload)
               .forEach(o -&gt; System.out.println("Connector says: " + o));
   }
}</markup>

<markup
lang="yaml"
title="Example of channel to connector mapping config:"
>mp.messaging.outgoing.to-connector-channel.connector: example-connector
mp.messaging.incoming.from-connector-channel.connector: example-connector</markup>

<markup
lang="java"
title="Example producing to connector:"
>Config config = Config.create();

Messaging.builder()
         .config(config)
         .connector(new ExampleConnector())
         .publisher(Channel.create("to-connector-channel"),
                ReactiveStreams.of("fee", "fie")
                    .map(Message::of)
         )
         .build()
         .start();

&gt; Connector says: fee
&gt; Connector says: fie</markup>

<markup
lang="java"
title="Example consuming from connector:"
>Messaging.builder()
        .connector(new ExampleConnector())
        .subscriber(Channel.create("from-connector-channel"),
                ReactiveStreams.&lt;Message&lt;String&gt;&gt;builder()
                    .peek(Message::ack)
                    .map(Message::getPayload)
                    .forEach(s -&gt; System.out.println("Consuming: " + s))
        )
        .build()
        .start();

&gt; Consuming: foo
&gt; Consuming: bar</markup>


<h5 id="_configuration_for_messaging_connector">Configuration for Messaging Connector</h5>
<div class="section">
<p>A messaging connector in Helidon SE can be configured explicitly by API or implicitly
by config following the notation of <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-1.0/microprofile-reactive-messaging-spec.html#_configuration">MicroProfile Reactive Messaging</a>.</p>

<p>Configuration that is supplied to connector by the Messaging implementation must include
two mandatory attributes:</p>

<ul class="ulist">
<li>
<p><code>channel-name</code> which is the name of the channel that has the connector configured as Publisher or Subscriber, or <code>Channel.create('name-of-channel')</code> in case of explicit configuration or <code>mp.messaging.incoming.name-of-channel.connector: connector-name</code> in case of implicit config</p>

</li>
<li>
<p><code>connector</code> name of the connector <code>@Connector("connector-name")</code></p>

</li>
</ul>

<markup
lang="java"
title="Example connector accessing configuration:"
>@Connector("example-connector")
public class ExampleConnector implements IncomingConnectorFactory {

    @Override
    public PublisherBuilder&lt;? extends Message&lt;?&gt;&gt; getPublisherBuilder(final Config config) {

        String firstPropValue = config.getValue("first-test-prop", String.class);<span class="conum" data-value="1" />
        String secondPropValue = config.getValue("second-test-prop", String.class);

        return ReactiveStreams.of(firstPropValue, secondPropValue)
                .map(Message::of);
    }
}</markup>

<ul class="colist">
<li data-value="1">Config context is merged from channel and connector contexts</li>
</ul>


<h6 id="_explicit_config_for_messaging_connector">Explicit Config for Messaging Connector</h6>
<div class="section">
<p>An explicit config for channel&#8217;s publisher is possible with <code>Channel.Builder#publisherConfig(Config config)</code>
and for a subscriber with the <code>Channel.Builder#subscriberConfig(Config config)</code>.
The supplied <router-link to="/se/config/introduction">Helidon Config</router-link> is merged with
the mandatory attributes and any implicit configuration found. The resulting configuration is then served to the Connector.</p>

<markup
lang="java"
title="Example consuming from Kafka connector with explicit config:"
>String kafkaServer = config.get("app.kafka.bootstrap.servers").asString().get();
String topic = config.get("app.kafka.topic").asString().get();

Channel&lt;String&gt; fromKafka = Channel.&lt;String&gt;builder()<span class="conum" data-value="1" /><span class="conum" data-value="2" />
        .name("from-kafka")
        .publisherConfig(KafkaConnector.configBuilder()
                .bootstrapServers(kafkaServer)
                .groupId("example-group-" + session.getId())
                .topic(topic)
                .autoOffsetReset(KafkaConfigBuilder.AutoOffsetReset.LATEST)
                .enableAutoCommit(true)
                .keyDeserializer(StringDeserializer.class)
                .valueDeserializer(StringDeserializer.class)
                .build()
        )
        .build();

KafkaConnector kafkaConnector = KafkaConnector.create();<span class="conum" data-value="3" />

Messaging messaging = Messaging.builder()
        .connector(kafkaConnector)
        .listener(fromKafka, payload -&gt; {
            System.out.println("Kafka says: " + payload);
        })
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare channel for connecting kafka connector with specific publisher configuration &#8594; listener,</li>
<li data-value="2">Channel &#8594; connector mapping is automatic when using <code>KafkaConnector.configBuilder()</code></li>
<li data-value="3">Prepare Kafka connector, can be used by any channel</li>
</ul>

</div>


<h6 id="_implicit_config_for_messaging_connector">Implicit Config for Messaging Connector</h6>
<div class="section">
<p>Implicit config without any hard-coding is possible with <router-link to="/se/config/introduction">Helidon Config</router-link> following notation of <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-1.0/microprofile-reactive-messaging-spec.html#_configuration">MicroProfile Reactive Messaging</a>.</p>

<markup
lang="yaml"
title="Example of channel to connector mapping config with custom properties:"
>mp.messaging.incoming.from-connector-channel.connector: example-connector<span class="conum" data-value="1" />
mp.messaging.incoming.from-connector-channel.first-test-prop: foo<span class="conum" data-value="2" />
mp.messaging.connector.example-connector.second-test-prop: bar<span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Channel &#8594; Connector mapping</li>
<li data-value="2">Channel configuration properties</li>
<li data-value="3">Connector configuration properties</li>
</ul>

<markup
lang="java"
title="Example consuming from connector:"
>Config config = Config.create();

Messaging.builder()
        .config(config)
        .connector(new ExampleConnector())
        .listener(Channel.create("from-connector-channel"),
                    s -&gt; System.out.println("Consuming: " + s))
        .build()
        .start();

&gt; Consuming: foo
&gt; Consuming: bar</markup>

</div>

</div>

</div>


<h4 id="_reusability_in_mp_messaging">Reusability in MP Messaging</h4>
<div class="section">
<p>As the API is the same for <router-link to="/mp/reactivemessaging/introduction">MicroProfile Reactive Messaging</router-link>
connectors, all that is needed to make connector work in both ways is annotating it with
<code>@ApplicationScoped</code>. Such connector is treated as a bean in Helidon MP.</p>

<p>For specific information about creating messaging connectors for Helidon MP visit
<router-link to="/mp/reactivemessaging/introduction">MicroProfile Reactive Messaging</router-link>.</p>

</div>


<h4 id="_kafka_connector">Kafka Connector</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.kafka&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-kafka&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h5 id="_reactive_kafka_connector">Reactive Kafka Connector</h5>
<div class="section">
<p>Connecting streams to Kafka with Reactive Messaging couldn&#8217;t be easier.</p>

</div>


<h5 id="_explicit_config_with_config_builder_for_kafka_connector">Explicit Config with Config Builder for Kafka Connector</h5>
<div class="section">
<markup
lang="java"
title="Example of consuming from Kafka:"
>String kafkaServer = config.get("app.kafka.bootstrap.servers").asString().get();
String topic = config.get("app.kafka.topic").asString().get();

Channel&lt;String&gt; fromKafka = Channel.&lt;String&gt;builder()<span class="conum" data-value="1" /><span class="conum" data-value="2" />
        .name("from-kafka")
        .publisherConfig(KafkaConnector.configBuilder()
                .bootstrapServers(kafkaServer)
                .groupId("example-group-" + session.getId())
                .topic(topic)
                .autoOffsetReset(KafkaConfigBuilder.AutoOffsetReset.LATEST)
                .enableAutoCommit(true)
                .keyDeserializer(StringDeserializer.class)
                .valueDeserializer(StringDeserializer.class)
                .build()
        )
        .build();

KafkaConnector kafkaConnector = KafkaConnector.create();<span class="conum" data-value="3" />

Messaging messaging = Messaging.builder()
        .connector(kafkaConnector)
        .listener(fromKafka, payload -&gt; {
            System.out.println("Kafka says: " + payload);
        })
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare a channel for connecting kafka connector with specific publisher configuration &#8594; listener</li>
<li data-value="2">Channel &#8594; connector mapping is automatic when using KafkaConnector.configBuilder()</li>
<li data-value="3">Prepare Kafka connector, can be used by any channel</li>
</ul>

<markup
lang="java"
title="Example of producing to Kafka:"
>String kafkaServer = config.get("app.kafka.bootstrap.servers").asString().get();
String topic = config.get("app.kafka.topic").asString().get();

Channel&lt;String&gt; toKafka = Channel.&lt;String&gt;builder()<span class="conum" data-value="1" /><span class="conum" data-value="2" />
        .subscriberConfig(KafkaConnector.configBuilder()
                .bootstrapServers(kafkaServer)
                .topic(topic)
                .keySerializer(StringSerializer.class)
                .valueSerializer(StringSerializer.class)
                .build()
        ).build();

KafkaConnector kafkaConnector = KafkaConnector.create();<span class="conum" data-value="3" />

messaging = Messaging.builder()
        .publisher(toKafka, Multi.just("test1", "test2").map(Message::of))
        .connector(kafkaConnector)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare a channel for connecting kafka connector with specific publisher configuration &#8594; listener</li>
<li data-value="2">Channel &#8594; connector mapping is automatic when using KafkaConnector.configBuilder()</li>
<li data-value="3">Prepare Kafka connector, can be used by any channel</li>
</ul>

</div>


<h5 id="_implicit_helidon_config_for_kafka_connector">Implicit Helidon Config for Kafka Connector</h5>
<div class="section">
<markup
lang="yaml"
title="Example of connector config:"
>mp.messaging:

  incoming.from-kafka:
    connector: helidon-kafka
    topic: messaging-test-topic-1
    auto.offset.reset: latest <span class="conum" data-value="1" />
    enable.auto.commit: true
    group.id: example-group-id

  outgoing.to-kafka:
    connector: helidon-kafka
    topic: messaging-test-topic-1

  connector:
    helidon-kafka:
      bootstrap.servers: localhost:9092 <span class="conum" data-value="2" />
      key.serializer: org.apache.kafka.common.serialization.StringSerializer
      value.serializer: org.apache.kafka.common.serialization.StringSerializer
      key.deserializer: org.apache.kafka.common.serialization.StringDeserializer
      value.deserializer: org.apache.kafka.common.serialization.StringDeserializer</markup>

<ul class="colist">
<li data-value="1">Kafka client consumer&#8217;s property auto.offset.reset configuration for <code>from-kafka</code> channel only</li>
<li data-value="2">Kafka client&#8217;s property <a target="_blank" href="https://kafka.apache.org/28/documentation.html#consumerconfigs_bootstrap.servers">bootstrap.servers</a> configuration for all channels using the connector</li>
</ul>

<markup
lang="java"
title="Example of consuming from Kafka:"
>Config config = Config.create();

Channel&lt;String&gt; fromKafka = Channel.create("from-kafka");

KafkaConnector kafkaConnector = KafkaConnector.create();<span class="conum" data-value="1" />

Messaging messaging = Messaging.builder()
        .config(config)
        .connector(kafkaConnector)
        .listener(fromKafka, payload -&gt; {
            System.out.println("Kafka says: " + payload);
        })
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare Kafka connector, can be used by any channel</li>
</ul>

<markup
lang="java"
title="Example of producing to Kafka:"
>Config config = Config.create();

Channel&lt;String&gt; toKafka = Channel.create("to-kafka");

KafkaConnector kafkaConnector = KafkaConnector.create();<span class="conum" data-value="1" />

messaging = Messaging.builder()
        .config(config)
        .publisher(toKafka, Multi.just("test1", "test2").map(Message::of))
        .connector(kafkaConnector)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare Kafka connector, can be used by any channel</li>
</ul>

<p>Don&#8217;t forget to check out the examples with pre-configured Kafka docker image, for easy testing:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/messaging" class="bare">https://github.com/oracle/helidon/tree/master/examples/messaging</a></p>

</li>
</ul>

</div>

</div>


<h4 id="_jms_connector">JMS Connector</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.jms&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-jms&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h5 id="_reactive_jms_connector">Reactive JMS Connector</h5>
<div class="section">
<p>Connecting streams to JMS with Reactive Messaging couldn&#8217;t be easier.</p>

</div>


<h5 id="_explicit_config_with_config_builder_for_jms_connector">Explicit Config with Config Builder for JMS Connector</h5>
<div class="section">
<markup
lang="java"
title="Example of consuming from JMS:"
>Channel&lt;String&gt; fromJms = Channel.&lt;String&gt;builder()<span class="conum" data-value="1" /><span class="conum" data-value="2" />
        .name("from-jms")
        .publisherConfig(JmsConnector.configBuilder()
                .jndiInitialFactory(ActiveMQInitialContextFactory.class)
                .jndiProviderUrl("tcp://127.0.0.1:61616")
                .type(JmsConfigBuilder.Type.QUEUE)
                .destination("se-example-queue-1")
                .build()
        )
        .build();

JmsConnector jmsConnector = JmsConnector.create();<span class="conum" data-value="3" />

Messaging messaging = Messaging.builder()
        .connector(jmsConnector)
        .listener(fromJms, payload -&gt; {
            System.out.println("Jms says: " + payload);
        })
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare a channel for connecting jms connector with specific publisher configuration &#8594; listener</li>
<li data-value="2">Channel &#8594; connector mapping is automatic when using JmsConnector.configBuilder()</li>
<li data-value="3">Prepare JMS connector, can be used by any channel</li>
</ul>

<markup
lang="java"
title="Example of producing to JMS:"
>Channel&lt;String&gt; toJms = Channel.&lt;String&gt;builder()<span class="conum" data-value="1" /><span class="conum" data-value="2" />
        .subscriberConfig(JmsConnector.configBuilder()
                .jndiInitialFactory(ActiveMQInitialContextFactory.class)
                .jndiProviderUrl("tcp://127.0.0.1:61616")
                .type(JmsConfigBuilder.Type.QUEUE)
                .destination("se-example-queue-1")
                .build()
        ).build();

JmsConnector jmsConnector = JmsConnector.create();<span class="conum" data-value="3" />

messaging = Messaging.builder()
        .publisher(toJms, Multi.just("test1", "test2").map(Message::of))
        .connector(jmsConnector)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare a channel for connecting jms connector with specific publisher configuration &#8594; listener</li>
<li data-value="2">Channel &#8594; connector mapping is automatic when using JmsConnector.configBuilder()</li>
<li data-value="3">Prepare JMS connector, can be used by any channel</li>
</ul>

</div>


<h5 id="_implicit_helidon_config_for_jms_connector">Implicit Helidon Config for JMS Connector</h5>
<div class="section">
<markup
lang="yaml"
title="Example of connector config:"
>mp.messaging:

  incoming.from-jms:
    connector: helidon-jms
    destination: se-example-queue-1
    session-group-id: session-group-1
    type: queue

  outgoing.to-jms:
    connector: helidon-jms
      destination: se-example-queue-1
      type: queue

  connector:
    helidon-jms:
      jndi:
        jms-factory: ConnectionFactory
        env-properties:
          java.naming.factory.initial: org.apache.activemq.jndi.ActiveMQInitialContextFactory
          java.naming.provider.url: tcp://127.0.0.1:61616</markup>

<markup
lang="java"
title="Example of consuming from JMS:"
>Config config = Config.create();

Channel&lt;String&gt; fromJms = Channel.create("from-jms");

JmsConnector jmsConnector = JmsConnector.create();<span class="conum" data-value="1" />

Messaging messaging = Messaging.builder()
        .config(config)
        .connector(jmsConnector)
        .listener(fromJms, payload -&gt; {
            System.out.println("Jms says: " + payload);
        })
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare JMS connector, can be used by any channel</li>
</ul>

<markup
lang="java"
title="Example of producing to JMS:"
>Config config = Config.create();

Channel&lt;String&gt; toJms = Channel.create("to-jms");

JmsConnector jmsConnector = JmsConnector.create();<span class="conum" data-value="1" />

messaging = Messaging.builder()
        .config(config)
        .publisher(toJms, Multi.just("test1", "test2").map(Message::of))
        .connector(jmsConnector)
        .build()
        .start();</markup>

<ul class="colist">
<li data-value="1">Prepare JMS connector, can be used by any channel</li>
</ul>

<p>Don&#8217;t forget to check out the examples with pre-configured ActiveMQ docker image, for easy testing:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/master/examples/messaging" class="bare">https://github.com/oracle/helidon/tree/master/examples/messaging</a></p>

</li>
</ul>

</div>

</div>


<h4 id="_aq_connector">AQ Connector</h4>
<div class="section">
<markup
lang="xml"
title="Maven dependency"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.messaging.aq&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-messaging-aq&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h5 id="_reactive_oracle_aq_connector">Reactive Oracle AQ Connector</h5>
<div class="section">

</div>


<h5 id="_sending_and_receiving">Sending and Receiving</h5>
<div class="section">
<markup
lang="java"
title="Example of producing to and consuming from Oracle AQ:"
>PoolDataSource pds = PoolDataSourceFactory.getPoolDataSource();<span class="conum" data-value="1" />
pds.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
pds.setURL("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(Host=192.168.0.123)(Port=1521))(CONNECT_DATA=(SID=XE)))");
pds.setUser("frank");
pds.setPassword("frank");

AqConnector seConn = AqConnector.builder()<span class="conum" data-value="2" />
    .dataSource("test-ds", pds)
    .build();

Channel&lt;String&gt; toAq = Channel.&lt;String&gt;builder()<span class="conum" data-value="3" />
    .name("toAq")
    .subscriberConfig(AqConnector.configBuilder()
        .queue("example_queue_1")
        .dataSource("test-ds")
        .build())
    .build();

Channel&lt;String&gt; fromAq = Channel.&lt;String&gt;builder()<span class="conum" data-value="4" />
    .name("fromAq")
    .publisherConfig(AqConnector.configBuilder()
        .queue("example_queue_1")
        .dataSource("test-ds")
        .build())
    .build();

Messaging.builder()<span class="conum" data-value="5" />
    .connector(seConn)
    .publisher(toAq, Multi.just("Hello", "world", "from", "Oracle", "DB!").map(Message::of))<span class="conum" data-value="6" />
    .listener(fromAq, s -&gt; System.out.pritln("Message received: "+s))<span class="conum" data-value="7" />
    .build()
    .start();</markup>

<ul class="colist">
<li data-value="1">Prepare Oracle UCP</li>
<li data-value="2">Setup AQ connector and provide datasource with an identifier <code>test-ds</code></li>
<li data-value="3">Setup channel for sending messages to queue <code>example_queue_1</code> with datasource <code>test-ds</code></li>
<li data-value="4">Setup channel for receiving messages from queue <code>example_queue_1</code> with datasource <code>test-ds</code></li>
<li data-value="5">Register connector and channels</li>
<li data-value="6">Add a publisher for several test messages to publish them to <code>example_queue_1</code> immediately</li>
<li data-value="7">Subscribe callback for any message coming from <code>example_queue_1</code></li>
</ul>

</div>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_configuration_for_messaging_connector" @click.native="this.scrollFix('#_configuration_for_messaging_connector')">Configuration for Messaging Connector</router-link></p>

</li>
<li>
<p><router-link to="#_explicit_config_with_config_builder_for_kafka_connector" @click.native="this.scrollFix('#_explicit_config_with_config_builder_for_kafka_connector')">Explicit Configuration with Config Builder for Kafka Connector</router-link></p>

</li>
<li>
<p><router-link to="#_implicit_helidon_config_for_kafka_connector" @click.native="this.scrollFix('#_implicit_helidon_config_for_kafka_connector')">Implicit Helidon Configuration for Kafka Connector</router-link></p>

</li>
<li>
<p><router-link to="#_explicit_config_with_config_builder_for_jms_connector" @click.native="this.scrollFix('#_explicit_config_with_config_builder_for_jms_connector')">Explicit Configuration with Config Builder for JMS Connector</router-link></p>

</li>
<li>
<p><router-link to="#_implicit_helidon_config_for_jms_connector" @click.native="this.scrollFix('#_implicit_helidon_config_for_jms_connector')">Implicit Helidon Configuration for JMS Connector</router-link></p>

</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0/microprofile-reactive-messaging-spec-3.0.html">MicroProfile Reactive Messaging Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-reactive-messaging">MicroProfile Reactive Messaging on GitHub</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/messaging">Helidon Messaging Examples</a></p>

</li>
</ul>

</div>

</doc-view>
