<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>A meter typically reflects the usage of a <em>single</em> point in your service which processes <em>multiple</em> requests over time.
A value such as the total time consumed by a given REST endpoint which can be invoked multiple times underscores the aggregate nature of meter values; Helidon accumulates the time from all requests in the total duration.</p>

<p>Tracing, on the other hand, captures the usage of <em>multiple</em> parts of your code as your service responds to a <em>single</em> request.</p>

<p>Metrics and tracing come together in Helidon&#8217;s support for exemplars.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p><a target="_blank" href="https://www.merriam-webster.com/dictionary/exemplar"><em>exemplar</em></a> - one that serves as a model or example</p>

<p>&#8201;&#8212;&#8201;Merriam-Webster Dictionary</p>
</p>
</div>

<p>In the context of metrics, an <em>exemplar</em> for a given meter is a specific sample which, in some sense, made a typical contribution to the meter&#8217;s value. For example, an exemplar for a <code>Counter</code> might be the most recent sample which updated the counter. The metrics output identifies the exemplar sample using the span and trace IDs of the span and trace which triggered that sample.</p>

<p>Exemplar support in Helidon relies on the exemplar support provided by the underlying metrics implementation. Currently, Helidon&#8217;s Micrometer implementation supports exemplars as recorded by Micrometer&#8217;s Prometheus meter registry and exposed by the OpenMetrics output (media type <code>application/openmetrics-text</code>).</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable OpenMetrics exemplar support
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-trace-exemplar&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Also, include the Helidon integration module for a tracing implementation (such as
<router-link :to="{path: '/se/tracing', hash: '#zipkin-tracing'}">Helidon Zipkin</router-link>)</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Add the Helidon tracing component itself:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;    <span class="conum" data-value="1" />
&lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
    &lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon tracing dependency.</li>
<li data-value="2">Observability dependencies for tracing.</li>
</ul>

<p>For further processing of the tracing data, different providers are used.</p>

<p>For Jaeger:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For Zipkin:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For OpenTelemetry:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-opentelemetry&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>For OpenTracing:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-providers-opentracing&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Once you add the appropriate dependencies to your project, exemplar support runs automatically as part of the Helidon metrics implementation using Micrometer. You do not need to change your application or configuration.</p>


<h3 id="_interpreting_exemplars">Interpreting Exemplars</h3>
<div class="section">
<p>Each exemplar reflects a sample described by a label, a value, and a timestamp.
When a client accesses the <code>/observe/metrics</code> endpoint and specifies that it accepts the <code>application/openmetrics-text</code> media type, the label, value, and timestamp appear in the OpenMetrics response for meters that support exemplars.</p>

<p>The exemplar information in the output describes a single, actual sample that is representative of the statistical value as recorded by the underlying Micrometer Prometheus meter registry.</p>

</div>


<h3 id="_output_format">Output Format</h3>
<div class="section">
<p>In the OpenMetrics output, an exemplar actually appears as a comment appended to the normal OpenMetrics output.</p>

<markup

title="OpenMetrics format with exemplars"
><em>meter-identifier</em> <em>meter-value</em> # <em>exemplar-label</em> <em>sample-timestamp</em></markup>

<p>Even downstream consumers of OpenMetrics output that do not recognize the exemplar format should continue to work correctly (as long as they <em>do</em> recognize comments).</p>

<p>But some consumers, such as trace collectors and their UIs, understand the exemplar format, and they allow you to browse meters and then navigate directly to the trace for the meter&#8217;s exemplar.</p>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon includes an <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/metrics/exemplar">example application</a>, based on the QuickStart application, which illustrates exemplar support.</p>

<p>Once you enable exemplar support you can see the exemplars in the metrics output.</p>

<div class="listing">
<pre># TYPE counterForPersonalizedGreetings counter
# HELP counterForPersonalizedGreetings
counterForPersonalizedGreetings_total{scope="application"} 4.0 # {span_id="6b1fc9f9fd42fb0c",trace_id="6b1fc9f9fd42fb0c"} 1.0 1696889651.779</pre>
</div>

<p>The exemplar (the portion following the <code>#</code>) is a sample corresponding to an update to the counter, showing the span and trace identifiers, the amount by which the counter was updated (<code>1.0</code>), and the timestamp recording when the update occurred expressed as seconds in the UNIX epoch (<code>1696889651.779</code>).</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Brief discussion of <a target="_blank" href="https://github.com/OpenObservability/OpenMetrics/blob/main/specification/OpenMetrics.md#exemplars">exemplars in the OpenMetrics spec</a></p>

</div>

</doc-view>
