<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE 4.x Upgrade Guide</dt>
<dd slot="desc"><p>In Helidon 4.x we have made some major changes to Helidon. Reactive engine has been removed. APIS and implementations are rewritten in "blocking" paradigm. This guide will help you upgrade a Helidon MP 3.x application to 4.x.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_java_21_runtime">Java 21 Runtime</h2>
<div class="section">
<p>Java 17 is no longer supported in Helidon 4. Java 21 or newer is required. Please follow the instructions in <router-link to="/about/prerequisites">Prerequisites</router-link> for proper installation.</p>

<p>Helidon 4 no longer uses Netty. Helidon SE is now running on Helidon WebServer which is based on virtual threads technology, available in Java 21.</p>

</div>


<h2 id="_programming_paradigm">Programming paradigm</h2>
<div class="section">
<p>Helidon SE has changed from an asynchronous style API to an imperative/blocking style API that is optimized for use with virtual threads. Currently, there is no compatibility API available</p>

</div>


<h2 id="_server_initialization_and_start_up">Server Initialization and Start Up</h2>
<div class="section">
<p>In Helidon 1.x-3.x you started a server like this:</p>

<markup
lang="java"
title="Start Helidon SE 3.x Server"
>static Single&lt;WebServer&gt; startServer() {

    Config config = Config.create();

    WebServer server = WebServer.builder(createRouting(config))
            .config(config.get("server"))
            .addMediaSupport(JsonpSupport.create())
            .build();

    Single&lt;WebServer&gt; webserver = server.start();   <span class="conum" data-value="1" />

    webserver.thenAccept(ws -&gt; {    <span class="conum" data-value="2" />
                System.out.println("WEB server is up! http://localhost:" + ws.port() + "/greet");
                ws.whenShutdown().thenRun(() -&gt; System.out.println("WEB server is DOWN. Good bye!"));
            })
            .exceptionallyAccept(t -&gt; { <span class="conum" data-value="3" />
                System.err.println("Startup failed: " + t.getMessage());
                t.printStackTrace(System.err);
            });

    return webserver;
}</markup>

<ul class="colist">
<li data-value="1">Server is started in an asynchronous way. A <code>Single</code> object is returned.</li>
<li data-value="2">Wait for the Server to start and print the message in an asynchronous way.</li>
<li data-value="3">Gracefully handle exceptions if they occur during the initialization process.</li>
</ul>

<p>Since Helidon SE in 3.x was reactive, during the start a <code>Single</code> object is returned, the server has been started in asynchronous way. We have to use reactive methods like <code>thenAccept</code> to wait for the server to start and then to perform the desired action. The exception handling should also be done in reactive way using the corresponding method.</p>

<p>In Helidon 4.x asynchronous programming is no longer required so the server startup is much simpler:</p>

<markup
lang="java"
title="Start Helidon SE 4.x Server"
>public static void main(String[] args) {

    Config config = Config.create();
    Config.global(config);

    WebServer server = WebServer.builder()  <span class="conum" data-value="1" />
            .config(config.get("server"))
            .routing(Main::routing)
            .build()
            .start();   <span class="conum" data-value="2" />

    System.out.println("WEB server is up! http://localhost:" + server.port() + "/greet");   <span class="conum" data-value="3" />
}</markup>

<ul class="colist">
<li data-value="1">Configure the Server.</li>
<li data-value="2">Start the Server. No reactive objects returned.</li>
<li data-value="3">Print a message when the Server is started.</li>
</ul>

<p>Just create it, configure it, and wait for it to start. If any exceptions happen, they are handled the traditional way using available language constructions.</p>

</div>


<h2 id="_server_features_and_media_support_discovery">Server Features and Media Support Discovery</h2>
<div class="section">
<p>In previous versions of Helidon you had to explicitly register WebServer features (<code>register(MetricsSupport.create())</code>) and
explicitly add media support (<code>addMediaSupport(JsonpSupport.create())</code>). In Helidon 4 the default behavior is
to automatically discover these components from the classpath. So all you need to do is add the
dependencies to your pom.xml and optionally add configuration to customize them.</p>

<p>If you want full control using the API, you still have that option.</p>

<p>For more information see:</p>

<ul class="ulist">
<li>
<p><router-link to="/se/observability">Observability feature support</router-link></p>

</li>
<li>
<p><router-link :to="{path: '/se/webserver', hash: '#_media_types_support'}">Media types support</router-link></p>

</li>
</ul>

</div>


<h2 id="_routing_configuration">Routing Configuration</h2>
<div class="section">
<p>In Helidon 1.x-3.x the routing config was done the following way:</p>

<markup
lang="java"
title="Routing in Helidon SE 3.x Server"
>private static Routing createRouting(Config config) {

    MetricsSupport metrics = MetricsSupport.create();   <span class="conum" data-value="1" />
    HealthSupport health = HealthSupport.builder()
            .addLiveness(HealthChecks.healthChecks())
            .build();

    GreetService greetService = new GreetService(config);   <span class="conum" data-value="2" />

    return Routing.builder()
            .register(health)   <span class="conum" data-value="3" />
            .register(metrics)
            .register("/greet", greetService)   <span class="conum" data-value="4" />
            .build();
}</markup>

<ul class="colist">
<li data-value="1">Create and configure <code>Metrics</code> and <code>Heath</code> support.</li>
<li data-value="2">Create a regular Helidon Service.</li>
<li data-value="3">Register <code>Metrics</code> and <code>Heath</code> support as Helidon Services.</li>
<li data-value="4">Register the regular Greeting service.</li>
</ul>

<p>Services are created and assigned to the desired path. Observability and other features are being created as usual Helidon <code>services</code>, available as part of the framework. User-defined services are also registered the same way.</p>

<p>In Helidon 4, the routing is configured the following way:</p>

<markup
lang="java"
title="Start Helidon SE 4.x Server"
>static void routing(HttpRouting.Builder routing) {
    routing.register("/greet", new GreetService());  <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">Register Greeting service as in previous versions of Helidon.</li>
</ul>

<p>As described previously, the Metrics and Health features will be discovered automatically as long as you have
added the dependencies for them to your project.</p>

<p>If you wanteded to add these features to the server programatically you would do so using <code>WebServer.builder().addFeature()</code> method.</p>

<p><code>Feature</code> encapsulates a set of endpoints, services and/or filters. It is similar to <code>HttpService</code> but gives more freedom in setup. Main difference is that a feature can add <code>Filters</code> and it cannot be registered on a path. Features are not registered immediately—each feature can define a <code>Weight</code> or implement <code>Weighted</code> to order features according to their weight. Higher-weighted features are registered first. This is to allow ordering of features in a meaningful way (e.g. Context should be first, Tracing second, Security third etc.).</p>

</div>


<h2 id="_services">Services</h2>
<div class="section">
<p>There are also significant changes in Helidon <code>Service</code>.</p>

<p>In prior versions, a service looks this way:</p>

<markup
lang="java"
title="Helidon SE 3.x Service"
>public class GreetService implements Service {

    @Override
    public void update(Routing.Rules rules) {   <span class="conum" data-value="1" />
        rules
            .get("/", this::getDefaultMessageHandler)
            .get("/{name}", this::getMessageHandler)
            .put("/greeting", this::updateGreetingHandler);
    }

    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {   <span class="conum" data-value="2" />
        sendResponse(response, "World");
    }

    // other methods omitted
}</markup>

<ul class="colist">
<li data-value="1">Use <code>update()</code> method to set up routing.</li>
<li data-value="2">Handle a <code>Request</code> and return a <code>Responce</code>.</li>
</ul>

<p>In Helidon 4, the same service:</p>

<markup
lang="java"
title="Helidon SE 4.x Service"
>public class GreetService implements HttpService {  <span class="conum" data-value="1" />

    @Override
    public void routing(HttpRules rules) {  <span class="conum" data-value="2" />
        rules.get("/", this::getDefaultMessageHandler)
             .get("/{name}", this::getMessageHandler)
             .put("/greeting", this::updateGreetingHandler);
    }


    private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) { <span class="conum" data-value="3" />
        sendResponse(response, "World");
    }

    // other methods omitted
}</markup>

<ul class="colist">
<li data-value="1">Implement <code>HttpService</code> for the <code>GreetingService</code>.</li>
<li data-value="2">Use <code>routing(HttpRules rules)</code> to set up routing.</li>
<li data-value="3">Handle a <code>Request</code> and return a <code>Responce</code>.</li>
</ul>

<p>Helidon 4 introduced <code>HttpService</code> that should be implemented in order to process HTTP requests. To set up routing, the method <code>routing(HttpRules rules)</code> should now be used. It receives <code>HttpRules</code> object with routes description.</p>

<p><code>ServerRequest</code> and <code>ServerResponse</code> are now in the <code>io.helidon.webserver.http</code> package;</p>

<p><code>Http.Status</code> is now <code>io.helidon.http.Status</code></p>

<div class="admonition warning">
<p class="admonition-inline">These changes make Helidon 4 incompatible with previous versions.</p>
</div>

<p>Learn more about <code>HttpService</code> and <code>Routing</code> at <router-link to="/se/webserver">Helidon SE WebServer</router-link></p>


<h3 id="_other_significant_changes">Other Significant Changes</h3>
<div class="section">

<h4 id="_media_support">Media Support</h4>
<div class="section">
<p>Media support has moved from the <code>io.helidon.media</code> Java package to <code>io.helidon.http.media</code> and has new dependency coordinates. For example:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>In Helidon 4 media support is discovered by default, so you simple need to add the dependency.
You no longer need to explicitly add media support using the <code>WebServer</code> builder.</p>

<p>Media support no long transitively brings the Jakarta API dependencies. So you might need to add these explicitly. For example:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;jakarta.json&lt;/groupId&gt;
    &lt;artifactId&gt;jakarta.json-api&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_testing">Testing</h4>
<div class="section">
<p>There is a new testing framework for Helidon SE.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.testing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-testing-junit5&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Find more information, see <router-link to="/se/introduction">Helidon SE testing</router-link></p>

</div>


<h4 id="_observability">Observability</h4>
<div class="section">
<p>Observability features of Helidon have now moved to different package. For <code>Health</code> and <code>Metrics</code> please use:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-health&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Observability has new endpoints. See them <router-link to="/se/observability">here</router-link>.</p>

<p>For System Metrics, please use:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-system-meters&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>By default Observability features are discovered automatically if you add the above dependencies.
If you choose to add them programmatically (using <code>addFeature</code>) you will need to add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Metrics has changed significantly in Helidon 4. See <router-link to="/se/metrics/metrics">Helidon SE Metrics</router-link> for more information.</p>

</div>


<h4 id="_security">Security</h4>
<div class="section">
<ul class="ulist">
<li>
<p>Changed modules:</p>
<ul class="ulist">
<li>
<p><code>helidon-security-integration-jersey</code> moved to the module <code>helidon-microprofile-security</code></p>

</li>
<li>
<p><code>helidon-security-integration-jersey-client</code> moved to the module <code>helidon-microprofile-security</code></p>

</li>
<li>
<p><code>helidon-security-integration-grpc</code> was removed</p>

</li>
<li>
<p><code>helidon-security-integration-webserver</code> moved to the module <code>helidon-webserver-security</code></p>

</li>
</ul>

</li>
<li>
<p>Significant class name changes:</p>
<ul class="ulist">
<li>
<p><code>OidcSupport</code> renamed to <code>OidcFeature</code></p>

</li>
<li>
<p><code>WebSecurity</code> renamed to <code>SecurityFeature</code></p>

</li>
</ul>

</li>
<li>
<p>Other:</p>
<ul class="ulist">
<li>
<p><code>SynchronousProvider removed</code> - <code>SynchronousProvider</code> usage is no longer needed, since all security providers are synchronous.</p>

</li>
</ul>

</li>
</ul>

</div>

</div>


<h3 id="_global_configuration">Global Configuration</h3>
<div class="section">
<p>The global configuration represents a single instance of the <code>Config</code> class, which is implicitly employed by certain Helidon components. Furthermore, it offers a handy approach for your application to access configuration information from any part of your code.</p>

<p>It is recommended that you explicitly initialize global configuration before using any Helidon components:</p>

<markup


>Config config = Config.create();  // Uses default config sources
Config.global(config);</markup>

<p>You can then utilize the global configuration for easy retrieval of your application&#8217;s configuration:</p>

<markup


>Config config = Config.global();</markup>

<p>More information at <router-link to="/se/config/introduction">Helidon SE Config</router-link>.</p>

</div>


<h3 id="_logging">Logging</h3>
<div class="section">
<p>The class <code>LogConfig</code> has moved to the <code>io.helidon.logging.common</code> Java package.</p>

<p>The Helidon console handler has changed from <code>io.helidon.common.HelidonConsoleHandler</code> to <code>io.helidon.logging.jul.HelidonConsoleHandler</code>.</p>

<p>If you use this handler in your <code>logging.properties</code> you will need to update it and add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.logging&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-logging-jul&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_conclusion">Conclusion</h2>
<div class="section">
<p>Please proceed to <router-link to="/se/introduction">Helidon SE Introduction</router-link> to find more information and documentation about each module.</p>

<p>Also, the
<a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/">Helidon examples</a> are a good resource for seeing how things are done in Helidon 4.</p>

</div>

</doc-view>
