<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE Tracing Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using tracing with a Helidon SE application.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 30 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>

</div>


<h2 id="_introduction">Introduction</h2>
<div class="section">
<p>Distributed tracing is a critical feature of microservice-based applications, since it traces workflow both
within a service and across multiple services.  This provides insight to sequence and timing data for specific blocks of work,
which helps you identify performance and operational issues. Helidon includes support for distributed tracing through its own API, backed by either
through the <a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a>, or by
<a target="_blank" href="https://opentracing.io">OpenTracing API</a>.</p>


<h3 id="_tracing_concepts">Tracing Concepts</h3>
<div class="section">
<p>This section explains a few concepts that you need to understand before you get started with tracing.
In the context of this document, a service is synonymous with an application.
A <em>span</em> is the basic unit of work done within a single service, on a single host.
Every span has a name, starting timestamp, and duration.  For example, the work done by a REST endpoint is a span.
A span is associated to a single service, but its descendants can belong to different services and hosts.
A <em>trace</em> contains a collection of spans from one or more services, running on one or more hosts. For example,
if you trace a service endpoint that calls another service, then the trace would contain spans from both services.
Within a trace, spans are organized as a directed acyclic graph (DAG) and
can belong to multiple services, running on multiple hosts.
Spans are automatically created by Helidon as needed during execution of the REST request.</p>

</div>

</div>


<h2 id="_getting_started_with_tracing">Getting Started with Tracing</h2>
<div class="section">
<p>The examples in this guide demonstrate how to integrate tracing with Helidon, how to view traces, how to trace
across multiple services, and how to integrate with tracing with Kubernetes. All examples use Jaeger and traces
will be viewed using the Jaeger UI.</p>


<h3 id="_create_a_sample_helidon_se_project">Create a Sample Helidon SE Project</h3>
<div class="section">
<p>Use the Helidon SE Maven archetype to create a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.2 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<markup
lang="bash"
title="The project will be built and run from the <code>helidon-quickstart-se</code> directory:"
>cd helidon-quickstart-se</markup>

</div>


<h3 id="_set_up_jaeger">Set up Jaeger</h3>
<div class="section">
<p>First, you need to run the Jaeger tracer.  Helidon will communicate with this tracer at runtime.</p>

<markup
lang="bash"
title="Run Jaeger within a docker container, then check the Jaeger server working:"
>docker run -d --name jaeger \                  <span class="conum" data-value="1" />
  -e COLLECTOR_OTLP_ENABLED=true \
  -p 6831:6831/udp \
  -p 6832:6832/udp \
  -p 5778:5778 \
  -p 16686:16686 \
  -p 4317:4317 \
  -p 4318:4318 \
  -p 14250:14250 \
  -p 14268:14268 \
  -p 14269:14269 \
  -p 9411:9411 \
  jaegertracing/all-in-one:1.50</markup>

<ul class="colist">
<li data-value="1">Run the Jaeger docker image.</li>
</ul>

</div>


<h3 id="_enable_tracing_in_the_helidon_application">Enable Tracing in the Helidon Application</h3>
<div class="section">
<p>Update the pom.xml file and add the following Jaeger dependency to the <code>&lt;dependencies&gt;</code>
section (<strong>not</strong> <code>&lt;dependencyManagement&gt;</code>). This will enable Helidon to use Jaeger at the
default host and port, <code>localhost:14250</code>.</p>

<markup
lang="xml"
title="Add the following dependencies to <code>pom.xml</code>:"
> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;   <span class="conum" data-value="1" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;  <span class="conum" data-value="3" />
 &lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon Tracing dependencies.</li>
<li data-value="2">Observability features for tracing.</li>
<li data-value="3">Jaeger tracing provider.</li>
</ul>

<p>All spans sent by Helidon to Jaeger need to be associated with a service.  Specify the service name below.</p>

<markup
lang="bash"
title="Add the following lines to <code>resources/application.yaml</code>:"
>tracing:
  service: helidon-se-1
  protocol: http
  port: 14250
  path: /api/traces
  tags:
    env: development
  enabled: true
  sampler-type: "const"
  sampler-param: 1
  log-spans: true
  propagation: b3</markup>

<markup
lang="java"
title="Update the <code>Main</code> class. Add Tracer to the WebServer builder"
>import io.helidon.tracing.TracerBuilder;
...

Tracer tracer = TracerBuilder.create("helidon") <span class="conum" data-value="1" />
                .build();

WebServer server = WebServer.builder(createRouting(config))
                .config(config.get("server"))
                .addFeature(ObserveFeature.builder()
                            .addObserver(TracingObserver.create(tracer)) <span class="conum" data-value="2" />
                            .build())
                .addMediaSupport(JsonpSupport.create())
                .build();</markup>

<ul class="colist">
<li data-value="1">Create the <code>Tracer</code> object.</li>
<li data-value="2">Add an observability feature using the created <code>Tracer</code>.</li>
</ul>

<markup
lang="java"
title="Update the <code>GreetService</code> class: replace the <code>getDefaultMessageHandler</code> method:"
>private void getDefaultMessageHandler(ServerRequest request,
                                      ServerResponse response) {
    var spanBuilder = Tracer.global().spanBuilder("mychildSpan"); <span class="conum" data-value="1" />
    request.context().get(SpanContext.class).ifPresent(sc -&gt; sc.asParent(spanBuilder)); <span class="conum" data-value="2" />
    var span = spanBuilder.start(); <span class="conum" data-value="3" />

    try {
        sendResponse(response, "World");
        span.end(); <span class="conum" data-value="4" />
    } catch (Throwable t) {
        span.end(t);    <span class="conum" data-value="5" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Create a new <code>Span</code> using the global tracer.</li>
<li data-value="2">Set the parent of the new span to the span from the <code>Request</code> if available.</li>
<li data-value="3">Start the span.</li>
<li data-value="4">End the span normally after the response is sent.</li>
<li data-value="5">End the span with an exception if one was thrown.</li>
</ul>

<markup
lang="bash"
title="Build the application, skipping unit tests, then run it:"
>mvn package -DskipTests=true
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Run the curl command in a new terminal window and check the response:"
>curl http://localhost:8080/greet
...
{
  "message": "Hello World!"
}</markup>

</div>


<h3 id="_viewing_tracing_using_jaeger_ui">Viewing Tracing Using Jaeger UI</h3>
<div class="section">
<p>The tracing output data is verbose and can be challenging to interpret using the REST API, especially since it represents
a structure of spans. Jaeger provides a web-based UI at <a target="_blank" href="http://localhost:16686/search" class="bare">http://localhost:16686/search</a>, where you can see a visual
representation of the same data and the relationship between spans within a trace.</p>

<p>Click on the UI Find traces button (the search icon) as shown in the image below.  Notice that you can change the look-back time to restrict the trace list.</p>


<div class="block-title"><span>Jaeger UI</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_se_refresh.png" alt="Trace Refresh" />
</v-card-text>
</v-card>


<p>The image below shows the trace summary, including start time and duration of each trace. There are two traces,
each one generated in response to a <code>curl <a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code> invocation.  The oldest trace will have a much
longer duration since there is one-time initialization that occurs.</p>


<div class="block-title"><span>Tracing list view</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_se_top.png" alt="Traces" />
</v-card-text>
</v-card>


<p>Click on a trace, and you will see the trace detail page where the spans are listed. You can clearly
see the root span and the relationship among all the spans in the trace, along with timing information.</p>


<div class="block-title"><span>Trace detail page</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_se_detail.png" alt="Trace Detail" />
</v-card-text>
</v-card>


<div class="admonition note">
<p class="admonition-inline">For OpenTracing, a parent span might not depend on the result of the child. This is called a <code>FollowsFrom</code> reference, see
<a target="_blank" href="https://github.com/opentracing/specification/blob/master/specification.md">Open Tracing Semantic Spec</a>.</p>
</div>

<p>You can examine span details by clicking on the span row.  Refer to the image below, which shows the span details, including timing information.
You can see times for each space relative to the root span.  These rows are annotated with <code>Server Start</code> and <code>Server Finish</code>, as shown in the third column.</p>


<div class="block-title"><span>Span detail page</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_span_detail.png" alt="Span Details" />
</v-card-text>
</v-card>


</div>


<h3 id="_tracing_across_services">Tracing Across Services</h3>
<div class="section">
<p>Helidon automatically traces across services if the services use the same tracer, for example, the same instance of Jaeger.
This means a single trace can include spans from multiple services and hosts.  Helidon uses a <code>SpanContext</code> to
propagate tracing information across process boundaries.  When you make client API calls, Helidon will
internally call OpenTelemetry APIs or OpenTracing APIs to propagate the <code>SpanContext</code>. There is nothing you need to do in your application to make this work.</p>

<p>To demonstrate distributed tracing, you will need to create a second project, where the server listens to on port 8081.
Create a new root directory to hold this new project, then do the following steps, similar to
what you did at the start of this guide:</p>

</div>


<h3 id="_create_the_second_service">Create the Second Service</h3>
<div class="section">
<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.2 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se-2 \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<markup
lang="bash"
title="The project will be built and run from the <code>helidon-quickstart-se</code> directory:"
>cd helidon-quickstart-se-2</markup>

<markup
lang="xml"
title="Add the following dependencies to <code>pom.xml</code>:"
> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing&lt;/artifactId&gt;   <span class="conum" data-value="1" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-webserver-observe-tracing&lt;/artifactId&gt; <span class="conum" data-value="2" />
 &lt;/dependency&gt;
 &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.tracing.providers&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-tracing-providers-jaeger&lt;/artifactId&gt;  <span class="conum" data-value="3" />
 &lt;/dependency&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon Tracing API.</li>
<li data-value="2">Observability features for tracing.</li>
<li data-value="3">Jaeger tracing provider.</li>
</ul>

<markup
lang="bash"
title="Replace <code>resources/application.yaml</code> with the following:"
>app:
  greeting: "Hello From SE-2"

tracing:
  service: helidon-se-2
  protocol: http
  port: 14250
  path: /api/traces
  tags:
    env: development
  enabled: true
  sampler-type: "const"
  sampler-param: 1
  log-spans: true
  propagation: b3

server:
  port: 8081
  host: 0.0.0.0</markup>

<div class="admonition note">
<p class="admonition-inline">The settings above are for development and experimental purposes only. For production environment, please see the <a target="_blank" href="../tracing.adoc">Tracing documentation</a>.</p>
</div>

<markup
lang="java"
title="Update the <code>Main</code> class; Add Tracer to the WebServer builder"
>Tracer tracer = TracerBuilder.create("helidon") <span class="conum" data-value="1" />
                .build();

WebServer server = WebServer.builder(createRouting(config))
                .config(config.get("server"))
                .addFeature(ObserveFeature.builder()
                            .addObserver(TracingObserver.create(tracer)) <span class="conum" data-value="2" />
                            .build())
                .addMediaSupport(JsonpSupport.create())
                .build();</markup>

<ul class="colist">
<li data-value="1">Create the <code>Tracer</code> object.</li>
<li data-value="2">Add an observability feature using the created <code>Tracer</code>.</li>
</ul>

<markup
lang="java"
title="Update the <code>GreetService</code> class. Replace the <code>getDefaultMessageHandler</code> method:"
>private void getDefaultMessageHandler(ServerRequest request,
                               ServerResponse response) {

    var spanBuilder = request.tracer()
            .buildSpan("getDefaultMessageHandler");
    request.spanContext().ifPresent(spanBuilder::asChildOf);
    Span span = spanBuilder.start();

    try {
        sendResponse(response, "World");
    } catch (Throwable t) {
        span.end(t);
    }
}</markup>

<markup
lang="bash"
title="Build the application, skipping unit tests, then run it:"
>mvn package -DskipTests=true
java -jar target/helidon-quickstart-se-2.jar</markup>

<markup
lang="bash"
title="Run the curl command in a new terminal window and check the response (<strong>notice the port is 8081</strong>) :"
>curl http://localhost:8081/greet
...
{
  "message": "Hello From SE-2 World!"
}</markup>

</div>


<h3 id="_modify_the_first_service">Modify the First Service</h3>
<div class="section">
<p>Once you have validated that the second service is running correctly, you need to modify the original application to
call it.</p>

<markup
lang="xml"
title="Add the following dependency to <code>pom.xml</code>:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.security.integration&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-security-integration-jersey&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.tracing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-tracing-jersey-client&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;org.glassfish.jersey.core&lt;/groupId&gt;
    &lt;artifactId&gt;jersey-client&lt;/artifactId&gt;
&lt;/dependency&gt;
&lt;dependency&gt;
    &lt;groupId&gt;org.glassfish.jersey.inject&lt;/groupId&gt;
    &lt;artifactId&gt;jersey-hk2&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="java"
title="Replace the <code>GreetService</code> class with the following code:"
>public class GreetService implements HttpService {

  private final AtomicReference&lt;String&gt; greeting = new AtomicReference&lt;&gt;();
  private WebTarget webTarget;
  private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());

  GreetService(Config config) {
    greeting.set(config.get("app.greeting").asString().orElse("Ciao"));

    Client jaxRsClient = ClientBuilder.newBuilder().build();

    webTarget = jaxRsClient.target("http://localhost:8081/greet");
  }

  @Override
  public void routing(HttpRules rules) {
    rules
        .get("/", this::getDefaultMessageHandler)
        .get("/outbound", this::outboundMessageHandler) <span class="conum" data-value="1" />
        .put("/greeting", this::updateGreetingHandler);
  }

  private void getDefaultMessageHandler(ServerRequest request, ServerResponse response) {
    var spanBuilder = Tracer.global().spanBuilder("getDefaultMessageHandler");
    request.context().get(SpanContext.class).ifPresent(sc -&gt; sc.asParent(spanBuilder));
    var span = spanBuilder.start();

    try {
        sendResponse(response, "World");
        span.end();
    } catch (Throwable t) {
        span.end(t);
    }
  }

  private void sendResponse(ServerResponse response, String name) {
    String msg = String.format("%s %s!", greeting.get(), name);

    JsonObject returnObject = JSON.createObjectBuilder().add("message", msg).build();
    response.send(returnObject);
  }

  private void updateGreetingFromJson(JsonObject jo, ServerResponse response) {

    if (!jo.containsKey("greeting")) {
      JsonObject jsonErrorObject =
          JSON.createObjectBuilder().add("error", "No greeting provided").build();
      response.status(Http.Status.BAD_REQUEST_400).send(jsonErrorObject);
      return;
    }

    greeting.set(jo.getString("greeting"));
    response.status(Http.Status.NO_CONTENT_204).send();
  }

  private void outboundMessageHandler(ServerRequest request, ServerResponse response) {
    Invocation.Builder requestBuilder = webTarget.request();

    var spanBuilder = Tracer.global().spanBuilder("outboundMessageHandler");
    request.context().get(SpanContext.class).ifPresent(sc -&gt; sc.asParent(spanBuilder));
    var span = spanBuilder.start();     <span class="conum" data-value="2" />

    try {
      requestBuilder.property(
          ClientTracingFilter.CURRENT_SPAN_CONTEXT_PROPERTY_NAME, span.context());  <span class="conum" data-value="3" />

      String result = requestBuilder   <span class="conum" data-value="4" />
          .get(String.class);
      response.send(result);
      span.end();
    } catch (Throwable t) {
      span.end(t);   <span class="conum" data-value="5" />
    }
  }

}</markup>

<ul class="colist">
<li data-value="1">Add <code>outboundMessageHandler</code> to the routing rules.</li>
<li data-value="2">Create and start a span that is a child of the current span.</li>
<li data-value="3">Set a property with the <code>SpanContext</code>.</li>
<li data-value="4">Invoke the second service.</li>
<li data-value="5">Stop the span.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the endpoint and check the response:"
>curl -i http://localhost:8080/greet/outbound <span class="conum" data-value="1" />
...
{
  "message": "Hello From SE-2 World!" <span class="conum" data-value="2" />
}</markup>

<ul class="colist">
<li data-value="1">The request went to the service on <code>8080</code>, which then invoked the service at <code>8081</code> to get the greeting.</li>
<li data-value="2">Notice the greeting came from the second service.</li>
</ul>

<p>Refresh the Jaeger UI trace listing page and notice that there is a trace across two services.</p>


<div class="block-title"><span>Tracing across multiple services detail view</span></div>
<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/guides/12_tracing_se_detail_2_services.png" alt="Traces" />
</v-card-text>
</v-card>


<p>In the image above, you can see that the trace includes spans from two services. You will notice there is a gap before the sixth span,
which is a <code>get</code> operation. This is a one-time client initialization delay.  Run the <code>/outbound</code> curl command again and look at the new trace to
see that the delay no longer exists.</p>

<p>You can now stop your second service, it is no longer used in this guide.</p>

</div>

</div>


<h2 id="_integration_with_kubernetes">Integration with Kubernetes</h2>
<div class="section">
<p>The following example demonstrates how to use Jaeger from a Helidon application running in Kubernetes.</p>

<markup
lang="bash"
title="Replace the tracing configuration in <code>resources/application.yaml</code> with the following:"
><span class="conum" data-value="1" />
tracing:
  service: helidon-se-1
  host: jaeger</markup>

<ul class="colist">
<li data-value="1">Helidon service <code>helidon-se-1</code> will connect to the Jaeger server at host name <code>jaeger</code>.</li>
</ul>

<markup
lang="bash"
title="Stop the application and build the docker image for your application:"
>docker build -t helidon-tracing-se .</markup>


<h3 id="_deploy_jaeger_into_kubernetes">Deploy Jaeger into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>jaeger.yaml</code>, with the following contents:"
>apiVersion: v1
kind: Service
metadata:
  name: jaeger
spec:
  ports:
    - port: 16686
      protocol: TCP
  selector:
    app: jaeger
---
kind: Pod
apiVersion: v1
metadata:
  name: jaeger
  labels:
    app: jaeger
spec:
  containers:
    - name: jaeger
      image: jaegertracing/all-in-one
      imagePullPolicy: IfNotPresent
      ports:
        - containerPort: 16686</markup>

<markup
lang="bash"
title="Create the Jaeger pod and ClusterIP service:"
>kubectl apply -f ./jaeger.yaml</markup>

<markup
lang="bash"
title="Create a Jaeger external server to view the UI and expose it on port 9142:"
>kubectl expose pod  jaeger --name=jaeger-external --port=16687 --target-port=16686 --type=LoadBalancer</markup>

<p>Navigate to <a target="_blank" href="http://localhost:16687/jaeger" class="bare">http://localhost:16687/jaeger</a> to validate that you can access Jaeger running in Kubernetes. It may
take a few seconds before it is ready.</p>

</div>


<h3 id="_deploy_your_helidon_application_into_kubernetes">Deploy Your Helidon Application into Kubernetes</h3>
<div class="section">
<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>tracing.yaml</code>, with the following contents:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-tracing <span class="conum" data-value="1" />
  labels:
    app: helidon-tracing
spec:
  type: NodePort
  selector:
    app: helidon-tracing
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-tracing
spec:
  replicas: 1 <span class="conum" data-value="2" />
  selector:
    matchLabels:
      app: helidon-tracing
  template:
    metadata:
      labels:
        app: helidon-tracing
        version: v1
    spec:
      containers:
        - name: helidon-tracing
          image: helidon-tracing-se
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./tracing.yaml</markup>

</div>


<h3 id="_access_your_application_and_the_jaeger_trace">Access Your Application and the Jaeger Trace</h3>
<div class="section">
<markup
lang="bash"
title="Get the application service information:"
>kubectl get service/helidon-tracing</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-tracing   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the tracing endpoint using port <code>31143</code>, your port will likely be different:"
>curl http://localhost:31143/greet
...
{
  "message": "Hello World!"
}</markup>

<p>Access the Jaeger UI at <a target="_blank" href="http://localhost:9412/jaeger" class="bare">http://localhost:9412/jaeger</a> and click on the refresh icon to see the trace that was just created.</p>

</div>


<h3 id="_cleanup">Cleanup</h3>
<div class="section">
<p>You can now delete the Kubernetes resources just created during this example.</p>

<markup
lang="bash"
title="Delete the Kubernetes resources:"
>kubectl delete -f ./jaeger.yaml
kubectl delete -f ./tracing.yaml
kubectl delete service jaeger-external
docker rm -f jaeger</markup>

</div>

</div>


<h2 id="_summary">Summary</h2>
<div class="section">
<p>This guide has demonstrated how to use the Helidon SE tracing feature with Jaeger. You have learned to do the following:</p>

<ul class="ulist">
<li>
<p>Enable tracing within a service</p>

</li>
<li>
<p>Use tracing with JAX-RS</p>

</li>
<li>
<p>Use the Jaeger REST API and UI</p>

</li>
<li>
<p>Use tracing across multiple services</p>

</li>
<li>
<p>Integrate tracing with Kubernetes</p>

</li>
</ul>

<p>Refer to the following references for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/microprofile-opentracing-spec-3.0.html">MicroProfile OpenTracing specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/apidocs">MicroProfile OpenTracing Javadoc</a></p>
<ul class="ulist">
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/js/api/tracing/">OpenTelemetry API</a></p>

</li>
</ul>

</li>
<li>
<p><a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadoc</a></p>

</li>
</ul>

</div>

</doc-view>
