<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>The Jakarta REST Client defines a programmatic API to access
REST resources. This API sits at a higher level than traditional HTTP client APIs and
provides full integration with server-side API concepts like providers. It differs
from the <router-link to="/mp/restclient">Rest Client API</router-link> in that it does not support
annotations or proxies, but instead uses builders and a fluent API to
create and execute requests.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable Jakarta REST Client
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.jersey&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-jersey-client&lt;/artifactId&gt;
 &lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>Bootstrapping the API is done by obtaining an instance of <code>Client</code>. A single instance of this
class can be used to create multiple service requests that share the same basic
configuration, e.g., the same set of <em>providers</em>. More precisely, from a <code>Client</code> we
can create multiple <code>WebTarget</code> s, and in turn, from each <code>WebTarget</code> we can
create multiple <code>Invocation</code> s.</p>

<markup
lang="java"

>Client client = ClientBuilder.newClient();
Response res = client
    .target("http://localhost:8080/greet")
    .request("text/plain")
    .get();</markup>

<p>In the snippet above, the call to <code>target</code> returns a <code>WebTarget</code>, and the call to
<code>request</code> returns an <code>Invocation.Builder</code>; finally, the call to <code>get</code> returns the <code>Response</code>
that results from accessing the remote resource.</p>

<p>Given that this API is fully integrated with message body readers and writers, it is
possible to request the response body be provided after conversion to a Java type&#8201;&#8212;&#8201;such as a <code>String</code> in the example below.</p>

<markup
lang="java"

>Client client = ClientBuilder.newClient();
String res = client
    .target("http://localhost:8080/greet")
    .request("text/plain")
    .get(String.class);</markup>

<p>Alternatively, there are also methods in <code>Response</code> that can trigger similar conversions.</p>

<p>Configuration can be specified at the <code>Client</code> or <code>WebTarget</code> level, as both types implement
<code>Configurable&lt;T&gt;</code>. This enables common configuration to be inherited by a <code>WebTarget</code> created
from a <code>Client</code> instance. In either case, several <code>register</code> methods can be used to
configure providers such as filters and exception mappers.</p>

<markup
lang="java"

>Client client = ClientBuilder.newClient();
client.register(GreetFilter.class);
String res = client
    .target("http://localhost:8080/greet")
    .register(GreetExceptionMapper.class)
    .request("text/plain")
    .get(String.class);</markup>

<p>The example above shows registration of <code>GreetFilter.class</code> for all targets and
registration of <code>GreetExceptionMapper.class</code> for just one of them. The same
logic applies to other types of configuration such as properties and features.</p>

<p>The Jakarta REST Client API has support for asynchronous invocations. Accessing
a resource asynchronously prevents the calling thread from blocking for the
duration of the call. By default, all invocations are <em>synchronous</em> but can be
turned into either asynchronous or reactive calls by simply inserting the
corresponding fluent method call during the creation phase.</p>

<p>Using <code>Future</code>:</p>

<markup
lang="java"

>Client client = ClientBuilder.newClient();
Future&lt;String&gt; res = client
    .target("http://localhost:8080/greet")
    .request("text/plain")
    .async()        // now asynchronous
    .get(String.class);</markup>

<p>Or using a more modern, reactive style:</p>

<markup
lang="java"

>Client client = ClientBuilder.newClient();
CompletionStage&lt;String&gt; res = client
    .target("http://localhost:8080/greet")
    .request("text/plain")
    .rx()           // now reactive
    .get(String.class);</markup>

<p>In either case, the implementation will ensure the calling thread is not blocked
and that the result from the invocation is available upon request or via a callback
mechanism.</p>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Configuration for this API is all done programmatically as shown in the previous sections.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>See <router-link to="#_api" @click.native="this.scrollFix('#_api')"></router-link> for same simple examples. For additional information, refer to the</p>

<p><a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1.0/jakarta-restful-ws-spec-3.1.0.html#client_api">Jakarta REST Client Specification</a>.</p>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>For additional information, see the <a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1.0/apidocs">Jakarta REST Javadocs</a>.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1.0/jakarta-restful-ws-spec-3.1.0.html#client_api">Jakarta REST Client Specification</a></p>

</li>
</ul>

</div>

</doc-view>
