<doc-view>

<h2 id="_introduction">Introduction</h2>
<div class="section">
<p>Helidon MP is an Eclipse MicroProfile 6.0 runtime that allows the Jakarta EE community to run microservices in a portable way. It is designed for ease of use and provides Spring Boot like development experience with heavy usage of dependency injection and annotations.</p>

<p>Even though Helidon MP supports Jakarta EE APIs it does not require
an application server. Helidon MP applications are stand-alone Java applications running
in their own JVM powered by Helidon WebServer. So you get all the benefits of a low
overhead server built on Java virtual threads.</p>

</div>


<h2 id="_supported_jakarta_ee_specifications">Supported Jakarta EE Specifications</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Specification</th>
<th>Version</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="/mp/beanvalidation">Jakarta Bean Validation</router-link></td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/bean-validation/3.0/bean-validation_3.0.html">3.0</a></td>
<td class="">Object level constraint declaration and validation facility</td>
</tr>
<tr>
<td class="">Jakarta Context and Dependency Injection (CDI)</td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/cdi/4.0.1/jakarta-cdi-spec-4.0.1.html">4.0.1</a></td>
<td class="">Declarative dependency injection and supporting services</td>
</tr>
<tr>
<td class="">Jakarta JSON Processing (JSON-P)</td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/jsonp/2.1.1/apidocs">2.1.1</a></td>
<td class="">API to parse, generate, transform, and query JSON docs</td>
</tr>
<tr>
<td class="">Jakarta JSON Binding (JSON-B)</td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/jsonb/3.0/jakarta-jsonb-spec-3.0.html">3.0</a></td>
<td class="">Binding framework for converting POJOs to/from JSON docs</td>
</tr>
<tr>
<td class=""><router-link to="/mp/server">Jakarta RESTful Web Services (JAX-RS)</router-link></td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/restful-ws/3.1.0/jakarta-restful-ws-spec-3.1.0.html">3.1.0</a></td>
<td class="">API to develop web services following the REST pattern</td>
</tr>
<tr>
<td class=""><router-link :to="{path: '/mp/persistence', hash: '#JPA'}">Jakarta Persistence (JPA)</router-link></td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/persistence/3.1.0/jakarta-persistence-spec-3.1.0.html">3.1.0</a></td>
<td class="">Management of persistence and object/relational mapping</td>
</tr>
<tr>
<td class=""><router-link :to="{path: '/mp/persistence', hash: '#JTA'}">Jakarta Transactions (JTA)</router-link></td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/jakarta-transactions-spec-2.0.html">2.0</a></td>
<td class="">Allows handling transactions consistent with X/Open XA-spec</td>
</tr>
<tr>
<td class=""><router-link to="/mp/websocket">Jakarta WebSocket</router-link></td>
<td class=""><a target="_blank" href="https://jakarta.ee/specifications/websocket/2.1.0/websocket-spec-2.1.0.html">2.1.0</a></td>
<td class="">API for Server and Client Endpoints for WebSocket protocol</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_supported_microprofile_specifications">Supported MicroProfile Specifications</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Specification</th>
<th>Version</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="/mp/config/introduction">MicroProfile Config</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.3/microprofile-config-spec-3.0.3.html">3.0.3</a></td>
<td class="">A flexible configuration framework with support for multiple sources and
 formats</td>
</tr>
<tr>
<td class=""><router-link to="/mp/fault-tolerance">MicroProfile Fault Tolerance</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0.2/microprofile-fault-tolerance-spec-4.0.2.html">4.0.2</a></td>
<td class="">Common strategies for various system problems such as time-outs, retries, Circuit Breaker, etc.</td>
</tr>
<tr>
<td class=""><router-link to="/mp/graphql">MicroProfile GraphQL</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-graphql-2.0/microprofile-graphql-spec-2.0.html">2.0</a></td>
<td class="">API for working with GraphQL</td>
</tr>
<tr>
<td class=""><router-link to="/mp/health">MicroProfile Health</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html">4.0</a></td>
<td class="">Health checks for automatic service restart/shutdown</td>
</tr>
<tr>
<td class=""><router-link to="/mp/jwt">MicroProfile JWT Auth</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.1/microprofile-jwt-auth-spec-2.1.html">2.1</a></td>
<td class="">Defines a compact and self-contained way for securely transmitting information between parties as a JSON object</td>
</tr>
<tr>
<td class=""><router-link to="/mp/lra">MicroProfile Long-Running Actions (LRA)</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-lra-2.0/microprofile-lra-spec-2.0.html">2.0</a></td>
<td class="">Distributed transactions for microservices following SAGA pattern</td>
</tr>
<tr>
<td class=""><router-link to="/mp/metrics/metrics">MicroProfile Metrics</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/microprofile-metrics-spec-5.0.1.html">5.0.1</a></td>
<td class="">Defining and exposing telemetry data in Prometheus and JSON formats</td>
</tr>
<tr>
<td class=""><router-link to="/mp/openapi/openapi">MicroProfile Open API</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.1/microprofile-openapi-spec-3.1.html">3.1</a></td>
<td class="">Annotations for documenting your application endpoints</td>
</tr>
<tr>
<td class=""><router-link to="/mp/tracing">MicroProfile OpenTracing</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-opentracing-3.0/microprofile-opentracing-spec-3.0.html">3.0</a></td>
<td class="">Profile and monitor your applications across multiple services</td>
</tr>
<tr>
<td class=""><router-link to="/mp/reactivemessaging/introduction">MicroProfile Reactive Messaging</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-messaging-3.0/microprofile-reactive-messaging-spec-3.0.html">3.0</a></td>
<td class="">Standard API for sending and receiving messages/events using streams</td>
</tr>
<tr>
<td class=""><router-link to="/mp/reactivestreams/rsoperators">MicroProfile Reactive Streams Operators</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-reactive-streams-operators-3.1.1/microprofile-reactive-streams-operators-spec-3.1.1.html">3.1.1</a></td>
<td class="">Control flow and error processing for event streams</td>
</tr>
<tr>
<td class=""><router-link to="/mp/restclient">MicroProfile REST Client</router-link></td>
<td class=""><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html">3.0</a></td>
<td class="">Type-safe API for RESTful Web Services</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_other_components">Other Components</h2>
<div class="section">

<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Component</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="/mp/cors/cors">CORS</router-link></td>
<td class="">Cross Origin Resource Sharing – API to control if and how REST resources served by their applications can be shared across origins</td>
</tr>
<tr>
<td class=""><router-link to="/mp/grpc/server">gRPC</router-link></td>
<td class="">gRPC server and client</td>
</tr>
<tr>
<td class=""><router-link to="/mp/integrations/oci">OCI SDK</router-link></td>
<td class="">Full set of APIs for working with OCI services</td>
</tr>
<tr>
<td class=""><router-link to="/mp/scheduling">Scheduling</router-link></td>
<td class="">Scheduling functionality based on <a target="_blank" href="https://github.com/jmrozanec/cron-utils">Cron-utils</a></td>
</tr>
<tr>
<td class=""><router-link to="/mp/security/security">Security</router-link></td>
<td class="">A tool-chain to handle authentication, authorization and context propagation</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_upgrade">Upgrade</h2>
<div class="section">
<p>In case you need to upgrade the version of Helidon, follow the <code>Upgrade Guides</code>.</p>

<p>For upgrade from Helidon 1.x to 2.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/mp/guides/upgrade">Helidon MP 2x Upgrade Guide</router-link></p>

</li>
</ul>

<p>For upgrade from Helidon 2.x to 3.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/mp/guides/upgrade_3x">Helidon MP 3x Upgrade Guide</router-link></p>

</li>
</ul>

<p>For upgrade from Helidon 3.x to 4.x:</p>

<ul class="ulist">
<li>
<p><router-link to="/mp/guides/upgrade_4x">Helidon MP 4x Upgrade Guide</router-link></p>

</li>
</ul>

</div>


<h2 id="_next_steps">Next Steps</h2>
<div class="section">
<ul class="ulist">
<li>
<p>Try the <router-link to="/mp/guides/overview">Helidon MP quickstart guides</router-link> to get your
first Helidon MP application up and running in minutes.</p>

</li>
<li>
<p>Browse the <a target="_blank" href="/apidocs/index.html?overview-summary.html">Helidon Javadocs</a></p>

</li>
</ul>

</div>

</doc-view>
