<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#Maven-Coordinates" @click.native="this.scrollFix('#Maven-Coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#Rest-Endpoints" @click.native="this.scrollFix('#Rest-Endpoints')">REST Endpoints</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Microservices expose their health status primarily so external tools (for example, an orchestrator such as Kubernetes)
can monitor each service and take action, such as restarting a service instance if it has failed
or temporarily shunting traffic away from the instance if the service is unable to process
incoming requests normally.</p>

</div>


<h2 id="Maven-Coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Health add the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link>  dependency to your project&#8217;s <code>pom.xml</code> (see <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.bundles&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>MicroProfile Health is already included in the bundle.</p>

<p>If full control over the dependencies is required, and you want to minimize the quantity of the dependencies - <code>Helidon MicroProfile Core budnle</code> should be used. In this case the following dependencies should be included in your project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.bundles&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-core&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-health&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>To enable built-in health checks add the following dependency
(or use the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> )</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>Helidon implements <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html">MicroProfile Health</a> Specification.
The spec prescribes how external tools probe a service&#8217;s health checks and how you
implement health checks as part of your microservice that are specific to your service&#8217;s needs.</p>


<h3 id="_concepts_liveness_readiness_and_startup_checks">Concepts - Liveness, Readiness, and Startup Checks</h3>
<div class="section">
<p>MicroProfile Health supports three types of health checks:</p>

<ul class="ulist">
<li>
<p><em>Liveness</em> checks report whether the runtime environment in which the service is running
is sufficient to support the work the service performs.
The environment is beyond the control of
the service itself and typically cannot improve without outside intervention.
If a microservice instance reports a <code>DOWN</code>
liveness check, it should never report <code>UP</code> later.
It will need to be stopped and a replacement instance created.</p>

</li>
<li>
<p><em>Readiness</em> checks report whether the service is <em>currently</em> capable of performing its work.
A service that reports <code>DOWN</code> for its readiness cannot <em>at the moment</em> do its job, but at
some future point it might become able to do so without requiring a restart.</p>

</li>
<li>
<p><em>Startup</em> checks indicate whether the service has started to the point where liveness and readiness checks even make sense.
A service reporting <code>DOWN</code> for a startup check is still initializing itself and normally will report <code>UP</code> soon, assuming it is able to start successfully.</p>

</li>
</ul>

</div>

</div>


<h2 id="Rest-Endpoints">REST Endpoints</h2>
<div class="section">
<p>A MicroProfile-compliant service reports its health via known REST endpoints. Helidon MP
provides these endpoints automatically as part of every MP microservice that includes health support..</p>

<p>External management tools (or <code>curl</code> or browsers) retrieve health checks using the REST endpoints in the table below which summarizes the types of health checks in MicroProfile Health.
Responses from the health endpoints report <code>200</code> (OK), <code>204</code> (no content), or <code>503</code> (service unavailable) depending on the outcome of running the health checks.
HTTP <code>GET</code> responses include JSON content showing the detailed results of all the health checks which the server executed after receiving the request.
HTTP <code>HEAD</code> requests return only the status with no payload.</p>

<div class="block-title"><span>Types of Health Checks</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
<col style="width: 25%;">
</colgroup>
<thead>
<tr>
<th>Type</th>
<th>Meaning</th>
<th>REST endpoint</th>
<th>Kubernetes response on failure</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">liveness</td>
<td class="">whether the runtime environment is suitable</td>
<td class=""><code>/health/live</code></td>
<td class="">Restarts container.</td>
</tr>
<tr>
<td class="">readiness</td>
<td class="">whether the microservice is currently capable of doing its work</td>
<td class=""><code>/health/ready</code></td>
<td class="">Diverts requests away from the instance; periodically rechecks readiness and resumes traffic once the
microservice reports itself as ready.</td>
</tr>
<tr>
<td class="">startup</td>
<td class="">whether the microservice has initialized to the point where liveness and readiness checks might pass</td>
<td class=""><code>/health/started</code></td>
<td class="">Treats the instance as still starting up; does not check liveness or readiness until the startup probe reports success or times out according to its configuration.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Health checks may be configured using the following properties.</p>

<p>The class responsible for configuration is:</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe.health/io/helidon/webserver/observe/health/HealthObserver.html">io.helidon.webserver.observe.health.HealthObserver</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>health</code></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.observe.spi.ObserveProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>details</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether details should be printed.
 By default, health only returns a io.helidon.http.Status#NO_CONTENT_204 for success,
 io.helidon.http.Status#SERVICE_UNAVAILABLE_503 for health down,
 and io.helidon.http.Status#INTERNAL_SERVER_ERROR_500 in case of error with no entity.
 When details are enabled, health returns io.helidon.http.Status#OK_200 for success, same codes
 otherwise
 and a JSON entity with detailed information about each health check executed.</p>

<pre>@return set to `true` to enable details</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>health</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>use-system-services</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether to use services discovered by java.util.ServiceLoader.
 By default, all io.helidon.health.spi.HealthCheckProvider based health checks are added.</p>

<pre>@return set to `false` to disable discovery</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>Properties may be set in <code>application.yaml</code> or in <code>microprofile-config.properties</code>, in both cases using the <code>health</code> prefix.</p>

<p>For example, you can specify a custom port and root context for the root health endpoint path.
However, you cannot use different ports, such as <a target="_blank" href="http://localhost:8080/myhealth" class="bare">http://localhost:8080/myhealth</a> and <a target="_blank" href="http://localhost:8081/myhealth/live" class="bare">http://localhost:8081/myhealth/live</a>.
Likewise, you cannot use different paths, such as <a target="_blank" href="http://localhost:8080/health" class="bare">http://localhost:8080/health</a> and <a target="_blank" href="http://localhost:8080/probe/live" class="bare">http://localhost:8080/probe/live</a>.
The example below will change the root path.</p>

<markup
lang="properties"
title="Create a file named <code>microprofile-config.properties</code> in the <code>resources/META-INF</code> directory with the following contents:"
>health.endpoint=/myhealth  <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The <code>endpoint</code> setting specifies the root path for the health endpoint.</li>
</ul>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Generate Helidon MP Quickstart project following these <router-link to="/mp/guides/quickstart">instructions</router-link>.</p>


<h3 id="_using_the_built_in_health_checks">Using the Built-In Health Checks</h3>
<div class="section">
<p>Helidon has a set of built-in health checks that can report various
conditions:</p>

<ul class="ulist">
<li>
<p>deadlock detection</p>

</li>
<li>
<p>available disk space</p>

</li>
<li>
<p>available heap memory</p>

</li>
</ul>

<p>The following example will demonstrate how to use the built-in health checks.  These examples are all executed
from the root directory of your project (helidon-quickstart-mp).</p>

<markup
lang="xml"
title="Include the built-in health checks dependency in your <code>pom.xml</code>:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.health&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-health-checks&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<markup
lang="bash"
title="Build the application, then run it:"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<markup
lang="bash"
title="Verify the health endpoint in a new terminal window:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "deadlock",
      "status": "UP"
    },
    {
      "name": "diskSpace",
      "status": "UP",
      "data": {
        "free": "325.54 GB",
        "freeBytes": 349543358464,
        "percentFree": "69.91%",
        "total": "465.63 GB",
        "totalBytes": 499963174912
      }
    },
    {
      "name": "heapMemory",
      "status": "UP",
      "data": {
        "free": "230.87 MB",
        "freeBytes": 242085696,
        "max": "3.56 GB",
        "maxBytes": 3817865216,
        "percentFree": "98.90%",
        "total": "271.00 MB",
        "totalBytes": 284164096
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_liveness_health_checks">Custom Liveness Health Checks</h3>
<div class="section">
<p>You can create application-specific custom health checks and integrate them with Helidon
using CDI.  The following example shows how to add a custom liveness health check.</p>

<markup
lang="java"
title="Create a new <code>GreetLivenessCheck</code> class with the following content:"
>@Liveness <span class="conum" data-value="1" />
@ApplicationScoped <span class="conum" data-value="2" />
public class GreetLivenessCheck implements HealthCheck {

  @Override
  public HealthCheckResponse call() {
    return HealthCheckResponse.named("LivenessCheck")  <span class="conum" data-value="3" />
        .up()
        .withData("time", System.currentTimeMillis())
        .build();
  }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating this is a liveness health check.</li>
<li data-value="2">Annotation indicating this is a bean instantiated once per application (in Helidon this means just once per runtime).</li>
<li data-value="3">Build the HealthCheckResponse with status <code>UP</code> and the current time.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then verify the custom liveness health endpoint:"
>curl http://localhost:8080/health/live</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566338255331
      }
    }
  ]
}</markup>

</div>


<h3 id="_custom_readiness_health_checks">Custom Readiness Health Checks</h3>
<div class="section">
<p>You can add a readiness check to indicate that the application is ready to be used.  In this
example, the server will wait five seconds before it becomes ready.</p>

<markup
lang="java"
title="Create a new <code>GreetReadinessCheck</code> class with the following content:"
>@Readiness <span class="conum" data-value="1" />
@ApplicationScoped
public class GreetReadinessCheck implements HealthCheck {
  private final AtomicLong readyTime = new AtomicLong(0);

  @Override
  public HealthCheckResponse call() {
    return HealthCheckResponse.named("ReadinessCheck")  <span class="conum" data-value="2" />
        .status(isReady())
        .withData("time", readyTime.get())
        .build();
  }

  public void onStartUp(
      @Observes @Initialized(ApplicationScoped.class) Object init) {
    readyTime.set(System.currentTimeMillis()); <span class="conum" data-value="3" />
  }

  private boolean isReady() { <span class="conum" data-value="4" />
    return Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 5;
  }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating that this is a readiness health check.</li>
<li data-value="2">Build the <code>HealthCheckResponse</code> with status <code>UP</code> after five seconds, else <code>DOWN</code>.</li>
<li data-value="3">Record the time at startup.</li>
<li data-value="4">Become ready after 5 seconds.</li>
</ul>

<markup
lang="bash"
title="Build and run the application. Issue the curl command with -v within five seconds and you will see that the application is not ready:"
>curl -v  http://localhost:8080/health/ready</markup>

<markup

title="HTTP response status"
>&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application is not ready.</li>
</ul>

<markup
lang="json"
title="JSON response body:"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "DOWN",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<markup
lang="bash"
title="After five seconds you will see the application is ready:"
>curl -v http://localhost:8080/health/ready</markup>

<markup

title="HTTP response status"
>&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is ready.</li>
</ul>

<markup
lang="json"
title="JSON response body:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "ReadinessCheck",
      "status": "UP",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<p>Full example code is available <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/microprofile">here</a>.</p>

</div>


<h3 id="_custom_startup_health_checks">Custom Startup Health Checks</h3>
<div class="section">
<p>You can add a startup check to indicate whether or not the application has initialized to the point that the other health checks make sense.
In this example, the server will wait eight seconds before it declares itself started.</p>

<markup
lang="java"
title="Create a new <code>GreetStartedCheck</code> class with the following content:"
>@Startup <span class="conum" data-value="1" />
@ApplicationScoped
public class GreetStartedCheck implements HealthCheck {
  private final AtomicLong readyTime = new AtomicLong(0);


  @Override
  public HealthCheckResponse call() {
    return HealthCheckResponse.named("StartedCheck")  <span class="conum" data-value="2" />
        .status(isStarted())
        .withData("time", readyTime.get())
        .build();
  }

  public void onStartUp(
      @Observes @Initialized(ApplicationScoped.class) Object init) {
    readyTime.set(System.currentTimeMillis()); <span class="conum" data-value="3" />
  }

  private boolean isStarted() { <span class="conum" data-value="4" />
    return Duration.ofMillis(System.currentTimeMillis() - readyTime.get()).getSeconds() &gt;= 8;
  }
}</markup>

<ul class="colist">
<li data-value="1">Annotation indicating that this is a startup health check.</li>
<li data-value="2">Build the <code>HealthCheckResponse</code> with status <code>UP</code> after eight seconds, else <code>DOWN</code>.</li>
<li data-value="3">Record the time at startup of Helidon; the application will declare itself as started eight seconds later.</li>
<li data-value="4">Become ready after 5 seconds.</li>
</ul>

<markup
lang="bash"
title="Build and run the application.  Issue the curl command with -v within five seconds and you will see that the application has not yet started:"
>curl -v  http://localhost:8080/health/started</markup>

<markup

title="HTTP response status:"
>&lt; HTTP/1.1 503 Service Unavailable <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>503</code> since the application has not started.</li>
</ul>

<markup
lang="json"
title="JSON response body:"
>{
  "status": "DOWN",
  "checks": [
    {
      "name": "StartedCheck",
      "status": "DOWN",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<markup
lang="bash"
title="After eight seconds you will see the application has started:"
>curl -v http://localhost:8080/health/started</markup>

<markup

title="HTTP response status:"
>&lt; HTTP/1.1 200 OK <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The HTTP status is <code>200</code> indicating that the application is started.</li>
</ul>

<markup
lang="json"
title="JSON response body:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "StartedCheck",
      "status": "UP",
      "data": {
        "time": 1566399775700
      }
    }
  ]
}</markup>

<p>When using the health check URLs, you can get the following health check data:</p>

<ul class="ulist">
<li>
<p>liveness only - <a target="_blank" href="http://localhost:8080/health/live" class="bare">http://localhost:8080/health/live</a></p>

</li>
<li>
<p>readiness only -  <a target="_blank" href="http://localhost:8080/health/ready" class="bare">http://localhost:8080/health/ready</a></p>

</li>
<li>
<p>startup checks only - <a target="_blank" href="http://localhost:8080/health/started" class="bare">http://localhost:8080/health/started</a></p>

</li>
<li>
<p>all health check data -  <a target="_blank" href="http://localhost:8080/health" class="bare">http://localhost:8080/health</a></p>

</li>
</ul>

<markup
lang="bash"
title="Get all the health check data, including custom data:"
>curl http://localhost:8080/health</markup>

<markup
lang="json"
title="JSON response:"
>{
  "status": "UP",
  "checks": [
    {
      "name": "LivenessCheck",
      "status": "UP",
      "data": {
        "time": 1566403431536
      }
    }
  ]
}</markup>

<p>Full example code is available <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.2/examples/microprofile">here</a>.</p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.microprofile.health/module-summary.html">Helidon MicroProfile Health JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.health.checks/module-summary.html">Helidon Built-in Checks JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html">MicroProfile Health Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/eclipse/microprofile-health">MicroProfile Health on GitHub</a></p>

</li>
</ul>

</div>

</doc-view>
