<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon MP 4.x Upgrade Guide</dt>
<dd slot="desc"><p>In Helidon 4.x we have made some changes to APIs and runtime behavior. This guide
will help you upgrade a Helidon MP 3.x application to 4.x.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_java_21_runtime">Java 21 Runtime</h2>
<div class="section">
<p>Java 17 is no longer supported in Helidon 4. Java 21 or newer is required. Please follow the instructions in <router-link to="/about/prerequisites">Prerequisites</router-link> for proper installation.</p>

<p>Helidon 4 no longer uses Netty. Helidon MP is now running on Helidon WebServer which is based on virtual threads technology, available in Java 21.</p>

</div>


<h2 id="_microprofile_6_0_support">MicroProfile 6.0 support</h2>
<div class="section">
<p>MicroProfile 6.0 enables MicroProfile APIs to be used together with Jakarta EE 10 Core Profile.</p>


<h3 id="_microprofile_specifications">MicroProfile specifications</h3>
<div class="section">
<p>Most of the MicroProfile specifications had relatively minor changes. The exception is Metrics which had substantial changes.</p>

<ul class="ulist">
<li>
<p><strong>MicroProfile Config 3.0.3</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-config-3.0.1/microprofile-config-spec-3.0.1.html#_incompatible_changes">MicroProfile Config 3.0.3 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Fault Tolerance 4.0.2</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0.2/microprofile-fault-tolerance-spec-4.0.2.html#_backward_incompatible_changes=">MicroProfile Fault Tolerance 4.0.2 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Health 4.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-health-4.0/microprofile-health-spec-4.0.html#_incompatible_changes">MicroProfile Health 4.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile JWT Authentication 2.1</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-jwt-auth-2.0/microprofile-jwt-auth-spec-2.0.html#_incompatible_changes">MicroProfile JWT Authentication 2.1 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Metrics 5.0.1</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0/microprofile-metrics-spec-5.0.html#_incompatible_changes">MicroProfile Metrics 5.0.1 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile OpenAPI 3.1</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-open-api-3.1/microprofile-openapi-spec-3.1.html#incompatible_changes_30">MicroProfile OpenAPI 3.1 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Rest Client 3.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html#_incompatible_changes">MicroProfile Rest Client 3.0 Specification</a></p>

</li>
<li>
<p><strong>MicroProfile Telemetry Tracing 1.0</strong>:</p>
<p>Incompatible changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-telemetry-1.0/tracing/microprofile-telemetry-tracing-spec-1.0.html#_incompatible_changes">MicroProfile Telemetry Tracing 1.0 Specification</a></p>

</li>
</ul>

</div>


<h3 id="_supported_jakarta_ee_specifications">Supported Jakarta EE specifications</h3>
<div class="section">
<ul class="ulist">
<li>
<p><strong>CDI (Jakarta Contexts and Dependency Injection) 4.0.1</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/cdi/4.0/jakarta-cdi-spec-4.0.html#architecture">CDI (Jakarta Contexts and Dependency Injection) 4.0.1 Specification</a></p>

</li>
<li>
<p><strong>JAX-RS (Jakarta RESTful Web Services) 3.1.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-rest-client-3.0/microprofile-rest-client-spec-3.0.html#_incompatible_changes">JAX-RS (Jakarta RESTful Web Services) 3.1.0 Specification</a></p>

</li>
<li>
<p><strong>JSON-B (Jakarta JSON Binding) 3.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/jsonb/2.0/jakarta-jsonb-spec-2.0.html#change-log">JSON-B (Jakarta JSON Binding) 3.0 Specification</a></p>

</li>
<li>
<p><strong>JSON-P (Jakarta JSON Processing) 2.1.1</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/jsonp/2.1/apidocs/">JSON-P (Jakarta JSON Parsing) 2.1.1 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Annotations 2.1.1</strong>:</p>
<p>Full information in <a target="_blank" href="https://jakarta.ee/specifications/annotations/2.0/annotations-spec-2.0.html">Jakarta Annotations 2.1.1 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Persistence API 3.1.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/persistence/3.0/jakarta-persistence-spec-3.0.html#revision-history">Jakarta Persistence API 3.1.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Transactions API 2.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/transactions/2.0/jakarta-transactions-spec-2.0.html#revision-history">Jakarta Transactions API 2.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta WebSocket API 2.1.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/websocket/2.0/websocket-spec-2.0.html#changes">Jakarta WebSocket API 2.1.0 Specification</a></p>

</li>
<li>
<p><strong>Jakarta Bean Validation 3.0</strong>:</p>
<p>Changes described in <a target="_blank" href="https://jakarta.ee/specifications/bean-validation/2.0/bean-validation_2.0.html#changelog">Jakarta Bean Validation 3.0 Specification</a></p>

</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Please, read each specification carefully for incompatible changes!</p>
</div>

</div>


<h3 id="_significant_changes">Significant changes</h3>
<div class="section">

<h4 id="_jandex">Jandex</h4>
<div class="section">
<p>Jandex group id was <code>org.jboss.jandex</code> and now is <code>io.smallrye</code>.</p>

</div>


<h4 id="_testing">Testing</h4>
<div class="section">
<p>Testing is now in a new package. It was:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.tests&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-tests-junit5&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>Now is:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.testing&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-testing-junit5&lt;/artifactId&gt;
    &lt;scope&gt;test&lt;/scope&gt;
&lt;/dependency&gt;</markup>

<p>And the Java package has changed from <code>io.helidon.microprofile.tests.junit5</code> to <code>io.helidon.microprofile.testing.junit5</code></p>

</div>

</div>


<h3 id="_logging">Logging</h3>
<div class="section">
<p>The Helidon console handler has changed from <code>io.helidon.common.HelidonConsoleHandler</code> to <code>io.helidon.logging.jul.HelidonConsoleHandler</code>.</p>

<p>If you use this handler in your <code>logging.properties</code> you will need to update it and add the following dependency:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.logging&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-logging-jul&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_conclusion">Conclusion</h2>
<div class="section">
<p>Please proceed to <router-link to="/mp/introduction">Helidon MP Introduction</router-link> to find more information and documentation about each module.</p>

</div>

</doc-view>
