<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Fault Tolerance is part of the MicroProfile set of specifications. This API defines mostly
annotations that improve application robustness by providing support to conveniently handle
error conditions (faults) that may occur in real-world applications. Examples include
service restarts, network delays, temporal infrastructure instabilities, etc.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Fault Tolerance
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

> &lt;dependency&gt;
     &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
     &lt;artifactId&gt;helidon-microprofile-fault-tolerance&lt;/artifactId&gt;
 &lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The MicroProfile Fault Tolerance specification defines a set of annotations to decorate
classes and methods in your application for the purpose of improving its robustness.
Many of these annotations can be applied at the class or method level: if applied at the
class level, they will impact all methods in the class; if applied both at the
class and method level, the latter will take precedence over the former.</p>

<p>The following table provides a brief description of each of these annotations, including
its parameters and default values.</p>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Annotation</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@Retry(
    maxRetries=3,
    delay=0,
    delayUnit=ChronoUnit.MILLIS,
    maxDuration=180000,
    durationUnit=ChronoUnit.MILLIS,
    jitter=200,
    jitterDelayUnit=ChronoUnit.MILLIS,
    retryOn={Exception.class},
    abortOn={}
)</pre>
</div>

</doc-view>
</td>
<td class="">Retries the execution of a method if a failure is encountered. Annotation attributes can be
used to control the number of retries, delay between retries and which exceptions to retry
or abort on.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@Timeout(
    value=1000,
    unit=ChronoUnit.MILLIS
)</pre>
</div>

</doc-view>
</td>
<td class="">Defines an upper bound on a method&#8217;s execution time. Default value is 1 second.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@CircuitBreaker(
    failOn={Throwable.class},
    skipOn={},
    delay=5000,
    delayUnit=ChronoUnit.MILLIS,
    requestVolumeThreshold=20,
    failureRation=.50,
    successThreshold=1
)</pre>
</div>

</doc-view>
</td>
<td class="">Defines a policy to avoid repeated execution of logic that is likely to fail. A circuit
breaker can be <em>closed</em>, <em>open</em> or <em>half-open</em>. In <em>closed</em> state a circuit breaker will
execute logic normally. In <em>open</em> state a circuit breaker will
prevent execution of logic that has been seen to fail. Finally, in <em>half-open</em> state
a circuit breaker will allow <em>trial</em> executions in an attempt to switch its internal
state to <em>closed</em>. The other annotation parameters are used to control how these
state transitions are triggered.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@Bulkhead(
    value=10,
    waitingTaskQueue=10
)</pre>
</div>

</doc-view>
</td>
<td class="">Defines a policy to limit the number of concurrent executions allowed over some
application logic. A queue is used to park tasks awaiting execution after
the limit has been reached. A queue is only active when invocations are
<code>@Asynchronous</code>.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@Fallback(
    value=DEFAULT.class,
    fallbackMethod="",
    applyOn={Throwable.class},
    skipOn={}
)</pre>
</div>

</doc-view>
</td>
<td class="">Establishes a handler to be executed upon encountering an invocation failure. A handler
is either a class that implements <code>FallbackHandler&lt;T&gt;</code> or just a simple method in the
same class. Additional properties are used to control the conditions under which
these handlers are called.</td>
</tr>
<tr>
<td class=""><doc-view>
<div class="listing">
<pre>@Asynchronous</pre>
</div>

</doc-view>
</td>
<td class="">Executes an invocation asynchronously without blocking the calling thread. Annotated
method must return <code>Future</code> or <code>CompletionStage</code>. Typically used to avoid blocking
the calling thread on I/O or on a long-running computation.</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>Helidon&#8217;s implementation uses two types of thread pools: normal and scheduled. The default
core size of these executors is 20; however, that can be configured using an <code>application.yaml</code>
file as follows:</p>

<markup
lang="yaml"

>executor:
  core-pool-size: 32

scheduled-executor:
  core-pool-size: 32</markup>

<div class="admonition note">
<p class="admonition-inline">There is currently <em>no support</em> to configure these executor properties via a
<code>microprofile-config.properties</code> file.</p>
</div>

<p>For a complete set of properties available to configure these executors, see
<a target="_blank" href="/apidocs/io.helidon.common.configurable/io.helidon.common.configurable/ThreadPoolSupplier.Builder.html#config(io.helidon.config.Config)">ServerThreadPoolSupplier</a> and
<a target="_blank" href="/apidocs/io.helidon.common.configurable/io.helidon.common.configurable/ScheduledThreadPoolSupplier.Builder.html#config(io.helidon.config.Config)">ScheduledThreadPoolSupplier</a>.</p>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<ol style="margin-left: 15px;">
<li>
The method  <code>retryWithFallback</code> shall be called at most 3 times, first
call plus 2 retries, with a delay of 400 milliseconds between calls. If none of the
calls is successful, the <code>onFailure</code> method shall be called as a fallback mechanism.
<markup
lang="java"

>@Retry(maxRetries = 2, delay = 400L)
@Fallback(fallbackMethod = "onFailure")
String retryWithFallback() {
    //...
}</markup>

</li>
<li>
The method <code>timedCircuitBreaker</code> defines a <em>rolling window</em> of size 10 and a policy
to open the circuit breaker after 4 or more failures occur in that window, and to transition
back to half-open state after 3 consecutive and successful runs. Additionally, it sets an overall timeout
for the invocation of 1.5 seconds.
<markup
lang="java"

>@Timeout(1500)
@CircuitBreaker(requestVolumeThreshold = 10,
                failureRatio = .4
                successThreshold = 3)
void timedCircuitBreaker() throws InterruptedException {
    //...
}</markup>

</li>
<li>
The method <code>executeWithQueueAndFallback</code> defines a bulkhead that will limit the number of
concurrent calls to a maximum of 2; any additional tasks shall be queued up to a maximum of 10.
Finally, if an error occurs the <code>onFailure</code> method shall be called as a fallback mechanism.
The <code>@Asynchronous</code> annotation is needed to enable queueing of bulkhead tasks.
<markup
lang="java"

>@Asynchronous
@Fallback(fallbackMethod = "onFailure")
@Bulkhead(value = 2, waitingTaskQueue = 10)
CompletableFuture&lt;String&gt; executeWithQueueAndFallback() {
    //...
}</markup>

</li>
</ol>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>For additional information about this API, see the
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0.2/apidocs">MicroProfile Fault Tolerance Javadocs</a>.</p>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-fault-tolerance-4.0.2/microprofile-fault-tolerance-spec-4.0.2.html}">MicroProfile Fault Tolerance</a></p>

</li>
</ul>

</div>

</doc-view>
