<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Http2Config (webserver.http2) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.http2/io/helidon/webserver/http2/Http2Config.html">io.helidon.webserver.http2.Http2Config</a></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ProtocolConfig</code></p>

</li>
</ul>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>flow-control-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.1S</code></td>
<td class=""><doc-view>
<p>Outbound flow control blocking timeout configured as java.time.Duration
 or text in ISO-8601 format.
 Blocking timeout defines an interval to wait for the outbound window size changes(incoming window updates)
 before the next blocking iteration.
 Default value is <code>PT0.1S</code>.</p>

<pre>&lt;table&gt;
    &lt;caption&gt;&lt;b&gt;ISO_8601 format examples:&lt;/b&gt;&lt;/caption&gt;
    &lt;tr&gt;&lt;th&gt;PT0.1S&lt;/th&gt;&lt;th&gt;100 milliseconds&lt;/th&gt;&lt;/tr&gt;
    &lt;tr&gt;&lt;th&gt;PT0.5S&lt;/th&gt;&lt;th&gt;500 milliseconds&lt;/th&gt;&lt;/tr&gt;
    &lt;tr&gt;&lt;th&gt;PT2S&lt;/th&gt;&lt;th&gt;2 seconds&lt;/th&gt;&lt;/tr&gt;
&lt;/table&gt;</pre>
<pre>@return duration
@see &lt;a href="https://en.wikipedia.org/wiki/ISO_8601#Durations"&gt;ISO_8601 Durations&lt;/a&gt;</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>initial-window-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1048576</code></td>
<td class=""><doc-view>
<p>This setting indicates the sender&#8217;s maximum window size in bytes for stream-level flow control.
 Default and maximum value is 2&lt;sup&gt;31&lt;/sup&gt;-1 = 2147483647 bytes. This setting affects the window size
 of HTTP/2 connection.
 Any value greater than 2147483647 causes an error. Any value smaller than initial window size causes an error.
 See RFC 9113 section 6.9.1 for details.</p>

<pre>@return maximum window size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-concurrent-streams</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>8192</code></td>
<td class=""><doc-view>
<p>Maximum number of concurrent streams that the server will allow.
 Defaults to <code>8192</code>. This limit is directional: it applies to the number of streams that the sender
 permits the receiver to create.
 It is recommended that this value be no smaller than 100 to not unnecessarily limit parallelism
 See RFC 9113 section 6.5.2 for details.</p>

<pre>@return maximal number of concurrent streams</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-frame-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>16384</code></td>
<td class=""><doc-view>
<p>The size of the largest frame payload that the sender is willing to receive in bytes.
 Default value is <code>16384</code> and maximum value is 2&lt;sup&gt;24&lt;/sup&gt;-1 = 16777215 bytes.
 See RFC 9113 section 6.5.2 for details.</p>

<pre>@return maximal frame size</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-header-list-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>8192</code></td>
<td class=""><doc-view>
<p>The maximum field section size that the sender is prepared to accept in bytes.
 See RFC 9113 section 6.5.2 for details.
 Default is 8192.</p>

<pre>@return maximal header list size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>requested-uri-discovery</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_RequestedUriDiscoveryContext">RequestedUriDiscoveryContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Requested URI discovery settings.</p>

<pre>@return settings for computing the requested URI</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>send-error-details</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Whether to send error message over HTTP to client.
 Defaults to <code>false</code>, as exception message may contain internal information that could be used as an
 attack vector. Use with care and in cases where both server and clients are under your full control (such as for
 testing).</p>

<pre>@return whether to send error messages over the network</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>validate-path</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>If set to false, any path is accepted (even containing illegal characters).</p>

<pre>@return whether to validate path</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
