<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon Project Starter</dt>
<dd slot="desc"><p><a target="_blank" href="https://helidon.io/starter">Helidon Project Starter</a> allows you to choose from a set of archetypes with pre-defined feature sets and lets you customize it by providing a host of options.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_select_a_flavor">Select a Flavor</h2>
<div class="section">

<h3 id="_helidon_se">Helidon SE</h3>
<div class="section">

</div>


<h3 id="_helidon_mp">Helidon MP</h3>
<div class="section">

</div>

</div>


<h2 id="_choose_an_application_type">Choose an Application Type</h2>
<div class="section">
<p>Helidon provides the following set of archetypes to bootstrap your application development journey.</p>


<h3 id="_quickstart">QuickStart</h3>
<div class="section">
<p>This option creates a Helidon project that includes multiple REST operations along with default observability setup and a set of dependencies to enable ease of development e.g. in case of Helidon MP, it uses <code>helidon-microprofile</code> bundle instead of minimal <code>helidon-microprofile-core</code> bundle.</p>

</div>


<h3 id="_database">Database</h3>
<div class="section">
<p>This option builds on <code>QuickStart</code> to demonstrate how to integrate with database (in-memory H2, by default). In case of, Helidon SE that uses the DbClient API while for Helidon MP that uses JPA.</p>

</div>


<h3 id="_custom">Custom</h3>
<div class="section">
<p>This option enables user to create Helidon project of their choice, suitable to start from scratch i.e. bare minimum, if default values are chosen Or choose from many options available.</p>

</div>


<h3 id="_oci_mp_only">OCI (MP Only)</h3>
<div class="section">
<p>This option builds on <code>QuickStart</code> to demonstrate integration with Oracle Cloud Infrastructure (OCI) services using the OCI SDK. Generated project showcases OpenApi-driven development approach where the practice of designing and building APIs is done first, then creating the rest of an application around them is implemented next. This is available for Helidon MP only.</p>

</div>

</div>


<h2 id="_media_support_options">Media Support Options</h2>
<div class="section">

<h3 id="_jackson_json">Jackson JSON</h3>
<div class="section">

</div>


<h3 id="_json_b">JSON-B</h3>
<div class="section">
<p>Default.</p>

</div>


<h3 id="_json_p_se_only">JSON-P (SE Only)</h3>
<div class="section">

</div>

</div>


<h2 id="_customize_project">Customize Project</h2>
<div class="section">
<ul class="ulist">
<li>
<p>groupId</p>

</li>
<li>
<p>artifactId</p>

</li>
<li>
<p>Project Version</p>

</li>
<li>
<p>Java package name</p>

</li>
</ul>

</div>


<h2 id="_download_the_project_files">Download the Project Files</h2>
<div class="section">
<p>Click <strong>Download</strong> and Project Starter generates the files in a directory named after the <code>artifactId</code> value. It mainly contains the following:</p>

<ul class="ulist">
<li>
<p>Maven structure</p>

</li>
<li>
<p>skeletal application code</p>

</li>
<li>
<p>associated unit test code</p>

</li>
<li>
<p>example Dockerfile files</p>

</li>
<li>
<p>application configuration file(s)</p>

</li>
<li>
<p>Readme file with instructions to build and run application/test</p>

</li>
</ul>

</div>

</doc-view>
