<doc-view>
<v-layout row wrap class="mb-5">
<v-flex xs12>
<v-container fluid grid-list-md class="pa-0">
<v-layout row wrap class="pillars">
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">lightbulb</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Introduction to Helidon</span>
</v-card-title>
<v-card-text class="caption">
<p>Start here to learn how Helidon&#8217;s open-source set of Java libraries can help you write cloud-native Java microservices.</p>
<p><router-link to="/about/introduction">What is Helidon?</router-link></p>
<p><router-link to="/about/intro">What&#8217;s New in Helidon 4</router-link></p>
<p><router-link to="/about/archetype">Helidon Archetypes</router-link></p>
<p><router-link to="/about/additional_info">Helidon Community and Support</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">rocket_launch</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Getting Started</span>
</v-card-title>
<v-card-text class="caption">
<p>There are several ways to generate your first Helidon project. In a hurry? Try the Helidon CLI or Project Starter which provide a set of predefined archetypes to choose from.</p>
<p><router-link to="/about/prerequisites">Prerequisites and System Requirements</router-link></p>
<p><router-link to="/about/cli">Using the Helidon CLI</router-link></p>
<p><router-link to="/mp/guides/quickstart">Using the MP Quickstart Guide</router-link></p>
<p><router-link to="/se/guides/quickstart">Using the SE Quick Start Guide</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">storage</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Upgrading Helidon</span>
</v-card-title>
<v-card-text class="caption">
<p>Use the upgrade guides to help you upgrade your existing Helidon applications to the latest version of Helidon.</p>
<p><router-link to="/mp/guides/upgrade_4x">Upgrade From Helidon MP 3.x</router-link></p>
<p><router-link to="/se/guides/upgrade_4x">Upgrade From Helidon SE 3.x</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">terminal</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Developing Your First Application From Scratch</span>
</v-card-title>
<v-card-text class="caption">
<p>Use these hands-on development tutorials to learn how to generate a small "Hello World!" greeting service that demonstrates some of Helidon&#8217;s core features.</p>
<p><router-link to="/mp/guides/mp-tutorial">Helidon MP Tutorial</router-link></p>
<p><router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">library_books</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">How-To Guides</span>
</v-card-title>
<v-card-text class="caption">
<p>Ready for more hands-on learning? Explore the features of Helidon with these quick step-by-step guides.</p>
<p><router-link to="/se/guides/overview">SE Guides</router-link></p>
<p><router-link to="/mp/guides/overview">MP Guides</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">hotel_class</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Advanced SE Features</span>
</v-card-title>
<v-card-text class="caption">
<p><router-link to="/se/webserver">Helidon WebServer</router-link></p>
<p><router-link to="/se/metrics/metrics">Helidon Metrics</router-link></p>
<p><router-link to="/se/config/introduction">Helidon Config</router-link></p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">model_training</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Training and Certification</span>
</v-card-title>
<v-card-text class="caption">
<p>Training:
<a target="_blank" href="https://learn.oracle.com/ols/learning-path/become-a-helidon-microservices-developer-professional/88258/114512">Become a Helidon Microservices Developer Professional</a></p>
<p>Certification:
<a target="_blank" href="https://learn.oracle.com/ols/learning-path/become-a-helidon-microservices-developer-professional/88258/114512">Helidon Microservices Developer Professional (1Z0-1113)</a></p>
<p>New to Helidon? Check out <a target="_blank" href="https://a.co/d/0niQnwC">Beginning Helidon</a> to learn more about building cloud-native microservices with Helidon.</p>
</v-card-text>
</v-card>
</v-flex>
<v-flex xs12 sm4 lg3>
<v-card>
<v-layout align-center justify-center class="">
<v-avatar size="150px">
<v-icon class="xxx-large">groups</v-icon>
</v-avatar>
</v-layout>
<div class="px-3">
<v-divider class="indigo lighten-4"/>
</div>
<v-card-title primary class="headline layout justify-center">
<span style="text-align:center">Get Involved</span>
</v-card-title>
<v-card-text class="caption">
<p>Here are some additional resources you can use to get started, get help, and to follow the evolution of Helidon.</p>
<p>Project website: <a target="_blank" href="https://helidon.io" class="bare">https://helidon.io</a></p>
<p>Medium publication: <a target="_blank" href="https://medium.com/helidon" class="bare">https://medium.com/helidon</a></p>
<p>GitHub repository: <a target="_blank" href="https://github.com/helidon-io/helidon" class="bare">https://github.com/helidon-io/helidon</a></p>
<p>Public Slack workspace: <a target="_blank" href="https://slack.helidon.io/" class="bare">https://slack.helidon.io/</a></p>
<p>Twitter account: <a target="_blank" href="https://twitter.com/helidon_project" class="bare">https://twitter.com/helidon_project</a></p>
<p>YouTube channel: <a target="_blank" href="https://www.youtube.com/channel/UChg00-uTTrCMmPsuzUNaZsA" class="bare">https://www.youtube.com/channel/UChg00-uTTrCMmPsuzUNaZsA</a></p>
<p>Stack Overflow tag: <a target="_blank" href="https://stackoverflow.com/tags/helidon" class="bare">https://stackoverflow.com/tags/helidon</a></p>
</v-card-text>
</v-card>
</v-flex>
</v-layout>
</v-container>
</v-flex>
</v-layout>

</doc-view>
