<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_configuring_the_webserver_in_your_code" @click.native="this.scrollFix('#_configuring_the_webserver_in_your_code')">Configuring the WebServer in Your Code</router-link></p>

</li>
<li>
<p><router-link to="#_configuring_the_webserver_in_a_configuration_file" @click.native="this.scrollFix('#_configuring_the_webserver_in_a_configuration_file')">Configuring the WebServer in a Configuration File</router-link></p>

</li>
<li>
<p><router-link to="#_configuring_tls" @click.native="this.scrollFix('#_configuring_tls')">Configuring TLS</router-link></p>

</li>
<li>
<p><router-link to="#_configuration_options" @click.native="this.scrollFix('#_configuration_options')">Configuration Options</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_routing" @click.native="this.scrollFix('#_routing')">Routing</router-link></p>

</li>
<li>
<p><router-link to="#_request_handling" @click.native="this.scrollFix('#_request_handling')">Request Handling</router-link></p>

</li>
<li>
<p><router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">Error Handling</router-link></p>

</li>
</ul>

</li>
</ul>

</li>
<li>
<p><router-link to="#_server_features" @click.native="this.scrollFix('#_server_features')">Server Features</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_access_log" @click.native="this.scrollFix('#_access_log')">Access Log</router-link></p>

</li>
<li>
<p><router-link to="#_context" @click.native="this.scrollFix('#_context')">Context</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_supported_technologies" @click.native="this.scrollFix('#_supported_technologies')">Supported Technologies</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_http2_support" @click.native="this.scrollFix('#_http2_support')">HTTP/2 Support</router-link></p>

</li>
<li>
<p><router-link to="#_static_content_support" @click.native="this.scrollFix('#_static_content_support')">Static Content Support</router-link></p>

</li>
<li>
<p><router-link to="#_media_types_support" @click.native="this.scrollFix('#_media_types_support')">Media Types Support</router-link></p>

</li>
<li>
<p><router-link to="#_http_content_encoding" @click.native="this.scrollFix('#_http_content_encoding')">HTTP Content Encoding</router-link></p>

</li>
<li>
<p><router-link to="#_proxy_protocol_support" @click.native="this.scrollFix('#_proxy_protocol_support')">Proxy Protocol Support</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
<li>
<p><router-link to="#_additional_information" @click.native="this.scrollFix('#_additional_information')">Additional Information</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>WebServer provides an API for creating HTTP servers. It uses virtual threads and can handle nearly unlimited concurrent requests.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable WebServer
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>You can configure the WebServer either programmatically or by the Helidon configuration framework.</p>


<h3 id="_configuring_the_webserver_in_your_code">Configuring the WebServer in Your Code</h3>
<div class="section">
<p>The easiest way to configure the WebServer is in your
application code.</p>

<markup
lang="java"

>WebServer.builder()
        .port(8080)
        .build()
        .start();</markup>

</div>


<h3 id="_configuring_the_webserver_in_a_configuration_file">Configuring the WebServer in a Configuration File</h3>
<div class="section">
<p>You can also define the configuration in a file.</p>

<markup
lang="yaml"
title="WebServer configuration file <code>application.yaml</code>"
>server:
  port: 8080
  host: "0.0.0.0"</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebServer initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create(); <span class="conum" data-value="1" />
WebServer.builder()
        .config(config.get("server")); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1"><code>application.yaml</code> is a default configuration source loaded when YAML support is on classpath, so we can
just use <code>Config.create()</code></li>
<li data-value="2">Server expects the configuration tree located on the node of <code>server</code></li>
</ul>

</div>


<h3 id="_configuring_tls">Configuring TLS</h3>
<div class="section">
<p>Configure TLS either programmatically, or by the Helidon configuration framework.</p>


<h4 id="_configuring_tls_in_your_code">Configuring TLS in Your Code</h4>
<div class="section">
<p>To configure TLS in WebServer programmatically create your keystore configuration and pass it to the WebServer builder.</p>

<markup
lang="java"

>Tls tls = Tls.builder()
        .privateKey(pk -&gt; pk
                .keystore(keys -&gt; keys.keystore(it -&gt; it.resourcePath("private-key.p12"))
                        .passphrase("password".toCharArray())))
        .trust(trust -&gt; trust
                .keystore(keys -&gt; keys.keystore(it -&gt; it.resourcePath("trust.p12"))))
        .build();

WebServer.builder()
        .tls(tls);</markup>

</div>


<h4 id="_configuring_tls_in_the_config_file">Configuring TLS in the Config File</h4>
<div class="section">
<p>It is also possible to configure TLS via the config file.</p>

<markup
lang="yaml"
title="WebServer TLS configuration file <code>application.yaml</code>"
>server:
  tls:
    #Truststore setup
    trust:
      keystore:
        passphrase: "password"
        trust-store: true
        resource:
          resource-path: "keystore.p12"
    # Keystore with private key and server certificate
    private-key:
      keystore:
        passphrase: "password"
        resource:
          resource-path: "keystore.p12"</markup>

<p>Then, in your application code, load the configuration from that file.</p>

<markup
lang="java"
title="WebServer initialization using the <code>application.yaml</code> file located on the classpath"
>Config config = Config.create(); <span class="conum" data-value="1" />
WebServer.builder()
        .config(config.get("server")); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1"><code>application.yaml</code> is a default configuration source loaded when YAML support is on classpath, so we can
just use <code>Config.create()</code></li>
<li data-value="2">Server expects the configuration tree located on the node of <code>server</code></li>
</ul>

<p>Or you can only create WebServerTls instance based on the config file.</p>

<markup
lang="java"
title="WebServerTls instance based on <code>application.yaml</code> file located on the classpath"
>Config config = Config.create();
WebServer.builder()
        .tls(it -&gt; it.config(config.get("server.tls")));</markup>

<p>This can alternatively be configured with paths to PKCS#8 PEM files rather than KeyStores:</p>

<markup
lang="yaml"
title="WebServer TLS configuration file <code>application.yaml</code>"
>server:
  tls:
    #Truststore setup
    trust:
      pem:
        certificates:
          resource:
            resource-path: "ca-bundle.pem"
    private-key:
      pem:
        key:
          resource:
            resource-path: "key.pem"
        cert-chain:
          resource:
            resource-path: "chain.pem"</markup>

</div>

</div>


<h3 id="_configuration_options">Configuration Options</h3>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/WebServer.html">io.helidon.webserver.WebServer</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>server</code></p>


<h4 id="_configuration_options_2">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>backlog</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>Accept backlog.</p>

<pre>@return backlog</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-config</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ConnectionConfig">ConnectionConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of a connection (established from client against our server).</p>

<pre>@return connection configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>connection-options</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_socket_SocketOptions">SocketOptions</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Options for connections accepted by this listener.
 This is not used to setup server connection.</p>

<pre>@return socket options</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>content-encoding</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_encoding_ContentEncodingContext">ContentEncodingContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.encoding.ContentEncodingContext.
 This method discards all previously registered ContentEncodingContext.
 If no content encoding context is registered, content encoding context of the webserver would be used.</p>

<pre>@return content encoding context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>features</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ServerFeature[&#93; (service provider interface)</p>

<p>Such as:</p>

<ul class="ulist">
<li>
<p><router-link to="/config/io_helidon_webserver_observe_ObserveFeature">observe (ObserveFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_context_ContextFeature">context (ContextFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_cors_CorsFeature">cors (CorsFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_security_SecurityFeature">security (SecurityFeature)</router-link></p>

</li>
<li>
<p><router-link to="/config/io_helidon_webserver_accesslog_AccessLogFeature">access-log (AccessLogFeature)</router-link></p>

</li>
</ul>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Server features allow customization of the server, listeners, or routings.</p>

<pre>@return server features</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>host</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>0.0.0.0</code></td>
<td class=""><doc-view>
<p>Host of the default socket. Defaults to all host addresses (<code>0.0.0.0</code>).</p>

<pre>@return host address to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT2M</code></td>
<td class=""><doc-view>
<p>How often should we check for #idleConnectionTimeout().
 Defaults to <code>PT2M</code> (2 minutes).</p>

<pre>@return period of checking for idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>idle-connection-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT5M</code></td>
<td class=""><doc-view>
<p>How long should we wait before closing a connection that has no traffic on it.
 Defaults to <code>PT5M</code> (5 minutes). Note that the timestamp is refreshed max. once per second, so this setting
 would be useless if configured for shorter periods of time (also not a very good support for connection keep alive,
 if the connections are killed so soon anyway).</p>

<pre>@return timeout of idle connections</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-concurrent-requests</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of requests that can be executed at the same time (the number of active virtual threads of requests).
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.
 Also make sure that this number is higher than the expected time it takes to handle a single request in your application,
 as otherwise you may stop in-progress requests.</p>

<pre>@return number of requests that can be processed on this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-in-memory-entity</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>131072</code></td>
<td class=""><doc-view>
<p>If the entity is expected to be smaller that this number of bytes, it would be buffered in memory to optimize
 performance when writing it.
 If bigger, streaming will be used.</p>

<pre>Note that for some entity types we cannot use streaming, as they are already fully in memory (String, byte[]), for such
cases, this option is ignored.</pre>
<pre>Default is 128Kb.</pre>
<pre>@return maximal number of bytes to buffer in memory for supported writers</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-payload-size</code></td>
<td class=""><doc-view>
<p>long</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Maximal number of bytes an entity may have.
 If io.helidon.http.HeaderNames#CONTENT_LENGTH is used, this is checked immediately,
 if io.helidon.http.HeaderValues#TRANSFER_ENCODING_CHUNKED is used, we will fail when the
 number of bytes read would exceed the max payload size.
 Defaults to unlimited (<code>-1</code>).</p>

<pre>@return maximal number of bytes of entity</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>max-tcp-connections</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>-1</code></td>
<td class=""><doc-view>
<p>Limits the number of connections that can be opened at a single point in time.
 Defaults to <code>-1</code>, meaning "unlimited" - what the system allows.</p>

<pre>@return number of TCP connections that can be opened to this listener, regardless of protocol</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>media-context</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_http_media_MediaContext">MediaContext</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configure the listener specific io.helidon.http.media.MediaContext.
 This method discards all previously registered MediaContext.
 If no media context is registered, media context of the webserver would be used.</p>

<pre>@return media context</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>@default</code></td>
<td class=""><doc-view>
<p>Name of this socket. Defaults to <code>@default</code>.
 Must be defined if more than one socket is needed.</p>

<pre>@return name of the socket</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>port</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Port of the default socket.
 If configured to <code>0</code> (the default), server starts on a random port.</p>

<pre>@return port to listen on (for the default socket)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocols</code></td>
<td class=""><doc-view>
<p>io.helidon.webserver.spi.ProtocolConfig[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Configuration of protocols. This may be either protocol selectors, or protocol upgraders from HTTP/1.1.
 As the order is not important (providers are ordered by weight by default), we can use a configuration as an object,
 such as:
 &lt;pre&gt;
 protocols:
   providers:
     http_1_1:
       max-prologue-length: 8192
     http_2:
       max-frame-size: 4096
     websocket:
       &#8230;&#8203;.
 &lt;/pre&gt;</p>

<pre>@return all defined protocol configurations, loaded from service loader by default</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener receive buffer size.</p>

<pre>@return buffer size in bytes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-grace-period</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT0.5S</code></td>
<td class=""><doc-view>
<p>Grace period in ISO 8601 duration format to allow running tasks to complete before listener&#8217;s shutdown.
 Default is <code>500</code> milliseconds.
Configuration file values example: <code>PT0.5S</code>, <code>PT2S</code>.</p>

<pre>@return grace period</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>shutdown-hook</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>When true the webserver registers a shutdown hook with the JVM Runtime.</p>

<pre>Defaults to true. Set this to false such that a shutdown hook is not registered.</pre>
<pre>@return whether to register a shutdown hook</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_webserver_ListenerConfig">Map&lt;string, ListenerConfig&gt;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Socket configurations.
 Note that socket named <code>WebServer#DEFAULT_SOCKET_NAME</code> cannot be used,
 configure the values on the server directly.</p>

<pre>@return map of listener configurations, except for the default one</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tls</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_Tls">Tls</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Listener TLS configuration.</p>

<pre>@return tls of this configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>512</code></td>
<td class=""><doc-view>
<p>Initial buffer size in bytes of java.io.BufferedOutputStream created internally to
 write data to a socket connection. Default is <code>512</code>.</p>

<pre>@return initial buffer size used for writing</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>write-queue-length</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>0</code></td>
<td class=""><doc-view>
<p>Number of buffers queued for write operations.</p>

<pre>@return maximal number of queued writes, defaults to 0</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>


<h2 id="_routing">Routing</h2>
<div class="section">
<p>Routing lets you use request matching criteria to bind requests to a <code>handler</code> that implements
your custom business logic. Matching criteria include one or more <strong>HTTP Method(s)</strong> and, optionally,
a request <strong>path matcher</strong>. Use the <code>RequestPredicate</code> class to specify more routing
criteria.</p>


<h3 id="_routing_basics">Routing Basics</h3>
<div class="section">
<p>Routing also supports <em>Error Routing</em> which binds Java <code>Throwable</code> to the
handling logic.</p>

<p>Configure HTTP request routing using <code>HttpRouting.Builder</code>.</p>

<markup
lang="java"
title="Using HttpRouting.Builder to specify how HTTP requests are handled"
>WebServer.builder()
        .routing(it -&gt; it
                .get("/hello", (req, res) -&gt; res.send("Hello World!"))) <span class="conum" data-value="1" />
        .build(); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Handle all GETs to <code>/hello</code> path. Send the <code>Hello World!</code> string.</li>
<li data-value="2">Create a server instance with the provided routing</li>
</ul>

</div>


<h3 id="_http_method_routing">HTTP Method Routing</h3>
<div class="section">
<p><code>HttpRouting.Builder</code> lets you specify how to handle each HTTP method. For example:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 16.667%;">
<col style="width: 83.333%;">
</colgroup>
<thead>
<tr>
<th>HTTP Method</th>
<th>HttpRouting.Builder example</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><strong>GET</strong></td>
<td class=""><code>.get(handler)</code></td>
</tr>
<tr>
<td class=""><strong>PUT</strong></td>
<td class=""><code>.put(handler)</code></td>
</tr>
<tr>
<td class=""><strong>POST</strong></td>
<td class=""><code>.post(handler)</code></td>
</tr>
<tr>
<td class=""><strong>HEAD</strong></td>
<td class=""><code>.head(handler)</code></td>
</tr>
<tr>
<td class=""><strong>DELETE</strong></td>
<td class=""><code>.delete(handler)</code></td>
</tr>
<tr>
<td class=""><strong>TRACE</strong></td>
<td class=""><code>.trace(handler)</code></td>
</tr>
<tr>
<td class=""><strong>OPTIONS</strong></td>
<td class=""><code>.options(handler)</code></td>
</tr>
<tr>
<td class=""><em>any method</em></td>
<td class=""><code>.any(handler)</code></td>
</tr>
<tr>
<td class=""><em>multiple methods</em></td>
<td class=""><code>.route(Method.predicate(Method.GET, Method.POST), path, handler)</code></td>
</tr>
<tr>
<td class=""><em>custom method</em></td>
<td class=""><code>.route(Method.create("CUSTOM"), handler)</code></td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_path_matcher_routing">Path Matcher Routing</h3>
<div class="section">
<p>You can combine HTTP method routing with request path matching.</p>

<markup
lang="java"

>routing.post("/some/path", (req, res) -&gt; { /* handler */ });</markup>

<p>You can use <strong>path pattern</strong> instead of <em>path</em> with the following syntax:</p>

<ul class="ulist">
<li>
<p><code>/foo/bar/baz</code> - Exact path match against resolved path even with non-usual characters</p>

</li>
<li>
<p><code>/foo/*</code> - convenience method to match <code>/foo</code> or any subpath (but not <code>/foobar</code>)</p>

</li>
<li>
<p><code>/foo/{}/baz</code> - <code>{}</code> Unnamed regular expression segment <code>([^/]+)</code></p>

</li>
<li>
<p><code>/foo/{var}/baz</code> - Named regular expression segment <code>([^/]+)</code></p>

</li>
<li>
<p><code>/foo/{var:\d+}</code> - Named regular expression segment with a specified expression</p>

</li>
<li>
<p><code>/foo/{:\d+}</code> - Unnamed regular expression segment with a specified expression</p>

</li>
<li>
<p><code>/foo/{var}` - Convenience shortcut for `{var:.}</code></p>

</li>
<li>
<p><code>/foo/{}` - Convenience shortcut for unnamed segment with regular expression `{:.}</code></p>

</li>
<li>
<p><code>/foo[/bar]</code> - An optional block, which translates to the <code>/foo(/bar)?</code> regular expression</p>

</li>
<li>
<p><code>/<strong></code> or <code>/foo</strong></code> - <code>*</code> Wildcard character can be matched with any number of characters.</p>

</li>
</ul>

<div class="admonition important">
<p class="admonition-inline">Path (matcher) routing is <strong>exact</strong>. For example, a <code>/foo/bar</code> request is <strong>not</strong> routed to <code>.post('/foo', &#8230;&#8203;)</code>.</p>
</div>

<div class="admonition tip">
<p class="admonition-inline">Always start <em>path</em> and <em>path patterns</em> with the <code>/</code> character.</p>
</div>

<p>For more precise setup of path, you can use factory methods on <code>io.helidon.http.PathMatchers</code>
and register using <code>HttpRouting.Builder.route(Predicate&lt;Method&gt;, PathMatcher, Handler)</code> method.</p>

</div>


<h3 id="_using_full_httproute">Using full <code>HttpRoute</code></h3>
<div class="section">
<p>To have more control over selecting which requests should be handled by a specific route,
 you can use the <code>io.helidon.webserver.http.HttpRoute</code> interface using its <code>Builder</code>.</p>

<markup
lang="java"

>routing.route(HttpRoute.builder()
                      .path("/hello")
                      .methods(Method.POST, Method.PUT) <span class="conum" data-value="1" />
                      .handler((req, res) -&gt; {
                          String requestEntity = req.content().as(String.class);
                          res.send(requestEntity); <span class="conum" data-value="2" />
                      }));</markup>

<ul class="colist">
<li data-value="1">The route is specified for <code>GET</code> and <code>POST</code> requests</li>
<li data-value="2">The handler consumes the request payload and echoes it back</li>
</ul>

</div>


<h3 id="_organizing_code_into_services">Organizing Code into Services</h3>
<div class="section">
<p>By implementing the <code>io.helidon.webserver.http.HttpService</code> interface you can organize your code into one
or more services, each with its own path prefix and set of handlers.</p>

<markup
lang="java"
title="Use <code>HttpRouting.Builder.register</code> to register your service"
>routing.register("/hello", new HelloService());</markup>

<markup
lang="java"
title="Service implementation"
>class HelloService implements HttpService {
    @Override
    public void routing(HttpRules rules) {
        rules.get("/subpath", (req, res) -&gt; {
            // Some logic
        });
    }
}</markup>

<p>In this example, the <code>GET</code> handler matches requests to <code>/hello/subpath</code>.</p>

</div>


<h3 id="anchor-http-feature">Using <code>HttpFeature</code></h3>
<div class="section">
<p>By implementing the <code>io.helidon.webserver.http.HttpFeature</code> interface, you can organize multiple routes and/or filters into
a feature, that will be setup according to its defined <code>io.helidon.common.Weight</code> (or using <code>io.helidon.common.Weighted</code>).</p>

<p>Each service has access to the routing builder. HTTP Features are configured for each routing builder. If there is a need
to configure a feature for multiple sockets, you can use <router-link to="#_server_features" @click.native="this.scrollFix('#_server_features')">Server Feature</router-link> instead.</p>

</div>

</div>


<h2 id="_request_handling">Request Handling</h2>
<div class="section">
<p>Implement the logic to handle requests to WebServer in a <code>Handler</code>, which is a <code>FunctionalInterface</code>.
Handlers:</p>

<ul class="ulist">
<li>
<p>Process the request and <router-link to="#anchor-sending-response" @click.native="this.scrollFix('#anchor-sending-response')">send</router-link> a response.</p>

</li>
<li>
<p>Act as a filter and forward requests to downstream handlers using the <code>response.next()</code>
method.</p>

</li>
<li>
<p>Throw an exception to begin <router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">error handling</router-link>.</p>

</li>
</ul>


<h3 id="_process_request_and_produce_response">Process Request and Produce Response</h3>
<div class="section">
<p>Each <code>Handler</code> has two parameters. <code>ServerRequest</code> and <code>ServerResponse</code>.</p>

<ul class="ulist">
<li>
<p>Request provides access to the request method, URI, path, query parameters,
headers and entity.</p>

</li>
<li>
<p>Response provides an ability to set response code, headers, and entity.</p>

</li>
</ul>

</div>


<h3 id="anchor-filtering">Filtering</h3>
<div class="section">
<p>Filtering can be done either using a dedicated <code>Filter</code>, or through routes.</p>


<h4 id="_filter">Filter</h4>
<div class="section">
<p>You can register a <code>io.helidon.webserver.http.Filter</code> with HTTP routing to handle
filtering in interception style.</p>

<p>A simple filter example:</p>

<markup
lang="java"

>routing.addFilter((chain, req, res) -&gt; {
    try {
        chain.proceed();
    } finally {
        // do something for any finished request
    }
});</markup>

</div>


<h4 id="_routes">Routes</h4>
<div class="section">
<p>The handler forwards the request to the downstream handlers by
<em>nexting</em>. There are two options:</p>

<ul class="ulist">
<li>
<p>call <code>res.next()</code></p>
<markup
lang="java"

>rules.any("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // filtering logic  <span class="conum" data-value="2" />
    res.next(); <span class="conum" data-value="3" />
});</markup>

<ul class="colist">
<li data-value="1">handler for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">business logic implementation</li>
<li data-value="3">forward the current request to the downstream handler</li>
</ul>

</li>
<li>
<p>throw an exception to forward to <router-link to="#_error_handling" @click.native="this.scrollFix('#_error_handling')">error handling</router-link></p>
<markup
lang="java"

>rules.any("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // filtering logic (e.g., validating parameters) <span class="conum" data-value="2" />
    if (userParametersOk()) {
        res.next(); <span class="conum" data-value="3" />
    } else {
        throw new IllegalArgumentException("Invalid parameters."); <span class="conum" data-value="4" />
    }
});</markup>

<ul class="colist">
<li data-value="1">handler for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">custom logic</li>
<li data-value="3">forward the current request to the downstream handler</li>
<li data-value="4">forward the request to the error handler</li>
</ul>

</li>
</ul>

</div>

</div>


<h3 id="anchor-sending-response">Sending a Response</h3>
<div class="section">
<p>To complete the request handling, you must send a response by calling the <code>res.send()</code> method.</p>

<div class="admonition important">
<p class="admonition-inline">one of the variants of <code>send</code> method MUST be invoked in the same thread the request is started in; as we run in Virtual Threads, you can simply wait for any asynchronous tasks that must complete before sending a response</p>
</div>

<markup
lang="java"

>rules.get("/hello", (req, res) -&gt; { <span class="conum" data-value="1" />
    // terminating logic
    res.status(Status.ACCEPTED_202)
            .send("Saved!"); <span class="conum" data-value="2" />
});</markup>

<ul class="colist">
<li data-value="1">handler that terminates the request handling for any HTTP method using the <code>/hello</code> path</li>
<li data-value="2">send the response</li>
</ul>

</div>

</div>


<h2 id="_protocol_specific_routing">Protocol-Specific Routing</h2>
<div class="section">
<p>Handling routes based on the protocol version is possible by registering specific routes
on routing builder.</p>

<markup
lang="java"
title="Routing based on HTTP version"
>rules.get("/any-version", (req, res) -&gt; res.send("HTTP Version " + req.prologue().protocolVersion())) <span class="conum" data-value="1" />
        .route(Http1Route.route(Method.GET, "/version-specific", (req, res) -&gt; res.send("HTTP/1.1 route"))) <span class="conum" data-value="2" />
        .route(Http2Route.route(Method.GET, "/version-specific", (req, res) -&gt; res.send("HTTP/2 route"))); <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">An HTTP route registered on <code>/any-version</code> path that prints the version of HTTP protocol</li>
<li data-value="2">An HTTP/1.1 route registered on <code>/version-specific</code> path</li>
<li data-value="3">An HTTP/2 route registered on <code>/version-specific</code> path</li>
</ul>

<p>While <code>Http1Route</code> for Http/1 is always available with Helidon webserver, other routes like <code>Http2Route</code> for <router-link to="#_http2_support" @click.native="this.scrollFix('#_http2_support')">HTTP/2</router-link> needs to be added as additional dependency.</p>

</div>


<h2 id="_requested_uri_discovery">Requested URI Discovery</h2>
<div class="section">
<p>Proxies and reverse proxies between an HTTP client and your Helidon application mask important information (for example <code>Host</code> header, originating IP address, protocol) about the request the client sent.
Fortunately, many of these intermediary network nodes set or update either the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Forwarded">standard HTTP <code>Forwarded</code> header</a> or the <a target="_blank" href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For">non-standard <code>X-Forwarded-*</code> family of headers</a> to preserve information about the original client request.</p>

<p>Helidon&#8217;s requested URI discovery feature allows your application&#8212;&#8203;and Helidon itself&#8212;&#8203;to reconstruct information about the original request using the <code>Forwarded</code> header and the <code>X-Forwarded-*</code> family of headers.</p>

<p>When you prepare the connections in your server you can include the following optional requested URI discovery settings:</p>

<ul class="ulist">
<li>
<p>enabled or disabled</p>

</li>
<li>
<p>which type or types of requested URI discovery to use:</p>
<ul class="ulist">
<li>
<p><code>FORWARDED</code> - uses the <code>Forwarded</code> header</p>

</li>
<li>
<p><code>X_FORWARDED</code> - uses the <code>X-Forwarded-*</code> headers</p>

</li>
<li>
<p><code>HOST</code> - uses the <code>Host</code> header</p>

</li>
</ul>

</li>
<li>
<p>what intermediate nodes to trust</p>

</li>
</ul>

<p>When your application
invokes <code>request.requestedUri()</code>
Helidon iterates through the discovery types you set up for the receiving connection, gathering information from the corresponding header(s) for that type.
If the request does not have the corresponding header(s), or your settings do not trust the intermediate nodes reflected in those headers, then Helidon tries the next discovery type you set up.
Helidon uses the <code>HOST</code> discovery type if you do not set up discovery yourself or if, for a particular request, it cannot assemble the request information using any discovery type you did set up for the socket.</p>


<h3 id="_setting_up_requested_uri_discovery_programmatically">Setting Up Requested URI Discovery Programmatically</h3>
<div class="section">
<p>To set up requested URI discovery on the default socket for your server, use the <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/WebServerConfig.Builder.html"><code>WebServerConfig.Builder</code></a>:</p>

<markup
lang="java"
title="Requested URI set-up for the default server socket"
>import io.helidon.common.configurable.AllowList;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;

import static io.helidon.http.RequestedUriDiscoveryContext.RequestedUriDiscoveryType.FORWARDED;
import static io.helidon.http.RequestedUriDiscoveryContext.RequestedUriDiscoveryType.X_FORWARDED;

AllowList trustedProxies = AllowList.builder()
        .addAllowedPattern(Pattern.compile("lb.+\\.mycorp\\.com"))
        .addDenied("lbtest.mycorp.com")
        .build(); <span class="conum" data-value="1" />

WebServer.builder()
        .requestedUriDiscoveryContext(it -&gt; it
                .addDiscoveryType(FORWARDED) <span class="conum" data-value="2" />
                .addDiscoveryType(X_FORWARDED)
                .trustedProxies(trustedProxies)); <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Create the <code>AllowList</code> describing the intermediate networks nodes to trust and not trust.
Presumably the <code>lbxxx.mycorp.com</code> nodes are trusted load balancers except for the test load balancer <code>lbtest</code>,
and no other nodes are trusted. <code>AllowList</code> accepts prefixes, suffixes, predicates, regex patterns, and exact matches.
See the <a target="_blank" href="/apidocs/io.helidon.common.configurable/io/helidon/common/configurable/AllowList.html"><code>AllowList</code></a> JavaDoc for complete information.</li>
<li data-value="2">Use <code>Forwarded</code> first, then try <code>X-Forwarded-*</code> on each request.</li>
<li data-value="3">Set the <code>AllowList</code> for trusted intermediaries.</li>
</ul>

<p>If you build your server with additional sockets, you can control requested URI discovery separately for each.</p>

</div>


<h3 id="_setting_up_requested_uri_discovery_using_configuration">Setting Up Requested URI Discovery using Configuration</h3>
<div class="section">
<p>You can
also
use configuration to set up the requested URI discovery behavior.
The following example replicates the settings assigned programmatically in the earlier code example:</p>

<markup
lang="yaml"
title="Configuring requested URI behavior"
>server:
  port: 0
  requested-uri-discovery:
    types: FORWARDED,X_FORWARDED
    trusted-proxies:
      allow:
        pattern: "lb.*\\.mycorp\\.com"
      deny:
        exact: "lbtest.mycorp.com""</markup>

</div>


<h3 id="_obtaining_the_requested_uri_information">Obtaining the Requested URI Information</h3>
<div class="section">
<p>Your code obtains the requested URI information from the Helidon server request object:</p>

<markup
lang="java"
title="Retrieving Requested URI Information"
>import io.helidon.common.tls.Tls;
import io.helidon.common.uri.UriInfo;

rules.get((req, res) -&gt; {
    UriInfo uriInfo = req.requestedUri();
    // ...
});</markup>

<p>See the <a target="_blank" href="/apidocs/io.helidon.common.uri/io/helidon/common/uri/UriInfo.html"><code>UriInfo</code></a> JavaDoc for more information.</p>

</div>

</div>


<h2 id="_error_handling">Error Handling</h2>
<div class="section">

<h3 id="_error_routing">Error Routing</h3>
<div class="section">
<p>You may register an error handler for a specific <code>Throwable</code> in a
<code>HttpRouting.Builder</code> method.</p>

<markup
lang="java"

>routing.error(MyException.class, (req, res, ex) -&gt; { <span class="conum" data-value="1" />
    // handle the error, set the HTTP status code
    res.send(errorDescriptionObject); <span class="conum" data-value="2" />
});</markup>

<ul class="colist">
<li data-value="1">Registers an error handler that handles <code>MyException</code> that are thrown from the upstream handlers</li>
<li data-value="2">Finishes the request handling by sending a response</li>
</ul>

<p>Error handlers are called when</p>

<ul class="ulist">
<li>
<p>an exception is thrown from a handler</p>

</li>
</ul>

<p>As with the standard handlers, the error handler must either</p>

<ul class="ulist">
<li>
<p>send a response</p>
<markup
lang="java"

>routing.error(MyException.class, (req, res, ex) -&gt; {
    res.status(Status.BAD_REQUEST_400);
    res.send("Unable to parse request. Message: " + ex.getMessage());
});</markup>

</li>
<li>
<p>or throw an exception</p>
<markup
lang="java"

>routing.error(MyException.class, (req, res, ex) -&gt; {
    // some logic
    throw ex;
});</markup>

</li>
</ul>

<p>Exceptions thrown from error handlers are not error handled, and will end up in an <code>InternalServerError</code>.</p>

</div>


<h3 id="_default_error_handling">Default Error Handling</h3>
<div class="section">
<p>If no user-defined error handler is matched, or if the error handler of the
exception threw an exception, then the exception is translated to an HTTP response as follows:</p>

<ul class="ulist">
<li>
<p>Subtypes of <code>HttpException</code> are translated to their associated HTTP error codes.</p>
<markup
lang="java"
title="Reply with the <code>406</code> HTTP error code by throwing an exception"
>rules.get((req, res) -&gt; {
    throw new HttpException(
            "Amount of money must be greater than 0.",
            Status.NOT_ACCEPTABLE_406); <span class="conum" data-value="1" />
});</markup>

</li>
<li>
<p>Otherwise, the exceptions are translated to an Internal Server Error HTTP
error code <code>500</code>.</p>

</li>
</ul>

</div>


<h3 id="_configuration_options_3">Configuration Options</h3>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.common.tls/io/helidon/common/tls/Tls.html">io.helidon.common.tls.Tls</a></p>


<h4 id="_configuration_options_4">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>cipher-suite</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enabled cipher suites for TLS communication.</p>

<pre>@return cipher suits to enable, by default (or if list is empty), all available cipher suites
        are enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>client-auth</code></td>
<td class=""><doc-view>
<p>TlsClientAuth (REQUIRED, OPTIONAL, NONE)</p>

</doc-view>
</td>
<td class=""><code>NONE</code></td>
<td class=""><doc-view>
<p>Configure requirement for mutual TLS.</p>

<pre>@return what type of mutual TLS to use, defaults to TlsClientAuth#NONE</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Flag indicating whether Tls is enabled.</p>

<pre>@return enabled flag</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint-identification-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>HTTPS</code></td>
<td class=""><doc-view>
<p>Identification algorithm for SSL endpoints.</p>

<pre>@return configure endpoint identification algorithm, or set to `NONE`
        to disable endpoint identification (equivalent to hostname verification).
        Defaults to `Tls#ENDPOINT_IDENTIFICATION_HTTPS`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>internal-keystore-provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Provider of the key stores used internally to create a key and trust manager factories.</p>

<pre>@return keystore provider, if not defined, provider is not specified</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>internal-keystore-type</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Type of the key stores used internally to create a key and trust manager factories.</p>

<pre>@return keystore type, defaults to java.security.KeyStore#getDefaultType()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-manager-factory-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Algorithm of the key manager factory used when private key is defined.
 Defaults to javax.net.ssl.KeyManagerFactory#getDefaultAlgorithm().</p>

<pre>@return algorithm to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>manager</code></td>
<td class=""><doc-view>
<p>io.helidon.common.tls.TlsManager (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The Tls manager. If one is not explicitly defined in the config then a default manager will be created.</p>

<pre>@return the tls manager of the tls instance
@see ConfiguredTlsManager</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>private-key</code></td>
<td class=""><doc-view>
<p>PrivateKey</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Private key to use. For server side TLS, this is required.
 For client side TLS, this is optional (used when mutual TLS is enabled).</p>

<pre>@return private key to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocol</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>TLS</code></td>
<td class=""><doc-view>
<p>Configure the protocol used to obtain an instance of javax.net.ssl.SSLContext.</p>

<pre>@return protocol to use, defaults to `DEFAULT_PROTOCOL`</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>protocols</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Enabled protocols for TLS communication.
 Example of valid values for <code>TLS</code> protocol: <code>TLSv1.3</code>, <code>TLSv1.2</code></p>

<pre>@return protocols to enable, by default (or if list is empty), all available protocols are enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Use explicit provider to obtain an instance of javax.net.ssl.SSLContext.</p>

<pre>@return provider to use, defaults to none (only #protocol() is used by default)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>revocation</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_common_tls_RevocationConfig">RevocationConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Certificate revocation check configuration.</p>

<pre>@return certificate revocation configuration</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secure-random-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Algorithm to use when creating a new secure random.</p>

<pre>@return algorithm to use, by default uses java.security.SecureRandom constructor</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>secure-random-provider</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Provider to use when creating a new secure random.
 When defined, #secureRandomAlgorithm() must be defined as well.</p>

<pre>@return provider to use, by default no provider is specified</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-cache-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>1024</code></td>
<td class=""><doc-view>
<p>SSL session cache size.</p>

<pre>@return session cache size, defaults to 1024</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>session-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT30M</code></td>
<td class=""><doc-view>
<p>SSL session timeout.</p>

<pre>@return session timeout, defaults to 30 minutes</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust</code></td>
<td class=""><doc-view>
<p>X509Certificate[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of certificates that form the trust manager.</p>

<pre>@return certificates to be trusted</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Trust any certificate provided by the other side of communication.</p>

<pre>&lt;b&gt;This is a dangerous setting: &lt;/b&gt; if set to `true`, any certificate will be accepted, throwing away
most of the security advantages of TLS. &lt;b&gt;NEVER&lt;/b&gt; do this in production.</pre>
<pre>@return whether to trust all certificates, do not use in production</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>trust-manager-factory-algorithm</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Trust manager factory algorithm.</p>

<pre>@return algorithm to use</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>


<h2 id="_server_features">Server Features</h2>
<div class="section">
<p>Server features provide additional functionality to the WebServer, through modification of the server configuration,
listener configuration, or routing.</p>

<p>A server feature can be added by implementing <code>io.helidon.webserver.spi.ServerFeature</code>.
Server features support automated discovery, as long as the implementation is available through Java <code>ServiceLoader</code>.
Server features can also be added through configuration, as can be seen above in <router-link to="#_configuration_options" @click.native="this.scrollFix('#_configuration_options')">Configuration Options</router-link>,
configuration key <code>features</code>.</p>

<p>All features (both <code>ServerFeature</code> and <router-link to="#anchor-http-feature" @click.native="this.scrollFix('#anchor-http-feature')">HttpFeature</router-link>) honor weight of the feature
(defined either through <code>@Weight</code> annotation, or by implementing <code>Weighted</code> interface) when registering routes,
<code>HttpService</code>, or <code>Filter</code> to the routing.</p>

<p>The following table shows available server features and their weight. The highest weight is always registered (and invoked)
first.</p>


<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Feature</th>
<th>Weight</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><router-link to="#_context" @click.native="this.scrollFix('#_context')">Context</router-link></td>
<td class="">1100</td>
</tr>
<tr>
<td class=""><router-link to="#_access_log" @click.native="this.scrollFix('#_access_log')">Access Log</router-link></td>
<td class="">1000</td>
</tr>
<tr>
<td class=""><router-link to="/se/tracing">Tracing</router-link></td>
<td class="">900</td>
</tr>
<tr>
<td class=""><router-link to="/se/cors">CORS</router-link></td>
<td class="">850</td>
</tr>
<tr>
<td class=""><router-link to="/se/security/introduction">Security</router-link></td>
<td class="">800</td>
</tr>
<tr>
<td class="">Routing (all handlers and filters)</td>
<td class="">100</td>
</tr>
<tr>
<td class=""><router-link to="/se/openapi/openapi">OpenAPI</router-link></td>
<td class="">90</td>
</tr>
<tr>
<td class=""><router-link to="/se/observability">Observability</router-link></td>
<td class="">80</td>
</tr>
</tbody>
</table>
</div>


<h3 id="_context">Context</h3>
<div class="section">
<p>Context feature adds a filter that executes all requests within the context of <code>io.helidon.common.context.Context</code>.
A <code>Context</code> instance is available on <code>ServerRequest</code> even if this feature is not added. This feature adds support for
obtaining request context through <code>io.helidon.common.context.Contexts.context()</code>.</p>

<p>This feature will provide the same behavior as previous versions of Helidon. Since Helidon 4.0.0, this feature is not
automatically added.</p>

<p>To enable execution of routes within Context, add the following dependency to project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-context&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Context feature can be configured, all options shown below are also available both in config, and programmatically
when using builder.</p>

</div>

</div>


<h2 id="_contextfeature_webserver_context_configuration">ContextFeature (webserver.context) Configuration</h2>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.context/io/helidon/webserver/context/ContextFeature.html">io.helidon.webserver.context.ContextFeature</a></p>

<markup
lang="text"
title="Config key"
>context</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options_5">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of sockets to register this feature on. If empty, it would get registered on all sockets.</p>

<pre>@return socket names to register on, defaults to empty (all available sockets)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>1100.0</code></td>
<td class=""><doc-view>
<p>Weight of the context feature. As it is used by other features, the default is quite high:
 <code>io.helidon.webserver.context.ContextFeature#WEIGHT</code>.</p>

<pre>@return weight of the feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>


<h3 id="_access_log">Access Log</h3>
<div class="section">
<p>Access logging in Helidon is done by a dedicated module that can be
added to WebServer and configured.</p>

<p>Access logging is a Helidon WebServer <code>ServerFeature</code>. Access Log feature has a
very high weight, so it is registered before other features (such as security) that may
terminate a request. This is to ensure the log contains all requests with appropriate status codes.</p>

<p>To enable Access logging add the following dependency to project&#8217;s <code>pom.xml</code>:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-access-log&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h4 id="_configuring_access_log_in_your_code">Configuring Access Log in Your Code</h4>
<div class="section">
<p><code>AccessLogFeature</code> is discovered automatically by default, and configured through <code>server.features.access-log</code>.
You can also configure this feature in code by registering it with WebServer (which will replace the discovered feature).</p>

<markup
lang="java"

>WebServer.builder()
        .addFeature(AccessLogFeature.builder()
                            .commonLogFormat()
                            .build());</markup>

</div>


<h4 id="_configuring_access_log_in_a_configuration_file">Configuring Access Log in a Configuration File</h4>
<div class="section">
<p>Access log can be configured as follows:</p>

<markup
lang="yaml"
title="Access Log configuration file"
>server:
  port: 8080
  features:
    access-log:
      format: "%h %l %u %t %r %s %b %{Referer}i"</markup>

<p>All options shown below are also available programmatically when using builder.</p>

</div>

</div>

</div>


<h2 id="_accesslogfeature_webserver_accesslog_configuration">AccessLogFeature (webserver.accesslog) Configuration</h2>
<div class="section">
<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.accesslog/io/helidon/webserver/accesslog/AccessLogFeature.html">io.helidon.webserver.accesslog.AccessLogFeature</a></p>

<markup
lang="text"
title="Config key"
>access-log</markup>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.spi.ServerFeatureProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options_6">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether this feature will be enabled.</p>

<pre>@return whether enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>format</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>The format for log entries (similar to the Apache <code>LogFormat</code>).
 &lt;table class="config"&gt;
     &lt;caption&gt;Log format elements&lt;/caption&gt;
     &lt;tr&gt;
         &lt;td&gt;%h&lt;/td&gt;
         &lt;td&gt;IP address of the remote host&lt;/td&gt;
         &lt;td&gt;HostLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%l&lt;/td&gt;
         &lt;td&gt;The client identity. This is always undefined in Helidon.&lt;/td&gt;
         &lt;td&gt;UserIdLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%u&lt;/td&gt;
         &lt;td&gt;User ID as asserted by Helidon Security.&lt;/td&gt;
         &lt;td&gt;UserLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%t&lt;/td&gt;
         &lt;td&gt;The timestamp&lt;/td&gt;
         &lt;td&gt;TimestampLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%r&lt;/td&gt;
         &lt;td&gt;The request line (<code>"GET /favicon.ico HTTP/1.0"</code>)&lt;/td&gt;
         &lt;td&gt;RequestLineLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%s&lt;/td&gt;
         &lt;td&gt;The status code returned to the client&lt;/td&gt;
         &lt;td&gt;StatusLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%b&lt;/td&gt;
         &lt;td&gt;The entity size in bytes&lt;/td&gt;
         &lt;td&gt;SizeLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%D&lt;/td&gt;
         &lt;td&gt;The time taken in microseconds (start of request until last byte written)&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%T&lt;/td&gt;
         &lt;td&gt;The time taken in seconds (start of request until last byte written), integer&lt;/td&gt;
         &lt;td&gt;TimeTakenLogEntry&lt;/td&gt;
     &lt;/tr&gt;
     &lt;tr&gt;
         &lt;td&gt;%{header-name}i&lt;/td&gt;
         &lt;td&gt;Value of header <code>header-name</code>&lt;/td&gt;
         &lt;td&gt;HeaderLogEntry&lt;/td&gt;
     &lt;/tr&gt;
 &lt;/table&gt;</p>

<pre>@return format string, such as `%h %l %u %t %r %b %{Referer`i}</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>logger-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>io.helidon.webserver.AccessLog</code></td>
<td class=""><doc-view>
<p>Name of the logger used to obtain access log logger from System#getLogger(String).
 Defaults to <code>AccessLogFeature#DEFAULT_LOGGER_NAME</code>.</p>

<pre>@return name of the logger to use</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>sockets</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of sockets to register this feature on. If empty, it would get registered on all sockets.
 The logger used will have the expected logger with a suffix of the socket name.</p>

<pre>@return socket names to register on, defaults to empty (all available sockets)</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>weight</code></td>
<td class=""><doc-view>
<p>double</p>

</doc-view>
</td>
<td class=""><code>1000.0</code></td>
<td class=""><doc-view>
<p>Weight of the access log feature. We need to log access for anything happening on the server, so weight is high:
 <code>io.helidon.webserver.accesslog.AccessLogFeature#WEIGHT</code>.</p>

<pre>@return weight of the feature</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_supported_technologies">Supported Technologies</h2>
<div class="section">

</div>


<h2 id="_http2_support">HTTP/2 Support</h2>
<div class="section">
<p>Helidon supports HTTP/2 upgrade from HTTP/1, HTTP/2 without prior knowledge, HTTP/2 with prior knowledge, and HTTP/2 with ALPN over TLS.
HTTP/2 support is enabled in WebServer by default when it&#8217;s artifact is available on classpath.</p>


<h3 id="_maven_coordinates">Maven Coordinates</h3>
<div class="section">
<p>To enable HTTP/2 support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-http2&lt;/artifactId&gt;&gt;
&lt;/dependency&gt;</markup>

</div>

</div>


<h2 id="_static_content_support">Static Content Support</h2>
<div class="section">
<p>+Use the <code>io.helidon.webserver.staticcontent.StaticContentService</code> class to serve files and classpath resources.
<code>StaticContentService</code> can be created for any readable directory or classpath
context root and registered on a path in <code>HttpRouting</code>.</p>

<p>You can combine dynamic handlers with <code>StaticContentService</code> objects: if no file matches the request path, then the request is forwarded to
the next handler.</p>


<h3 id="_maven_coordinates_2">Maven Coordinates</h3>
<div class="section">
<p>To enable Static Content Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-static-content&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_registering_static_content">Registering Static Content</h3>
<div class="section">
<p>To register static content based on a file system (<code>/pictures</code>), and classpath (<code>/</code>):</p>

<markup
lang="java"

>routing.register("/pictures", StaticContentService.create(Paths.get("/some/WEB/pics"))) <span class="conum" data-value="1" />
        .register("/", StaticContentService.builder("/static-content") <span class="conum" data-value="2" />
                .welcomeFileName("index.html") <span class="conum" data-value="3" />
                .build());</markup>

<ul class="colist">
<li data-value="1">Create a new <code>StaticContentService</code> object to serve data from the file system,
and associate it with the <code>"/pictures"</code> context path.</li>
<li data-value="2">Create a <code>StaticContentService</code> object to serve resources from the contextual
<code>ClassLoader</code>. The specific classloader can be also
defined. A builder lets you provide more configuration values.</li>
<li data-value="3"><code>index.html</code> is the file that is returned if a directory is requested.</li>
</ul>

<p>A <code>StaticContentService</code> object can be created using <code>create(&#8230;&#8203;)</code> factory methods or a
<code>builder</code>. The <code>builder</code> lets you provide more configuration values, including <em>welcome file-name</em>
and mappings of filename extensions to media types.</p>

</div>

</div>


<h2 id="_media_types_support">Media types support</h2>
<div class="section">
<p>WebServer and WebClient share the HTTP media support of Helidon, and any supported media type can be used in both.
The media type support is automatically discovered from classpath.
Programmatic support is of course enabled as well through <code>MediaContext</code>.</p>

<p>Customized media support for WebServer</p>

<markup
lang="java"

>WebServer.builder()
        .mediaContext(it -&gt; it
                .mediaSupportsDiscoverServices(false)
                .addMediaSupport(JsonpSupport.create())
                .build());</markup>

<p>Each registered (or discovered) media support adds support for writing and reading entities of a specific type.</p>

<p>The following table lists JSON media supports:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 10%;">
<col style="width: 10%;">
<col style="width: 50%;">
<col style="width: 30%;">
</colgroup>
<thead>
<tr>
<th>Media type</th>
<th>TypeName</th>
<th>Maven groupId:artifactId</th>
<th>Supported Java type(s)</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><strong>JSON-P</strong></td>
<td class="">JsonpSupport</td>
<td class=""><code>io.helidon.http.media:helidon-http-media-jsonp</code></td>
<td class=""><code>JsonObject, JsonArray</code></td>
</tr>
<tr>
<td class=""><strong>JSON-B</strong></td>
<td class="">JsonbSupport</td>
<td class=""><code>io.helidon.http.media:helidon-http-media-jsonb</code></td>
<td class="">Any *</td>
</tr>
<tr>
<td class=""><strong>Jackson</strong></td>
<td class="">JacksonSupport</td>
<td class=""><code>io.helidon.http.media:helidon-http-media-jackson</code></td>
<td class="">Any *</td>
</tr>
</tbody>
</table>
</div>

<ul class="ulist">
<li>
<p>JSON-B and Jackson have lower weight, so they are used only when no other media type matched the object being written or read</p>

</li>
</ul>


<h3 id="_json_p_support">JSON-P Support</h3>
<div class="section">
<p>The WebServer supports JSON-P. When enabled, you can send and
receive JSON-P objects transparently.</p>


<h4 id="_maven_coordinates_3">Maven Coordinates</h4>
<div class="section">
<p>To enable JSON Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_usage">Usage</h4>
<div class="section">
<markup
lang="java"
title="Handler that receives and returns JSON objects"
>static final JsonBuilderFactory JSON_FACTORY = Json.createBuilderFactory(Map.of()); <span class="conum" data-value="1" />

rules.post("/hello", (req, res) -&gt; {
    JsonObject requestEntity = req.content().as(JsonObject.class); <span class="conum" data-value="2" />
    JsonObject responseEntity = JSON_FACTORY.createObjectBuilder() <span class="conum" data-value="3" />
            .add("message", "Hello " + requestEntity.getString("name"))
            .build();
    res.send(responseEntity); <span class="conum" data-value="4" />
});</markup>

<ul class="colist">
<li data-value="1">Using a <code>JsonBuilderFactory</code> is more efficient than <code>Json.createObjectBuilder()</code></li>
<li data-value="2">Get the request entity as <code>JsonObject</code></li>
<li data-value="3">Create a new <code>JsonObject</code> for the response entity</li>
<li data-value="4">Send <code>JsonObject</code> in response</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to sayHello endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/sayhello -d '{"name":"Joe"}'</markup>

<markup
lang="json"
title="Response body"
>{"message":"Hello Joe"}</markup>

</div>

</div>


<h3 id="_json_b_support">JSON-B Support</h3>
<div class="section">
<p>The WebServer supports the <a target="_blank" href="http://json-b.net/">JSON-B
specification</a>. When this support is enabled, Java objects will be
serialized to and deserialized from JSON automatically using
<a target="_blank" href="https://github.com/eclipse-ee4j/yasson">Yasson</a>, an implementation of
the <a target="_blank" href="https://jakarta.ee/specifications/jsonb/3.0/jakarta-jsonb-spec-3.0.html">JSON-B specification</a>.</p>


<h4 id="_maven_coordinates_4">Maven Coordinates</h4>
<div class="section">
<p>To enable JSON-B Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonb&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_usage_2">Usage</h4>
<div class="section">
<p>Now that automatic JSON serialization and deserialization facilities
have been set up, you can register a <code>Handler</code> that works with Java
objects instead of raw JSON.  Deserialization from and serialization
to JSON will be handled according to the
<a target="_blank" href="https://jcp.org/en/jsr/detail?id=367">JSON-B specification</a>.</p>

<p>Suppose you have a <code>Person</code> class that looks like this:</p>

<markup
lang="java"
title="Hypothetical <code>Person</code> class"
>public class Person {

    private String name;

    public Person() {
        super();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}</markup>

<p>Then you can set up a <code>Handler</code> like this:</p>

<markup
lang="java"
title="A <code>Handler</code> that works with Java objects instead of raw JSON"
>rules.post("/echo", (req, res) -&gt; {
    res.send(req.content().as(Person.class)); <span class="conum" data-value="1" />
});</markup>

<ul class="colist">
<li data-value="1">This handler consumes a <code>Person</code> instance and simply echoes it back.  Note that there is not working with raw JSON here.</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to the <code>/echo</code> endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/echo -d '{"name":"Joe"}'
{"name":"Joe"}</markup>

</div>

</div>


<h3 id="_jackson_support">Jackson Support</h3>
<div class="section">
<p>The WebServer supports
<a target="_blank" href="https://github.com/FasterXML/jackson#jackson-project-home-github">Jackson</a>.
When this support is enabled, Java objects will be serialized to and
deserialized from JSON automatically using Jackson.</p>


<h4 id="_maven_coordinates_5">Maven Coordinates</h4>
<div class="section">
<p>To enable Jackson Support add the following dependency to your project&#8217;s <code>pom.xml</code>.</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jackson&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_usage_3">Usage</h4>
<div class="section">
<p>Now that automatic JSON serialization and deserialization facilities
have been set up, you can register a <code>Handler</code> that works with Java
objects instead of raw JSON.  Deserialization from and serialization
to JSON will be handled by
<a target="_blank" href="https://github.com/FasterXML/jackson#jackson-project-home-github">Jackson</a>.</p>

<p>Suppose you have a <code>Person</code> class that looks like this:</p>

<markup
lang="java"
title="Hypothetical <code>Person</code> class"
>public class Person {

    private String name;

    public Person() {
        super();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}</markup>

<p>Then you can set up a <code>Handler</code> like this:</p>

<markup
lang="java"
title="A <code>Handler</code> that works with Java objects instead of raw JSON"
>rules.post("/echo", (req, res) -&gt; {
    res.send(req.content().as(Person.class)); <span class="conum" data-value="1" />
});</markup>

<ul class="colist">
<li data-value="1">This handler consumes a <code>Person</code> instance and simply echoes it back.  Note that there is no working with raw JSON here.</li>
</ul>

<markup
lang="bash"
title="Example of posting JSON to the <code>/echo</code> endpoint"
>curl --noproxy '*' -X POST -H "Content-Type: application/json" \
    http://localhost:8080/echo -d '{"name":"Joe"}'</markup>

<markup
lang="json"
title="Response body"
>{"name":"Joe"}</markup>

</div>

</div>

</div>


<h2 id="_http_content_encoding">HTTP Content Encoding</h2>
<div class="section">
<p>HTTP encoding can improve bandwidth utilization and transfer speeds in certain scenarios. It
requires a few extra CPU cycles for compressing and uncompressing, but these can be offset
if data is transferred over low-bandwidth network links.</p>

<p>A client advertises the compression encodings it supports at request time, and the
WebServer responds by selecting an encoding it supports and setting it in a header,
effectively <em>negotiating</em> the content encoding of the response. If none of the
advertised encodings is supported by the WebServer, the response is returned
uncompressed.</p>


<h3 id="_configuring_http_encoding">Configuring HTTP Encoding</h3>
<div class="section">
<p>HTTP encoding support is discovered automatically by WebServer from the classpath, or it can be customized programmatically.</p>

<p>Encoding can be configured per socket.</p>

<p>Disabling discovery and registering a Gzip encoding support:</p>

<markup
lang="java"

>WebServer.builder()
        .contentEncoding(it -&gt; it
        .contentEncodingsDiscoverServices(false)
        .addContentEncoding(GzipEncoding.create()));</markup>

<p>Or use a config file using the following options:</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.http.encoding/io/helidon/http/encoding/ContentEncodingContext.html">io.helidon.http.encoding.ContentEncodingContext</a></p>


<h4 id="_configuration_options_7">Configuration options</h4>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>content-encodings</code></td>
<td class=""><doc-view>
<p>io.helidon.http.encoding.ContentEncoding[&#93; (service provider interface)</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>List of content encodings that should be used.
 Encodings configured here have priority over encodings discovered through service loader.</p>

<pre>@return list of content encodings to be used (such as `gzip,deflate`)</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

<p>The following providers are currently available (simply add the library on the classpath):</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 12.5%;">
<col style="width: 25%;">
<col style="width: 62.5%;">
</colgroup>
<thead>
<tr>
<th>Encoding type</th>
<th>TypeName</th>
<th>Maven groupId:artifactId</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><strong>gzip</strong></td>
<td class="">GzipEncoding</td>
<td class=""><code>io.helidon.http.encoding:helidon-http-encoding-gzip</code></td>
</tr>
<tr>
<td class=""><strong>deflate</strong></td>
<td class="">DeflateSupport</td>
<td class=""><code>io.helidon.http.encoding:helidon-http-encoding-deflate</code></td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h3 id="_http_compression_negotiation">HTTP Compression Negotiation</h3>
<div class="section">
<p>HTTP compression negotiation is controlled by clients using the <code>Accept-Encoding</code> header.
The value of this header is a comma-separated list of encodings. The WebServer
will select one of these encodings for compression purposes; it currently supports <code>gzip</code>
and <code>deflate</code>.</p>

<p>For example, if the request includes <code>Accept-Encoding: gzip, deflate</code>, and HTTP compression
has been enabled as shown above, the response shall include the header <code>Content-Encoding: gzip</code>
and a compressed payload.</p>

</div>

</div>


<h2 id="_proxy_protocol_support">Proxy Protocol Support</h2>
<div class="section">
<p>The <a target="_blank" href="https://www.haproxy.org/download/1.8/doc/proxy-protocol.txt">Proxy Protocol</a>
provides a way to convey client information across reverse
proxies or load balancers which would otherwise be lost given that new connections
are established for each network hop. Often times, this information
can be carried in HTTP headers, but not all proxies support this feature.
Helidon is capable of
parsing a proxy protocol header (i.e., a network preamble) that is based on
either V1 or V2 of the protocol, thus making client information available to
service developers.</p>

<p>Proxy Protocol support is enabled via configuration, and
can be done either declaratively or programmatically. Once enabled, every new
connection on the corresponding port <strong>MUST</strong> be preambled by a proxy header
for the connection not to be rejected as invalid --that is, proxy headers are
never optional.</p>

<p>Programmatically, support for the Proxy Protocol is enabled as follows:</p>

<markup
lang="java"

>WebServer.builder()
        .enableProxyProtocol(true);</markup>

<p>Declaratively, support for the Proxy Protocol is enabled as follows:</p>

<markup
lang="yaml"

>server:
  port: 8080
  host: 0.0.0.0
  enable-proxy-protocol: true</markup>


<h3 id="_accessing_proxy_protocol_data">Accessing Proxy Protocol Data</h3>
<div class="section">
<p>There are two ways in which the header data can be accessed in your application.
One way is by obtaining the protocol data directly from a request as shown
next:</p>

<markup
lang="java"

>rules.get("/", (req, res) -&gt; {
    ProxyProtocolData data = req.proxyProtocolData().orElse(null);
    if (data != null
        &amp;&amp; data.family() == ProxyProtocolData.Family.IPv4
        &amp;&amp; data.protocol() == ProxyProtocolData.Protocol.TCP
        &amp;&amp; data.sourceAddress().equals("192.168.0.1")
        &amp;&amp; data.destAddress().equals("192.168.0.11")
        &amp;&amp; data.sourcePort() == 56324
        &amp;&amp; data.destPort() == 443) {
        // ...
    }
});</markup>

<div class="admonition note">
<p class="admonition-inline">Every request associated with a certain connection shall have
access to the Proxy Protocol data received when the connection was opened.</p>
</div>

<p>Alternatively, the WebServer also makes the original client source
address and source port available in the HTTP headers <code>X-Forwarded-For</code>
and <code>X-Forwarded-Port</code>, respectively. In some cases, it is just simpler
to inspect these headers instead of getting the complete <code>ProxyProtocolData</code>
instance as shown above.</p>

</div>

</div>


<h2 id="_additional_information">Additional Information</h2>
<div class="section">
<p>Here is the code for a minimalist web application that runs on a random free port:</p>

<markup
lang="java"

>public static void main(String[] args) {
    WebServer webServer = WebServer.builder()
            .routing(it -&gt; it.any((req, res) -&gt; res.send("It works!"))) <span class="conum" data-value="1" />
            .build() <span class="conum" data-value="2" />
            .start(); <span class="conum" data-value="3" />

    System.out.println("Server started at: http://localhost:" + webServer.port()); <span class="conum" data-value="4" />
}</markup>

<ul class="colist">
<li data-value="1">For any kind of request, at any path, respond with <code>It works!</code>.</li>
<li data-value="2">Build the server with the provided configuration</li>
<li data-value="3">Start the server (and wait for it to open the port).</li>
<li data-value="4">The server is bound to a random free port.</li>
</ul>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webserver/module-summary.html">Helidon WebServer JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.webserver.staticcontent/module-summary.html">Helidon WebServer Static Content JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.http.media.jsonp/module-summary.html">Helidon JSON-B Support JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.http.media.jsonb/module-summary.html">Helidon JSON-P Support JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="/apidocs/io.helidon.http.media.jackson/module-summary.html">Helidon Jackson Support JavaDoc</a></p>

</li>
<li>
<p><a target="_blank" href="https://www.haproxy.org/download/1.8/doc/proxy-protocol.txt">Proxy Protocol Specification</a></p>

</li>
</ul>

</div>

</doc-view>
