<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_helidon_metrics_api" @click.native="this.scrollFix('#_helidon_metrics_api')">Helidon Metrics API</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_example_application_code" @click.native="this.scrollFix('#_example_application_code')">Example Application Code</router-link></p>

</li>
<li>
<p><router-link to="#example-configuration" @click.native="this.scrollFix('#example-configuration')">Example Configuration</router-link></p>

</li>
</ul>

</li>
<li>
<p><router-link to="#config-rest-request" @click.native="this.scrollFix('#config-rest-request')">Additional Information</router-link></p>
<ul class="ulist">
<li>
<p><router-link to="#_support_for_the_prometheus_metrics_api" @click.native="this.scrollFix('#_support_for_the_prometheus_metrics_api')">Support for the Prometheus Metrics API</router-link></p>

</li>
</ul>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon SE metrics is a neutral metrics API which provides</p>

<ul class="ulist">
<li>
<p>a unified way for
Helidon
servers to export monitoring data&#8212;&#8203;telemetry&#8212;&#8203;to management agents, and</p>

</li>
<li>
<p>a unified Java API which all application programmers can use to register and update meters to expose telemetry data from their services.</p>

</li>
</ul>

<p>Metrics is one of the Helidon observability features.</p>


<h3 id="_a_word_about_terminology">A Word about Terminology</h3>
<div class="section">
<p>Helidon SE uses the term "metrics" to refer to the subsystem in Helidon which manages the registration of, updates to,
 and reporting of aggregate statistical measurements about the service.
The term "meter" refers to an entity which collects these measurements, such as a counter or a timer.</p>

</div>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable metrics
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"
title="Packaging the metrics API"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-api&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>This dependency adds the metrics API and a no-op implementation of that API to your project.
The no-op implementation:</p>

<ul class="ulist">
<li>
<p>does not register meters in a registry</p>

</li>
<li>
<p>does not update meter values</p>

</li>
<li>
<p>does not expose the metrics endpoint for reporting meter values.</p>

</li>
</ul>

<p>To include the full-featured metrics implementation, add the following dependency to your project:</p>

<markup
lang="xml"
title="Packaging a full-featured metrics implementation"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webserver.observe&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webserver-observe-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Adding this dependency packages the full-featured metrics implementation and support for the metrics endpoint with your service.</p>

<p>You might notice the transitive dependency <code>io.helidon.metrics.providers:helidon-metrics-providers-micrometer</code> in your project.
This component contains an implementation of the Helidon metrics API that uses Micrometer as the underlying metrics technology.</p>

<p>Helidon provides several built-in meters in a separate artifact.
To include the build-in meters, add the following dependency to your project:</p>

<markup
lang="xml"
title="Packaging the built-in meters"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-system-meters&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">

<h3 id="_instrumenting_your_service">Instrumenting Your Service</h3>
<div class="section">
<p>You add meters to your service
by writing code which explicitly invokes the metrics API to register meters, retrieve previously-registered meters, and update meter values.</p>

<p>Later sections of this document describe how to do
this.</p>

</div>


<h3 id="_categorizing_types_of_meters">Categorizing Types of Meters</h3>
<div class="section">
<p>Helidon distinguishes among <em>scopes</em>, or types, of
meters.</p>

<p>Helidon includes meters in the built-in scopes described below.
Applications often register their own meters in the <code>application</code> scope but can create their own scopes and register meters within them.</p>

<div class="block-title"><span>Built-in meter scopes</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Built-in Scope</th>
<th>Typical Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>base</code></td>
<td class="">OS or Java runtime measurements (available heap, disk space, etc.).</td>
</tr>
<tr>
<td class=""><code>vendor</code></td>
<td class="">Implemented by vendors, including the <code>REST.request</code> metrics and other key performance indicator measurements (described in later sections).</td>
</tr>
<tr>
<td class=""><code>application</code></td>
<td class="">Declared via annotations or programmatically registered by your service code.</td>
</tr>
</tbody>
</table>
</div>

<p>When an application creates a new meter it can specify which scope the meter belongs to. If the application does not specify a scope for a new meter, the default scope is <code>application</code>.</p>

</div>


<h3 id="_meter_registry">Meter Registry</h3>
<div class="section">
<p>Helidon stores all meters in a <em>meter registry</em>. Typically, applications use the global meter registry which is the registry where Helidon stores built-in meters.
Application code refers to the global registry using <code>Metrics.globalRegistry()</code>.</p>

</div>


<h3 id="_retrieving_metrics_reports_from_your_service">Retrieving Metrics Reports from your Service</h3>
<div class="section">
<p>When you add the
<code>helidon-webserver-observe-metrics</code> dependency
to your project, Helidon automatically provides a built-in REST endpoint <code>/observe/metrics</code> which responds with a report of the registered meters and their values.</p>

<p>Clients can request a particular output format.</p>

<div class="block-title"><span>Formats for <code>/observe/metrics</code> output</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Format</th>
<th>Requested by</th>
</tr>
</thead>
<tbody>
<tr>
<td class="">OpenMetrics (Prometheus)</td>
<td class="">default (<code>text/plain</code>)</td>
</tr>
<tr>
<td class="">JSON</td>
<td class="">Header <code>Accept: application/json</code></td>
</tr>
</tbody>
</table>
</div>

<p>Clients can also limit the report by specifying the scope as a query parameter in the request URL:</p>

<ul class="ulist">
<li>
<p><code>/observe/metrics?scope=base</code></p>

</li>
<li>
<p><code>/observe/metrics?scope=vendor</code></p>

</li>
<li>
<p><code>/observe/metrics?scope=application</code></p>

</li>
</ul>

<p>Further, clients can narrow down to a specific metric name by adding the name as another query parameter, such as <code>/observe/metrics?scope=application&amp;name=myCount</code>.</p>

<markup
lang="bash"
title="Example Reporting: Prometheus format"
>curl -s -H 'Accept: text/plain' -X GET http://localhost:8080/observe/metrics</markup>

<markup
lang="text"

># TYPE base:classloader_total_loaded_class_count counter
# HELP base:classloader_total_loaded_class_count Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
base:classloader_total_loaded_class_count 3157</markup>

<markup
lang="bash"
title="Example Reporting: JSON format"
>curl -s -H 'Accept: application/json' -X GET http://localhost:8080/observe/metrics</markup>

<markup
lang="json"
title="JSON response:"
>{
   "base" : {
      "memory.maxHeap" : 3817865216,
      "memory.committedHeap" : 335544320
    }
}</markup>

<p>In addition to your application meters, the reports contain other
meters of interest such as system and VM information.</p>

</div>


<h3 id="_enabling_the_metrics_rest_service">Enabling the Metrics REST Service</h3>
<div class="section">
<p>If you add the dependencies described above, your service automatically supports the metrics REST endpoint as long as the <code>WebServer</code> is configured to discover features automatically.</p>

<p>If you disable auto-discovery, you can add the metrics observer explicitly.</p>

<ol style="margin-left: 15px;">
<li>
Create an instance of <code>MetricsObserver</code>, either directly as shown below or using its builder.

</li>
<li>
Include the <code>MetricsObserver</code> instance in your application&#8217;s <code>ObserveFeature</code>.

</li>
<li>
Register your <code>ObserveFeature</code> with your <code>WebServer</code>.

</li>
</ol>

<markup
lang="java"

>ObserveFeature observe = ObserveFeature.builder()
        .config(config.get("server.features.observe"))
        .addObserver(MetricsObserver.create())
        .build();

WebServer server = WebServer.builder()
        .config(Config.global().get("server"))
        .featuresDiscoverServices(false)
        .addFeature(observe)
        .routing(Main::routing)
        .build()
        .start();</markup>

</div>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>To work with Helidon Metrics in your code, follow these steps:</p>

<ol style="margin-left: 15px;">
<li>
Use the static <code>globalRegistry</code> method on the <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/Metrics.html"><code>Metrics</code></a> interface to get a reference to the global  <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/MeterRegistry.html"><code>MeterRegistry</code></a> instance.

</li>
<li>
Use the <code>MeterRegistry</code> instance to register new meters and look up previously-registered meters.

</li>
<li>
Use the meter reference returned from the <code>MeterRegistry</code> to update the meter or get its value.

</li>
</ol>

<p>You can also use the <code>MeterRegistry</code> to remove an existing meter.</p>


<h3 id="_helidon_metrics_api">Helidon Metrics API</h3>
<div class="section">
<p>The Helidon Metrics API defines the classes and interfaces for meter types and other related items.</p>

<p>The following table summarizes the meter types.</p>

<div class="block-title"><span>Meter Types</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Meter Type</th>
<th>Usage</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/Counter.html"><code>Counter</code></a></td>
<td class="">Monotonically increasing count of events.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/Gauge.html"><code>Gauge</code></a></td>
<td class="">Access to a value managed by other code in the service.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/DistributionSummary.html"><code>DistributionSummary</code></a></td>
<td class="">Calculates the distribution of a value.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/Timer.html"><code>Timer</code></a></td>
<td class="">Frequency of invocations and the distribution of how long the invocations take.</td>
</tr>
</tbody>
</table>
</div>

<p>Each meter type has its own set of methods for updating and retrieving the value.</p>

</div>


<h3 id="_the_meterregistry_api">The <code>MeterRegistry</code> API</h3>
<div class="section">
<p>To register or look up meters programmatically, your service code uses the global <code>MeterRegistry</code>.
Simply invoke <code>Metrics.globalRegistry()</code> to get a reference to the global meter registry.</p>

<p>To locate an existing meter or register a new one, your code:</p>

<ol style="margin-left: 15px;">
<li>
Creates a builder of the appropriate type of meter, setting the name and possibly other characteristics of the meter.

</li>
<li>
Invokes the <code>MeterRegistry.getOrCreate</code> method, passing the builder.

</li>
</ol>

<p>The meter registry returns a reference to a previously-registered meter with the specified name and tags or, if none exists, a newly-registered meter.
Your code can then operate on the returned meter as needed to record new measurements or retrieve existing data.</p>

<p>The example code in the <router-link to="#_examples" @click.native="this.scrollFix('#_examples')"></router-link> section below illustrates how to register, retrieve, and update meters.</p>

</div>


<h3 id="_accessing_the_underlying_implementation_unwrap">Accessing the Underlying Implementation: <code>unwrap</code></h3>
<div class="section">
<p>The neutral Helidon metrics API is an abstraction of common metrics behavior independent from any given implementation. As such, we intentionally excluded some implementation-specific behavior from the API.</p>

<p>Sometimes you might want access to methods that are present in a particular metrics implementation but not in the Helidon API. Helidon allows that via the <code>unwrap</code> method on the meter types and on their builders. Each full implementation of the Helidon meter types and their builders refers to a delegate meter or delegate builder internally. The <code>unwrap</code> method lets you obtain the delegate, cast to the type you want.</p>

<p>Of course, using this technique binds your code to a particular metrics implementation.</p>

<p>The <a target="_blank" href="/apidocs/io.helidon.metrics.api/io/helidon/metrics/api/Wrapper.html"><code>Wrapper</code></a> interface declares the <code>unwrap</code> method which accepts a class parameter to which the delegate is cast. You can then invoke any method declared on the implementation-specific type.</p>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>To control how the Helidon metrics subsystem behaves, add a <code>metrics</code> section to
your configuration file, such as <code>application.yaml</code>.</p>

<p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver.observe.metrics/io/helidon/webserver/observe/metrics/MetricsObserver.html">io.helidon.webserver.observe.metrics.MetricsObserver</a></p>

<p>This is a standalone configuration type, prefix from configuration root: <code>metrics</code></p>

<p>This type provides the following service implementations:</p>

<ul class="ulist">
<li>
<p><code>io.helidon.webserver.observe.spi.ObserveProvider</code></p>

</li>
</ul>


<h3 id="_configuration_options">Configuration options</h3>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>app-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Value for the application tag to be added to each meter ID.</p>

<pre>@return application tag value</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>app-tag-name</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Name for the application tag to be added to each meter ID.</p>

<pre>@return application tag name</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Whether metrics functionality is enabled.</p>

<pre>@return if metrics are configured to be enabled</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>endpoint</code></td>
<td class=""><doc-view>
<p>string</p>

</doc-view>
</td>
<td class=""><code>metrics</code></td>
<td class=""><doc-view>

</doc-view>
</td>
</tr>
<tr>
<td class=""><code>key-performance-indicators</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_KeyPerformanceIndicatorMetricsConfig">KeyPerformanceIndicatorMetricsConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Key performance indicator metrics settings.</p>

<pre>@return key performance indicator metrics settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>permit-all</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether to allow anybody to access the endpoint.</p>

<pre>@return whether to permit access to metrics endpoint to anybody, defaults to `true`
@see #roles()</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>rest-request-enabled</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Whether automatic REST request metrics should be measured.</p>

<pre>@return true/false</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>roles</code></td>
<td class=""><doc-view>
<p>string[&#93;</p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Hints for role names the user is expected to be in.</p>

<pre>@return list of hints</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>scoping</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_ScopingConfig">ScopingConfig</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Settings related to scoping management.</p>

<pre>@return scoping settings</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tags</code></td>
<td class=""><doc-view>
<p><router-link to="/config/io_helidon_metrics_api_Tag">Tag[&#93;</router-link></p>

</doc-view>
</td>
<td class="">&#160;</td>
<td class=""><doc-view>
<p>Global tags.</p>

<pre>@return name/value pairs for global tags</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>Helidon SE includes several pre-written example applications illustrating aspects of metrics:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.10/examples/metrics/filtering/se">Enabling/disabling meters</a> using
<code>MetricsObserver</code> and <code>MetricsConfig</code></p>

</li>
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.10/examples/metrics/kpi">Controlling key performance indicator metrics</a> using configuration and <code>KeyPerformanceIndicatorMetricsSettings</code>.</p>

</li>
</ul>

<p>The rest of this section shows how to add a custom meter to your code and how to configure the Helidon metrics subsystem.</p>


<h3 id="_example_application_code">Example Application Code</h3>
<div class="section">
<p>The following example, based on the Helidon SE QuickStart application, shows how to register and update a new <code>Counter</code> in application code.
 The counter tracks the number of times any of the service endpoints is accessed.</p>

<markup
lang="java"
title="Define and use a <code>Counter</code>"
>public class GreetService implements HttpService {

    private final Counter accessCtr = Metrics.globalRegistry() <span class="conum" data-value="1" />
            .getOrCreate(Counter.builder("accessctr")); <span class="conum" data-value="2" />

    @Override
    public void routing(HttpRules rules) {
        rules
                .any(this::countAccess) <span class="conum" data-value="3" />
                .get("/", this::getDefaultMessageHandler)
                .get("/{name}", this::getMessageHandler)
                .put("/greeting", this::updateGreetingHandler);

    }

    void countAccess(ServerRequest request,
                     ServerResponse response) {

        accessCtr.increment(); <span class="conum" data-value="4" />
        response.next();
    }

    void getDefaultMessageHandler(ServerRequest request,
                                  ServerResponse response) {
        // ...
    }

    void getMessageHandler(ServerRequest request,
                           ServerResponse response) {
        // ...
    }

    void updateGreetingHandler(ServerRequest request,
                               ServerResponse response) {
        // ...
    }
}</markup>

<ul class="colist">
<li data-value="1">Get the global meter registry.</li>
<li data-value="2">Create (or find) a counter named "accessctr" in the global registry.</li>
<li data-value="3">Route every request to the <code>countAccess</code> method.</li>
<li data-value="4">Increment the access counter for every request.</li>
</ul>

<p>Perform the following steps to see the new counter in action.</p>

<markup
lang="bash"
title="Build and run the application"
>mvn package
java -jar target/helidon-quickstart-se.jar</markup>

<markup
lang="bash"
title="Retrieve <code>application</code> metrics"
>curl 'http://localhost:8080/observe/metrics?scope=application' <span class="conum" data-value="1" /></markup>

<markup
lang="text"
title="Response"
># HELP accessctr_total
# TYPE accessctr_total counter
accessctr_total{scope="application",} 0.0 <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Access the metrics endpoint, selecting only application meters.</li>
<li data-value="2">Note the counter is zero; we have not accessed a service endpoint yet.</li>
</ul>

<markup
lang="bash"
title="Access a service endpoint to retrieve a greeting"
>curl http://localhost:8080/greet</markup>

<markup
lang="json"
title="JSON response:"
>{"message":"Hello World"}</markup>

<markup
lang="bash"
title="Retrieve <code>application</code> metrics again"
>curl 'http://localhost:8080/observe/metrics?scope=application'</markup>

<markup
lang="text"
title="Response"
># HELP accessctr_total
# TYPE accessctr_total counter
accessctr_total{scope="application",} 1.0 <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">The counter now reports 1, reflecting our earlier access to the <code>/greet</code> endpoint.</li>
</ul>

</div>


<h3 id="example-configuration">Example Configuration</h3>
<div class="section">
<p>Metrics configuration is quite extensive and powerful and, therefore, a bit complicated.
The rest of this section illustrates some of the most common scenarios:</p>

<ul class="ulist">
<li>
<p><router-link to="#config-disable" @click.native="this.scrollFix('#config-disable')">Disable metrics entirely.</router-link></p>

</li>
<li>
<p><router-link to="#config-kpi" @click.native="this.scrollFix('#config-kpi')">Choose whether to collect extended key performance indicator metrics.</router-link></p>

</li>
</ul>


<h4 id="config-disable">Disable Metrics Subsystem</h4>
<div class="section">
<markup
lang="yaml"
title="Disabling metrics entirely"
>server:
  features:
    observe:
      observers:
        metrics:
          enabled: false</markup>

<p>Helidon does not update metrics, and the <code>/observe/metrics</code> endpoints respond with <code>404</code>..</p>

</div>


<h4 id="config-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Meters</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks a basic performance indicator meter: a <code>Counter</code> of all requests received (<code>requests.count</code>)</p>

<p>Helidon SE also includes additional, extended KPI meters which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>Gauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Counter</code> (<code>requests.longRunning</code>) measuring the total number of requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Counter</code> (<code>requests.load</code>) measuring the number of requests worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Gauge</code> (<code>requests.deferred</code>) measuring delayed request processing (work on a request was delayed after Helidon received the request)</p>

</li>
</ul>

<p>You can enable and control these meters using configuration:</p>

<markup
lang="yaml"
title="Controlling extended KPI meters"
>server:
  features:
    observe:
      observers:
        metrics:
          key-performance-indicators:
            extended: true
            long-running:
              threshold-ms: 2000</markup>

</div>

</div>

</div>


<h2 id="config-rest-request">Additional Information</h2>
<div class="section">

<h3 id="_support_for_the_prometheus_metrics_api">Support for the Prometheus Metrics API</h3>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
</ul>

<p>Helidon provides optional support for the Prometheus metrics API.</p>

<p>To use it, your service registers Prometheus support with your routing set-up.
You can customize its configuration. For information about using Prometheus, see the
Prometheus documentation: <a target="_blank" href="https://prometheus.io/docs/introduction/overview/" class="bare">https://prometheus.io/docs/introduction/overview/</a>.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon&#8217;s fully-functional, built-in metrics implementation supports Prometheus (OpenMetrics) output.
 Use the optional support described in <em>this</em> section only if you want to use the Prometheus <em>API</em> from your application code.</p>
</div>


<h4 id="prom-maven-coordinates">Maven Coordinates</h4>
<div class="section">
<markup
lang="xml"
title="Dependency for Helidon Prometheus API support"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.metrics&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-metrics-prometheus&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="prom-usage">Usage</h4>
<div class="section">
<p>Your application code uses the Prometheus API to manage metrics.
To expose those metrics to clients via a REST endpoint, your code uses the <code>PrometheusSupport</code> interface which Helidon provides.</p>

</div>


<h4 id="prom-api">API</h4>
<div class="section">
<p>Your code creates a <a target="_blank" href="/apidocs/io.helidon.metrics.prometheus/io/helidon/metrics/prometheus/PrometheusSupport.html"><code>PrometheusSupport</code></a> object either using a static factory method (shown in the following example) or by using its <a target="_blank" href="/apidocs/io.helidon.metrics.prometheus/io/helidon/metrics/prometheus/PrometheusSupport.Builder.html"><code>Builder</code></a>.</p>

<markup
lang="java"

>routing
        .addFeature(PrometheusSupport.create())
        .register("/myapp", new MyService());</markup>

<p>This example uses the default Prometheus <code>CollectorRegistry</code>. By default, the <code>PrometheusSupport</code> and exposes its REST endpoint at the path
<code>/metrics</code>. Use the builder obtained by <code>PrometheusSupport.builder()</code> to
configure a different <code>CollectorRegistry</code> or a different path.</p>

</div>

</div>

</div>

</doc-view>
