<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_references" @click.native="this.scrollFix('#_references')">References</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon SE OCI Integration provides easy access to Oracle Cloud Infrastructure using the OCI Java SDK.</p>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p>It is recommended that you use the OCI Java SDK directly, in particular the Async clients. All you need to do is configure and create an OCI SDK Client object. The configuration primarily
consists of setting up authenticate with OCI.</p>


<h3 id="_configuring_the_oci_sdk_client">Configuring the OCI SDK Client</h3>
<div class="section">
<p>Authentication with OCI is abstracted through <code>AuthenticationDetailsProvider</code>.</p>

<p>If your environment is already set up to work with the OCI SDK or
the OCI command line, then it is very likely you do not need to do any additional
configuration. It is recommended that you do this first, and verify your configuration
by using the <a target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/API/SDKDocs/javasdk.htm">OCI CLI</a> to access the service.</p>

<markup
lang="java"

>ConfigFile config = ConfigFileReader.parse("~/.oci/config", "DEFAULT");
AuthenticationDetailsProvider authProvider = new ConfigFileAuthenticationDetailsProvider(config);</markup>

<p>You also need to add the following dependency to your application for this</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;com.oracle.oci.sdk&lt;/groupId&gt;
    &lt;artifactId&gt;oci-java-sdk-common-httpclient-jersey3&lt;/artifactId&gt;
    &lt;scope&gt;runtime&lt;/scope&gt;
&lt;/dependency&gt;</markup>

</div>


<h3 id="_accessing_oci_services">Accessing OCI Services</h3>
<div class="section">
<p>Once you have authentication with OCI configured, you can use it to access any OCI service
supported by the OCI SDK. You will need to add dependencies for the specific
ODI SDK clients you will use.</p>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>This example describes how to access OCI Object Storage.</p>

<p>As mentioned above in <router-link to="#_accessing_oci_services" @click.native="this.scrollFix('#_accessing_oci_services')"></router-link>, you need to add a dependency on the OCI SDK
Object Storage API:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;com.oracle.oci.sdk&lt;/groupId&gt;
    &lt;artifactId&gt;oci-java-sdk-objectstorage&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>


<h3 id="_creating_an_object_storage_client">Creating an Object Storage Client</h3>
<div class="section">
<p>Now you can create OCI SDK Clients.</p>

<markup
lang="java"

>ConfigFile config = ConfigFileReader.parse("~/.oci/config", "DEFAULT");
AuthenticationDetailsProvider authProvider = new ConfigFileAuthenticationDetailsProvider(config);
ObjectStorageAsync objectStorageAsyncClient = new ObjectStorageAsyncClient(authProvider);</markup>

</div>


<h3 id="_using_the_object_storage_client">Using the Object Storage client</h3>
<div class="section">
<p>Once you have created an ObjectStorage client you can use it as described in:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://docs.oracle.com/en-us/iaas/tools/java/latest/com/oracle/bmc/objectstorage/package-summary.html">OCI SDK Object Storage Javadocs</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.cloud.oracle.com/iaas/Content/Object/Concepts/objectstorageoverview.htm">OCI Object Storage Overview</a></p>

</li>
</ul>

</div>

</div>


<h2 id="_references">References</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.10/examples/integrations/oci">OCI SDK Usage Examples</a></p>

</li>
<li>
<p><a target="_blank" href="https://docs.oracle.com/en-us/iaas/Content/home.htm">OCI Documentation</a></p>

</li>
</ul>

</div>

</doc-view>
