<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon SE WebClient Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon SE project
that can be used to run some basic examples using WebClient.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What you need</h2>
<div class="section">
<p>For this 15 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon SE Application</td>
<td class="">You can use your own application or use the
 <router-link to="/se/guides/quickstart">Helidon SE Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>

<ul class="ulist">
<li>
<p><router-link to="#WebClient-features" @click.native="this.scrollFix('#WebClient-features')">WebClient features</router-link></p>

</li>
<li>
<p><router-link to="#WebClient-usage" @click.native="this.scrollFix('#WebClient-usage')">WebClient usage</router-link></p>

</li>
<li>
<p><router-link to="#WebClient-Metrics" @click.native="this.scrollFix('#WebClient-Metrics')">WebClient Metrics</router-link></p>

</li>
</ul>


<h3 id="WebClient-features">WebClient Features</h3>
<div class="section">
<p>Helidon&#8217;s WebClient is used to perform HTTP REST requests to target endpoints and handle their responses.</p>

<p><strong>Note</strong>: WebClient is still experimental and not intended for production use. APIs and features are not yet fully tested
and are subject to change.</p>

<p>WebClient provides the following features:</p>

<ul class="ulist">
<li>
<p><strong>User-friendly</strong>:
Every client and request is created by a builder pattern, so it improves readability and code maintenance.</p>

</li>
<li>
<p><strong>Following redirects</strong>:
The WebClient is able to follow the redirect chain and perform requests on the correct endpoint for you. You no longer
have to point your client to the correct/final endpoint.</p>

</li>
<li>
<p><strong>Tracing, metrics and security propagation</strong>:
When you configure the Helidon WebServer to use tracing, metrics and security, the settings are automatically
propagated to the WebClient and used during request/response.</p>

</li>
</ul>

<p>For more information about the <code>WebClient</code>, please refer to the <router-link to="/se/webclient">WebClient Introduction</router-link>.</p>

</div>


<h3 id="WebClient-usage">WebClient Usage</h3>
<div class="section">

<h4 id="_create_a_sample_se_project">Create a sample SE project</h4>
<div class="section">
<p>Generate the project sources using the Helidon SE Maven archetype.
The result is a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype:"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-se \
    -DarchetypeVersion=4.0.10 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-se \
    -Dpackage=io.helidon.examples.quickstart.se</markup>

<p>You should now have a directory called <code>helidon-quickstart-se</code>.</p>

<markup
lang="bash"
title="Open this directory"
>cd helidon-quickstart-se</markup>

<p>The Helidon quickstart is a greeting application supporting several HTTP requests such as GET and PUT. Using it will
be time-saving for this exercise as it will allow us to modify the project to demonstrate some of the Webclient features and usability, rather than start from scratch.</p>

</div>


<h4 id="_add_clientexample_class">Add ClientExample class</h4>
<div class="section">
<p>In <code>io.helidon.examples.quickstart.se</code> package, create a new class named ClientExample. This class will use the
WebClient to send request to the greeting application.</p>

<markup
lang="java"
title="Create ClientExample class:"
>public class ClientExample {

    public static void main(String[] args) {

    }
}</markup>

<p>Add the following code to the main method to create a WebClient instance.
The builder approach allows you to create the WebClient with specific settings and improves the readability and simplicity of the
code.</p>

<markup
lang="java"
title="Add WebClient instance to the main method:"
>WebClient webClient = WebClient.builder()
        .baseUri("http://localhost:8080") <span class="conum" data-value="1" />
        .build();</markup>

<ul class="colist">
<li data-value="1">The base URI of the outbound requests.</li>
</ul>

<p>By default, the Helidon quickstart application runs on localhost:8080. If for some reason the host name or port
number of the quickstart application is changed, make sure that the baseURI is also modified to reflect that change.
Once built, the WebClient can
be used to send a GET request to the greeting application.</p>

<markup
lang="java"
title="Send a GET request to the target endpoint:"
>ClientResponseTyped&lt;String&gt; response = webClient.get() <span class="conum" data-value="1" />
        .path("/greet") <span class="conum" data-value="2" />
        .request(String.class); <span class="conum" data-value="3" />
String entityString = response.entity(); <span class="conum" data-value="4" />
System.out.println(entityString);</markup>

<ul class="colist">
<li data-value="1">Create an HTTP GET request.</li>
<li data-value="2">Target endpoint path.</li>
<li data-value="3">Execute the request</li>
<li data-value="4">Return response entity handled as a String.</li>
</ul>

<p>The path method appends <code>/greet</code> to the WebClient base URI which results to the request URI becoming
<code><a target="_blank" href="http://localhost:8080/greet" class="bare">http://localhost:8080/greet</a></code>. The received response entity will be a greeting message and will be
automatically handled as a String. If no specific type is set in the method request(),
<code>HttpClientResponse</code> will be returned by default. This <code>HttpClientResponse</code> object contains response code, headers and entity.</p>

</div>


<h4 id="_run_the_application">Run the application</h4>
<div class="section">
<markup
lang="bash"
title="Build the quickstart:"
>mvn package</markup>

<p>This command will create helidon-quickstart-se.jar in the target folder.</p>

<markup
lang="bash"
title="Run the greeting application:"
>java -cp target/helidon-quickstart-se.jar io.helidon.examples.quickstart.se.Main</markup>

<p>Open a new command prompt or terminal and run the ClientExample class you just created.</p>

<markup
lang="bash"
title="Run the client application:"
>java -cp target/helidon-quickstart-se.jar io.helidon.examples.quickstart.se.ClientExample</markup>

<markup
lang="json"
title="JSON response:"
>{"message":"Hello World!"}</markup>

<p>When the ClientExample finishes its execution, you can stop the Main class by pressing <code>CTRL+C</code>.</p>

</div>


<h4 id="_discover_other_webclient_functionality">Discover other WebClient functionality</h4>
<div class="section">
<p>In practice, String is not the most useful return type, since it usually needs some more handling. In this case, it
could be more interesting to return an object of another type like a JSON object. One way to process a JSON object is
by enabling Helidon&#8217;s built-in JSON-P support and this can be simply achieved by adding its dependency in the project&#8217;s pom.xml:</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.http.media&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-http-media-jsonp&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

<p>Once the dependency is added, the feature will be automatically loaded as a service allowing the response methods to
easily parse the JSON object.</p>

<markup
lang="java"
title="Replace String with JsonObject:"
>ClientResponseTyped&lt;JsonObject&gt; response = webClient.get()
        .path("/greet/David")
        .request(JsonObject.class); <span class="conum" data-value="1" />
String value = response.entity().getString("message"); <span class="conum" data-value="2" />
System.out.println(value);</markup>

<ul class="colist">
<li data-value="1">Request a JsonObject as return value.</li>
<li data-value="2">Extract the value of the JsonObject with name of <code>message</code>.</li>
</ul>

<p>In the URI, the String value following <code>greet</code> is a path parameter which allows the application to greet someone.</p>

<markup
lang="bash"
title="Output:"
>Hello David!</markup>

<p>It is also possible to change the greeting word by using a PUT request to <code>/greet/greeting</code> path. The request also
needs to include a body with JSON type and using a structure like <code>It is also possible to change the greeting word by using a PUT request to `/greet/greeting` path. The request also
needs to include a body with JSON type and using a structure like `pass:[{"greeting" : "value"}]`.</code>.</p>

<markup
lang="java"
title="Modify the application greeting:"
>JsonObject entity = Json.createObjectBuilder() <span class="conum" data-value="1" />
        .add("greeting", "Bonjour")
        .build();
webClient.put() <span class="conum" data-value="2" />
        .path("/greet/greeting")
        .submit(entity); <span class="conum" data-value="3" />
ClientResponseTyped&lt;JsonObject&gt; response = webClient.get() <span class="conum" data-value="4" />
        .path("/greet/David")
        .request(JsonObject.class);
String entityString = response.entity().getString("message"); <span class="conum" data-value="5" />
System.out.println(entityString);</markup>

<ul class="colist">
<li data-value="1">Create a JsonObject with key <code>greeting</code> and value <code>bonjour</code>.</li>
<li data-value="2">Create a PUT request.</li>
<li data-value="3">Submit the JsonObject created earlier.</li>
<li data-value="4">Execute a GET call to verify that the greeting has been changed.</li>
<li data-value="5">Retrieve the greeting message from the JSON object</li>
</ul>

<p>Executing the above code will yield this output showing that the greeting word has been changed.</p>

<markup
lang="bash"
title="Output:"
>Bonjour David!</markup>

</div>

</div>


<h3 id="WebClient-Metrics">WebClient Metrics</h3>
<div class="section">
<p>WebClient, like other Helidon components, supports Metrics. The following example introduces a counter metric that
can be used to measure WebClient request activity. There are two ways to set up metrics, programmatically on the
WebClient instance or manually using the configuration file.</p>


<h4 id="_add_metrics_dependency">Add metrics dependency</h4>
<div class="section">
<p>To enable support for this feature, the <code>helidon-webclient-metrics</code> dependency needs to be added .</p>

<markup
lang="xml"
title="Add the following dependency to pom.xml:"
>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.webclient&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-webclient-metrics&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h4 id="_set_up_metrics_on_webclient_instance">Set up metrics on WebClient instance</h4>
<div class="section">
<p>Metrics can be registered on the WebClient directly.
The following example shows how a <code>Counter</code> metric can be defined, created and monitored.</p>

<markup
lang="java"
title="Example of metric creation:"
>MeterRegistry METER_REGISTRY = Metrics.globalRegistry();

String metricName = "counter.GET.localhost"; <span class="conum" data-value="1" />

Counter counter = METER_REGISTRY.getOrCreate(Counter.builder(metricName)); <span class="conum" data-value="2" />
System.out.println(metricName + ": " + counter.count());

WebClientService clientServiceMetric = WebClientMetrics.counter()
        .methods(Method.GET)                // OPTIONAL
        .success(true)                      // OPTIONAL
        .errors(true)                       // OPTIONAL
        .description("Metric Description")  // OPTIONAL
        .nameFormat("counter.%1$s.%2$s") <span class="conum" data-value="3" />
        .build(); <span class="conum" data-value="4" /></markup>

<ul class="colist">
<li data-value="1">Specify the metric name.</li>
<li data-value="2">From the <code>MeterRegistry</code>, create a Counter metric using the specified metric name.</li>
<li data-value="3">Specify how the name of the metric will be generated using the <code>nameFormat</code>.</li>
<li data-value="4">Build a WebClient Metric Service that can count number of GET requests made.</li>
</ul>

<p>In this example, the metric uses a <code>Counter</code> to measure the number of <code>GET</code> requests executed on the <code>localhost</code>.
The format strings in the parameter value of <code>nameFormat</code> method will identify how the name of a metric will get
generated:</p>

<ul class="ulist">
<li>
<p><code>%1$s</code> = Request method</p>

</li>
<li>
<p><code>%2$s</code> = Request host</p>

</li>
<li>
<p><code>%3$s</code> = Response status</p>

</li>
</ul>

<p>So for example, if the <code>nameFormat</code> value is <code>metric.%1$s.%2$s.%3$s</code> and a request uses a GET method, targeting a URL with localhost as the hostname, and got a response code of 200, that the final metric will get created with a name of metric.GET.localhost.200.</p>

<p>To register the metric service, simply use the <code>addService</code> method and pass in the created WebClient Metric Service as a
parameter.</p>

<markup
lang="java"
title="Add the metric service to the WebClient:"
>WebClient webClient = WebClient.builder()
        .baseUri("http://localhost:8080")
        .addService(clientServiceMetric) <span class="conum" data-value="1" />
        .build();

webClient.get().path("/greet").request(); <span class="conum" data-value="2" /></markup>

<ul class="colist">
<li data-value="1">Register the metric service to the webclient.</li>
<li data-value="2">Send an HTTP GET request</li>
</ul>

<p>To verify that the metric is set up correctly, print the value of the Counter at the end of the main method.</p>

<markup
lang="java"
title="Print the metric count"
>System.out.println(metricName + ": " + counter.count());</markup>

<p>This will result to an output showing that a metric with the name of <code>counter.GET.localhost</code> was created with
a count value of 1 indicating that it correctly measured the request that was just made.</p>

<markup
lang="bash"
title="Output:"
>counter.GET.localhost: 1</markup>

</div>


<h4 id="_set_up_metrics_with_configuration_files">Set up metrics with configuration files</h4>
<div class="section">
<p>Using the configuration file can reduce the code complexity and make the metrics simpler to use. With this approach,
it eliminates the need to modify the source code for scenarios where the metric settings have to be changed.
The <code>application.yaml</code> file is the default configuration file for Helidon and can be used to set up metrics settings.</p>

<markup
lang="yaml"
title="Example of metric configuration:"
>client:
  services:
    metrics:
      - type: COUNTER
        methods: ["GET"]
        description: "Metric Description"
        name-format: "counter.%1$s.%2$s"</markup>

<p>In the example configuration definition above, the metrics configuration are located under <code>client.services.metrics</code>.
The metric setting can start either by its <code>type</code> or <code>methods</code>. The configuration file uses the same keywords as the
programmatic way. For example, <code>type</code> defines the kind of metric and <code>methods</code> identifies the http methods that will
be measured.</p>

<markup
lang="java"
title="Add the metric service to the WebClient via the Configuration:"
>MeterRegistry METER_REGISTRY = Metrics.globalRegistry();

String counterName = "counter.GET.localhost"; <span class="conum" data-value="1" />

Counter counter = METER_REGISTRY.getOrCreate(Counter.builder(counterName)); <span class="conum" data-value="2" />
System.out.println(counterName + ": " + counter.count());

Config config = Config.create(); <span class="conum" data-value="3" />

WebClient webClient = WebClient.builder()
        .baseUri("http://localhost:8080")
        .config(config.get("client")) <span class="conum" data-value="4" />
        .build();
webClient.get().path("/greet").request(); <span class="conum" data-value="5" />
System.out.println(counterName + ": " + counter.count()); <span class="conum" data-value="6" /></markup>

<ul class="colist">
<li data-value="1">Choose the metric name.</li>
<li data-value="2">Create counter metric from <code>MeterRegistry</code>.</li>
<li data-value="3">Create a Helidon Config instance from default config file <code>application.yaml</code>.</li>
<li data-value="4">Configure the WebClient using the <code>client</code> section from <code>application.yaml</code>.</li>
<li data-value="5">Send an HTTP GET request</li>
<li data-value="6">Print out the metric result</li>
</ul>

<p>As demonstrated, using the configuration file reduces the amount of code needed in the source code. For more information
about metrics, see the <router-link to="/se/guides/metrics">Helidon Metrics Guide</router-link>.</p>

</div>

</div>

</div>

</doc-view>
