<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_api" @click.native="this.scrollFix('#_api')">API</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">
<p>Helidon 4 has been written from the ground up to take full advantage of Java 21’s virtual threads. With this
new architecture, threads are no longer a scarce resource that need to be pooled and managed, instead they
are an abundant resource that can be created as needed to satisfy your application needs.</p>

<p>In most cases, users do not need to worry about thread management and are able to run any type of
task on virtual threads provided by the Helidon Webserver.
However, there are certain use cases where tasks may need to be executed on
platform threads: these include cpu-intensive tasks as well as tasks that may pin a virtual thread to
a platform thread due to the use of synchronized blocks. Many libraries that are typically used in Helidon
applications have been updated to take full advantage of virtual threads by avoiding unwanted synchronization blocks,
yet this process is still underway and some legacy libraries may never be fully converted.</p>

<p>Helidon MP supports a new <code>@ExecuteOn</code> annotation to give developers full control on how to run
tasks. This annotation can be applied to any CDI bean method to control the type of thread in
which invocations of that method shall execute on.</p>

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable ExecuteOn
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-cdi&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_api">API</h2>
<div class="section">
<p>The API consists of a single <code>@ExecuteOn</code> annotation (with a few parameters) that can be applied to
any CDI bean method.</p>

<div class="admonition note">
<p class="admonition-inline">This feature is based on CDI interceptors, so using it on a non-CDI bean method will have no effect.</p>
</div>


<div class="table__overflow elevation-1  flex sm10
">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">Name</td>
<td class="">Value</td>
<td class="">Description</td>
</tr>
<tr>
<td class="">value</td>
<td class="">ThreadType.PLATFORM, ThreadType.VIRTUAL, ThreadType.EXECUTOR</td>
<td class="">Type of thread used to execute a method invocation</td>
</tr>
<tr>
<td class="">timeout</td>
<td class="">A long value</td>
<td class="">Maximum wait time for the method to return a value before triggering
a timeout exception</td>
</tr>
<tr>
<td class="">unit</td>
<td class="">A <code>TimeUnit</code> value</td>
<td class="">Unit for <code>timeout</code> parameter</td>
</tr>
<tr>
<td class="">executorName</td>
<td class="">The name of an executor from which to obtain a thread</td>
<td class="">CDI producer with a <code>@Named</code>
qualifier to access the executor</td>
</tr>
</tbody>
</table>
</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<p>The implementation of the <code>@ExecuteOn</code> annotation takes advantage of Helidon&#8217;s <code>ThreadPoolSupplier</code>
to (lazily) create a pool of platform threads. The default configuration for this thread
pool can be overridden using the (root) config key <code>execute-on.platform</code> as shown in the example
below.</p>

<markup
lang="yaml"

>execute-on:
  platform:
    thread-name-prefix: "my-platform-thread"
    core-pool-size: 1
    max-pool-size: 2
    queue-capacity: 10</markup>

<p>For more information see the Javadoc for
<a target="_blank" href="/apidocs/io.helidon.common.configurable/io/helidon/common/configurable/ThreadPoolSupplier.html">io.helidon.common.configurable.ThreadPoolSupplier</a>.
For virtual threads, only the thread name prefix can be overridden as follows:</p>

<markup
lang="yaml"

>execute-on:
  virtual:
    thread-name-prefix: "my-virtual-thread"</markup>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<ol style="margin-left: 15px;">
<li>
The following example creates a new platform thread from a (configurable) default pool
to execute a cpu-intensive task. Platform threads are a scarce resource, creating threads of
type <code>PLATFORM</code> should be done responsibly!
<markup
lang="java"

>public class MyPlaformBean {

    @ExecuteOn(ThreadType.PLATFORM)
    int cpuIntensive(int n) {
        return PiDigitCalculator.nthDigitOfPi(n);
    }
}</markup>

</li>
<li>
The next example also uses a platform thread, but this time the developer is also
responsible for providing an executor; this is done by creating a CDI provider with the same
executor name (using the <code>@Named</code> annotation) as the one in the annotation parameter.
Note that for simplicity the producer in this example is also part of the same bean,
but that is not a requirement in CDI.
<markup
lang="java"

>public class MyExecutorBean {

    @ExecuteOn(value = ThreadType.EXECUTOR, executorName = "my-executor")
    int cpuIntensive(int n) {
        return PiDigitCalculator.nthDigitOfPi(n);
    }

    @Produces
    @Named("my-executor")
    ExecutorService myExecutor() {
        return Executors.newFixedThreadPool(2);
    }
}</markup>

</li>
<li>
Finally, it is also possible to explicitly execute a method in a
virtual thread, blocking the caller thread until the method execution is complete.
<markup
lang="java"

>public class MyVirtualBean {

    @ExecuteOn(ThreadType.VIRTUAL)
    void someTask() {
        // run task on virtual thread
    }
}</markup>

</li>
</ol>

</div>

</doc-view>
