<doc-view>

<h2 id="_contents">Contents</h2>
<div class="section">
<ul class="ulist">
<li>
<p><router-link to="#_overview" @click.native="this.scrollFix('#_overview')">Overview</router-link></p>

</li>
<li>
<p><router-link to="#maven-coordinates" @click.native="this.scrollFix('#maven-coordinates')">Maven Coordinates</router-link></p>

</li>
<li>
<p><router-link to="#_usage" @click.native="this.scrollFix('#_usage')">Usage</router-link></p>

</li>
<li>
<p><router-link to="#_configuration" @click.native="this.scrollFix('#_configuration')">Configuration</router-link></p>

</li>
<li>
<p><router-link to="#_examples" @click.native="this.scrollFix('#_examples')">Examples</router-link></p>

</li>
<li>
<p><router-link to="#_reference" @click.native="this.scrollFix('#_reference')">Reference</router-link></p>

</li>
</ul>

</div>


<h2 id="_overview">Overview</h2>
<div class="section">

</div>


<h2 id="maven-coordinates">Maven Coordinates</h2>
<div class="section">
<p>To enable MicroProfile Telemetry
either add a dependency on the <router-link to="/mp/introduction/microprofile">helidon-microprofile bundle</router-link> or
add the following dependency to your project&#8217;s <code>pom.xml</code> (see
 <router-link to="/about/managing-dependencies">Managing Dependencies</router-link>).</p>

<markup
lang="xml"

>&lt;dependency&gt;
    &lt;groupId&gt;io.helidon.microprofile.telemetry&lt;/groupId&gt;
    &lt;artifactId&gt;helidon-microprofile-telemetry&lt;/artifactId&gt;
&lt;/dependency&gt;</markup>

</div>


<h2 id="_usage">Usage</h2>
<div class="section">
<p><a target="_blank" href="https://opentelemetry.io/">OpenTelemetry</a> comprises a collection of APIs, SDKs, integration tools, and other software components intended to facilitate the generation and control of telemetry data, including traces, metrics, and logs. In an environment where distributed tracing is enabled via OpenTelemetry (which combines OpenTracing and OpenCensus), this specification establishes the necessary behaviors for MicroProfile applications to participate seamlessly.</p>

<p>MicroProfile Telemetry 1.0 allows for the exportation of the data it collects to Jaeger or Zipkin and to other systems using a variety of exporters.</p>

<p>In a distributed tracing system, <strong>traces</strong> are used to capture a series of requests and are composed of multiple <strong>spans</strong> that represent individual operations within those requests. Each <strong>span</strong> includes a name, timestamps, and metadata that provide insights into the corresponding operation.</p>

<p><strong>Context</strong> is included in each span to identify the specific request that it belongs to. This context information is crucial for tracking requests across various components in a distributed system, enabling developers to trace a single request as it traverses through multiple services.</p>

<p>Finally, <strong>exporters</strong> are responsible for transmitting the collected trace data to a backend service for monitoring and visualization. This enables developers to gain a comprehensive understanding of the system&#8217;s behavior and detect any issues or bottlenecks that may arise.</p>

<div class="fit"><div>

<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/telemetry/telemetry-general.png" alt="General understanding of OpenTelemetry Tracing" />
</v-card-text>
</v-card>
</div></div>

<p>There are two ways to work with Telemetry, using:</p>

<ul class="ulist">
<li>
<p>Automatic Instrumentation</p>

</li>
<li>
<p>Manual Instrumentation</p>

</li>
</ul>

<p>For Automatic Instrumentation, OpenTelemetry provides a JavaAgent. The Tracing API allows for the automatic participation in distributed tracing of Jakarta RESTful Web Services (both server and client) as well as MicroProfile REST Clients, without requiring any modifications to the code. This is achieved through automatic instrumentation.</p>

<p>For Manual Instrumentation, there is a set of annotations and access to OpenTelemetry API.</p>

<p><code>@WithSpan</code> - By adding this annotation to a method in any Jakarta CDI aware bean, a new span will be created and any necessary connections to the current Trace context will be established. Additionally, the <code>SpanAttribute</code> annotation can be used to mark method parameters that should be included in the Trace.</p>

<p>Helidon provides full access to OpenTelemetry Tracing API:</p>

<ul class="ulist">
<li>
<p><code>io.opentelemetry.api.OpenTelemetry</code></p>

</li>
<li>
<p><code>io.opentelemetry.api.trace.Tracer</code></p>

</li>
<li>
<p><code>io.opentelemetry.api.trace.Span</code></p>

</li>
<li>
<p><code>io.opentelemetry.api.baggage.Baggage</code></p>

</li>
</ul>

<p>Accessing and using these objects can be done as follows. For span:</p>

<markup
lang="java"
title="Span sample"
>@ApplicationScoped
class HelidonBean {

    @WithSpan <span class="conum" data-value="1" />
    void doSomethingWithinSpan() {
        // do something here
    }

    @WithSpan("name") <span class="conum" data-value="2" />
    void complexSpan(@SpanAttribute(value = "arg") String arg) {
        // do something here
    }
}</markup>

<ul class="colist">
<li data-value="1">Simple <code>@WithSpan</code> annotation usage.</li>
<li data-value="2">Additional attributes can be set on a method.</li>
</ul>


<h3 id="_working_with_tracers">Working With Tracers</h3>
<div class="section">
<p>You can inject OpenTelemetry <code>Tracer</code> using the regular <code>@Inject</code> annotation and use <code>SpanBuilder</code> to manually create, star and stop spans.</p>

<markup
lang="java"
title="SpanBuilder usage"
>@Path("/")
public class HelidonEndpoint {

    @Inject
    Tracer tracer; <span class="conum" data-value="1" />

    @GET
    @Path("/span")
    public Response span() {
        Span span = tracer.spanBuilder("new") <span class="conum" data-value="2" />
                .setSpanKind(SpanKind.CLIENT)
                .setAttribute("someAttribute", "someValue")
                .startSpan();

        span.end();

        return Response.ok().build();
    }
}</markup>

<ul class="colist">
<li data-value="1">Inject <code>Tracer</code>.</li>
<li data-value="2">Use <code>Tracer.spanBuilder</code> to create and start new <code>Span</code>.</li>
</ul>

<p>Helidon Microprofile Telemetry is integrated with <router-link to="/mp/tracing">Helidon Tracing API</router-link>. This means that both APIs can be mixed, and all parent hierarchies will be kept. In the case below, <code>@WithSpan</code> annotated method is mixed with manually created <code>io.helidon.tracing.Span</code>:</p>

<markup
lang="java"
title="Inject Helidon Tracer"
>private io.helidon.tracing.Tracer helidonTracerInjected;

@Inject
GreetResource(io.helidon.tracing.Tracer helidonTracerInjected) {
    this.helidonTracerInjected = helidonTracerInjected; <span class="conum" data-value="1" />
}

@GET
@Path("mixed_injected")
@Produces(MediaType.APPLICATION_JSON)
@WithSpan("mixed_parent_injected")
public GreetingMessage mixedSpanInjected() {
    io.helidon.tracing.Span mixedSpan = helidonTracerInjected.spanBuilder("mixed_injected") <span class="conum" data-value="2" />
            .kind(io.helidon.tracing.Span.Kind.SERVER)
            .tag("attribute", "value")
            .start();
    mixedSpan.end();

    return new GreetingMessage("Mixed Span Injected" + mixedSpan);
}</markup>

<ul class="colist">
<li data-value="1">Inject <code>io.helidon.tracing.Tracer</code>.</li>
<li data-value="2">Use the injected tracer to create  <code>io.helidon.tracing.Span</code> using the <code>spanBuilder()</code> method.</li>
</ul>

<p>The span is then started and ended manually. Span parent relations will be preserved. This means that span named "mixed_injected" with have parent span named "mixed_parent_injected", which will have parent span named "mixed_injected".</p>

<p>Another option is to use the Global Tracer:</p>

<markup
lang="java"
title="Obtain the Global tracer"
>@GET
@Path("mixed")
@Produces(MediaType.APPLICATION_JSON)
@WithSpan("mixed_parent")
public GreetingMessage mixedSpan() {
    io.helidon.tracing.Tracer helidonTracer = io.helidon.tracing.Tracer.global(); <span class="conum" data-value="1" />
    io.helidon.tracing.Span mixedSpan = helidonTracer.spanBuilder("mixed") <span class="conum" data-value="2" />
            .kind(io.helidon.tracing.Span.Kind.SERVER)
            .tag("attribute", "value")
            .start();
    mixedSpan.end();

    return new GreetingMessage("Mixed Span" + mixedSpan);
}</markup>

<ul class="colist">
<li data-value="1">Obtain tracer using the <code>io.helidon.tracing.Tracer.global()</code> method;</li>
<li data-value="2">Use the created tracer to create a span.</li>
</ul>

<p>The span is then started and ended manually. Span parent relations will be preserved.</p>

</div>


<h3 id="_working_with_spans">Working With Spans</h3>
<div class="section">
<p>To obtain the current span, it can be injected by CDI. The current span can also be obtained using the static method <code>Span.current()</code>.</p>

<markup
lang="java"
title="Inject the current span"
>@Path("/")
public class HelidonEndpoint {
    @Inject
    Span span; <span class="conum" data-value="1" />

    @GET
    @Path("/current")
    public Response currentSpan() {
        return Response.ok(span).build(); <span class="conum" data-value="2" />
    }

    @GET
    @Path("/current/static")
    public Response currentSpanStatic() {
        return Response.ok(Span.current()).build(); <span class="conum" data-value="3" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Inject the current span.</li>
<li data-value="2">Use the injected span.</li>
<li data-value="3">Use <code>Span.current()</code> to access the current span.</li>
</ul>

</div>


<h3 id="_working_with_baggage">Working With Baggage</h3>
<div class="section">
<p>The same functionality is available for the <code>Baggage</code> API:</p>

<markup
lang="java"
title="Inject the current baggage"
>@Path("/")
public class HelidonEndpoint {
    @Inject
    Baggage baggage; <span class="conum" data-value="1" />

    @GET
    @Path("/current")
    public Response currentBaggage() {
        return Response.ok(baggage.getEntryValue("baggageKey")).build(); <span class="conum" data-value="2" />
    }

    @GET
    @Path("/current/static")
    public Response currentBaggageStatic() {
        return Response.ok(Baggage.current().getEntryValue("baggageKey")).build(); <span class="conum" data-value="3" />
    }
}</markup>

<ul class="colist">
<li data-value="1">Inject the current baggage.</li>
<li data-value="2">Use the injected baggage.</li>
<li data-value="3">Use <code>Baggage.current()</code> to access the current baggage.</li>
</ul>

</div>


<h3 id="Tracing-callbacks">Responding to Span Lifecycle Events</h3>
<div class="section">
<p>Applications and libraries can register listeners to be notified at several moments during the lifecycle of every span:</p>

<ul class="ulist">
<li>
<p>Before a new span starts</p>

</li>
<li>
<p>After a new span has started</p>

</li>
<li>
<p>After a span ends</p>

</li>
<li>
<p>After a span is activated (creating a new scope)</p>

</li>
<li>
<p>After a scope is closed</p>

</li>
</ul>

<p>The next sections explain how you can write and add a listener and what it can do. See the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> Javadoc for more information.</p>


<h4 id="_understanding_what_listeners_do">Understanding What Listeners Do</h4>
<div class="section">
<p>A listener cannot affect the lifecycle of a span or scope it is notified about, but it can add tags and events and update the baggage associated with a span.
Often a listener does additional work that does not change the span or scope such as logging a message.</p>

<p>When Helidon invokes the listener&#8217;s methods it passes proxies for the <code>Span.Builder</code>, <code>Span</code>, and <code>Scope</code> arguments. These proxies limit the access the listener has to the span builder, span, or scope, as summarized in the following table. If a listener method tries to invoke a forbidden operation, the proxy throws a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.ForbiddenOperationException.html"><code>SpanListener.ForbiddenOperationException</code></a> and Helidon then logs a <code>WARNING</code> message describing the invalid operation invocation.</p>

<div class="block-title"><span>Summary of Permitted Operations on Proxies Passed to Listeners</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Tracing type</th>
<th>Changes allowed</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>Span.Builder</code></a></td>
<td class="">Add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>Span</code></a></td>
<td class="">Retrieve and update baggage, add events, add tags</td>
</tr>
<tr>
<td class=""><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>Scope</code></a></td>
<td class="">none</td>
</tr>
</tbody>
</table>
</div>

<p>The following tables list specifically what operations the proxies permit.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.Builder.html"><code>io.helidon.tracing.Span.Builder</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>build()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>end</code> methods</td>
<td class="">Ends the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>get()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>kind(Kind)</code></td>
<td class="">Sets the "kind" of span (server, client, internal, etc.)</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>parent(SpanContext)</code></td>
<td class="">Sets the parent of the span to be created from the builder.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start()</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>start(Instant)</code></td>
<td class="">Starts the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>tag</code> methods</td>
<td class="">Add a tag to the builder before the span is built.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the builder to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy for it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Span.html"><code>io.helidon.tracing.Span</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>activate()</code></td>
<td class="">Makes the span "current", returning a <code>Scope</code>.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>addEvent</code> methods</td>
<td class="">Associate a string (and optionally other info) with a span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns the <code>Baggage</code> instance associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>context()</code></td>
<td class="">Returns the <code>SpanContext</code> associated with the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>status(Status)</code></td>
<td class="">Sets the status of the span.</td>
<td class="">-</td>
</tr>
<tr>
<td class="">any <code>tag</code> method</td>
<td class="">Add a tag to the span.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>unwrap(Class)</code></td>
<td class="">Cast the span to the specified implementation type. †</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<p>† Helidon returns the unwrapped object, not a proxy to it.</p>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Scope.html"><code>io.helidon.tracing.Scope</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>close()</code></td>
<td class="">Close the scope.</td>
<td class="">-</td>
</tr>
<tr>
<td class=""><code>isClosed()</code></td>
<td class="">Reports whether the scope is closed.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

<div class="block-title"><span><a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanContext.html"><code>io.helidon.tracing.SpanContext</code></a> Operations</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 33.333%;">
<col style="width: 33.333%;">
<col style="width: 33.333%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>Purpose</th>
<th>OK?</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>asParent(Span.Builder)</code></td>
<td class="">Sets this context as the parent of a new span builder.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>baggage()</code></td>
<td class="">Returns <code>Baggage</code> instance associated with the span context.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>spanId()</code></td>
<td class="">Returns the span ID.</td>
<td class="">&check;</td>
</tr>
<tr>
<td class=""><code>traceId()</code></td>
<td class="">Returns the trace ID.</td>
<td class="">&check;</td>
</tr>
</tbody>
</table>
</div>

</div>


<h4 id="_adding_a_listener">Adding a Listener</h4>
<div class="section">

<h5 id="_explicitly_registering_a_listener_on_a_tracer">Explicitly Registering a Listener on a <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/Tracer.html"><code>Tracer</code></a></h5>
<div class="section">
<p>Create a <code>SpanListener</code> instance and invoke the <code>Tracer#register(SpanListener)</code> method to make the listener known to that tracer.</p>

</div>


<h5 id="_automatically_registering_a_listener_on_all_tracer_instances">Automatically Registering a Listener on all <code>Tracer</code> Instances</h5>
<div class="section">
<p>Helidon also uses Java service loading to locate listeners and register them automatically on all <code>Tracer</code> objects.
Follow these steps to add a listener service provider.</p>

<ol style="margin-left: 15px;">
<li>
Implement the <a target="_blank" href="/apidocs/io.helidon.tracing/io/helidon/tracing/SpanListener.html"><code>SpanListener</code></a> interface.

</li>
<li>
Declare your implementation as a service provider:
<ol style="margin-left: 15px;">
<li>
Create the file <code>META-INF/services/io.helidon.tracing.SpanListener</code> containing a line with the fully-qualified name of your class which implements <code>SpanListener</code>.

</li>
<li>
If your service has a <code>module-info.java</code> file add the following line to it:
<markup
lang="java"

>provides io.helidon.tracing.SpanListener with &lt;your-implementation-class&gt;;</markup>

</li>
</ol>

</li>
</ol>

<p>The <code>SpanListener</code> interface declares default no-op implementations for all the methods, so your listener can implement only the methods it needs to.</p>

<p>Helidon invokes each listener&#8217;s methods in the following order:</p>

<div class="block-title"><span>Order in which Helidon Invokes Listener Methods</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
<tr>
<th>Method</th>
<th>When invoked</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>starting(Span.Builder&lt;?&gt; spanBuilder)</code></td>
<td class="">Just before a span is started from its builder.</td>
</tr>
<tr>
<td class=""><code>started(Span span)</code></td>
<td class="">Just after a span has started.</td>
</tr>
<tr>
<td class=""><code>activated(Span span, Scope scope)</code></td>
<td class="">After a span has been activated, creating a new scope. A given span might never be activated; it depends on the code.</td>
</tr>
<tr>
<td class=""><code>closed(Span span, Scope scope)</code></td>
<td class="">After a scope has been closed.</td>
</tr>
<tr>
<td class=""><code>ended(Span span)</code></td>
<td class="">After a span has ended successfully.</td>
</tr>
<tr>
<td class=""><code>ended(Span span, Throwable t)</code></td>
<td class="">After a span has ended unsuccessfully.</td>
</tr>
</tbody>
</table>
</div>

</div>

</div>

</div>

</div>


<h2 id="_configuration">Configuration</h2>
<div class="section">
<div class="admonition important">
<p class="admonition-inline">MicroProfile Telemetry is not activated by default. To activate this feature, you need to specify the configuration <code>otel.sdk.disabled=false</code> in one of the MicroProfile Config or other config sources.</p>
</div>

<p>To configure OpenTelemetry, MicroProfile Config must be used, and the configuration properties outlined in the following sections must be followed:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://github.com/open-telemetry/opentelemetry-java/tree/v1.19.0/sdk-extensions/autoconfigure">OpenTelemetry SDK Autoconfigure</a> (excluding properties related to Metrics and Logging)</p>

</li>
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/instrumentation/java/manual/">Manual Instrumentation</a></p>

</li>
</ul>

<p>Please consult with the links above for all configurations' properties usage.</p>

<p>The property should be declared in <code>microprofile-config.properties</code> file to be processed correctly.</p>


<h3 id="_opentelemetry_java_agent">OpenTelemetry Java Agent</h3>
<div class="section">
<p>The OpenTelemetry Java Agent may influence the work of MicroProfile Telemetry, on how the objects are created and configured. Helidon will do "best effort" to detect the use of the agent. But if there is a decision to run the Helidon app with the agent, a configuration property should be set:</p>

<p><code>otel.agent.present=true</code></p>

<p>This way, Helidon will explicitly get all the configuration and objects from the Agent, thus allowing correct span hierarchy settings.</p>

</div>

</div>


<h2 id="_examples">Examples</h2>
<div class="section">
<p>This guide demonstrates how to incorporate MicroProfile Telemetry into Helidon and provides illustrations of how to view traces. Jaeger is employed in all the examples, and the Jaeger UI is used to view the traces.</p>


<h3 id="_set_up_jaeger">Set Up Jaeger</h3>
<div class="section">
<p>For example, Jaeger will be used for gathering of the tracing information.</p>

<markup
lang="bash"
title="Run Jaeger in a docker container."
>docker run -d --name jaeger \
  -e COLLECTOR_ZIPKIN_HOST_PORT=:9411 \
  -e COLLECTOR_OTLP_ENABLED=true \
  -p 6831:6831/udp \
  -p 6832:6832/udp \
  -p 5778:5778 \
  -p 16686:16686 \
  -p 4317:4317 \
  -p 4318:4318 \
  -p 14250:14250 \
  -p 14268:14268 \
  -p 14269:14269 \
  -p 9411:9411 \
  jaegertracing/all-in-one:1.50</markup>

<p>All the tracing information gathered from the examples runs is accessible from the browser in the Jaeger UI under <a target="_blank" href="http://localhost:16686/" class="bare">http://localhost:16686/</a></p>

</div>


<h3 id="_enable_microprofile_telemetry_in_helidon_application">Enable MicroProfile Telemetry in Helidon Application</h3>
<div class="section">
<p>Together with Helidon Telemetry dependency, an OpenTelemetry Exporter dependency should be added to project&#8217;s pom.xml file.</p>

<markup
lang="xml"

>&lt;dependencies&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.helidon.microprofile.telemetry&lt;/groupId&gt;
        &lt;artifactId&gt;helidon-microprofile-telemetry&lt;/artifactId&gt; <span class="conum" data-value="1" />
    &lt;/dependency&gt;
    &lt;dependency&gt;
        &lt;groupId&gt;io.opentelemetry&lt;/groupId&gt;
        &lt;artifactId&gt;opentelemetry-exporter-jaeger&lt;/artifactId&gt;  <span class="conum" data-value="2" />
    &lt;/dependency&gt;
&lt;/dependencies&gt;</markup>

<ul class="colist">
<li data-value="1">Helidon Telemetry dependency.</li>
<li data-value="2">OpenTelemetry Jaeger exporter.</li>
</ul>

<p>Add these lines to <code>META-INF/microprofile-config.properties</code>:</p>

<markup
lang="properties"
title="MicroProfile Telemetry properties"
>otel.sdk.disabled=false     <span class="conum" data-value="1" />
otel.traces.exporter=jaeger <span class="conum" data-value="2" />
otel.exporter.name=greeting-service <span class="conum" data-value="3" /></markup>

<ul class="colist">
<li data-value="1">Enable MicroProfile Telemetry.</li>
<li data-value="2">Set exporter to Jaeger.</li>
<li data-value="3">Name of our service.</li>
</ul>

<p>Here we enable MicroProfile Telemetry, set tracer to "jaeger" and give a name, which will be used to identify our service in the tracer.</p>

<div class="admonition note">
<p class="admonition-textlabel">Note</p>
<p ><p>For this example, you will use Jaeger to manage data tracing. If you prefer to use Zipkin, please set <code>otel.traces.exporter</code> property to "zipkin". For more information using about Zipkin, see <a target="_blank" href="https://zipkin.io/" class="bare">https://zipkin.io/</a>. Also, a corresponding Maven dependency for the exporter should be added:</p>

<div class="listing">
<pre>&lt;dependency&gt;
    &lt;groupId&gt;io.opentelemetry&lt;/groupId&gt;
    &lt;artifactId&gt;opentelemetry-exporter-zipkin&lt;/artifactId&gt;
&lt;/dependency&gt;</pre>
</div>
</p>
</div>

</div>


<h3 id="_tracing_at_method_level">Tracing at Method Level</h3>
<div class="section">
<p>To create simple services, use <code>@WithSpan</code> and <code>Tracer</code> to create span and let MicroProfile OpenTelemetry handle them.</p>

<markup
lang="java"

>@Path("/greet")
public class GreetResource {

    @GET
    @WithSpan("default") <span class="conum" data-value="1" />
    public String getDefaultMessage() {
        return "Hello World";
    }
}</markup>

<ul class="colist">
<li data-value="1">Use of <code>@WithSpan</code> with name "default".</li>
</ul>

<p>Now let&#8217;s call the Greeting endpoint:</p>

<markup
lang="bash"

>curl localhost:8080/greet
Hello World</markup>

<p>Next, launch the Jaeger UI at <a target="_blank" href="http://localhost:16686/" class="bare">http://localhost:16686/</a>. The expected output is:</p>

<div class="fit"><div>

<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/telemetry/telemetry-greeting-jaeger.png" alt="Greeting service tracing output" />
</v-card-text>
</v-card>
</div></div>

<markup
lang="java"
title="Custom method"
>@Inject
private Tracer tracer; <span class="conum" data-value="1" />

@GET
@Path("custom")
@Produces(MediaType.APPLICATION_JSON)
@WithSpan <span class="conum" data-value="2" />
public JsonObject useCustomSpan() {
    Span span = tracer.spanBuilder("custom") <span class="conum" data-value="3" />
            .setSpanKind(SpanKind.INTERNAL)
            .setAttribute("attribute", "value")
            .startSpan();
    span.end(); <span class="conum" data-value="4" />

    return Json.createObjectBuilder()
            .add("Custom Span", span.toString())
            .build();
}</markup>

<ul class="colist">
<li data-value="1">Inject OpenTelemetry <code>Tracer</code>.</li>
<li data-value="2">Create a span around the method <code>useCustomSpan()</code>.</li>
<li data-value="3">Create a custom <code>INTERNAL</code> span and start it.</li>
<li data-value="4">End the custom span.</li>
</ul>

<p>Let us call the custom endpoint:</p>

<markup
lang="bash"

>curl localhost:8080/greeting/custom</markup>

<p>Again you can launch the Jaeger UI at <a target="_blank" href="http://localhost:16686/" class="bare">http://localhost:16686/</a>. The expected output is:</p>

<div class="fit"><div>

<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/telemetry/telemetry-custom-jaeger.png" alt="Custom span usage" />
</v-card-text>
</v-card>
</div></div>

<p>Now let us use multiple services calls. In the example below our main service will call the <code>secondary</code> services. Each method in each service will be annotated with <code>@WithSpan</code> annotation.</p>

<markup
lang="java"
title="Outbound method"
>@Uri("http://localhost:8081/secondary")
private WebTarget target; <span class="conum" data-value="1" />

@GET
@Path("/outbound")
@WithSpan("outbound") <span class="conum" data-value="2" />
public String outbound() {
    return target.request().accept(MediaType.TEXT_PLAIN).get(String.class); <span class="conum" data-value="3" />
}</markup>

<ul class="colist">
<li data-value="1">Inject <code>WebTarget</code> pointing to Secondary service.</li>
<li data-value="2">Wrap method using <code>WithSpan</code>.</li>
<li data-value="3">Call the secondary service.</li>
</ul>

<p>The secondary service is basic; it has only one method, which is also annotated with <code>@WithSpan</code>.</p>

<markup
lang="java"
title="Secondary service"
>@GET
@WithSpan <span class="conum" data-value="1" />
public String getSecondaryMessage() {
    return "Secondary"; <span class="conum" data-value="2" />
}</markup>

<ul class="colist">
<li data-value="1">Wrap method in a span.</li>
<li data-value="2">Return a string.</li>
</ul>

<p>Let us call the <em>Outbound</em> endpoint:</p>

<markup
lang="bash"

>curl localhost:8080/greet/outbound
Secondary</markup>

<p>The <code>greeting-service</code> call <code>secondary-service</code>. Each service will create spans with corresponding names, and a service class hierarchy will be created.</p>

<p>Launch the Jaeger UI at <a target="_blank" href="http://localhost:16686/" class="bare">http://localhost:16686/</a> to see the expected output (shown below).</p>

<div class="fit"><div>

<v-card>
<v-card-text class="overflow-y-hidden" >
<img src="/images/telemetry/telemetry-outbound-jaeger.png" alt="Secondary service outbound call" />
</v-card-text>
</v-card>
</div></div>

<p>This example is available at the <a target="_blank" href="https://github.com/oracle/helidon/tree/4.0.10/examples/microprofile/telemetry">Helidon official GitHub repository</a>.</p>

</div>

</div>


<h2 id="_reference">Reference</h2>
<div class="section">
<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-telemetry-1.0/tracing/microprofile-telemetry-tracing-spec-1.0.pdf">MicroProfile Telemetry Specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://opentelemetry.io/docs/">OpenTelemetry Documentation</a></p>

</li>
</ul>

</div>

</doc-view>
