<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>Helidon MP Metrics Guide</dt>
<dd slot="desc"><p>This guide describes how to create a sample Helidon MicroProfile (MP) project
that can be used to run some basic examples using both built-in and custom metrics with Helidon.</p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_what_you_need">What You Need</h2>
<div class="section">
<p>For this 30 minute tutorial, you will need the following:</p>


<div class="table__overflow elevation-1  flex sm7
">
<table class="datatable table">
<colgroup>
<col style="width: 50%;">
<col style="width: 50%;">
</colgroup>
<thead>
</thead>
<tbody>
<tr>
<td class="">A Helidon MP Application</td>
<td class="">You can use your own application or use the
 <router-link to="/mp/guides/quickstart">Helidon MP Quickstart</router-link> to create a sample application.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://www.oracle.com/technetwork/java/javase/downloads">Java&#160;SE&#160;21</a> (<a target="_blank" href="http://jdk.java.net">Open&#160;JDK&#160;21</a>)</td>
<td class="">Helidon requires Java 21+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://maven.apache.org/download.cgi">Maven 3.8+</a></td>
<td class="">Helidon requires Maven 3.8+.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://docs.docker.com/install/">Docker 18.09+</a></td>
<td class="">You need Docker if you
want to build and deploy Docker containers.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://kubernetes.io/docs/tasks/tools/install-kubectl/">Kubectl 1.16.5+</a></td>
<td class="">If you want to
deploy to Kubernetes, you need <code>kubectl</code> and a Kubernetes cluster (you can
<router-link to="/about/kubernetes">install one on your desktop</router-link>.</td>
</tr>
<tr>
<td class=""><a target="_blank" href="https://github.com/helm/helm">Helm</a></td>
<td class="">To manage Kubernetes applications.</td>
</tr>
</tbody>
</table>
</div>

<markup
lang="bash"
title="Verify Prerequisites"
>java -version
mvn --version
docker --version
kubectl version --short</markup>

<markup
lang="bash"
title="Setting JAVA_HOME"
># On Mac
export JAVA_HOME=`/usr/libexec/java_home -v 21`

# On Linux
# Use the appropriate path to your JDK
export JAVA_HOME=/usr/lib/jvm/jdk-21</markup>


<h3 id="_create_a_sample_helidon_mp_project">Create a Sample Helidon MP Project</h3>
<div class="section">
<p>Use the Helidon MP Maven archetype to create a simple project that can be used for the examples in this guide.</p>

<markup
lang="bash"
title="Run the Maven archetype"
>mvn -U archetype:generate -DinteractiveMode=false \
    -DarchetypeGroupId=io.helidon.archetypes \
    -DarchetypeArtifactId=helidon-quickstart-mp \
    -DarchetypeVersion=4.0.10 \
    -DgroupId=io.helidon.examples \
    -DartifactId=helidon-quickstart-mp \
    -Dpackage=io.helidon.examples.quickstart.mp</markup>

</div>


<h3 id="_using_the_built_in_metrics">Using the Built-In Metrics</h3>
<div class="section">
<p>Helidon provides three built-in scopes of metrics: base, vendor, and application. Here are the metric endpoints:</p>

<ol style="margin-left: 15px;">
<li>
<code>/metrics?scope=base</code> - Base metrics
as specified by the MicroProfile Metrics specification

</li>
<li>
<code>/metrics?scope=vendor</code> - Helidon-specific metrics

</li>
<li>
<code>/metrics?scope=application</code> - Application-specific metrics data.

</li>
</ol>

<p>Applications can add their own custom scopes as well simply by specifying a custom scope name when registering a metric.</p>

<div class="admonition note">
<p class="admonition-inline">The <code>/metrics</code> endpoint returns data for all scopes.</p>
</div>

<p>The built-in metrics fall into these categories:</p>

<ol style="margin-left: 15px;">
<li>
JVM behavior (in the base scope), and

</li>
<li>
basic key performance indicators for request handling (in the vendor scope).

</li>
</ol>

<p>A later section describes the <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">key performance indicator metrics</router-link> in detail.</p>

<p>The following example demonstrates how to use the other built-in metrics.  All examples are executed
from the root directory of your project (helidon-quickstart-mp).</p>

<markup
lang="bash"
title="Build the application and then run it:"
>mvn package
java -jar target/helidon-quickstart-mp.jar</markup>

<div class="admonition note">
<p class="admonition-inline">Metrics output can be returned in either text format (the default), or JSON.  The text format uses OpenMetrics (Prometheus) Text Format,
see <a target="_blank" href="https://prometheus.io/docs/instrumenting/exposition_formats/#text-format-details" class="bare">https://prometheus.io/docs/instrumenting/exposition_formats/#text-format-details</a>.</p>
</div>

<markup
lang="bash"
title="Verify the metrics endpoint in a new terminal window:"
>curl http://localhost:8080/metrics</markup>

<markup
lang="text"
title="Text response: (partial)"
># HELP classloader_loadedClasses_total Displays the total number of classes that have been loaded since the Java virtual machine has started execution.
# TYPE classloader_loadedClasses_total counter
classloader_loadedClasses_total{mp_scope="base",} 8146.0
# HELP requests_count_total Each request (regardless of HTTP method) will increase this counter
# TYPE requests_count_total counter
requests_count_total{mp_scope="vendor",} 1.0
# HELP jvm_uptime_seconds Displays the start time of the Java virtual machine in seconds. This attribute displays the approximate time when the Java virtual machine started.
# TYPE jvm_uptime_seconds gauge
jvm_uptime_seconds{mp_scope="base",} 7.3770</markup>

<p>You can get the same data in JSON format.</p>

<markup
lang="bash"
title="Verify the metrics endpoint with an HTTP accept header:"
>curl -H "Accept: application/json"  http://localhost:8080/metrics</markup>

<markup
lang="json"
title="JSON response (partial):"
>{
  "application": {
    "personalizedGets": 0,
    "allGets": {
      "count": 0,
      "elapsedTime": 0,
      "max": 0,
      "mean": 0
    }
  },
  "vendor": {
    "requests.count": 2
  },
  "base": {
    "gc.total;name=G1 Concurrent GC": 2,
    "cpu.systemLoadAverage": 10.3388671875,
    "classloader.loadedClasses.count": 8224,
    "thread.count": 19,
    "classloader.unloadedClasses.total": 0,
    "jvm.uptime": 36.8224
  }
}</markup>

<p>You can get a single metric by specifying the scope and name as query parameters in the URL.</p>

<markup
lang="bash"
title="Get the Helidon <code>requests.count</code> metric:"
>curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=vendor&amp;name=requests.count'</markup>

<markup
lang="json"
title="JSON response:"
>{
  "requests.count": 6
}</markup>

<p>The <code>base</code> metrics illustrated above provide some insight into the behavior of the JVM in which the server runs.</p>

<p>The <code>vendor</code> metric shown above gives an idea of the request traffic the server is handling. See the <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">later section</router-link> for more information on the basic and extended key performance indicator metrics.</p>

</div>


<h3 id="_controlling_metrics_behavior">Controlling Metrics Behavior</h3>
<div class="section">
<p>By adding a <code>metrics</code> section to your application configuration you can control how the Helidon metrics subsystem behaves in any of several ways.</p>

<ul class="ulist">
<li>
<p><router-link to="#disabling-entirely" @click.native="this.scrollFix('#disabling-entirely')">Disable metrics subsystem entirely</router-link>.</p>

</li>
<li>
<p><router-link to="#controlling-rest-request-metrics" @click.native="this.scrollFix('#controlling-rest-request-metrics')">Control <code>REST.request</code> metrics.</router-link></p>

</li>
<li>
<p>Select whether to collect <router-link to="#basic-and-extended-kpi" @click.native="this.scrollFix('#basic-and-extended-kpi')">extended key performance indicator metrics</router-link>.</p>

</li>
</ul>


<h4 id="disabling-entirely">Disabling Metrics Subsystem Entirely</h4>
<div class="section">
<p>You can disable the metrics subsystem entirely using configuration:</p>

<markup
lang="properties"
title="Configuration properties file disabling metrics"
>metrics.enabled=false</markup>

<p>With metrics processing disabled, Helidon never updates any metrics and the <code>/metrics</code> endpoints respond with <code>404</code>.</p>

</div>


<h4 id="basic-and-extended-kpi">Collecting Basic and Extended Key Performance Indicator (KPI) Metrics</h4>
<div class="section">
<p>Any time you include the Helidon metrics module in your application, Helidon tracks a basic performance indicator metric: a <code>Counter</code> of all requests received (<code>requests.count</code>).</p>

<p>Helidon MP also includes additional, extended KPI metrics which are disabled by default:</p>

<ul class="ulist">
<li>
<p>current number of requests in-flight - a <code>Gauge</code> (<code>requests.inFlight</code>) of requests currently being processed</p>

</li>
<li>
<p>long-running requests - a <code>Counter</code> (<code>requests.longRunning</code>) measuring the total number of requests which take at least a given amount of time to complete; configurable, defaults to 10000 milliseconds (10 seconds)</p>

</li>
<li>
<p>load - a <code>Counter</code> (<code>requests.load</code>) measuring the number of requests worked on (as opposed to received)</p>

</li>
<li>
<p>deferred - a <code>Gauge</code> (<code>requests.deferred</code>) measuring delayed request processing (work on a request was delayed after Helidon received the request)</p>

</li>
</ul>

<p>You can enable and control these metrics using configuration:</p>

<markup
lang="properties"
title="Configuration properties file controlling extended KPI metrics"
>metrics.key-performance-indicators.extended = true
metrics.key-performance-indicators.long-running.threshold-ms = 2000</markup>

</div>


<h4 id="controlling-rest-request-metrics">Controlling <code>REST.request</code> Metrics</h4>
<div class="section">
<p>Helidon MP implements the optional family of metrics, all with the name <code>REST.request</code>, as described in the
<a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/microprofile-metrics-spec-5.0.1.html#_optional_rest">MicroProfile Metrics specification</a>.
Each instance is a <code>Timer</code> with tags <code>class</code> and <code>method</code> identifying exactly which REST endpoint Java
method that instance measures.</p>

<p>By default, Helidon MP does <em>not</em> enable this feature.
Enable it by editing your application configuration to set <code>metrics.rest-request.enabled</code> to <code>true</code>.</p>

<p>Note that the applications you generate using the full Helidon archetype <em>do</em> enable this feature in the
generated config file.
You can see the results in the sample output shown in earlier example runs.</p>

</div>

</div>


<h3 id="_metrics_metadata">Metrics Metadata</h3>
<div class="section">
<p>Each metric has associated metadata that includes:</p>

<ol style="margin-left: 15px;">
<li>
name: The name of the metric.

</li>
<li>
units: The unit of the metric such as time (seconds, milliseconds), size (bytes, megabytes), etc.

</li>
<li>
a description of the metric.

</li>
</ol>

<p>You can get the metadata for any scope, such as <code>/metrics?scope=base</code>, as shown below:</p>

<markup
lang="bash"
title="Get the metrics metadata using HTTP OPTIONS method:"
> curl -X OPTIONS -H "Accept: application/json"  'http://localhost:8080/metrics?scope=base'</markup>

<markup
lang="json"
title="JSON response (truncated):"
>{
   "classloader.loadedClasses.count": {
      "type": "gauge",
      "description": "Displays the number of classes that are currently loaded in the Java virtual machine."
    },
   "jvm.uptime": {
      "type": "gauge",
      "unit": "seconds",
      "description": "Displays the start time of the Java virtual machine in milliseconds. This attribute displays the approximate time when the Java virtual machine started."
    },
   "memory.usedHeap": {
      "type": "gauge",
      "unit": "bytes",
      "description": "Displays the amount of used heap memory in bytes."
    }
}</markup>

</div>


<h3 id="_application_specific_metrics_data">Application-Specific Metrics Data</h3>
<div class="section">
<p>You can create application-specific metrics and integrate them with Helidon using CDI.
To add a new metric, simply annotate the JAX-RS resource with one of the metric annotations. Metrics can
be injected at the class, method, and field-levels.  This document shows examples of all three.</p>

<p>Helidon will automatically create and register annotated application metrics and store them in the application <code>MetricRegistry</code>, which
also contains the metric metadata. The metrics will exist for the lifetime of the application.
Each metric annotation has mandatory and optional fields. The name field, for example, is optional.</p>


<h4 id="_method_level_metrics">Method Level Metrics</h4>
<div class="section">
<p>There are two metrics that you can use by annotating a method:</p>

<ol style="margin-left: 15px;">
<li>
<code>@Counted</code> - Register a <code>Counter</code> metric

</li>
<li>
<code>@Timed</code> - Register a <code>Timer</code> metric

</li>
</ol>

<p>The following example will demonstrate how to use the <code>@Counted</code> annotation to track the number of times
the <code>/cards</code> endpoint is called.</p>

<markup
lang="java"
title="Create a new class <code>GreetingCards</code> with the following code:"
>@Path("/cards") <span class="conum" data-value="1" />
@RequestScoped <span class="conum" data-value="2" />
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "any-card")  <span class="conum" data-value="3" />
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">This class is annotated with <code>Path</code> which sets the path for this resource
as <code>/cards</code>.</li>
<li data-value="2">The <code>@RequestScoped</code> annotation defines that this bean is
request scoped.  The request scope is active only for the duration of
one web service invocation, and it is destroyed at the end of that
invocation.</li>
<li data-value="3">The annotation <code>@Counted</code> will register a <code>Counter</code> metric for this method, creating it if needed.
The counter is incremented each time the anyCards method is called.  The <code>name</code> attribute is optional.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the application endpoints below:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response (partial):"
>{
  "io.helidon.examples.quickstart.mp.GreetingCards.any-card":2 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The any-card count is two, since you invoked the endpoint twice.</li>
</ul>

<div class="admonition note">
<p class="admonition-inline">Notice the counter is fully qualified.  You can remove the package prefix by using the <code>absolute=true</code> field in the <code>@Counted</code> annotation.
You must use  <code>absolute=false</code> for class-level annotations.</p>
</div>

</div>


<h4 id="_additional_method_level_metrics">Additional Method Level Metrics</h4>
<div class="section">
<p>The <code>@Timed</code> annotation can also be used with a method.  For the following example.
you can just annotate the same method with <code>@Timed</code>. These metrics collect significant
information about the measured methods, but at a cost of some overhead and more complicated output.</p>

<p>Note that when using multiple annotations on a method, you <strong>must</strong> give the metrics different names as shown below.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "cardCount", absolute = true) <span class="conum" data-value="1" />
    @Timed(name = "cardTimer", absolute = true, unit = MetricUnits.MILLISECONDS) <span class="conum" data-value="2" />
    public JsonObject anyCard() {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">Specify a custom name for the <code>Counter</code> metric and set <code>absolute=true</code> to remove the path prefix from the name.</li>
<li data-value="2">Add the <code>@Timed</code> annotation to get a <code>Timer</code> metric.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the application endpoints below:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="json"
title="JSON response (partial):"
>{
  "cardTimer": {
    "count": 2,
    "max": 0.002921992,
    "mean": 0.0014682555,
    "elapsedTime": 0.002936511,
    "p0.5": 1.4336e-05,
    "p0.75": 0.003014144,
    "p0.95": 0.003014144,
    "p0.98": 0.003014144,
    "p0.99": 0.003014144,
    "p0.999": 0.003014144
  },
  "cardCount": 2
}</markup>

</div>


<h4 id="_reusing_metrics">Reusing Metrics</h4>
<div class="section">
<p>You can share a metric across multiple endpoints simply by specifying the same metric annotation as
demonstrated below.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "anyCard", absolute = true)
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some cards ...");
    }

    @GET
    @Path("/birthday")
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "specialEventCard", absolute = true)  <span class="conum" data-value="1" />
    public JsonObject birthdayCard() throws InterruptedException {
        return createResponse("Here are some birthday cards ...");
    }

    @GET
    @Path("/wedding")
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "specialEventCard", absolute = true)  <span class="conum" data-value="2" />
    public JsonObject weddingCard() throws InterruptedException {
        return createResponse("Here are some wedding cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">The <code>/birthday</code> endpoint uses a <code>Counter</code> metric, named <code>specialEventCard</code>.</li>
<li data-value="2">The <code>/wedding</code> endpoint uses the same <code>Counter</code> metric, named <code>specialEventCard</code>.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the following endpoints:"
>curl  http://localhost:8080/cards/wedding
curl  http://localhost:8080/cards/birthday
curl  http://localhost:8080/cards
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response (partial):"
>{
  "anyCard": 1,
  "specialEventCard": 2 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">Notice that <code>specialEventCard</code> count is two, since you accessed <code>/cards/wedding</code> and <code>/cards/birthday</code>.</li>
</ul>

</div>


<h4 id="_class_level_metrics">Class Level Metrics</h4>
<div class="section">
<p>You can collect metrics at the class-level to aggregate data from all methods in that class using the same metric.
The following example introduces a metric to count all card queries.  In the following example, the method-level metrics are not
needed to aggregate the counts, but they are left in the example to demonstrate the combined output of all three metrics.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
@Counted(name = "totalCards") <span class="conum" data-value="1" />
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true) <span class="conum" data-value="2" />
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    @Path("/birthday")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true) <span class="conum" data-value="3" />
    public JsonObject birthdayCard() throws InterruptedException {
        return createResponse("Here are some birthday cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<ul class="colist">
<li data-value="1">This class is annotated with <code>@Counted</code>, which aggregates count data from all the method that have a <code>Count</code> annotation.</li>
<li data-value="2">Use <code>absolute=true</code> to remove path prefix for method-level annotations.</li>
<li data-value="3">Add a method with a <code>Counter</code> metric to get birthday cards.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the following endpoints:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response (partial):"
>{
  "anyCard": 1,
  "birthdayCard": 1,
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 2 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The <code>totalCards</code> count is a total of all the method-level <code>Counter</code> metrics.  Class level metric names are always
fully qualified.</li>
</ul>

</div>


<h4 id="_field_level_metrics">Field Level Metrics</h4>
<div class="section">
<p>Field level metrics can be injected into managed objects, but they need to be updated by the application code.
This annotation can be used on fields of type <code>Timer</code>, <code>Counter</code>, and <code>Histogram</code>.</p>

<p>The following example shows how to use a field-level <code>Counter</code> metric to track cache hits.</p>

<markup
lang="java"
title="Replace the <code>GreetingCards</code> class with the following code:"
>@Path("/cards")
@RequestScoped
@Counted(name = "totalCards")
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @Inject
    @Metric(name = "cacheHits", absolute = true) <span class="conum" data-value="1" />
    private Counter cacheHits;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true)
    public JsonObject anyCard() throws InterruptedException {
        updateStats(); <span class="conum" data-value="2" />
        return createResponse("Here are some random cards ...");
    }

    @Path("/birthday")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(absolute = true)
    public JsonObject birthdayCard() throws InterruptedException {
        updateStats();  <span class="conum" data-value="3" />
        return createResponse("Here are some birthday cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }

    private void updateStats() {
        if (new Random().nextInt(3) == 1) {
            cacheHits.inc(); <span class="conum" data-value="4" />
        }
    }
}</markup>

<ul class="colist">
<li data-value="1">A <code>Counter</code> metric field, <code>cacheHits</code>, is automatically injected by Helidon.</li>
<li data-value="2">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="3">Call <code>updateStats()</code> to update the cache hits.</li>
<li data-value="4">Randomly increment the <code>cacheHits</code> counter.</li>
</ul>

<markup
lang="bash"
title="Build and run the application, then invoke the following endpoints:"
>curl http://localhost:8080/cards
curl http://localhost:8080/cards
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl http://localhost:8080/cards/birthday
curl -H "Accept: application/json"  'http://localhost:8080/metrics?scope=application'</markup>

<markup
lang="hocon"
title="JSON response (partial):"
>{
  "anyCard": 2,
  "birthdayCard": 3,
  "cacheHits": 2, <span class="conum" data-value="1" />
  "io.helidon.examples.quickstart.mp.totalCards.GreetingCards": 5
}</markup>

<ul class="colist">
<li data-value="1">The cache was hit two times out of five queries.</li>
</ul>

</div>


<h4 id="_gauge_metric">Gauge Metric</h4>
<div class="section">
<p>The <code>Gauge</code> metric measures a value that is maintained by code outside the metrics subsystem. As with other metrics, the application explicitly registers a gauge. When the <code>/metrics</code> endpoint
is invoked, Helidon retrieves the value of each registered <code>Gauge</code>.</p>

<p>The following example demonstrates how to use a <code>Gauge</code> to track application up-time.</p>

<markup
lang="java"
title="Create a new <code>GreetingCardsAppMetrics</code> class with the following code:"
>@ApplicationScoped <span class="conum" data-value="1" />
public class GreetingCardsAppMetrics {

    private AtomicLong startTime = new AtomicLong(0); <span class="conum" data-value="2" />

    public void onStartUp(@Observes @Initialized(ApplicationScoped.class) Object init) {
        startTime = new AtomicLong(System.currentTimeMillis()); <span class="conum" data-value="3" />
    }

    @Gauge(unit = "TimeSeconds")
    public long appUpTimeSeconds() {
        return Duration.ofMillis(System.currentTimeMillis() - startTime.get()).getSeconds();  <span class="conum" data-value="4" />
    }
}</markup>

<ul class="colist">
<li data-value="1">This managed object must be application scoped to properly register and use the <code>Gauge</code> metric.</li>
<li data-value="2">Declare an <code>AtomicLong</code> field to hold the start time of the application.</li>
<li data-value="3">Initialize the application start time.</li>
<li data-value="4">Return the application <code>appUpTimeSeconds</code> metric, which will be included in the application metrics.</li>
</ul>

<markup
lang="java"
title="Update the <code>GreetingCards</code> class with the following code to simplify the metrics output:"
>@Path("/cards")
@RequestScoped
public class GreetingCards {

    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Counted(name = "cardCount", absolute = true)
    public JsonObject anyCard() throws InterruptedException {
        return createResponse("Here are some random cards ...");
    }

    private JsonObject createResponse(String msg) {
        return JSON.createObjectBuilder().add("message", msg).build();
    }
}</markup>

<markup
lang="bash"
title="Build and run the application, then invoke the application metrics endpoint:"
>curl -H "Accept: application/json"  http://localhost:8080/metrics/application</markup>

<markup
lang="hocon"
title="JSON response from <code>/metrics/application</code>:"
>{
  "cardCount": 0,
  "io.helidon.examples.quickstart.mp.GreetingCardsAppMetrics.appUpTimeSeconds": 6 <span class="conum" data-value="1" />
}</markup>

<ul class="colist">
<li data-value="1">The application has been running for 6 seconds.</li>
</ul>

</div>

</div>


<h3 id="_integration_with_kubernetes_and_prometheus">Integration with Kubernetes and Prometheus</h3>
<div class="section">

<h4 id="_kubernetes_integration">Kubernetes Integration</h4>
<div class="section">
<p>The following example shows how to integrate the Helidon MP application with Kubernetes.</p>

<markup
lang="bash"
title="Stop the application and build the docker image:"
>docker build -t helidon-metrics-mp .</markup>

<markup
lang="yaml"
title="Create the Kubernetes YAML specification, named <code>metrics.yaml</code>, with the following content:"
>kind: Service
apiVersion: v1
metadata:
  name: helidon-metrics <span class="conum" data-value="1" />
  labels:
    app: helidon-metrics
  annotations:
    prometheus.io/scrape: "true" <span class="conum" data-value="2" />
spec:
  type: NodePort
  selector:
    app: helidon-metrics
  ports:
    - port: 8080
      targetPort: 8080
      name: http
---
kind: Deployment
apiVersion: apps/v1
metadata:
  name: helidon-metrics
spec:
  replicas: 1 <span class="conum" data-value="3" />
  selector:
    matchLabels:
      app: helidon-metrics
  template:
    metadata:
      labels:
        app: helidon-metrics
        version: v1
    spec:
      containers:
        - name: helidon-metrics
          image: helidon-metrics-mp
          imagePullPolicy: IfNotPresent
          ports:
            - containerPort: 8080</markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>8080</code>.</li>
<li data-value="2">An annotation that will allow Prometheus to discover and scrape the application pod.</li>
<li data-value="3">A deployment with one replica of a pod.</li>
</ul>

<markup
lang="bash"
title="Create and deploy the application into Kubernetes:"
>kubectl apply -f ./metrics.yaml</markup>

<markup
lang="bash"
title="Get the service information:"
>kubectl get service/helidon-metrics</markup>

<markup
lang="bash"

>NAME             TYPE       CLUSTER-IP      EXTERNAL-IP   PORT(S)          AGE
helidon-metrics   NodePort   10.99.159.2   &lt;none&gt;        8080:31143/TCP   8s <span class="conum" data-value="1" /></markup>

<ul class="colist">
<li data-value="1">A service of type <code>NodePort</code> that serves the default routes on port <code>31143</code>.</li>
</ul>

<markup
lang="bash"
title="Verify the metrics endpoint using port <code>30116</code>, your port will likely be different:"
>curl http://localhost:31143/metrics</markup>

<div class="admonition note">
<p class="admonition-inline">Leave the application running in Kubernetes since it will be used for Prometheus integration.</p>
</div>

</div>


<h4 id="_prometheus_integration">Prometheus Integration</h4>
<div class="section">
<p>The metrics service that you just deployed into Kubernetes is already annotated with <code>prometheus.io/scrape:</code>.  This will allow
Prometheus to discover the service and scrape the metrics.  This example shows how to install Prometheus
into Kubernetes, then verify that it discovered the Helidon metrics in your application.</p>

<markup
lang="bash"
title="Install Prometheus and wait until the pod is ready:"
>helm install stable/prometheus --name metrics
export POD_NAME=$(kubectl get pods --namespace default -l "app=prometheus,component=server" -o jsonpath="{.items[0].metadata.name}")
kubectl get pod $POD_NAME</markup>

<p>You will see output similar to the following.  Repeat the <code>kubectl get pod</code> command until you see <code>2/2</code> and <code>Running</code>. This may take up to one minute.</p>

<markup
lang="bash"

>metrics-prometheus-server-5fc5dc86cb-79lk4   2/2     Running   0          46s</markup>

<markup
lang="bash"
title="Create a port-forward, so you can access the server URL:"
>kubectl --namespace default port-forward $POD_NAME 7090:9090</markup>

<p>Now open your browser and navigate to <code><a target="_blank" href="http://localhost:7090/targets" class="bare">http://localhost:7090/targets</a></code>.  Search for helidon on the page, and you will see your
Helidon application as one of the Prometheus targets.</p>

</div>


<h4 id="_final_cleanup">Final Cleanup</h4>
<div class="section">
<p>You can now delete the Kubernetes resources that were just created during this example.</p>

<markup
lang="bash"
title="Delete the Prometheus Kubernetes resources:"
>helm delete --purge metrics</markup>

<markup
lang="bash"
title="Delete the application Kubernetes resources:"
>kubectl delete -f ./metrics.yaml</markup>

</div>

</div>


<h3 id="_summary">Summary</h3>
<div class="section">
<p>This guide demonstrated how to use metrics in a Helidon MP application using various combinations of
metrics and scopes.</p>

<ul class="ulist">
<li>
<p>Access metrics for all three scopes: base, vendor, and application</p>

</li>
<li>
<p>Configure application metrics at the class, method, and field-level</p>

</li>
<li>
<p>Integrate Helidon metrics with Kubernetes and Prometheus</p>

</li>
</ul>

<p>Refer to the following references for additional information:</p>

<ul class="ulist">
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/microprofile-metrics-spec-5.0.1.html">MicroProfile Metrics specification</a></p>

</li>
<li>
<p><a target="_blank" href="https://download.eclipse.org/microprofile/microprofile-metrics-5.0.1/apidocs">MicroProfile Metrics Javadoc</a></p>

</li>
<li>
<p>Helidon Javadoc at /apidocs/index.html?overview-summary.html</p>

</li>
</ul>

</div>

</div>

</doc-view>
