<doc-view>

<v-layout row wrap>
<v-flex xs12 sm10 lg10>
<v-card class="section-def" v-bind:color="$store.state.currentColor">
<v-card-text class="pa-3">
<v-card class="section-def__card">
<v-card-text>
<dl>
<dt slot=title>ConnectionConfig (webserver) Configuration</dt>
<dd slot="desc"><p>Type: <a target="_blank" href="/apidocs/io.helidon.webserver/io/helidon/webserver/ConnectionConfig.html">io.helidon.webserver.ConnectionConfig</a></p>
</dd>
</dl>
</v-card-text>
</v-card>
</v-card-text>
</v-card>
</v-flex>
</v-layout>


<h2 id="_configuration_options">Configuration options</h2>
<div class="section">
<div class="block-title"><span>Optional configuration options</span></div>
<div class="table__overflow elevation-1  ">
<table class="datatable table">
<colgroup>
<col style="width: 23.077%;">
<col style="width: 23.077%;">
<col style="width: 15.385%;">
<col style="width: 38.462%;">
</colgroup>
<thead>
<tr>
<th>key</th>
<th>type</th>
<th>default value</th>
<th>description</th>
</tr>
</thead>
<tbody>
<tr>
<td class=""><code>connect-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT10S</code></td>
<td class=""><doc-view>
<p>Connect timeout.
 Default is <code>DEFAULT_CONNECT_TIMEOUT_DURATION</code>.</p>

<pre>@return connect timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>keep-alive</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Configure socket keep alive.
 Default is <code>true</code>.</p>

<pre>@return keep alive
@see java.net.StandardSocketOptions#SO_KEEPALIVE</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>read-timeout</code></td>
<td class=""><doc-view>
<p>Duration</p>

</doc-view>
</td>
<td class=""><code>PT30S</code></td>
<td class=""><doc-view>
<p>Read timeout.
 Default is <code>DEFAULT_READ_TIMEOUT_DURATION</code></p>

<pre>@return read timeout</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>receive-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>32768</code></td>
<td class=""><doc-view>
<p>Socket receive buffer size.
 Default is <code>DEFAULT_SO_BUFFER_SIZE</code>.</p>

<pre>@return buffer size, in bytes
@see java.net.StandardSocketOptions#SO_RCVBUF</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>reuse-address</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>true</code></td>
<td class=""><doc-view>
<p>Socket reuse address.
 Default is <code>true</code>.</p>

<pre>@return whether to reuse address
@see java.net.StandardSocketOptions#SO_REUSEADDR</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>send-buffer-size</code></td>
<td class=""><doc-view>
<p>int</p>

</doc-view>
</td>
<td class=""><code>32768</code></td>
<td class=""><doc-view>
<p>Socket send buffer size.
 Default is <code>DEFAULT_SO_BUFFER_SIZE</code>.</p>

<pre>@return buffer size, in bytes
@see java.net.StandardSocketOptions#SO_SNDBUF</pre>
</doc-view>
</td>
</tr>
<tr>
<td class=""><code>tcp-no-delay</code></td>
<td class=""><doc-view>
<p>boolean</p>

</doc-view>
</td>
<td class=""><code>false</code></td>
<td class=""><doc-view>
<p>Disable Nagle&#8217;s algorithm by setting
 TCP_NODELAY to true. This can result in better performance on Mac or newer linux kernels for some
 payload types.
 Default is <code>false</code>.</p>

<pre>@return whether to use TCP_NODELAY, defaults to `false`
@see java.net.StandardSocketOptions#TCP_NODELAY</pre>
</doc-view>
</td>
</tr>
</tbody>
</table>
</div>

</div>

</doc-view>
