<doc-view>

<h2 id="_a_collection_of_java_libraries">A collection of Java libraries</h2>
<div class="section">
<p>Helidon is a collection of Java libraries for writing microservices.</p>

<p>There&#8217;s no need for any specific tooling or deployment model. Simply use your
 favorite tools !</p>

<div class="admonition note">
<p class="admonition-inline">Your microservice is a plain Java application. You do not need an
 application server.</p>
</div>
</div>

<h2 id="_cloud_native_java">Cloud-native Java</h2>
<div class="section">
<p>Helidon libraries interoperate with popular tools from the cloud-native space:</p>

<ul class="ulist">
<li>
<p><a id="" title="" target="_blank" href="https://www.docker.com/">Docker</a></p>

</li>
<li>
<p><a id="" title="" target="_blank" href="https://kubernetes.io/">Kubernetes</a></p>

</li>
<li>
<p><a id="" title="" target="_blank" href="https://prometheus.io/">Prometheus</a></p>

</li>
<li>
<p><a id="" title="" target="_blank" href="https://opentracing.io/">OpenTracing</a></p>

</li>
<li>
<p><a id="" title="" target="_blank" href="https://coreos.com/etcd/">Etcd</a></p>

</li>
</ul>
<div class="admonition tip">
<p class="admonition-inline">The <router-link to="#getting-started/02_base-example.adoc" @click.native="this.scrollFix('#getting-started/02_base-example.adoc')">Helidon Quickstart Examples</router-link>
 contain support for Docker and Kubernetes.</p>
</div>
</div>

<h2 id="_helidon_se">Helidon SE</h2>
<div class="section">
<p>Helidon SE is the functional programming style provided by all Helidon
 libraries.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon SE gives you full transparency and puts you in control. There is
 no magic!</p>
</div>
</div>

<h2 id="_helidon_mp">Helidon MP</h2>
<div class="section">
<p>Helidon MP is our MicroProfile implementation.</p>

<p><a id="" title="" target="_blank" href="https://microprofile.io">MicroProfile</a> is a platform definition that is familiar
 to enterprise Java developers. It provides a declarative programming style that
 is portable. It includes popular Java APIs such as <code>JAX-RS</code> and <code>CDI</code>.</p>

<div class="admonition note">
<p class="admonition-inline">Helidon MP is built on top of the Helidon libraries.</p>
</div>
</div>
</doc-view>
