/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbColumn;
import io.helidon.dbclient.DbColumnBase;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbRow;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class DbRowBase
implements DbRow {
    private final DbMapperManager dbMapperManager;
    private final DbColumnBase[] columns;
    private final Map<String, DbColumnBase> namesIndex;

    protected DbRowBase(DbColumnBase[] columns, DbMapperManager dbMapperManager) {
        this.columns = columns;
        this.dbMapperManager = dbMapperManager;
        this.namesIndex = new HashMap<String, DbColumnBase>(columns.length);
        for (DbColumnBase column : columns) {
            this.namesIndex.put(column.name(), column);
        }
    }

    @Override
    public DbColumn column(String name) {
        DbColumn column = this.namesIndex.get(name);
        if (column != null) {
            return column;
        }
        throw new DbClientException(String.format("Column with name %s does not exist", name));
    }

    @Override
    public DbColumn column(int index) {
        if (index < 1 || index > this.columns.length) {
            throw new IndexOutOfBoundsException(String.format("Column with index %d does not exist", index));
        }
        return this.columns[index - 1];
    }

    @Override
    public void forEach(Consumer<? super DbColumn> columnAction) {
        this.namesIndex.values().forEach(columnAction);
    }

    @Override
    public <T> T as(Class<T> type) throws MapperException {
        return this.dbMapperManager.read((DbRow)this, type);
    }

    @Override
    public <T> T as(GenericType<T> type) throws MapperException {
        return this.dbMapperManager.read((DbRow)this, type);
    }

    @Override
    public <T> T as(Function<DbRow, T> mapper) {
        return mapper.apply(this);
    }
}

