/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.dbclient.spi.DbClientProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

final class DbClientProviderLoader {
    private static final Map<String, DbClientProvider> PROVIDERS;
    private static final String[] NAMES;
    private static final DbClientProvider FIRST;

    private DbClientProviderLoader() {
        throw new UnsupportedOperationException("Instances of DbClientProviderLoader are not allowed");
    }

    static DbClientProvider first() {
        return FIRST;
    }

    static Optional<DbClientProvider> get(String name) {
        return Optional.ofNullable(PROVIDERS.get(name));
    }

    static String[] names() {
        return NAMES;
    }

    static {
        HelidonServiceLoader serviceLoader = HelidonServiceLoader.builder(ServiceLoader.load(DbClientProvider.class)).build();
        List providers = serviceLoader.asList();
        HashMap providersMap = new HashMap(providers.size());
        providers.forEach(dbProvider -> providersMap.put(dbProvider.name(), dbProvider));
        FIRST = providers.isEmpty() ? null : (DbClientProvider)providers.get(0);
        PROVIDERS = Map.copyOf(providersMap);
        NAMES = PROVIDERS.keySet().toArray(new String[PROVIDERS.size()]);
    }
}

