/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.mapper.MapperManager;
import io.helidon.dbclient.DbClient;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbMapper;
import io.helidon.dbclient.DbMapperManager;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.spi.DbClientBuilder;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class DbClientBuilderBase<T extends DbClientBuilderBase<T>>
implements DbClientBuilder<T> {
    private final DbMapperManager.Builder dbMapperBuilder = DbMapperManager.builder();
    private String url;
    private String username;
    private String password;
    private DbStatements statements;
    private MapperManager mapperManager;
    private DbMapperManager dbMapperManager;
    private final List<DbClientService> clientServices = new LinkedList<DbClientService>();

    protected DbClientBuilderBase() {
    }

    public DbClient build() {
        if (this.dbMapperManager == null) {
            this.dbMapperManager = this.dbMapperBuilder.build();
        }
        return this.doBuild();
    }

    protected abstract DbClient doBuild();

    @Override
    public T config(Config config) {
        config.get("statements").map(DbStatements::create).ifPresent(dbStatements -> this.statements((DbStatements)dbStatements));
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T url(String url) {
        this.url = url;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T username(String username) {
        this.username = username;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T password(String password) {
        this.password = password;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T statements(DbStatements statements) {
        this.statements = statements;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public <TYPE> T addMapper(final DbMapper<TYPE> dbMapper, final Class<TYPE> mappedClass) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <U> Optional<DbMapper<U>> mapper(Class<U> type) {
                if (type.equals(mappedClass)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public <TYPE> T addMapper(final DbMapper<TYPE> dbMapper, final GenericType<TYPE> mappedType) {
        this.dbMapperBuilder.addMapperProvider(new DbMapperProvider(){

            public <U> Optional<DbMapper<U>> mapper(Class<U> type) {
                return Optional.empty();
            }

            public <U> Optional<DbMapper<U>> mapper(GenericType<U> type) {
                if (type.equals((Object)mappedType)) {
                    return Optional.of(dbMapper);
                }
                return Optional.empty();
            }
        });
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T mapperManager(MapperManager manager) {
        this.mapperManager = manager;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T dbMapperManager(DbMapperManager manager) {
        this.dbMapperManager = manager;
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T addMapperProvider(DbMapperProvider provider) {
        this.dbMapperBuilder.addMapperProvider(provider);
        return (T)((DbClientBuilderBase)this.identity());
    }

    @Override
    public T addService(DbClientService clientService) {
        this.clientServices.add(clientService);
        return (T)((DbClientBuilderBase)this.identity());
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public DbStatements statements() {
        return this.statements;
    }

    public List<DbClientService> clientServices() {
        return List.copyOf(this.clientServices);
    }

    public MapperManager mapperManager() {
        return this.mapperManager;
    }

    public DbMapperManager dbMapperManager() {
        return this.dbMapperManager;
    }
}

