/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.mapper.MapperManager;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientProviderLoader;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.spi.DbClientProvider;
import io.helidon.dbclient.spi.DbClientProviderBuilder;
import io.helidon.dbclient.spi.DbClientServiceProvider;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;

public interface DbClient {
    public <U, T extends Subscribable<U>> T inTransaction(Function<DbTransaction, T> var1);

    public <U, T extends Subscribable<U>> T execute(Function<DbExecute, T> var1);

    public String dbType();

    public <C> Single<C> unwrap(Class<C> var1);

    public static DbClient create(Config config) {
        return DbClient.builder(config).build();
    }

    public static Builder builder() {
        DbClientProvider theSource = DbClientProviderLoader.first();
        if (null == theSource) {
            throw new DbClientException("No DbSource defined on classpath/module path. An implementation of io.helidon.dbclient.spi.DbSource is required to access a DB");
        }
        return DbClient.builder(theSource);
    }

    public static Builder builder(DbClientProvider source) {
        return new Builder(source);
    }

    public static Builder builder(String dbSource) {
        return DbClientProviderLoader.get(dbSource).map(DbClient::builder).orElseThrow(() -> new DbClientException("No DbSource defined on classpath/module path for name: " + dbSource + ", available names: " + Arrays.toString(DbClientProviderLoader.names())));
    }

    public static Builder builder(Config dbConfig) {
        return dbConfig.get("source").asString().map(DbClient::builder).orElseGet(DbClient::builder).config(dbConfig);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, DbClient> {
        private final HelidonServiceLoader.Builder<DbClientServiceProvider> clientServiceProviders = HelidonServiceLoader.builder(ServiceLoader.load(DbClientServiceProvider.class));
        private final DbClientProviderBuilder<?> theBuilder;
        private Config config = Config.empty();

        private Builder(DbClientProvider dbClientProvider) {
            this.theBuilder = dbClientProvider.builder();
        }

        public DbClient build() {
            Config servicesConfig = this.config.get("services");
            List providers = this.clientServiceProviders.build().asList();
            for (DbClientServiceProvider provider : providers) {
                Config providerConfig = servicesConfig.get(provider.configKey());
                if (!providerConfig.exists()) continue;
                provider.create(providerConfig).forEach(this::addService);
            }
            return this.theBuilder.build();
        }

        public Builder addServiceProvider(DbClientServiceProvider provider) {
            this.clientServiceProviders.addService((Object)provider);
            return this;
        }

        public Builder addService(DbClientService clientService) {
            this.theBuilder.addService(clientService);
            return this;
        }

        public Builder addService(Supplier<? extends DbClientService> clientServiceSupplier) {
            this.theBuilder.addService(clientServiceSupplier.get());
            return this;
        }

        public Builder config(Config config) {
            this.theBuilder.config(config);
            this.config = config;
            return this;
        }

        public Builder statements(DbStatements statements) {
            this.theBuilder.statements(statements);
            return this;
        }

        public Builder mapperProvider(DbMapperProvider provider) {
            this.theBuilder.addMapperProvider(provider);
            return this;
        }

        public Builder mapperManager(MapperManager manager) {
            this.theBuilder.mapperManager(manager);
            return this;
        }
    }
}

