/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.context.Context;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

class DbClientServiceContextImpl
implements DbClientServiceContext {
    private final String dbType;
    private DbStatementType dbStatementType;
    private Context context;
    private String statementName;
    private String statement;
    private CompletionStage<Void> statementFuture;
    private CompletionStage<Long> queryFuture;
    private List<Object> indexedParams;
    private Map<String, Object> namedParams;
    private boolean indexed;

    DbClientServiceContextImpl(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public String dbType() {
        return this.dbType;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public String statementName() {
        return this.statementName;
    }

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public CompletionStage<Void> statementFuture() {
        return this.statementFuture;
    }

    @Override
    public Optional<List<Object>> indexedParameters() {
        if (this.indexed) {
            return Optional.of(this.indexedParams);
        }
        throw new IllegalStateException("Indexed parameters are not available for statement with named parameters");
    }

    @Override
    public Optional<Map<String, Object>> namedParameters() {
        if (this.indexed) {
            throw new IllegalStateException("Named parameters are not available for statement with indexed parameters");
        }
        return Optional.of(this.namedParams);
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public boolean isNamed() {
        return !this.indexed;
    }

    @Override
    public DbClientServiceContext context(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public DbClientServiceContext statementName(String newName) {
        this.statementName = newName;
        return this;
    }

    @Override
    public DbClientServiceContext statementFuture(CompletionStage<Void> statementFuture) {
        this.statementFuture = statementFuture;
        return this;
    }

    @Override
    public CompletionStage<Long> resultFuture() {
        return this.queryFuture;
    }

    @Override
    public DbClientServiceContext resultFuture(CompletionStage<Long> resultFuture) {
        this.queryFuture = resultFuture;
        return this;
    }

    @Override
    public DbClientServiceContext statement(String statement, List<Object> indexedParams) {
        this.statement = statement;
        this.indexedParams = indexedParams;
        this.indexed = true;
        return this;
    }

    @Override
    public DbClientServiceContext statement(String statement, Map<String, Object> namedParams) {
        this.statement = statement;
        this.namedParams = namedParams;
        this.indexed = false;
        return this;
    }

    @Override
    public DbClientServiceContext parameters(List<Object> indexedParameters) {
        if (!this.indexed) {
            throw new IllegalStateException("Cannot configure indexed parameters for a statement that expects named parameters");
        }
        this.indexedParams = indexedParameters;
        return this;
    }

    @Override
    public DbClientServiceContext parameters(Map<String, Object> namedParameters) {
        if (this.indexed) {
            throw new IllegalStateException("Cannot configure named parameters for a statement that expects indexed parameters");
        }
        this.namedParams = namedParameters;
        return this;
    }

    @Override
    public DbStatementType statementType() {
        return this.dbStatementType;
    }

    @Override
    public DbClientServiceContext statementType(DbStatementType type) {
        this.dbStatementType = type;
        return this;
    }
}

