/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.context.Context;
import io.helidon.dbclient.DbInterceptorContextImpl;
import io.helidon.dbclient.DbStatementType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface DbInterceptorContext {
    public static DbInterceptorContext create(String dbType) {
        return new DbInterceptorContextImpl(dbType);
    }

    public String dbType();

    public Context context();

    public String statementName();

    public String statement();

    public CompletionStage<Void> statementFuture();

    public CompletionStage<Long> resultFuture();

    public Optional<List<Object>> indexedParameters();

    public Optional<Map<String, Object>> namedParameters();

    public boolean isIndexed();

    public boolean isNamed();

    public DbStatementType statementType();

    public DbInterceptorContext context(Context var1);

    public DbInterceptorContext statementName(String var1);

    public DbInterceptorContext statementFuture(CompletionStage<Void> var1);

    public DbInterceptorContext resultFuture(CompletionStage<Long> var1);

    public DbInterceptorContext statement(String var1, List<Object> var2);

    public DbInterceptorContext statement(String var1, Map<String, Object> var2);

    public DbInterceptorContext parameters(List<Object> var1);

    public DbInterceptorContext parameters(Map<String, Object> var1);

    public DbInterceptorContext statementType(DbStatementType var1);
}

