/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.reactive.OptionalCompletionStage;
import io.helidon.dbclient.DbResult;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbRows;
import io.helidon.dbclient.DbStatementDml;
import io.helidon.dbclient.DbStatementGeneric;
import io.helidon.dbclient.DbStatementGet;
import io.helidon.dbclient.DbStatementQuery;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface DbExecute {
    public DbStatementQuery createNamedQuery(String var1, String var2);

    public DbStatementQuery createNamedQuery(String var1);

    public DbStatementQuery createQuery(String var1);

    default public CompletionStage<DbRows<DbRow>> namedQuery(String statementName, Object ... parameters) {
        return ((DbStatementQuery)this.createNamedQuery(statementName).params(parameters)).execute();
    }

    default public CompletionStage<DbRows<DbRow>> query(String statement, Object ... parameters) {
        return ((DbStatementQuery)this.createQuery(statement).params(parameters)).execute();
    }

    public DbStatementGet createNamedGet(String var1, String var2);

    public DbStatementGet createNamedGet(String var1);

    public DbStatementGet createGet(String var1);

    default public OptionalCompletionStage<DbRow> namedGet(String statementName, Object ... parameters) {
        return OptionalCompletionStage.create(((DbStatementGet)this.createNamedGet(statementName).params(parameters)).execute());
    }

    default public CompletionStage<Optional<DbRow>> get(String statement, Object ... parameters) {
        return ((DbStatementGet)this.createGet(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedInsert(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedInsert(String var1);

    public DbStatementDml createInsert(String var1);

    default public CompletionStage<Long> namedInsert(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedInsert(statementName).params(parameters)).execute();
    }

    default public CompletionStage<Long> insert(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createInsert(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedUpdate(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedUpdate(String var1);

    public DbStatementDml createUpdate(String var1);

    default public CompletionStage<Long> namedUpdate(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedUpdate(statementName).params(parameters)).execute();
    }

    default public CompletionStage<Long> update(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createUpdate(statement).params(parameters)).execute();
    }

    default public DbStatementDml createNamedDelete(String statementName, String statement) {
        return this.createNamedDmlStatement(statementName, statement);
    }

    public DbStatementDml createNamedDelete(String var1);

    public DbStatementDml createDelete(String var1);

    default public CompletionStage<Long> namedDelete(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedDelete(statementName).params(parameters)).execute();
    }

    default public CompletionStage<Long> delete(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createDelete(statement).params(parameters)).execute();
    }

    public DbStatementDml createNamedDmlStatement(String var1, String var2);

    public DbStatementDml createNamedDmlStatement(String var1);

    public DbStatementDml createDmlStatement(String var1);

    default public CompletionStage<Long> namedDml(String statementName, Object ... parameters) {
        return ((DbStatementDml)this.createNamedDmlStatement(statementName).params(parameters)).execute();
    }

    default public CompletionStage<Long> dml(String statement, Object ... parameters) {
        return ((DbStatementDml)this.createDmlStatement(statement).params(parameters)).execute();
    }

    public DbStatementGeneric createNamedStatement(String var1, String var2);

    public DbStatementGeneric createNamedStatement(String var1);

    public DbStatementGeneric createStatement(String var1);

    default public CompletionStage<DbResult> namedStatement(String statementName, Object ... parameters) {
        return ((DbStatementGeneric)this.createNamedStatement(statementName).params(parameters)).execute();
    }

    default public CompletionStage<DbResult> statement(String statement, Object ... parameters) {
        return ((DbStatementGeneric)this.createStatement(statement).params(parameters)).execute();
    }
}

