/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.dbclient.spi.DbClientProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

final class DbClientProviderLoader {
    private static final Map<String, DbClientProvider> DB_SOURCES = new HashMap<String, DbClientProvider>();
    private static final String[] NAMES;
    private static final DbClientProvider FIRST;

    private DbClientProviderLoader() {
    }

    static DbClientProvider first() {
        return FIRST;
    }

    static Optional<DbClientProvider> get(String name) {
        return Optional.ofNullable(DB_SOURCES.get(name));
    }

    static String[] names() {
        return NAMES;
    }

    static {
        HelidonServiceLoader serviceLoader = HelidonServiceLoader.builder(ServiceLoader.load(DbClientProvider.class)).build();
        List sources = serviceLoader.asList();
        DbClientProvider first = null;
        if (!sources.isEmpty()) {
            first = (DbClientProvider)sources.get(0);
        }
        FIRST = first;
        sources.forEach(dbProvider -> DB_SOURCES.put(dbProvider.name(), (DbClientProvider)dbProvider));
        NAMES = (String[])sources.stream().map(DbClientProvider::name).toArray(String[]::new);
    }
}

