/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.dbclient.DbClientException;
import io.helidon.dbclient.DbClientProviderLoader;
import io.helidon.dbclient.DbExecute;
import io.helidon.dbclient.DbInterceptor;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.DbStatements;
import io.helidon.dbclient.DbTransaction;
import io.helidon.dbclient.spi.DbClientProvider;
import io.helidon.dbclient.spi.DbClientProviderBuilder;
import io.helidon.dbclient.spi.DbInterceptorProvider;
import io.helidon.dbclient.spi.DbMapperProvider;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public interface DbClient {
    public <T> CompletionStage<T> inTransaction(Function<DbTransaction, CompletionStage<T>> var1);

    public <T extends CompletionStage<?>> T execute(Function<DbExecute, T> var1);

    public CompletionStage<Void> ping();

    public String dbType();

    public static DbClient create(Config config) {
        return DbClient.builder(config).build();
    }

    public static Builder builder() {
        DbClientProvider theSource = DbClientProviderLoader.first();
        if (null == theSource) {
            throw new DbClientException("No DbSource defined on classpath/module path. An implementation of io.helidon.dbclient.spi.DbSource is required to access a DB");
        }
        return DbClient.builder(theSource);
    }

    public static Builder builder(DbClientProvider source) {
        return new Builder(source);
    }

    public static Builder builder(String dbSource) {
        return DbClientProviderLoader.get(dbSource).map(DbClient::builder).orElseThrow(() -> new DbClientException("No DbSource defined on classpath/module path for name: " + dbSource + ", available names: " + Arrays.toString(DbClientProviderLoader.names())));
    }

    public static Builder builder(Config dbConfig) {
        return dbConfig.get("source").asString().map(DbClient::builder).orElseGet(DbClient::builder).config(dbConfig);
    }

    public static final class Builder
    implements io.helidon.common.Builder<DbClient> {
        private final HelidonServiceLoader.Builder<DbInterceptorProvider> interceptorServices = HelidonServiceLoader.builder(ServiceLoader.load(DbInterceptorProvider.class));
        private final DbClientProviderBuilder<?> theBuilder;
        private Config config;

        private Builder(DbClientProvider dbClientProvider) {
            this.theBuilder = dbClientProvider.builder();
        }

        public DbClient build() {
            if (null != this.config) {
                Config interceptors = this.config.get("interceptors");
                List providers = this.interceptorServices.build().asList();
                for (DbInterceptorProvider provider : providers) {
                    Config typed;
                    Config named;
                    Config providerConfig = interceptors.get(provider.configKey());
                    if (!providerConfig.exists()) continue;
                    AtomicBoolean added = new AtomicBoolean(false);
                    Config global = providerConfig.get("global");
                    if (global.exists() && !global.isLeaf()) {
                        global.asNodeList().ifPresent(configs -> configs.forEach(globalConfig -> {
                            added.set(true);
                            this.addInterceptor(provider.create((Config)globalConfig));
                        }));
                    }
                    if ((named = providerConfig.get("named")).exists()) {
                        named.asNodeList().ifPresent(configs -> configs.forEach(namedConfig -> {
                            ConfigValue names = namedConfig.get("names").asList(String.class);
                            names.ifPresent(nameList -> {
                                added.set(true);
                                this.addInterceptor(provider.create((Config)namedConfig), nameList.toArray(new String[0]));
                            });
                        }));
                    }
                    if ((typed = providerConfig.get("typed")).exists()) {
                        typed.asNodeList().ifPresent(configs -> configs.forEach(typedConfig -> {
                            ConfigValue types = typedConfig.get("types").asList(String.class);
                            types.ifPresent(typeList -> {
                                DbStatementType[] typeArray = (DbStatementType[])typeList.stream().map(DbStatementType::valueOf).toArray(DbStatementType[]::new);
                                added.set(true);
                                this.addInterceptor(provider.create((Config)typedConfig), typeArray);
                            });
                        }));
                    }
                    if (added.get()) continue;
                    if (global.exists()) {
                        this.addInterceptor(provider.create(global));
                        continue;
                    }
                    this.addInterceptor(provider.create(providerConfig));
                }
            }
            return this.theBuilder.build();
        }

        public Builder addInterceptorProvider(DbInterceptorProvider provider) {
            this.interceptorServices.addService((Object)provider);
            return this;
        }

        public Builder addInterceptor(DbInterceptor interceptor) {
            this.theBuilder.addInterceptor(interceptor);
            return this;
        }

        public Builder addInterceptor(DbInterceptor interceptor, String ... statementNames) {
            this.theBuilder.addInterceptor(interceptor, statementNames);
            return this;
        }

        public Builder addInterceptor(DbInterceptor interceptor, DbStatementType ... dbStatementTypes) {
            this.theBuilder.addInterceptor(interceptor, dbStatementTypes);
            return this;
        }

        public Builder config(Config config) {
            this.theBuilder.config(config);
            this.config = config;
            return this;
        }

        public Builder statements(DbStatements statements) {
            this.theBuilder.statements(statements);
            return this;
        }

        public Builder mapperProvider(DbMapperProvider provider) {
            this.theBuilder.addMapperProvider(provider);
            return this;
        }

        public Builder mapperManager(MapperManager manager) {
            this.theBuilder.mapperManager(manager);
            return this;
        }

        static {
            HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"DbClient"});
        }
    }
}

