/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.tracing;

import io.helidon.common.config.Config;
import io.helidon.dbclient.DbClientService;
import io.helidon.dbclient.spi.DbClientServiceProvider;
import io.helidon.dbclient.tracing.DbClientTracing;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DbClientTracingProvider
implements DbClientServiceProvider {
    private static final System.Logger LOGGER = System.getLogger(DbClientTracingProvider.class.getName());

    public String configKey() {
        return "tracing";
    }

    public Collection<DbClientService> create(Config config) {
        List tracingConfigs = (List)config.asNodeList().orElseGet(List::of);
        LinkedList<DbClientService> result = new LinkedList<DbClientService>();
        for (Config tracingConfig : tracingConfigs) {
            result.add((DbClientService)DbClientTracing.create(tracingConfig));
        }
        if (result.isEmpty()) {
            LOGGER.log(System.Logger.Level.INFO, "Database Client tracing is enabled, yet none is configured in config.");
        }
        return result;
    }
}

