/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.tracing;

import io.helidon.common.context.Context;
import io.helidon.common.reactive.Single;
import io.helidon.config.Config;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.common.DbClientServiceBase;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Map;

public class DbClientTracing
extends DbClientServiceBase {
    private DbClientTracing(Builder builder) {
        super((DbClientServiceBase.DbClientServiceBuilderBase)builder);
    }

    public static DbClientTracing create(Config config) {
        return ((Builder)DbClientTracing.builder().config(config)).build();
    }

    public static DbClientTracing create() {
        return DbClientTracing.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Single<DbClientServiceContext> apply(DbClientServiceContext serviceContext) {
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"dbclient", (String)"statement");
        if (!spanConfig.enabled()) {
            return Single.just((Object)serviceContext);
        }
        Context context = serviceContext.context();
        Tracer tracer = context.get(Tracer.class).orElseGet(GlobalTracer::get);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(serviceContext.statementName());
        context.get(SpanContext.class).ifPresent(arg_0 -> ((Tracer.SpanBuilder)spanBuilder).asChildOf(arg_0));
        Span span = spanBuilder.start();
        span.setTag("db.operation", serviceContext.statementType().toString());
        if (spanConfig.logEnabled("statement", true)) {
            Tags.DB_STATEMENT.set(span, serviceContext.statement());
        }
        Tags.COMPONENT.set(span, "dbclient");
        Tags.DB_TYPE.set(span, serviceContext.dbType());
        serviceContext.statementFuture().thenAccept(nothing -> {
            if (spanConfig.logEnabled("statement-finish", true)) {
                span.log(Map.of("type", "statement"));
            }
        });
        serviceContext.resultFuture().thenAccept(count -> {
            if (spanConfig.logEnabled("result-finish", true)) {
                span.log(Map.of("type", "result", "count", count));
            }
            span.finish();
        }).exceptionally(throwable -> {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(Map.of("event", "error", "error.kind", "Exception", "error.object", throwable, "message", throwable.getMessage()));
            span.finish();
            return null;
        });
        return Single.just((Object)serviceContext);
    }

    public static class Builder
    extends DbClientServiceBase.DbClientServiceBuilderBase<Builder>
    implements io.helidon.common.Builder<Builder, DbClientTracing> {
        private Builder() {
        }

        public DbClientTracing build() {
            return new DbClientTracing(this);
        }
    }
}

