/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbRow;
import io.helidon.dbclient.DbStatementQuery;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.mongodb.MongoDbCommandExecutor;
import io.helidon.dbclient.mongodb.MongoDbRows;
import io.helidon.dbclient.mongodb.MongoDbStatement;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDbStatementQuery
extends MongoDbStatement<DbStatementQuery, Multi<DbRow>>
implements DbStatementQuery {
    private static final Logger LOGGER = Logger.getLogger(MongoDbStatementQuery.class.getName());

    MongoDbStatementQuery(MongoDatabase db, DbStatementContext statementContext) {
        super(db, statementContext);
    }

    protected Multi<DbRow> doExecute(Single<DbClientServiceContext> dbContextFuture, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        MongoDbStatement.MongoStatement stmt;
        dbContextFuture.exceptionally(throwable -> {
            statementFuture.completeExceptionally((Throwable)throwable);
            queryFuture.completeExceptionally((Throwable)throwable);
            return null;
        });
        String statement = this.build();
        try {
            stmt = this.queryOrCommand(statement);
        }
        catch (Exception e) {
            return Multi.error((Throwable)e);
        }
        if (stmt.getOperation() != MongoDbStatement.MongoOperation.QUERY) {
            if (stmt.getOperation() == MongoDbStatement.MongoOperation.COMMAND) {
                return MongoDbCommandExecutor.executeCommand(this, dbContextFuture, statementFuture, queryFuture);
            }
            return Multi.error((Throwable)new UnsupportedOperationException(String.format("Operation %s is not supported by query", stmt.getOperation().toString())));
        }
        MongoDbStatement.MongoStatement usedStatement = stmt;
        return Single.create(dbContextFuture).flatMap(it -> this.callStatement(usedStatement, statementFuture, queryFuture));
    }

    private MongoDbStatement.MongoStatement queryOrCommand(String statement) {
        try {
            return new MongoDbStatement.MongoStatement(DbStatementType.QUERY, READER_FACTORY, statement);
        }
        catch (IllegalStateException e) {
            try {
                return new MongoDbStatement.MongoStatement(DbStatementType.COMMAND, READER_FACTORY, statement);
            }
            catch (IllegalStateException ignored) {
                throw e;
            }
        }
    }

    private Multi<DbRow> callStatement(MongoDbStatement.MongoStatement mongoStmt, CompletableFuture<Void> statementFuture, CompletableFuture<Long> queryFuture) {
        FindPublisher publisher;
        MongoCollection mc = this.db().getCollection(mongoStmt.getCollection());
        Document query = mongoStmt.getQuery();
        Document projection = mongoStmt.getProjection();
        LOGGER.fine(() -> String.format("Query: %s, Projection: %s", query.toString(), projection != null ? projection : "N/A"));
        FindPublisher findPublisher = publisher = this.noTx() ? mc.find((Bson)query) : mc.find(this.txManager().tx(), (Bson)query);
        if (projection != null) {
            publisher = publisher.projection((Bson)projection);
        }
        return Multi.create(new MongoDbRows<DbRow>(this.clientContext(), (FindPublisher<Document>)publisher, this, DbRow.class, statementFuture, queryFuture).publisher());
    }
}

