/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.mongodb;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.helidon.dbclient.DbStatement;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.common.AbstractStatement;
import io.helidon.dbclient.common.DbStatementContext;
import io.helidon.dbclient.mongodb.MongoDbTransaction;
import io.helidon.dbclient.mongodb.StatementParsers;
import jakarta.json.Json;
import jakarta.json.JsonReaderFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

abstract class MongoDbStatement<S extends DbStatement<S, R>, R>
extends AbstractStatement<S, R> {
    static final Document EMPTY = Document.parse((String)Json.createObjectBuilder().build().toString());
    protected static final String JSON_OPERATION = "operation";
    protected static final String JSON_COLLECTION = "collection";
    protected static final String JSON_QUERY = "query";
    protected static final String JSON_VALUE = "value";
    protected static final String JSON_PROJECTION = "projection";
    protected static final JsonReaderFactory READER_FACTORY = Json.createReaderFactory(Collections.emptyMap());
    private final MongoDatabase db;
    private MongoDbTransaction.TransactionManager txManager;

    MongoDbStatement(MongoDatabase db, DbStatementContext statementContext) {
        super(statementContext);
        this.db = db;
        this.txManager = null;
    }

    <B extends MongoDbStatement> B inTransaction(MongoDbTransaction.TransactionManager tx) {
        this.txManager = tx;
        this.txManager.addStatement(this);
        return (B)((Object)this);
    }

    String build() {
        switch (this.paramType()) {
            case UNKNOWN: {
                return this.statement();
            }
            case INDEXED: {
                return StatementParsers.indexedParser(this.statement(), this.indexedParams()).convert();
            }
            case NAMED: {
                return StatementParsers.namedParser(this.statement(), this.namedParams()).convert();
            }
        }
        throw new IllegalStateException("Unknown SQL statement type: " + this.paramType());
    }

    public String statementName() {
        return super.statementName();
    }

    MongoDatabase db() {
        return this.db;
    }

    boolean noTx() {
        return this.txManager == null;
    }

    MongoDbTransaction.TransactionManager txManager() {
        return this.txManager;
    }

    protected String dbType() {
        return "mongoDb";
    }

    static class MongoStatement {
        private final String preparedStmt;
        private final Document jsonStmt;
        private final MongoOperation operation;
        private final String collection;
        private final Document query;
        private final Document value;
        private final Document projection;

        private static Document readStmt(JsonReaderFactory jrf, String preparedStmt) {
            return Document.parse((String)preparedStmt);
        }

        MongoStatement(DbStatementType dbStatementType, JsonReaderFactory jrf, String preparedStmt) {
            MongoOperation operation;
            block17: {
                block16: {
                    this.preparedStmt = preparedStmt;
                    this.jsonStmt = MongoStatement.readStmt(jrf, preparedStmt);
                    if (!this.jsonStmt.containsKey((Object)MongoDbStatement.JSON_OPERATION)) break block16;
                    operation = MongoOperation.operationByName(this.jsonStmt.getString((Object)MongoDbStatement.JSON_OPERATION));
                    switch (dbStatementType) {
                        case QUERY: 
                        case GET: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.QUERY);
                            break block17;
                        }
                        case INSERT: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.INSERT);
                            break block17;
                        }
                        case UPDATE: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.UPDATE);
                            break block17;
                        }
                        case DELETE: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.DELETE);
                            break block17;
                        }
                        case DML: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.INSERT, MongoOperation.UPDATE, MongoOperation.DELETE);
                            break block17;
                        }
                        case COMMAND: {
                            MongoStatement.validateOperation(dbStatementType, operation, MongoOperation.COMMAND);
                            break block17;
                        }
                        default: {
                            throw new IllegalStateException("Operation type is not defined in statement, and cannot be inferred from statement type: " + dbStatementType);
                        }
                    }
                }
                switch (dbStatementType) {
                    case QUERY: {
                        operation = MongoOperation.QUERY;
                        break;
                    }
                    case GET: {
                        operation = MongoOperation.QUERY;
                        break;
                    }
                    case INSERT: {
                        operation = MongoOperation.INSERT;
                        break;
                    }
                    case UPDATE: {
                        operation = MongoOperation.UPDATE;
                        break;
                    }
                    case DELETE: {
                        operation = MongoOperation.DELETE;
                        break;
                    }
                    case COMMAND: {
                        operation = MongoOperation.COMMAND;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Operation type is not defined in statement, and cannot be inferred from statement type: " + dbStatementType);
                    }
                }
            }
            this.operation = operation;
            this.collection = this.jsonStmt.getString((Object)MongoDbStatement.JSON_COLLECTION);
            this.value = (Document)this.jsonStmt.get((Object)MongoDbStatement.JSON_VALUE, Document.class);
            this.query = (Document)this.jsonStmt.get((Object)MongoDbStatement.JSON_QUERY, Document.class);
            this.projection = (Document)this.jsonStmt.get((Object)MongoDbStatement.JSON_PROJECTION, Document.class);
        }

        private static void validateOperation(DbStatementType dbStatementType, MongoOperation actual, MongoOperation ... expected) {
            for (MongoOperation operation : expected) {
                if (actual != operation) continue;
                return;
            }
            throw new IllegalStateException("Statement type is " + dbStatementType + ", yet operation in statement is: " + actual);
        }

        Document getJsonStmt() {
            return this.jsonStmt;
        }

        MongoOperation getOperation() {
            return this.operation;
        }

        String getCollection() {
            return this.collection;
        }

        Document getQuery() {
            return this.query != null ? this.query : EMPTY;
        }

        Document getValue() {
            return this.value;
        }

        Document getProjection() {
            return this.projection;
        }

        public String toString() {
            return this.preparedStmt;
        }
    }

    static enum MongoOperation {
        QUERY("query", "find", "select"),
        INSERT("insert"),
        UPDATE("update"),
        DELETE("delete"),
        COMMAND("command");

        private static final Map<String, MongoOperation> NAME_TO_OPERATION;
        private final String[] names;

        static MongoOperation operationByName(String name) {
            if (name == null) {
                return null;
            }
            return NAME_TO_OPERATION.get(name.toLowerCase());
        }

        private MongoOperation(String ... names) {
            this.names = names;
        }

        static {
            NAME_TO_OPERATION = new HashMap<String, MongoOperation>();
            for (MongoOperation value : MongoOperation.values()) {
                for (String name : value.names) {
                    NAME_TO_OPERATION.put(name.toLowerCase(), value);
                }
            }
        }
    }
}

