/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.common.LazyValue;
import io.helidon.dbclient.DbClientServiceBase;
import io.helidon.dbclient.DbClientServiceContext;
import io.helidon.dbclient.DbStatementType;
import io.helidon.dbclient.metrics.MeterMetadata;
import io.helidon.dbclient.metrics.MetricBuilderBase;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;

abstract class MetricService<T extends Meter>
extends DbClientServiceBase {
    private final MeterMetadata meta;
    private final String description;
    private final BiFunction<String, DbStatementType, String> nameFunction;
    private final LazyValue<MeterRegistry> registry = LazyValue.create(Metrics::globalRegistry);
    private final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();
    private final boolean measureErrors;
    private final boolean measureSuccess;

    protected MetricService(MetricBuilderBase<?, ?> builder) {
        super(builder);
        BiFunction<String, DbStatementType, String> nameFunction = builder.nameFormat();
        this.meta = builder.meta();
        if (null == nameFunction) {
            nameFunction = (name, statement) -> this.defaultNamePrefix() + name;
        }
        this.nameFunction = nameFunction;
        this.measureErrors = builder.errors();
        this.measureSuccess = builder.success();
        String tmpDescription = builder.description() == null ? (null == this.meta ? null : this.meta.description()) : builder.description();
        this.description = tmpDescription;
    }

    protected abstract String defaultNamePrefix();

    protected DbClientServiceContext apply(DbClientServiceContext context) {
        DbStatementType dbStatementType = context.statementType();
        String statementName = context.statementName();
        Meter metric = this.cache.computeIfAbsent(statementName, s -> {
            MeterMetadata.Builder builder;
            String name = this.nameFunction.apply(statementName, dbStatementType);
            MeterMetadata.Builder builder2 = builder = this.meta == null ? MeterMetadata.builder().name(name) : MeterMetadata.builder(this.meta);
            if (this.description != null) {
                builder = builder.description(this.description);
            }
            return this.metric((MeterRegistry)this.registry.get(), builder.build());
        });
        this.executeMetric(metric, context.statementFuture());
        return context;
    }

    protected boolean measureErrors() {
        return this.measureErrors;
    }

    protected boolean measureSuccess() {
        return this.measureSuccess;
    }

    protected abstract void executeMetric(T var1, CompletionStage<Void> var2);

    protected abstract Class<? extends Meter> metricType();

    protected abstract T metric(MeterRegistry var1, MeterMetadata var2);
}

