/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import io.helidon.dbclient.metrics.MeterMetadata;
import io.helidon.dbclient.metrics.MetricService;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Timer;
import java.time.Duration;
import java.util.concurrent.CompletionStage;

final class MetricTimer
extends MetricService<Timer> {
    private MetricTimer(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Timer metric, CompletionStage<Void> future) {
        long started = System.nanoTime();
        future.thenAccept(nothing -> {
            if (this.measureSuccess()) {
                this.update(metric, started);
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                this.update(metric, started);
            }
            return null;
        });
    }

    private void update(Timer metric, long started) {
        long delta = System.nanoTime() - started;
        metric.record(Duration.ofNanos(delta));
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.timer.";
    }

    @Override
    protected Class<Timer> metricType() {
        return Timer.class;
    }

    @Override
    protected Timer metric(MeterRegistry registry, MeterMetadata meta) {
        return (Timer)registry.getOrCreate((Meter.Builder)meta.apply(Timer.builder((String)meta.name())));
    }

    static class Builder
    extends DbClientMetricBuilder<Builder, MetricTimer> {
        Builder() {
        }

        public MetricTimer build() {
            return new MetricTimer(this);
        }
    }
}

