/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.dbclient.metrics;

import io.helidon.dbclient.metrics.DbClientMetricBuilder;
import io.helidon.dbclient.metrics.MeterMetadata;
import io.helidon.dbclient.metrics.MetricService;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import java.util.concurrent.CompletionStage;

final class MetricCounter
extends MetricService<Counter> {
    private MetricCounter(Builder builder) {
        super(builder);
    }

    static Builder builder() {
        return new Builder();
    }

    @Override
    protected void executeMetric(Counter metric, CompletionStage<Void> future) {
        future.thenRun(() -> {
            if (this.measureSuccess()) {
                metric.increment();
            }
        }).exceptionally(throwable -> {
            if (this.measureErrors()) {
                metric.increment();
            }
            return null;
        });
    }

    @Override
    protected Class<Counter> metricType() {
        return Counter.class;
    }

    @Override
    protected Counter metric(MeterRegistry registry, MeterMetadata meta) {
        return (Counter)registry.getOrCreate((Meter.Builder)meta.apply(Counter.builder((String)meta.name())));
    }

    @Override
    protected String defaultNamePrefix() {
        return "db.counter.";
    }

    static class Builder
    extends DbClientMetricBuilder<Builder, MetricCounter> {
        Builder() {
        }

        public MetricCounter build() {
            return new MetricCounter(this);
        }
    }
}

